// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008/09 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "gmindex.h"

int pos2bin(unsigned int slot, unsigned int block, unsigned char pos, unsigned int chr);
int pos2bin_rev(unsigned int slot, unsigned int block, unsigned char pos, unsigned int chr);
int get_slot(unsigned int block, unsigned int pos, unsigned int spacerblock, unsigned int spacer);
int get_next_snindel(SNINDEL* snindel, int strain, unsigned int chr);
char encode_char(char *r, char *s);
void decode_strainseq(char *seq, char* template);
char get_strain_base(char c);
void print_blocktable(int lim);

int index_chromosome(unsigned int chr) 
{
	if (VERBOSE) { printf("\tBuilding index ..."); fflush(stdout); }

	unsigned int pos = 0, blockpos = 0, varpos = CHR_LENGTH, new_varpos = CHR_LENGTH, len, delpos =  0; 
	unsigned int k, spacer = 0, slot = 0, first_strain_block = 0, last_strain_block = 0, last_snindel_pos = 0, actual_refblock = 0, flanking_block, strain, block, blocks;
	int diff = 0, indel_offset = 0;
	unsigned int whole_branchlen[NUM_STRAINS+1];
	unsigned int actual_branchlen[NUM_STRAINS+1];
	unsigned int last_blocks[NUM_STRAINS+1];
	unsigned int branchblock_startpos[NUM_STRAINS+1];
	char base;
	char seq[1000];
	SNINDEL *old_snindels = (SNINDEL *) malloc((NUM_STRAINS + 1) * sizeof(SNINDEL));
	SNINDEL *snindel_iterator;
	BLOCK_LIST_ENTRY *blocklist_iterator;
	
	HAS_SLOT = 0;
	last_blocks[0] = 0;
	flanking_block = 0;
	branchblock_startpos[0] = 0;

	if (NUM_STRAINS != 0) {
	
		if (chr == 0) SNINDELS = (SNINDEL *) malloc((NUM_STRAINS+1) * sizeof(SNINDEL));
	
		// initialize snindel_list
		SNINDEL_LIST = NULL;
		for (k=1; k<=NUM_STRAINS; ++k) {
			
			STRAINLEN[k] = 0;
			whole_branchlen[k] = 0;
			branchblock_startpos[k] = 0;
			last_blocks[k] = 0;
			
			if (chr == 0 && get_next_snindel(SNINDELS+k, k, chr) < 1) continue;
			
			if (strcmp(SNINDELS[k].chr, CHR_DESC) == 0) {
//if (DEBUG) printf("SNINDEL[%d]:\n{acc %d, chr %s, pos %d, len %d, %c %s}\n", k, SNINDELS[k].strain, SNINDELS[k].chr, SNINDELS[k].pos, (int) strlen(SNINDELS[k].seq), SNINDELS[k].type, SNINDELS[k].seq);
				
				// insert into snindel_list according to position (in case of equality: del before ins before snp)
				if (SNINDEL_LIST == NULL) {
//if (DEBUG) printf("first entry in snindellist\n");
					SNINDEL_LIST = SNINDELS+k;
					SNINDELS[k].next = NULL;
					SNINDELS[k].prev = NULL;
				}
				else {
//if (DEBUG) printf("already entries in snindellist\n");
					snindel_iterator = SNINDEL_LIST;
					if (snindel_iterator->pos > SNINDELS[k].pos 
						|| (snindel_iterator->pos == SNINDELS[k].pos && snindel_iterator->type < SNINDELS[k].type)) {
						
						// insert to the front of SNINDEL_LIST
						SNINDELS[k].next = SNINDEL_LIST;
						SNINDEL_LIST->prev = SNINDELS+k;
						SNINDELS[k].prev = NULL;
						SNINDEL_LIST = SNINDELS+k;
					}
					else {
						while (snindel_iterator->next != NULL 
							&& ((snindel_iterator->next->pos < SNINDELS[k].pos) || (snindel_iterator->next->pos == SNINDELS[k].pos && snindel_iterator->next->type > SNINDELS[k].type))) {
							snindel_iterator = snindel_iterator->next;
						}
						
						// insert after snindel_iterator
						SNINDELS[k].next = snindel_iterator->next;
						SNINDELS[k].prev = snindel_iterator;
						snindel_iterator->next = SNINDELS+k;
					}
					
				}
			}
		}
		
		strain = SNINDEL_LIST->strain;
		
//if (DEBUG) { printf("---SNINDELLIST---\n"); snindel_iterator = SNINDEL_LIST; while (snindel_iterator != NULL) {	printf("{acc %d, chr %s, pos %d, len %d, %c %s}\n", snindel_iterator->strain, snindel_iterator->chr, snindel_iterator->pos, (int) strlen(snindel_iterator->seq), snindel_iterator->type, snindel_iterator->seq);	snindel_iterator = snindel_iterator->next; } printf("-----------------\n"); }
		
		memcpy(old_snindels, SNINDELS, (NUM_STRAINS + 1) * sizeof(SNINDEL));
	
	}
	
	// initialize varpos:
	if (SNINDEL_LIST == NULL) {
		if (VERBOSE) { printf("No divergent strain information"); fflush(stdout); }
		varpos = CHR_LENGTH + 1;	// this switches off branching
	}
	else {
		if (VERBOSE) { 
			printf("Incorporating divergent strain data of ");
			for (k=1; k<=NUM_STRAINS; k++) if (strcmp(SNINDELS[k].chr, CHR_DESC) == 0) printf("%s ", STRAIN_DESC[k-1]);
			fflush(stdout);
		} 
		varpos = (SNINDEL_LIST->pos < INDEX_DEPTH)? 0: SNINDEL_LIST->pos - INDEX_DEPTH + 1;
	}
	
	// varpos is the length of the reference block	
	if (varpos != 0) {
	
		blocks = varpos/BLOCK_SIZE - (varpos % BLOCK_SIZE == 0);
		for (k=0; k<=blocks; ++k) {
			// create new reference block:
			if (BLOCK == BLOCK_TABLE_SIZE - 1) {
				fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
				exit(0);
			}
			BLOCK++;
			BLOCK_TABLE[BLOCK].chr = chr;
			BLOCK_TABLE[BLOCK].pos = pos + k * BLOCK_SIZE;
			BLOCK_TABLE[BLOCK].strain = 0;
			BLOCK_TABLE[BLOCK].strainpos = 0;
			len = (k==blocks)? varpos - k * BLOCK_SIZE: BLOCK_SIZE;
			strncpy(BLOCK_TABLE[BLOCK].seq, CHR_SEQ+BLOCK_TABLE[BLOCK].pos, len);
			BLOCK_TABLE[BLOCK].seq[len] = '\0';
			if (k!=0) {
				BLOCK_TABLE[BLOCK-1].next_block = BLOCK;
				BLOCK_TABLE[BLOCK].prev_block = BLOCK - 1;
			}
			else {
				BLOCK_TABLE[BLOCK].prev_block = 0;
				actual_refblock = BLOCK;
			}
		}
		
		flanking_block = BLOCK;
		last_blocks[0] = BLOCK;
		
//if (DEBUG) printf("refseq until first snindel: .%s. len %d\n",BLOCK_TABLE[flanking_block].seq, (int)strlen(BLOCK_TABLE[flanking_block].seq));
		
	}
	// Initialization end
	
//if (DEBUG) printf("varpos: %d BLOCKS %d\n",varpos, BLOCK);
	
	
	// Iterate over whole chromosome:
	while (spacer <= CHR_LENGTH) {
		
//if (DEBUG) printf("spacer %d pos %d blockpos %d\n",spacer,pos,blockpos);
		
		// BRANCHING
		if (pos >= varpos) {
			
//if (DEBUG) printf("\n\n HERE new varpos: pos %d varpos %d POS %d \n\n", pos, varpos, blockpos);
			
			flanking_block = BLOCK;
		
//if (DEBUG) printf("SNINDEL_LIST:{acc %d, chr %s, pos %d, len %d, %c %s}\n", SNINDEL_LIST->strain, SNINDEL_LIST->chr, SNINDEL_LIST->pos, SNINDEL_LIST->seqlen, SNINDEL_LIST->type, SNINDEL_LIST->seq);
			
			// filling seq up to first snindel:
			actual_branchlen[SNINDEL_LIST->strain] = (SNINDEL_LIST->pos < INDEX_DEPTH)? SNINDEL_LIST->pos: INDEX_DEPTH - 1;
//if (DEBUG) printf("branchlen %d strain %d\n",actual_branchlen[SNINDEL_LIST->strain], SNINDEL_LIST->strain);
			strncpy(BRANCHSEQ[SNINDEL_LIST->strain-1], CHR_SEQ+varpos, actual_branchlen[SNINDEL_LIST->strain]);

			switch (SNINDEL_LIST->type) {
				case 'S':	BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]] = encode_char(CHR_SEQ+varpos+actual_branchlen[SNINDEL_LIST->strain], SNINDEL_LIST->seq); 
						actual_branchlen[SNINDEL_LIST->strain] += 1;
						whole_branchlen[0] = actual_branchlen[SNINDEL_LIST->strain];
						branchblock_startpos[SNINDEL_LIST->strain] = 0;
						BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]] = '\0';
						break;
				case 'I':	for (k=0; k!=SNINDEL_LIST->seqlen; ++k)
							BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]+k] = encode_char("-", SNINDEL_LIST->seq+k);
						whole_branchlen[0] = actual_branchlen[SNINDEL_LIST->strain];
						actual_branchlen[SNINDEL_LIST->strain] += SNINDEL_LIST->seqlen;
						branchblock_startpos[SNINDEL_LIST->strain] = whole_branchlen[0];
						branchblock_startpos[0] = whole_branchlen[0];
						BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]] = '\0';
						break;
				case 'D':	for (k=0; k!=SNINDEL_LIST->seqlen; ++k)
							BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]+k] = encode_char(CHR_SEQ+varpos+actual_branchlen[SNINDEL_LIST->strain]+k, "-");
						whole_branchlen[0] = actual_branchlen[SNINDEL_LIST->strain] + SNINDEL_LIST->seqlen;
						branchblock_startpos[SNINDEL_LIST->strain] = whole_branchlen[0];
						branchblock_startpos[0] = whole_branchlen[0];
						BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain] + SNINDEL_LIST->seqlen] = '\0';
						break;
			}
			
			
			
//if (DEBUG) { decode_seq(seq, BRANCHSEQ[SNINDEL_LIST->strain-1]); printf("strain %d: .%s.\n",SNINDEL_LIST->strain, seq); seq[0] = '\0'; decode_strainseq(seq, BRANCHSEQ[SNINDEL_LIST->strain-1]); printf("strain %d: .%s.\n",SNINDEL_LIST->strain, seq); printf("ref. length: %d\n",whole_branchlen[0]); }
			
			// create first new reference block:
			if (BLOCK == BLOCK_TABLE_SIZE - 1) {
				fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
				exit(0);
			}
			BLOCK++;
			BLOCK_TABLE[BLOCK].chr = chr;
			BLOCK_TABLE[BLOCK].pos = varpos;
			BLOCK_TABLE[BLOCK].strainpos = 1;	// to indicate that this reference block is in a superblock
			BLOCK_TABLE[BLOCK].strain = 0;
			BLOCK_TABLE[BLOCK].prev_block = last_blocks[0];
			// next is set after while loop
			
			// reference block before superblock
			BLOCK_TABLE[last_blocks[0]].next_block = BLOCK;
			
			last_blocks[0] = BLOCK;
			first_strain_block = BLOCK;
			last_strain_block = BLOCK;
			actual_refblock = BLOCK;
			blockpos = pos - varpos;

			// create first new branch block:
			if (last_blocks[SNINDEL_LIST->strain] == 0) STRAINLEN[SNINDEL_LIST->strain] = varpos;// + branchblock_startpos;
			else STRAINLEN[SNINDEL_LIST->strain] += varpos - BLOCK_TABLE[BLOCK_TABLE[last_blocks[SNINDEL_LIST->strain]].next_block].pos;
			
			if (BLOCK == BLOCK_TABLE_SIZE - 1) {
				fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
				exit(0);
			}
			BLOCK++;
			BLOCK_TABLE[BLOCK].chr = chr;
			BLOCK_TABLE[BLOCK].pos = varpos;
			BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[SNINDEL_LIST->	strain];
			BLOCK_TABLE[BLOCK].strain = SNINDEL_LIST->strain;
			BLOCK_TABLE[BLOCK].prev_block = flanking_block;
			// next is set after while loop
//if (DEBUG) printf("BLOCK=%d, strain=%d %d\n",BLOCK,BLOCK_TABLE[BLOCK].strain,SNINDEL_LIST->strain);
			
			last_blocks[SNINDEL_LIST->strain] = BLOCK;
			
			BLOCK_TABLE[first_strain_block].next_strain_front = BLOCK;
			first_strain_block = BLOCK;
						
			// mark that block is active in blocklist:
			BLOCK_LIST[SNINDEL_LIST->strain].blocknr = BLOCK;
			BLOCK_LIST[SNINDEL_LIST->strain].next = NULL;
			ACTIVE_BLOCKS = BLOCK_LIST+SNINDEL_LIST->strain;

//if (DEBUG) printf("BRANCHSEQ[%d] before while .%s. len %d\n", SNINDEL_LIST->strain,BRANCHSEQ[SNINDEL_LIST->strain-1],actual_branchlen[SNINDEL_LIST->strain]);



			// if Indel, close and build indel block(s):
			if (SNINDEL_LIST->type != 'S') {

				// save seq of insertion block
				len = (strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]) > BLOCK_SIZE)? BLOCK_SIZE: strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]);
//if (DEBUG) printf("BLOCK %d len %d  branchlenseq %d branchseq .%s.\n", BLOCK, len, (int)strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]), BRANCHSEQ[SNINDEL_LIST->strain-1]);
				strncpy(BLOCK_TABLE[BLOCK].seq, BRANCHSEQ[SNINDEL_LIST->strain-1], len);
			
				BLOCK_TABLE[BLOCK].seq[len] = '\0';
				
				if (SNINDEL_LIST->type == 'I') {
					STRAINLEN[SNINDEL_LIST->strain] += len;
						
					BLOCK_TABLE[BLOCK].indel_offset = whole_branchlen[0] + 1;
					BLOCK_TABLE[BLOCK].ins_pos = 0;
				}
				else {
					STRAINLEN[SNINDEL_LIST->strain] += strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]) - SNINDEL_LIST->seqlen;
					BLOCK_TABLE[BLOCK].indel_offset = actual_branchlen[SNINDEL_LIST->strain]-len-1;
					BLOCK_TABLE[BLOCK].ins_pos = 0;
				}
								
				// build other insertion blocks if insertion spans over more than 1 block (> BLOCK_SIZE)
				blocks = strlen(BRANCHSEQ[SNINDEL_LIST->strain-1])/BLOCK_SIZE - (strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]) % BLOCK_SIZE == 0);
				for (k=1; k<=blocks; ++k) {
					if (BLOCK == BLOCK_TABLE_SIZE - 1) {
						fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
						exit(0);
					}
					BLOCK++;
					BLOCK_TABLE[BLOCK].chr = chr;
					BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[SNINDEL_LIST->strain];
					BLOCK_TABLE[BLOCK].strain = SNINDEL_LIST->strain;
					BLOCK_TABLE[BLOCK].prev_block = last_blocks[SNINDEL_LIST->strain];
					
					len = (strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]) - k * BLOCK_SIZE > BLOCK_SIZE)? BLOCK_SIZE: strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]) - k * BLOCK_SIZE;
					strncpy(BLOCK_TABLE[BLOCK].seq, BRANCHSEQ[SNINDEL_LIST->strain-1] + k * BLOCK_SIZE, len);
					BLOCK_TABLE[BLOCK].seq[len] = '\0';
					
					BLOCK_TABLE[last_blocks[SNINDEL_LIST->strain]].next_block = BLOCK;
					last_blocks[SNINDEL_LIST->strain] = BLOCK;
					
					if (SNINDEL_LIST->type == 'I') 	{
						BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[BLOCK-1].pos;
						BLOCK_TABLE[BLOCK].indel_offset = 0;
						STRAINLEN[SNINDEL_LIST->strain] += len;
						BLOCK_TABLE[BLOCK].ins_pos = BLOCK_TABLE[BLOCK-1].ins_pos + strlen(BLOCK_TABLE[BLOCK-1].seq) - BLOCK_TABLE[BLOCK-1].indel_offset + 2;
					}
					else {	// 'D'
						BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[BLOCK-1].pos + BLOCK_SIZE;
						BLOCK_TABLE[BLOCK].indel_offset = -strlen(BLOCK_TABLE[BLOCK].seq)-1; 
						BLOCK_TABLE[BLOCK].ins_pos = 0;
					}
				}
				
				whole_branchlen[SNINDEL_LIST->strain] += strlen(BRANCHSEQ[SNINDEL_LIST->strain-1]);
				
				// set branch seq to 0
				actual_branchlen[SNINDEL_LIST->strain] = 0;
				BRANCHSEQ[SNINDEL_LIST->strain-1][0] = '\0';
				
			}
			// end of insertion special status
			
//if (DEBUG) print_blocktable(10);
//if (DEBUG) printf("branchblock_startpos: %d\n", branchblock_startpos[SNINDEL_LIST->strain]);


			// following snindels (jumps from one snindel to the next one until end of superblock which is determined hereby):
			do {
				
				if (SNINDEL_LIST->type == 'I')
					last_snindel_pos = (SNINDEL_LIST->pos > last_snindel_pos)? SNINDEL_LIST->pos: last_snindel_pos;
				else
					last_snindel_pos = (SNINDEL_LIST->pos+SNINDEL_LIST->seqlen > last_snindel_pos)? SNINDEL_LIST->pos+SNINDEL_LIST->seqlen: last_snindel_pos;
				
//if (DEBUG) printf("next SNINDEL:\n{acc %d, chr %s, pos %d, len %d, %c %s}\n", SNINDEL_LIST->strain, SNINDEL_LIST->chr, SNINDEL_LIST->pos, SNINDEL_LIST->seqlen, SNINDEL_LIST->type, SNINDEL_LIST->seq);
//if (DEBUG) { printf("---SNINDELLIST---\n"); snindel_iterator = SNINDEL_LIST; while (snindel_iterator != NULL) {	printf("{acc %d, chr %s, pos %d, len %d, %c %s}\n", snindel_iterator->strain, snindel_iterator->chr, snindel_iterator->pos, (int)strlen(snindel_iterator->seq), snindel_iterator->type, snindel_iterator->seq); snindel_iterator = snindel_iterator->next; } printf("-----------------\n"); }
				
				if (get_next_snindel(SNINDELS+SNINDEL_LIST->strain, SNINDEL_LIST->strain, chr) > 0 && 
					strcmp(SNINDELS[SNINDEL_LIST->strain].chr, CHR_DESC) == 0) {
					
					strain = SNINDEL_LIST->strain;
					
					// Error detection:
					if (strcmp(old_snindels[strain].chr, SNINDELS[strain].chr) == 0 && old_snindels[strain].pos == SNINDELS[strain].pos) {
						/*if (old_snindels[strain].type == 'S' || SNINDELS[strain].type == 'S') {
							fprintf(stderr, "In strain '%s': SNP has the same position than indel! This cannot be processed.\n", STRAIN_DESC[strain-1]);
							exit(0);
						}*/
						// ... probably more.. @TODO
					}

					if (strcmp(old_snindels[strain].chr, SNINDELS[strain].chr) == 0 && old_snindels[strain].type == 'D' && SNINDELS[strain].pos < old_snindels[strain].pos+old_snindels[strain].seqlen) {
						fprintf(stderr, "ERROR: Deletion on pos %d chr %s on strain %s overstretches the next SNP or indel on this strain!\n", old_snindels[strain].pos, old_snindels[strain].chr, STRAIN_DESC[strain-1]);
						exit(0);
					}
				
					// sort new snindel in SNINDEL_LIST (new connections of order of strains in snindel list)
					if (SNINDEL_LIST->next != NULL) {
						
						snindel_iterator = SNINDEL_LIST->next;
						if (snindel_iterator->pos < SNINDELS[SNINDEL_LIST->strain].pos
							|| (snindel_iterator->pos == SNINDELS[SNINDEL_LIST->strain].pos && snindel_iterator->type < SNINDELS[SNINDEL_LIST->strain].type)) {
//if (DEBUG) printf("has to iterate\n");
							snindel_iterator->prev = NULL;
							
							while (snindel_iterator->next != NULL 
									&& ((snindel_iterator->next->pos < SNINDELS[SNINDEL_LIST->strain].pos)
										|| (snindel_iterator->next->pos == SNINDELS[SNINDEL_LIST->strain].pos && snindel_iterator->next->type > SNINDELS[SNINDEL_LIST->strain].type))) {
//if (DEBUG) printf("iterate\n");
								snindel_iterator = snindel_iterator->next;
							}
							
//if (DEBUG) printf("remove first entry\n");
							// "remove" first entry from SNINDEL_LIST
							SNINDEL_LIST = SNINDEL_LIST->next;
														
//if (DEBUG) { printf("insert after following snindel:"); printf(" {acc %d, chr %s, pos %d, len %d, %c %s}\n", snindel_iterator->strain, snindel_iterator->chr, snindel_iterator->pos, snindel_iterator->seqlen, snindel_iterator->type, snindel_iterator->seq); }

							// insert after snindel_iterator
							SNINDELS[strain].next = snindel_iterator->next;
							SNINDELS[strain].prev = snindel_iterator;
							snindel_iterator->next = SNINDELS+strain;
				
						}
						
					}
				}
				else {
//if (DEBUG) printf("empty\n");
					SNINDEL_LIST = SNINDEL_LIST->next;
					if (SNINDEL_LIST == NULL) {
						new_varpos = CHR_LENGTH;
						break;
					}
				}
				
//if (DEBUG) printf("done\n");
				strain = SNINDEL_LIST->strain;

				diff = SNINDEL_LIST->pos - last_snindel_pos;
		
//if (DEBUG) { printf("next SNINDEL:\n{acc %d, chr %s, pos %d, len %d, %c %s}\n", SNINDEL_LIST->strain, SNINDEL_LIST->chr, SNINDEL_LIST->pos, SNINDEL_LIST->seqlen, SNINDEL_LIST->type, SNINDEL_LIST->seq); printf("  diff %d\n",diff); }
//if (DEBUG) for (k=0; k<=NUM_STRAINS; ++k) printf("%d: chr %s pos %d\n",k,SNINDELS[k].chr, SNINDELS[k].pos);
//if (DEBUG) { printf("---SNINDELLIST---\n"); snindel_iterator = SNINDEL_LIST; while (snindel_iterator != NULL) { printf("{acc %d, chr %s, pos %d, len %d, %c %s}\n", snindel_iterator->strain, snindel_iterator->chr, snindel_iterator->pos, (int)strlen(snindel_iterator->seq), snindel_iterator->type, snindel_iterator->seq); snindel_iterator = snindel_iterator->next; } printf("-----------------\n"); }


				// !!! if next snindel is less or equal than INDEX_DEPTH away, then branch has to be extended !!! 
				if (diff < INDEX_DEPTH) {

					// branch extension
					
					if (BLOCK_LIST[SNINDEL_LIST->strain].blocknr != 0) {
						// same branch has more than 1 snindel in superblock:
//if (DEBUG) printf("\n1) already entry in blocklist for strain %d   old snindel pos: %d\n",SNINDEL_LIST->strain, old_snindels[SNINDEL_LIST->strain].pos);
							
						if (actual_branchlen[SNINDEL_LIST->strain] != 0) {
							len = SNINDEL_LIST->pos - old_snindels[SNINDEL_LIST->strain].pos - 1;
							
//if (DEBUG) printf("len: %d\n",len);
							unsigned int l = strlen(BRANCHSEQ[strain-1]);
							strncpy(BRANCHSEQ[SNINDEL_LIST->strain-1]+strlen(BRANCHSEQ[strain-1]), CHR_SEQ+old_snindels[SNINDEL_LIST->strain].pos+1, len);
							actual_branchlen[SNINDEL_LIST->strain] += len;
							BRANCHSEQ[SNINDEL_LIST->strain-1][l+len] = '\0';
						}
						else {
							// last snindel was an indel, thus there was a blockbreak -> new branchblock has to be created first
//if (DEBUG) printf("latest: %d\n",branchblock_startpos[strain]);
							actual_branchlen[SNINDEL_LIST->strain] = SNINDEL_LIST->pos - branchblock_startpos[SNINDEL_LIST->strain] - varpos;
							strncpy(BRANCHSEQ[SNINDEL_LIST->strain-1], CHR_SEQ+branchblock_startpos[SNINDEL_LIST->strain]+varpos, actual_branchlen[SNINDEL_LIST->strain]);
//if (DEBUG) printf("actual_branchlen %d, snindel->pos %d\n",actual_branchlen[strain], SNINDEL_LIST->pos);
							
							// create new strain block after indel:
							if (BLOCK == BLOCK_TABLE_SIZE - 1) {
								fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
								exit(0);
							}
							BLOCK++;
							BLOCK_TABLE[BLOCK].pos = branchblock_startpos[SNINDEL_LIST->strain] + varpos;
							BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[SNINDEL_LIST->strain];
							BLOCK_TABLE[BLOCK].chr = chr;
							BLOCK_TABLE[BLOCK].strain = SNINDEL_LIST->strain;
							BLOCK_TABLE[BLOCK].ins_pos = 0;
							BLOCK_TABLE[BLOCK].prev_block = last_blocks[SNINDEL_LIST->strain];
							
							BLOCK_TABLE[last_blocks[SNINDEL_LIST->strain]].next_block = BLOCK;
							last_blocks[SNINDEL_LIST->strain] = BLOCK;
						}
						
						if (SNINDEL_LIST->type == 'S') {
							BRANCHSEQ[strain-1][actual_branchlen[strain]] =	encode_char(CHR_SEQ+varpos+branchblock_startpos[strain]+actual_branchlen[strain], SNINDEL_LIST->seq); 
							actual_branchlen[SNINDEL_LIST->strain] += 1;
							BRANCHSEQ[strain-1][actual_branchlen[strain]] = '\0';
						}
						else {
							// close branchblock and create new subsequent ones:
										
							if (SNINDEL_LIST->type == 'D') {
//if (DEBUG) printf("NEW DELETION! strain: %d\n",strain);
								for (k=0; k!=SNINDEL_LIST->seqlen; ++k)
									BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]+k] = 
										encode_char(CHR_SEQ+varpos+branchblock_startpos[strain]+actual_branchlen[SNINDEL_LIST->strain]+k, "-");
								BRANCHSEQ[strain-1][actual_branchlen[strain]+SNINDEL_LIST->seqlen] = '\0';
							}
							else {
//if (DEBUG) printf("NEW INSERTION! strain: %d\n",strain);
								indel_offset = actual_branchlen[strain] + 1;
//if (DEBUG) printf("indel_offset = %d\n",indel_offset);
								
								// update actual_branchlen and BRANCHSEQ up to the insertion
								for (k=0; k!=SNINDEL_LIST->seqlen; ++k)	BRANCHSEQ[strain-1][actual_branchlen[strain]+k] = encode_char("-", SNINDEL_LIST->seq+k);
								actual_branchlen[strain] += SNINDEL_LIST->seqlen;
								BRANCHSEQ[strain-1][actual_branchlen[strain]] = '\0';
								
								if (indel_offset > BLOCK_SIZE) indel_offset -= BLOCK_SIZE;
								else BLOCK_TABLE[last_blocks[strain]].indel_offset = indel_offset;
//if (DEBUG) printf("indel_offset = %d\n",indel_offset);
							}
										
							// FIRST fill existing branch block
							len = (strlen(BRANCHSEQ[strain-1]) > BLOCK_SIZE)? BLOCK_SIZE: strlen(BRANCHSEQ[strain-1]);
//if (DEBUG) printf("last_blocks[%d]: %d len %d  branchseqlen %d\n",strain, last_blocks[strain], len, (int)strlen(BRANCHSEQ[strain-1]));
							strncpy(BLOCK_TABLE[last_blocks[strain]].seq, BRANCHSEQ[SNINDEL_LIST->strain-1], len);
							BLOCK_TABLE[last_blocks[strain]].seq[len] = '\0';
				
							if (SNINDEL_LIST->type == 'I') STRAINLEN[strain] += len;
							else {
								delpos = strlen(BRANCHSEQ[strain-1]) - SNINDEL_LIST->seqlen;
								if (delpos > BLOCK_SIZE) {
									STRAINLEN[strain] += BLOCK_SIZE;
									delpos -= BLOCK_SIZE;
									BLOCK_TABLE[last_blocks[strain]].indel_offset = 0;
								}
								else {
									BLOCK_TABLE[last_blocks[strain]].indel_offset = delpos-len-1;
									STRAINLEN[strain] += delpos;
									delpos = 0;
								}
							}
							
//if (DEBUG) { seq[0]='\0'; printf("strain %d: .%s.\n",strain, decode_seq(seq, BRANCHSEQ[strain-1])); seq[0]='\0'; printf("blockseq1 .%s.\n", decode_seq(seq, BLOCK_TABLE[last_blocks[strain]].seq)); }
							
							BLOCK_TABLE[last_blocks[strain]].ins_pos = 0;
							
							// build other indel blocks if indel spans over more than 1 block (> BLOCK_SIZE)
							blocks = strlen(BRANCHSEQ[strain-1])/BLOCK_SIZE - (strlen(BRANCHSEQ[strain-1]) % BLOCK_SIZE == 0);
							for (k=1; k<=blocks; ++k) {
								if (BLOCK == BLOCK_TABLE_SIZE - 1) {
									fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
									exit(0);
								}
								BLOCK++;
								BLOCK_TABLE[BLOCK].chr = chr; 
								BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[strain];
								BLOCK_TABLE[BLOCK].strain = strain;
								BLOCK_TABLE[BLOCK].prev_block = last_blocks[strain];
//if (DEBUG) printf("BLOCK_TABLE[last_blocks[strain]].indel_offset %d BLOCK_TABLE[last_blocks[strain]].ins_pos %d\n", BLOCK_TABLE[last_blocks[strain]].indel_offset, BLOCK_TABLE[last_blocks[strain]].ins_pos);
								
								if (SNINDEL_LIST->type == 'I') {
									// determine indel_offset / ins_pos and pos entries of blocktable

									if (BLOCK_TABLE[last_blocks[strain]].indel_offset > 0) {
										BLOCK_TABLE[BLOCK].indel_offset = 0;
										BLOCK_TABLE[BLOCK].ins_pos = BLOCK_TABLE[last_blocks[strain]].ins_pos + BLOCK_SIZE - BLOCK_TABLE[last_blocks[strain]].indel_offset + 3;
										BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos;
									}
									else if (BLOCK_TABLE[last_blocks[strain]].ins_pos > 0) {
										BLOCK_TABLE[BLOCK].indel_offset = 0;
										BLOCK_TABLE[BLOCK].ins_pos = BLOCK_TABLE[last_blocks[strain]].ins_pos + BLOCK_SIZE;
										BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos; 
									}
									else {
										BLOCK_TABLE[BLOCK].ins_pos = 0;
										BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos + BLOCK_SIZE;
										if (indel_offset > BLOCK_SIZE) {
											indel_offset -= BLOCK_SIZE;
											BLOCK_TABLE[BLOCK].indel_offset = 0;
										}
										else BLOCK_TABLE[BLOCK].indel_offset = indel_offset;
									}
								}
								else {
									BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos + BLOCK_SIZE;
									BLOCK_TABLE[BLOCK].ins_pos = 0;
								}
								
								len = (strlen(BRANCHSEQ[strain-1]) - k * BLOCK_SIZE > BLOCK_SIZE)? BLOCK_SIZE: strlen(BRANCHSEQ[strain-1]) - k * BLOCK_SIZE;
								strncpy(BLOCK_TABLE[BLOCK].seq, BRANCHSEQ[strain-1] + k * BLOCK_SIZE, len);
								BLOCK_TABLE[BLOCK].seq[len] = '\0';
								
//if (DEBUG) { seq[0]='\0'; printf("blockseqs .%s.\n", decode_seq(seq, BLOCK_TABLE[BLOCK].seq)); }
								
								BLOCK_TABLE[last_blocks[strain]].next_block = BLOCK;
								last_blocks[strain] = BLOCK;
								
								if (SNINDEL_LIST->type == 'I') STRAINLEN[strain] += len;
								else {
									if (delpos > BLOCK_SIZE) {
										STRAINLEN[strain] += BLOCK_SIZE;
										delpos -= BLOCK_SIZE;
										BLOCK_TABLE[BLOCK].indel_offset = 0;
									}
									else {
										BLOCK_TABLE[BLOCK].indel_offset = delpos-len-1;
										STRAINLEN[strain] += delpos;
										delpos = 0;
									}
								}
							}
							
							
							whole_branchlen[strain] += strlen(BRANCHSEQ[strain-1]);
//if (DEBUG) printf("whole_branchlen[%d] = %d actual: %d\n",strain, whole_branchlen[strain],actual_branchlen[strain]);
							
							// set branch seq to 0
							actual_branchlen[strain] = 0;
							BRANCHSEQ[strain-1][0] = '\0';
							
							len = (SNINDEL_LIST->type == 'I')? SNINDEL_LIST->pos - varpos: SNINDEL_LIST->pos + SNINDEL_LIST->seqlen - varpos;
							branchblock_startpos[strain] = len;
							whole_branchlen[0] = (len > whole_branchlen[0])? len: whole_branchlen[0];
							
							branchblock_startpos[0] = whole_branchlen[0];
//if (DEBUG) print_blocktable(10);
						}
						
//if (DEBUG) printf("  BRANCHSEQ[%d] .%s. len %d\n", SNINDEL_LIST->strain,BRANCHSEQ[SNINDEL_LIST->strain-1], (int)strlen(BRANCHSEQ[strain-1]));
						
						// length on reference:
						if (SNINDEL_LIST->type != 'I') len = SNINDEL_LIST->pos - varpos + SNINDEL_LIST->seqlen;
						else len = SNINDEL_LIST->pos - varpos;
						whole_branchlen[0] = (len > whole_branchlen[0])? len: whole_branchlen[0];

//if (DEBUG) printf("ref.length: %d\n",whole_branchlen[0]);
					}
					else {
						
						// new branch, new block:
						
//if (DEBUG) printf("\n3) new branch, new block / strain %d\n", SNINDEL_LIST->strain);
						actual_branchlen[SNINDEL_LIST->strain] = SNINDEL_LIST->pos - varpos;
						strncpy(BRANCHSEQ[SNINDEL_LIST->strain-1], CHR_SEQ+varpos, actual_branchlen[SNINDEL_LIST->strain]);
						BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]] = '\0';
						
//if (DEBUG) printf("last refblock: %d act.branchlen[%d] %d first_Strain_block %d branchblock_startpos %d\n",last_blocks[0], SNINDEL_LIST->strain, actual_branchlen[SNINDEL_LIST->strain], first_strain_block, branchblock_startpos[strain]);

						// create new branch block:
						if (last_blocks[strain] == 0) STRAINLEN[strain] = varpos;
						else STRAINLEN[SNINDEL_LIST->strain] += varpos - BLOCK_TABLE[BLOCK_TABLE[last_blocks[strain]].next_block].pos;
						if (BLOCK == BLOCK_TABLE_SIZE - 1) {
							fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
							exit(0);
						}
						BLOCK++;
						BLOCK_TABLE[BLOCK].pos = varpos;
						BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[SNINDEL_LIST->strain];
						BLOCK_TABLE[BLOCK].chr = chr;
						BLOCK_TABLE[BLOCK].strain = SNINDEL_LIST->strain;
						BLOCK_TABLE[BLOCK].prev_block = flanking_block;
						
						last_blocks[SNINDEL_LIST->strain] = BLOCK;
						
						BLOCK_TABLE[first_strain_block].next_strain_front = BLOCK;
						first_strain_block = BLOCK;
						
						// mark that block is active in blocklist (insert to the front):
						BLOCK_LIST[SNINDEL_LIST->strain].blocknr = BLOCK;
						BLOCK_LIST[SNINDEL_LIST->strain].next = ACTIVE_BLOCKS;
						ACTIVE_BLOCKS = BLOCK_LIST+SNINDEL_LIST->strain;
						
												
						if (SNINDEL_LIST->type == 'S') {
							BRANCHSEQ[strain-1][actual_branchlen[strain]] =	encode_char(CHR_SEQ+varpos+actual_branchlen[strain], SNINDEL_LIST->seq);
							actual_branchlen[SNINDEL_LIST->strain] += 1;
							BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]] = '\0';
						}
						else {
							// close refblock and branchblock and create new subsequent ones:
							
							if (SNINDEL_LIST->type == 'D') {
//if (DEBUG) printf("DELETION! strain: %d\n",strain);
								for (k=0; k!=SNINDEL_LIST->seqlen; ++k)
									BRANCHSEQ[SNINDEL_LIST->strain-1][actual_branchlen[SNINDEL_LIST->strain]+k] = encode_char(CHR_SEQ+varpos+actual_branchlen[SNINDEL_LIST->strain]+k, "-");
								BRANCHSEQ[strain-1][actual_branchlen[strain]+SNINDEL_LIST->seqlen] = '\0';
							}
							else {
//if (DEBUG) printf("INSERTION! strain: %d\n",strain);
								
								indel_offset = actual_branchlen[strain] + 1;
//if (DEBUG) printf("indel_offset = %d\n",indel_offset);
								
								// update actual_branchlen and BRANCHSEQ up to the insertion
								for (k=0; k!=SNINDEL_LIST->seqlen; ++k)	BRANCHSEQ[strain-1][actual_branchlen[strain]+k] = encode_char("-", SNINDEL_LIST->seq+k);
								actual_branchlen[strain] += SNINDEL_LIST->seqlen;
								BRANCHSEQ[strain-1][actual_branchlen[strain]] = '\0';
					
								if (indel_offset > BLOCK_SIZE) indel_offset -= BLOCK_SIZE;
								else BLOCK_TABLE[last_blocks[strain]].indel_offset = indel_offset;
//if (DEBUG) printf("indel_offset = %d\n",indel_offset);
							}
							
							// FIRST fill existing branch block
							len = (strlen(BRANCHSEQ[strain-1]) > BLOCK_SIZE)? BLOCK_SIZE: strlen(BRANCHSEQ[strain-1]);
//if (DEBUG) printf("last_blocks[%d]: %d len %d  branchseqlen %d\n",strain, last_blocks[strain], len, (int)strlen(BRANCHSEQ[strain-1]));
							strncpy(BLOCK_TABLE[last_blocks[strain]].seq, BRANCHSEQ[SNINDEL_LIST->strain-1], len);
							BLOCK_TABLE[last_blocks[strain]].seq[len] = '\0';
							
							if (SNINDEL_LIST->type == 'I') STRAINLEN[strain] += len;
							else {
								delpos = strlen(BRANCHSEQ[strain-1]) - SNINDEL_LIST->seqlen;
								if (delpos > BLOCK_SIZE) {
									STRAINLEN[strain] += BLOCK_SIZE;
									delpos -= BLOCK_SIZE;
									BLOCK_TABLE[last_blocks[strain]].indel_offset = 0;
								}
								else {
									BLOCK_TABLE[last_blocks[strain]].indel_offset = delpos-len-1;
									STRAINLEN[strain] += delpos;
									delpos = 0;
								}
							}

//if (DEBUG) { seq[0]='\0'; printf("strain %d: .%s.\n",strain, decode_seq(seq, BRANCHSEQ[strain-1])); seq[0]='\0'; printf("blockseq1 .%s.\n", decode_seq(seq, BLOCK_TABLE[last_blocks[strain]].seq)); }
							
							BLOCK_TABLE[last_blocks[strain]].ins_pos = 0;
											
							// build other indel blocks if indel spans over more than 1 block (> BLOCK_SIZE)
							blocks = strlen(BRANCHSEQ[strain-1])/BLOCK_SIZE - (strlen(BRANCHSEQ[strain-1]) % BLOCK_SIZE == 0);
							for (k=1; k<=blocks; ++k) {
								if (BLOCK == BLOCK_TABLE_SIZE - 1) {
									fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
									exit(0);
								}
								BLOCK++;
								BLOCK_TABLE[BLOCK].chr = chr; 
								BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[strain];
								BLOCK_TABLE[BLOCK].strain = strain;
								BLOCK_TABLE[BLOCK].prev_block = last_blocks[strain];
//if (DEBUG) printf("BLOCK_TABLE[last_blocks[strain]].indel_offset %d BLOCK_TABLE[last_blocks[strain]].ins_pos %d\n", BLOCK_TABLE[last_blocks[strain]].indel_offset, BLOCK_TABLE[last_blocks[strain]].ins_pos);
								
								if (SNINDEL_LIST->type == 'I') {
									// determine indel_offset / ins_pos and pos entries of blocktable
									if (BLOCK_TABLE[last_blocks[strain]].indel_offset > 0) {
										BLOCK_TABLE[BLOCK].indel_offset = 0;
										BLOCK_TABLE[BLOCK].ins_pos = BLOCK_TABLE[last_blocks[strain]].ins_pos + BLOCK_SIZE - BLOCK_TABLE[last_blocks[strain]].indel_offset + 3;
										BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos;
									}
									else if (BLOCK_TABLE[last_blocks[strain]].ins_pos > 0) {
										BLOCK_TABLE[BLOCK].indel_offset = 0;
										BLOCK_TABLE[BLOCK].ins_pos = BLOCK_TABLE[last_blocks[strain]].ins_pos + BLOCK_SIZE;
										BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos; 
									}
									else {
										BLOCK_TABLE[BLOCK].ins_pos = 0;
										BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos + BLOCK_SIZE;
										if (indel_offset > BLOCK_SIZE) {
											indel_offset -= BLOCK_SIZE;
											BLOCK_TABLE[BLOCK].indel_offset = 0;
										}
										else BLOCK_TABLE[BLOCK].indel_offset = indel_offset;

									}
								}
								else {
									BLOCK_TABLE[BLOCK].pos = BLOCK_TABLE[last_blocks[strain]].pos + BLOCK_SIZE;
									BLOCK_TABLE[BLOCK].ins_pos = 0;
								}
								
								len = (strlen(BRANCHSEQ[strain-1]) - k * BLOCK_SIZE > BLOCK_SIZE)? BLOCK_SIZE: strlen(BRANCHSEQ[strain-1]) - k * BLOCK_SIZE;
								strncpy(BLOCK_TABLE[BLOCK].seq, BRANCHSEQ[strain-1] + k * BLOCK_SIZE, len);
								BLOCK_TABLE[BLOCK].seq[len] = '\0';
								
								seq[0]='\0';
//if (DEBUG) printf("blockseqs .%s.\n", decode_seq(seq, BLOCK_TABLE[BLOCK].seq));
								
								BLOCK_TABLE[last_blocks[strain]].next_block = BLOCK;
								last_blocks[strain] = BLOCK;
								
								if (SNINDEL_LIST->type == 'I') STRAINLEN[strain] += len;
								else {
									if (delpos > BLOCK_SIZE) {
										STRAINLEN[strain] += BLOCK_SIZE;
										delpos -= BLOCK_SIZE;
										BLOCK_TABLE[BLOCK].indel_offset = 0;
									}
									else {
										BLOCK_TABLE[BLOCK].indel_offset = delpos-len-1;
										STRAINLEN[strain] += delpos;
										delpos = 0;
									}
								}
							}
							
							whole_branchlen[strain] += strlen(BRANCHSEQ[strain-1]);
//if (DEBUG) printf("whole_branchlen[%d] = %d actual: %d\n",strain, whole_branchlen[strain],actual_branchlen[strain]);
							
							// set branch seq to 0
							actual_branchlen[strain] = 0;
							BRANCHSEQ[strain-1][0] = '\0';
							
							len = (SNINDEL_LIST->type == 'I')? SNINDEL_LIST->pos - varpos: SNINDEL_LIST->pos + SNINDEL_LIST->seqlen - varpos;
							branchblock_startpos[strain] = len;
							whole_branchlen[0] = (len > whole_branchlen[0])? len: whole_branchlen[0];

							branchblock_startpos[0] = whole_branchlen[0];
							
//if (DEBUG) print_blocktable(10);
						}
						
						// length on reference:
						if (SNINDEL_LIST->type != 'I') len = SNINDEL_LIST->pos - varpos + SNINDEL_LIST->seqlen;
						else len = SNINDEL_LIST->pos - varpos;
						whole_branchlen[0] = (len > whole_branchlen[0])? len: whole_branchlen[0];
						
//if (DEBUG) printf("ref.length: %d -diff %d snindellen %d\n",whole_branchlen[0], -diff, SNINDEL_LIST->seqlen);
						
//if (DEBUG) printf("  BRANCHSEQ[%d] .%s. len %d\n", SNINDEL_LIST->strain,BRANCHSEQ[SNINDEL_LIST->strain-1],actual_branchlen[SNINDEL_LIST->strain]);
					
					}
					
					memcpy(&old_snindels[SNINDEL_LIST->strain], SNINDEL_LIST, sizeof(SNINDEL));
				}
				
			} while (diff < INDEX_DEPTH);
			// for now, all branch seqs aren't complete in the superblock except of the one(s) with the most right snindel
			
			
//if (DEBUG) { printf("---SNINDELLIST---\n"); snindel_iterator = SNINDEL_LIST; while (snindel_iterator != NULL) { printf("{acc %d, chr %s, pos %d, len %d, %c %s}\n", snindel_iterator->strain, snindel_iterator->chr, snindel_iterator->pos, (int)strlen(snindel_iterator->seq), snindel_iterator->type, snindel_iterator->seq); snindel_iterator = snindel_iterator->next; } printf("-----------------\n"); for (k=0; k<=NUM_STRAINS; ++k) printf("%d: chr %s pos %d\n",k,SNINDELS[k].chr, SNINDELS[k].pos); }
			
			// split reference part of superblock into blocks (len: whole_branchlen[0])
			// then finish branches
			// build refblock after superblock
			// build backpointers
			
			// reference part of superblock	(length: whole_branchlen[0], if 0 -> jump over)		branchblock_startpos[0] is max over all strains 
//if (DEBUG) printf("flanking_block+1 %d, last_blocks[0] %d pos %d\n",flanking_block+1, last_blocks[0],BLOCK_TABLE[last_blocks[0]].pos);
			if (whole_branchlen[0] > 0) {
				len = (whole_branchlen[0] > BLOCK_SIZE)? BLOCK_SIZE: whole_branchlen[0];
				strncpy(BLOCK_TABLE[last_blocks[0]].seq, CHR_SEQ+BLOCK_TABLE[last_blocks[0]].pos, len);
				BLOCK_TABLE[last_blocks[0]].seq[len] = '\0';
				
				blocks = whole_branchlen[0]/BLOCK_SIZE - (whole_branchlen[0] % BLOCK_SIZE == 0);
				for (k=1; k<=blocks; ++k) {
					// create new block:
					if (BLOCK == BLOCK_TABLE_SIZE - 1) {
						fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
						exit(0);
					}
					BLOCK++;
					BLOCK_TABLE[BLOCK].chr = chr;
					BLOCK_TABLE[BLOCK].pos = varpos + k * BLOCK_SIZE;
					BLOCK_TABLE[BLOCK].strainpos = 1;	// to indicate that this reference block is in a superblock
					BLOCK_TABLE[BLOCK].strain = 0;
					len = (k==blocks)? whole_branchlen[0] - k * BLOCK_SIZE: BLOCK_SIZE;
					strncpy(BLOCK_TABLE[BLOCK].seq, CHR_SEQ+BLOCK_TABLE[BLOCK].pos, len);
					BLOCK_TABLE[BLOCK].seq[len] = '\0';
					BLOCK_TABLE[last_blocks[0]].next_block = BLOCK;
					BLOCK_TABLE[BLOCK].prev_block = last_blocks[0];
					
					last_blocks[0] = BLOCK;
					
				}
				
				last_strain_block = last_blocks[0];
				
//if (DEBUG) printf("Reference sequence[%d]: .%s. seqlen %d whole_branchlen[0] = %d latest %d\n", last_blocks[0], BLOCK_TABLE[last_blocks[0]].seq, (int)strlen(BLOCK_TABLE[last_blocks[0]].seq), whole_branchlen[0],branchblock_startpos[0]);
			}
			
//if (DEBUG) { printf("Reference part of superblock finished:\n"); print_blocktable(20); }
			
			
			// browse ACTIVE_BLOCKS and finish the branch blocks sequences
//if (DEBUG) { blocklist_iterator = ACTIVE_BLOCKS; printf("############### ACTIVE_BLOCKLIST #################\n"); while (blocklist_iterator != NULL) { printf("block %d\n", blocklist_iterator->blocknr); blocklist_iterator = blocklist_iterator->next; } printf("############### ACTIVE_BLOCKLIST #################\n"); }
			
			blocklist_iterator = ACTIVE_BLOCKS;
			while (blocklist_iterator != NULL) {
//if (DEBUG) printf("finish branches\n");
				
				block = blocklist_iterator->blocknr;
				strain = BLOCK_TABLE[block].strain;
				
				block = last_blocks[strain];
				
//if (DEBUG) printf("block %d strain %d\n", block, strain);
//if (DEBUG) printf("varpos %d whole_branchlen[0] %d old_snindels.pos %d old_snindels.type %c seqlen %d\n", varpos,whole_branchlen[0], old_snindels[strain].pos, old_snindels[strain].type, old_snindels[strain].seqlen);
				
				len = whole_branchlen[0] - branchblock_startpos[strain] - strlen(BRANCHSEQ[strain-1]);
//if (DEBUG) printf("len: %d%s",len, (len<0)? "->0\n": "\n");
				
				if (old_snindels[strain].type != 'S') {
					if (len > 0) {
						// create new branchblock(s)	length: whole_branchlen[0] - branchblock_startpos[strain]
						if (BLOCK == BLOCK_TABLE_SIZE - 1) {
							fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
							exit(0);
						}
						BLOCK++;
						BLOCK_TABLE[BLOCK].chr = chr;
						BLOCK_TABLE[BLOCK].pos = varpos + branchblock_startpos[strain];
						BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[strain];
						BLOCK_TABLE[BLOCK].strain = strain;
						BLOCK_TABLE[BLOCK].prev_block = last_blocks[strain];
						
						BLOCK_TABLE[last_blocks[strain]].next_block = BLOCK;
						last_blocks[strain] = BLOCK;
						
						block = BLOCK;
					}
					else {
						// no need to fill up strain -> next strain
						BLOCK_TABLE[last_strain_block].next_strain_end = block;
						last_strain_block = block;
						branchblock_startpos[strain] = 0;
						blocklist_iterator = blocklist_iterator->next;
						continue;
					}
				}
				
				
				strncpy(BRANCHSEQ[strain-1]+actual_branchlen[strain], CHR_SEQ+varpos+whole_branchlen[0]-len, len);
				actual_branchlen[strain] += len;
				BRANCHSEQ[strain-1][actual_branchlen[strain]] = '\0';
				
//if (DEBUG) printf("BRANCHSEQ[%d] = .%s.\n",strain, BRANCHSEQ[strain-1]);
				
				len = (actual_branchlen[strain] > BLOCK_SIZE)?  BLOCK_SIZE: actual_branchlen[strain];
				strncpy(BLOCK_TABLE[block].seq, BRANCHSEQ[strain-1], len);
				
				STRAINLEN[strain] += len;
				
				last_blocks[strain] = block;
				
				blocks = actual_branchlen[strain]/BLOCK_SIZE - (actual_branchlen[strain] % BLOCK_SIZE == 0);
//if (DEBUG) printf("blocks for branches = %d\n",blocks);
				if (blocks == 0) {
					BLOCK_TABLE[last_strain_block].next_strain_end = block;
					last_strain_block = block;
				}
				else {
					for (k=1; k<=blocks; ++k) {
						// create new block(s):
						if (BLOCK == BLOCK_TABLE_SIZE - 1) {
							fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
							exit(0);
						}
						BLOCK++;
						BLOCK_TABLE[BLOCK].chr = chr;
						BLOCK_TABLE[BLOCK].pos = varpos + branchblock_startpos[strain] + k * BLOCK_SIZE;
						BLOCK_TABLE[BLOCK].strainpos = STRAINLEN[strain];
						BLOCK_TABLE[BLOCK].strain = strain;
						len = (k==blocks)? actual_branchlen[strain] - k * BLOCK_SIZE: BLOCK_SIZE;
						strncpy(BLOCK_TABLE[BLOCK].seq, BRANCHSEQ[strain-1]+(k*BLOCK_SIZE), len);
						BLOCK_TABLE[BLOCK].seq[len] = '\0';
//if (DEBUG) printf("strain BRANCHSEQ[%d]: .%s.\n",BLOCK, BLOCK_TABLE[BLOCK].seq);
						BLOCK_TABLE[last_blocks[strain]].next_block = BLOCK;
						BLOCK_TABLE[BLOCK].prev_block = last_blocks[strain];
						BLOCK_TABLE[BLOCK].next_strain_end = 0;
						BLOCK_TABLE[BLOCK].next_strain_front = 0;
						if (k==blocks) {
							BLOCK_TABLE[last_strain_block].next_strain_end = BLOCK;
							last_strain_block = BLOCK;
						}
						
						last_blocks[strain] = BLOCK;
						
						STRAINLEN[strain] += strlen(BLOCK_TABLE[BLOCK].seq);
					}
				}
				
				branchblock_startpos[strain] = 0;
				
				blocklist_iterator = blocklist_iterator->next;
				
			} // finish branches
			
			// Now all sequences are built and BLOCKs are defined
			// => Superblock is finished.
			
			
//if (DEBUG) { printf("---SNINDELLIST---\n"); snindel_iterator = SNINDEL_LIST; while (snindel_iterator != NULL) { printf("{acc %d, chr %s, pos %d, len %d, %c %s}\n", snindel_iterator->strain, snindel_iterator->chr, snindel_iterator->pos, (int)strlen(snindel_iterator->seq), snindel_iterator->type, snindel_iterator->seq); snindel_iterator = snindel_iterator->next; } printf("-----------------\n"); }
			
			// determine the next varpos:
			if (SNINDEL_LIST != NULL) new_varpos = (SNINDEL_LIST->pos < INDEX_DEPTH)? 0: SNINDEL_LIST->pos - INDEX_DEPTH + 1;
			
//if (DEBUG) printf("new_varpos = %d \n", new_varpos);
			
			// reference blocks after superblock	(length: new_varpos-varpos-whole_branchlen[0])
			len = new_varpos-varpos-whole_branchlen[0];
//if (DEBUG) printf("len %d	new_varpos %d  varpos %d  wholebranchlen0 %d\n",len,new_varpos,varpos,whole_branchlen[0]);
			if (len != 0) {
				blocks = len/BLOCK_SIZE - (len % BLOCK_SIZE == 0);

//if (DEBUG) printf("last blcoks[0]: %d\n",last_blocks[0]);
//if (DEBUG) printf("blocks for refblock after superblock: %d (length: %d)\n",blocks+1, new_varpos-varpos-whole_branchlen[0]);

				for (k=0; k<=blocks; ++k) {
					if (BLOCK == BLOCK_TABLE_SIZE - 1) {
						fprintf(stderr, "ERROR: Too large chromosomes/contigs or too many chromosomes/contigs! Split input file into many smaller ones!\n");
						exit(0);
					}
					BLOCK++;
					BLOCK_TABLE[last_blocks[0]].next_block = BLOCK;
					BLOCK_TABLE[BLOCK].prev_block = last_blocks[0];
					BLOCK_TABLE[BLOCK].chr = chr;
					BLOCK_TABLE[BLOCK].pos = varpos + whole_branchlen[0] + k * BLOCK_SIZE;
					BLOCK_TABLE[BLOCK].strainpos = 0;
					BLOCK_TABLE[BLOCK].strain = 0;
					strncpy(BLOCK_TABLE[BLOCK].seq, CHR_SEQ+BLOCK_TABLE[BLOCK].pos, (k==blocks)? len - k * BLOCK_SIZE: BLOCK_SIZE);
					BLOCK_TABLE[BLOCK].seq[(k==blocks)? len - k * BLOCK_SIZE: BLOCK_SIZE] = '\0';
					BLOCK_TABLE[BLOCK].next_strain_end = 0;
					
//if (DEBUG) printf("refblock after superblock seq: .%s. len %d\n", BLOCK_TABLE[BLOCK].seq, (int)strlen(BLOCK_TABLE[BLOCK].seq));
					
					last_blocks[0] = BLOCK;
					
					if (k==0) flanking_block = BLOCK;
				}
				
			}
			else {
				BLOCK_TABLE[last_blocks[0]].next_block = 0;
			}
			
			branchblock_startpos[0] = 0;
			
//if (DEBUG) print_blocktable(10);
			
			// build pointers at the end of superblock
			blocklist_iterator = ACTIVE_BLOCKS;
			while (blocklist_iterator != NULL) {
				strain = BLOCK_TABLE[blocklist_iterator->blocknr].strain;
				BLOCK_TABLE[last_blocks[strain]].next_block = (varpos+whole_branchlen[0] >= CHR_LENGTH)? 0: flanking_block;
				blocklist_iterator = blocklist_iterator->next;
			}


//if (DEBUG) print_blocktable(10);
						
			///////////////////////
			// get all seeds of superblock - iterate over all STRAINS		starting at pos (not varpos)
			char has_slot = HAS_SLOT;
			unsigned int p = 0, s = 0;
			unsigned int psdelta=0;
			int spacerblock;
			blocklist_iterator = ACTIVE_BLOCKS;
			while (blocklist_iterator != NULL) {
				
				block = blocklist_iterator->blocknr;
				strain = BLOCK_TABLE[block].strain;
				
				p = pos - BLOCK_TABLE[block].pos;
				HAS_SLOT = has_slot;
				if (HAS_SLOT) {
					SLOT[strain] = SLOT[0];
					if (BUILD_REVERSE_INDEX) SLOT_REV[strain] = SLOT_REV[0];
					
					s = p + INDEX_DEPTH - 1;
					psdelta = INDEX_DEPTH - 1;
				}
				else {
					s = p;
					psdelta = 0;
				}
				
				
				// determine spacerblock for the beginning (if s is set to pos+INDEX_DEPTH-1, the correct block has to be found, otherwise spacerblock is block) 
				spacerblock = block;
				// now done in the loop at the beginning instead of following deleted while loop
				
//if (DEBUG) printf("STRAIN %d / block %d  -  p: %d, s: %d, spacerblock %d pos %d varpos %d\n", strain, block, p, s, spacerblock, pos, varpos);
				
				k = p;
				whole_branchlen[strain] += actual_branchlen[strain];
//if (DEBUG) printf("whole branchlen: %d k %d\n",whole_branchlen[strain], k);

				while (k < whole_branchlen[strain]) {
					
					if (spacerblock != 0 && s >= strlen(BLOCK_TABLE[spacerblock].seq)) {
						if (BLOCK_TABLE[spacerblock].next_block == 0) s = BLOCK_TABLE[spacerblock].pos + strlen(BLOCK_TABLE[spacerblock].seq);
						else s -= strlen(BLOCK_TABLE[spacerblock].seq);
						if (s >= CHR_LENGTH) break;
						spacerblock = BLOCK_TABLE[spacerblock].next_block;
					}

					while (p >= strlen(BLOCK_TABLE[block].seq)) {
						p -= strlen(BLOCK_TABLE[block].seq);
						block = BLOCK_TABLE[block].next_block;
					}
					
//if (DEBUG) printf("s %d spacerblock %d: %c p %d block %d psdelta %d k %d\n",s,spacerblock, get_strain_base(BLOCK_TABLE[spacerblock].seq[s]),p,block,psdelta,k);

					if (spacerblock != 0) base = get_strain_base(BLOCK_TABLE[spacerblock].seq[s]);
						else base = CHR_SEQ[s];	

					if (psdelta < INDEX_DEPTH - 1) {

						if (base=='A' || base=='T' || base=='C' || base=='G') {
							s++;
							psdelta++;
						}
						else {
//if (DEBUG) printf("0base %c\n",base);
							if (spacerblock == 0) break;
							s++;
							if (base != '-') {	// jump over deletions
								p = s;
								block = spacerblock;
								k += psdelta + 1;
								psdelta = 0;
								HAS_SLOT = 0;
							}
							else k++;
						}
					}
					else {

						if (base=='A' || base=='T' || base=='C' || base=='G') {
							
							if (get_strain_base(BLOCK_TABLE[block].seq[p]) != '-') {	// if first base of seed is '-', don't construct this seed!
								slot = get_slot(block, p, spacerblock, s);
								
								if(INDEX[slot] == NULL) {
									alloc_bin(slot);
									if (BUILD_REVERSE_INDEX) alloc_bin_rev(SLOT_REV[strain]);
								}
			
								pos2bin(slot, block, p, chr);	// 0-initialized
								
								if (BUILD_REVERSE_INDEX) {
									pos2bin_rev(SLOT_REV[strain], block, p, chr); 			// 0-initialized
								}
								
								s++;
								HAS_SLOT = 1;
								k++;
							}	// HAS_SLOT???????? !!!!!!!!!!!!!!!!!!!!!
							
							p++;
						}
						else {
//if (DEBUG) printf("s %d spacerblock %d 1base %c\n",s,spacerblock,base);
							if (spacerblock == 0) break;
							s++;
							if (base != '-') {	// jump over deletions
								p = s;
								block = spacerblock;
								k += psdelta + 1;
								psdelta = 0;
								HAS_SLOT = 0;
							}
							else k++;
						}
					}
					
				}
				
				whole_branchlen[strain] = 0;	
				
				blocklist_iterator = blocklist_iterator->next;
			}
			///////////////////////
			
//if (DEBUG) printf("\nactual_refblock : %d\n",actual_refblock);
			
			
			if (strlen(BLOCK_TABLE[actual_refblock].seq)>0) {
				///////////////////////
				// get REFERENCE slots:
				HAS_SLOT = has_slot;
				p = pos;
				s = spacer;
				blockpos = pos - BLOCK_TABLE[actual_refblock].pos;
//if (DEBUG) printf("REF / block %d  -  has_slot %d p: %d, spacer: %d, blockpos: %d pos %d varpos %d\n", actual_refblock, HAS_SLOT, p, spacer, blockpos, pos, varpos);
				
				while (p < varpos + whole_branchlen[0] && s < CHR_LENGTH) {
//if (DEBUG) printf("s %d p %d blockpos %d\n",s, p,blockpos);
					
					if (s < p + INDEX_DEPTH - 1) {
						if (CHR_SEQ[s]=='A' || CHR_SEQ[s]=='T' || CHR_SEQ[s]=='C' || CHR_SEQ[s]=='G') {
							s++;				
						}
						else {
							s++;
							blockpos += s - p;
							p = s;
							HAS_SLOT = 0;
						}
					}
					else {
						if (CHR_SEQ[s]=='A' || CHR_SEQ[s]=='T' || CHR_SEQ[s]=='C' || CHR_SEQ[s]=='G') {
			
							// reference slot:
							slot = get_slot(actual_refblock, blockpos, 0, s); // yields also SLOT_REV if -r option wasn't set
			
							if(INDEX[slot] == NULL) {
								alloc_bin(slot);
								if (BUILD_REVERSE_INDEX) alloc_bin_rev(SLOT_REV[0]);
							}
							pos2bin(slot, actual_refblock, blockpos, chr);	// 0-initialized
							
							if (BUILD_REVERSE_INDEX) {
								pos2bin_rev(SLOT_REV[0], actual_refblock, blockpos, chr); // 0-initialized
							}
							
							s++;
							p++;
							blockpos++;
							HAS_SLOT = 1;
						}
						else {
							s++;
							blockpos += s - p;				
							p = s;
							HAS_SLOT = 0;
						}
					}
					
//if (DEBUG) printf("blockpos %d p %d s %d\n",blockpos, p, s);
					while (blockpos >= strlen(BLOCK_TABLE[actual_refblock].seq)) {
						if (BLOCK_TABLE[actual_refblock].next_block == 0) break;
						blockpos -= strlen(BLOCK_TABLE[actual_refblock].seq);						
						actual_refblock = BLOCK_TABLE[actual_refblock].next_block;
//if (DEBUG) printf("blockpos %d actualrefblock %d\n",blockpos, actual_refblock);
					}
				}
				///////////////////////
			}
			else {
				HAS_SLOT = 0;
			}
			
//if (DEBUG) { printf("blockpos %d\n",blockpos); printf("pos %d\n",pos); printf("s %d\n",s); }
			
			if (s >= CHR_LENGTH) break;
			
//if (DEBUG) printf("\nactual_refblock : %d\n",actual_refblock);
			
			
			spacer = (pos != 0)? s-1: s;
			if (blockpos == 0) pos = BLOCK_TABLE[actual_refblock].pos;
			else pos = p;
		
			memcpy(old_snindels, SNINDELS, (NUM_STRAINS+1) * sizeof(SNINDEL));
			
			varpos = new_varpos;
			
//if (DEBUG) printf("varpos = %d %d\n",varpos, CHR_LENGTH);
			
			// reset for next branch
			memcpy(BLOCK_LIST, EMPTY_BLOCK_LIST, (NUM_STRAINS+1) * sizeof(BLOCK_LIST_ENTRY));
			ACTIVE_BLOCKS = NULL;

		} // branch opening
		

		if (spacer == CHR_LENGTH) {
			pos++;
			spacer++;	
		} 
		else if (strlen(BLOCK_TABLE[actual_refblock].seq) != 0) 	{
			
			// GETTING THE SLOTS
//if (DEBUG) printf("2REF / block %d  -  pos: %d, spacer: %d, blockpos: %d pos %d varpos %d base(spacer)=%c\n", actual_refblock, pos, spacer, blockpos, pos, varpos, CHR_SEQ[spacer]);		
			if (spacer < pos + INDEX_DEPTH - 1) {
				if (CHR_SEQ[spacer]=='A' || CHR_SEQ[spacer]=='T' || CHR_SEQ[spacer]=='C' || CHR_SEQ[spacer]=='G') {
					spacer++;
				}
				else {
					spacer++;
					blockpos += spacer - pos;
					pos = spacer;
					HAS_SLOT = 0;
				}
			}
			else {
				if (CHR_SEQ[spacer]=='A' || CHR_SEQ[spacer]=='T' || CHR_SEQ[spacer]=='C' || CHR_SEQ[spacer]=='G') {
					// reference slot:
					slot = get_slot(actual_refblock, blockpos, 0, spacer); // yields also SLOT_REV if -r option wasn't set
	
					if(INDEX[slot] == NULL) {
						alloc_bin(slot);
						if (BUILD_REVERSE_INDEX) alloc_bin_rev(SLOT_REV[0]);
					}

					pos2bin(slot, actual_refblock, blockpos, chr);	// 0-initialized

					if (BUILD_REVERSE_INDEX) {
						pos2bin_rev(SLOT_REV[0], actual_refblock, blockpos, chr); // 0-initialized
					}	
					
					spacer++;
					pos++;
					blockpos++;
					HAS_SLOT = 1;
				}
				else {
					spacer++;
					blockpos += spacer - pos;				
					pos = spacer;
					HAS_SLOT = 0;
				}
			}
		}
		
		// BLOCK_SIZE EXCEEDING
//if (DEBUG) printf("block size exceeding? blockpos %d\n", blockpos);
		while (blockpos >= strlen(BLOCK_TABLE[actual_refblock].seq)) {
			
			blockpos -= strlen(BLOCK_TABLE[actual_refblock].seq);
			if (BLOCK_TABLE[actual_refblock].next_block == 0) break;
			actual_refblock = BLOCK_TABLE[actual_refblock].next_block;

//if (DEBUG) printf("  BLOCK SIZE EXCEEDING --> actual refblock %d\n", actual_refblock);
		}

	}

//if (DEBUG) printf("actual refblock: %d, flanking_block: %d\n",actual_refblock, flanking_block);
	
	ACTIVE_BLOCKS = NULL;
	
	// finish strain lengths and update longest chromosome if applicable
	if (CHR_LENGTH > LONGEST_CHROMOSOME) LONGEST_CHROMOSOME = CHR_LENGTH;
	for (k=1; k<=NUM_STRAINS; ++k) {
		block = BLOCK_TABLE[last_blocks[k]].next_block;
		if (last_blocks[k] != 0 && block != 0) STRAINLEN[k] += CHR_LENGTH - BLOCK_TABLE[block].pos;
		if (STRAINLEN[k] > LONGEST_CHROMOSOME) LONGEST_CHROMOSOME = STRAINLEN[k];
	}
	
	
	free(old_snindels);
		
	if (VERBOSE) printf("... done\n");
//if (DEBUG) printf("Longest chromosome: %d\n",LONGEST_CHROMOSOME);

	return 1;
}



int get_slot(unsigned int block, unsigned int pos, unsigned int spacerblock, unsigned int spacer)
{
	
//if (DEBUG) printf("get slot with block %d at pos %d spacerblock %d spacer %d\n",block,pos, spacerblock, spacer);
	unsigned int slot = 0;
	unsigned int i;
	int c = 0;
	char base;
	int strain = BLOCK_TABLE[block].strain;
	
//if (DEBUG) printf("has slot = %d - %s\n",HAS_SLOT, get_seq(SLOT[strain]));
	
	if (HAS_SLOT == 0) { 
		
		if (BUILD_REVERSE_INDEX) SLOT_REV[strain] = 0;
		
		for (i=0; i<INDEX_DEPTH; i++) {
			
			if (BLOCK_TABLE[block].strain == 0) base = CHR_SEQ[BLOCK_TABLE[block].pos + pos];
			else {
				while (pos >= strlen(BLOCK_TABLE[block].seq)) {
					pos -= strlen(BLOCK_TABLE[block].seq);
					block = BLOCK_TABLE[block].next_block;
				}
			
				while (get_strain_base(BLOCK_TABLE[block].seq[pos]) == '-') {
					pos++;
					if (pos >= strlen(BLOCK_TABLE[block].seq)) {
						block = BLOCK_TABLE[block].next_block;
						pos = 0;
					}
				}
				base = get_strain_base(BLOCK_TABLE[block].seq[pos]);
			}
			
//if (DEBUG) printf("pos=%d, base='%c'\n", pos, base);
			
			switch (base) 
			{
				case 'A':	c = 0;
							break;
				case 'C':	c = 1;
							break;
				case 'G':	c = 2;
							break;
				case 'T':	c = 3;
							break;
				default:	fprintf(stderr, "ERROR: Encountered unallowed character '%c' at position %d in strain %d\n", 
							base, (BLOCK_TABLE[block].strain!=0)? pos+i: pos+i-BLOCK_TABLE[block].pos, BLOCK_TABLE[block].strain);
						exit(1);
			}
			
			slot = slot + POWER[i] * c;
			if (BUILD_REVERSE_INDEX) SLOT_REV[strain] += POWER[INDEX_DEPTH - i - 1] * (c ^ 3);
			
			pos++;
		}
	}
	else {

		slot = SLOT[strain];
		slot >>= 2;

		if (BUILD_REVERSE_INDEX) {
			SLOT_REV[strain] <<= 2;
		}
		
		if (BLOCK_TABLE[block].strain == 0 || (spacerblock == 0 && spacer > 0)) base = CHR_SEQ[spacer];
		else {
			base = get_strain_base(BLOCK_TABLE[spacerblock].seq[spacer]);
		}

//if (DEBUG) printf("pos+indexdepth-1=%d base='%c'\n",pos,base);

		switch (base)
		{
			case 'A':	slot = slot | BINARY_CODE[0];
						if (BUILD_REVERSE_INDEX) SLOT_REV[strain] |= 3;
						break;
			case 'C':	slot = slot | BINARY_CODE[1];
						if (BUILD_REVERSE_INDEX) SLOT_REV[strain] |= 2;
						break;			
			case 'G':	slot = slot | BINARY_CODE[2];
						if (BUILD_REVERSE_INDEX) SLOT_REV[strain] |= 1;
						break;		
			case 'T':	slot = slot | BINARY_CODE[3];
						break;
			default:	fprintf(stderr, "ERROR: Encountered unallowed character '%c' at position %d in strain %d\n", 
						base, (BLOCK_TABLE[block].strain==0)? pos+INDEX_DEPTH-1: pos+INDEX_DEPTH-BLOCK_TABLE[block].pos-2, BLOCK_TABLE[block].strain);
					exit(1);
		}
		
	}

	SLOT_REV[strain] &= BINARY_CODE[4];
	SLOT[strain] = slot;
	
//if (DEBUG) printf("slot %d %s slot_rev %d %s\tstrain %d\n", SLOT[strain], get_seq(SLOT[strain]), SLOT_REV[strain], get_seq(SLOT_REV[strain]), strain);

	return(slot);
}



int pos2bin(unsigned int slot, unsigned int block, unsigned char pos, unsigned int chr) 
{
	BIN_EXT **bin_ext;
	BIN *bin, *binrev;
	unsigned int num, numrev;
	
//if (DEBUG) printf("pos2bin slot %d %s pos %d\n", slot, get_seq(slot), pos);

	bin = INDEX[slot];
	bin->num_all++;
	num = bin->num_pos;

	numrev = 0;
	if (BUILD_REVERSE_INDEX && INDEX_REV[slot] != NULL) {
		binrev = INDEX_REV[slot];
		numrev = binrev->num_pos;	
	}

	POSITION_COUNTER++;

	if (num == 0 && numrev == 0) {
		USED_SLOTS[NUM_USED_SLOTS] = slot;
		NUM_USED_SLOTS++;
	}

	if (num == 0) {
		SLOT_COUNTER++;
	}

	if (num < BIN_SIZE) {
		memcpy(&(bin->ids[num].id[0]), &block, 3 * sizeof(char));
		memcpy(&(bin->ids[num].id[3]), &pos, sizeof(unsigned char));
		bin->num_pos++;
	}
	else {
		bin_ext = &(bin->bin_ext);
		if (*bin_ext == 0) {
			*bin_ext = alloc_bin_ext();
			memcpy(&(*bin_ext)->ids[0].id, &block, 3 * sizeof(char));
			memcpy(&(*bin_ext)->ids[0].id[3], &pos, sizeof(unsigned char));

        	bin->num_pos++;
			bin->last_bin_ext = *bin_ext;
			return 0;
		}
		else {
			bin_ext = &(bin->last_bin_ext);
			if ((num % BIN_SIZE_EXT) != BIN_SIZE) {
				memcpy(&(*bin_ext)->ids[(num-BIN_SIZE) % BIN_SIZE_EXT].id, &block, 3 * sizeof(char));
				memcpy(&(*bin_ext)->ids[(num-BIN_SIZE) % BIN_SIZE_EXT].id[3], &pos, sizeof(unsigned char));
				bin->num_pos++;
				return 0;
			}
			else  {
				bin_ext = &((*bin_ext)->bin_ext);
				*bin_ext = alloc_bin_ext();
				memcpy(&(*bin_ext)->ids[0].id, &block, 3 * sizeof(char));
				memcpy(&(*bin_ext)->ids[0].id[3], &pos, sizeof(unsigned char));
				bin->num_pos++;
				bin->last_bin_ext = *bin_ext;
			}
		}
	}

	return(0);
}


int pos2bin_rev(unsigned int slot, unsigned int block, unsigned char pos, unsigned int chr) 
{
//if (DEBUG) printf("pos2bin_rev slot %d %s pos %d\n", slot, get_seq(slot), pos);
	BIN_EXT **bin_ext;
	BIN *bin, *binfwd;
	unsigned int num, numfwd;
	
	bin = INDEX_REV[slot];
	bin->num_all++;
	num = bin->num_pos;
	
	numfwd = 0;
	if (INDEX[slot] != NULL) {
		binfwd = INDEX[slot];
		numfwd = binfwd->num_pos;
	}

	if (num == 0 && numfwd == 0) {
		USED_SLOTS[NUM_USED_SLOTS] = slot;
		NUM_USED_SLOTS++;
	}
	
	if (num < BIN_SIZE) {
		memcpy(&(bin->ids[num].id[0]), &block, 3 * sizeof(char));
		memcpy(&(bin->ids[num].id[3]), &pos, sizeof(unsigned char));
		
		bin->num_pos++;
	}
	else {
		bin_ext = &(bin->bin_ext);
		if (*bin_ext == 0) {
			*bin_ext = alloc_bin_ext();
			memcpy(&(*bin_ext)->ids[0].id, &block, 3 * sizeof(char));
			memcpy(&(*bin_ext)->ids[0].id[3], &pos, sizeof(unsigned char));

        	bin->num_pos++;
			bin->last_bin_ext = *bin_ext;
			return 0;
		}
		else {
			bin_ext = &(bin->last_bin_ext);
			if ((num % BIN_SIZE_EXT) != BIN_SIZE) {
				memcpy(&(*bin_ext)->ids[(num-BIN_SIZE) % BIN_SIZE_EXT].id, &block, 3 * sizeof(char));
				memcpy(&(*bin_ext)->ids[(num-BIN_SIZE) % BIN_SIZE_EXT].id[3], &pos, sizeof(unsigned char));
				bin->num_pos++;
				return 0;
			}
			else  {
				bin_ext = &((*bin_ext)->bin_ext);
				*bin_ext = alloc_bin_ext();
				memcpy(&(*bin_ext)->ids[0].id, &block, 3 * sizeof(char));
				memcpy(&(*bin_ext)->ids[0].id[3], &pos, sizeof(unsigned char));
				bin->num_pos++;
				bin->last_bin_ext = *bin_ext;
			}
		}
	}

	return(0);
}

int get_next_snindel(SNINDEL* snindel, int strain, unsigned int chr)
{
//if (DEBUG) printf("get next snindel on strain %d on chr %d\n", strain, chr);
	strain--;
	char line[MAX_BRANCH_LENGTH];
	
	do {
		if (fgets(line, MAX_BRANCH_LENGTH, STRAIN_FP[strain]) == NULL || line[0] == '#') {
			// End of file
			return -1;
		}
	} while (strcspn(line, "\t\n ") == 0);

	strcpy(STRAIN_DESC[strain], strtok(&(line[0]), "\t"));	

	snindel->strain = strain+1;

	snindel->type = (strtok('\0', "\t"))[0];

	strcpy(snindel->chr, strtok('\0', "\t"));

	snindel->pos = atoi(strtok('\0', "\t")) - 1;

	snindel->seqlen = atoi(strtok('\0', "\t"));

	if (snindel->type == 'D' && snindel->pos + snindel->seqlen > CHR_LENGTH) {
		fprintf(stderr, "ERROR: Deletion in strain '%s' exceeds length of chromosome '%s'!\n", STRAIN_DESC[strain], CHR_DESC);
		exit(0);
	}

	strcpy(snindel->seq, strtok('\0', "\t"));
	if (snindel->seq[strlen(snindel->seq)-1] == '\n') snindel->seq[strlen(snindel->seq)-1] = '\0';

	if (snindel->type == 'S' && strlen(snindel->seq) > 1) {
		fprintf(stderr, "ERROR: SNP on pos %d in strain '%s' on chromosome '%s' has length > 1! .%s.\n",snindel->pos+1,STRAIN_DESC[strain], CHR_DESC,snindel->seq);
		exit(0);
	}

	if (snindel->type != 'S' && snindel->seqlen != strlen(snindel->seq)) {
		fprintf(stderr, "\nWARNING: .%s.Specified length of %s on pos %d doesn't match length of specified sequence in strain '%s' on chromosome '%s'! Sequence is cut to the lowest of the two values!%d %d\n\n", 
			snindel->seq, (snindel->type == 'I')? "insertion": "deletion", snindel->pos+1, STRAIN_DESC[strain], CHR_DESC,snindel->seqlen, (int)strlen(snindel->seq));
		if (snindel->seqlen < strlen(snindel->seq)) snindel->seq[snindel->seqlen] = '\0';
		else snindel->seqlen = strlen(snindel->seq);
	}

//if (DEBUG) printf("  next snindel: {acc %d, chr %s, pos %d, len %d, %c %s} CHR_DESC %s\n", snindel->strain, snindel->chr, snindel->pos, snindel->seqlen, snindel->type, snindel->seq, CHR_DESC);
	
	return 1;
}

char encode_char(char *r, char *s)
{
	switch (*r) {
		case 'A':	switch (*s) {
						case '-':	return 8;
						case 'A':	return 9;
						case 'C':	return 11;
						case 'G':	return 15;
						case 'T':	return 12;
						default :	return 14;
		}
		case 'C':	switch (*s) {
						case '-':	return 24;
						case 'A':	return 25;
						case 'C':	return 27;
						case 'G':	return 31;
						case 'T':	return 28;
						default :	return 30;
		}
		case 'G':	switch (*s) {
						case '-':	return 56;
						case 'A':	return 57;
						case 'C':	return 59;
						case 'G':	return 63;
						case 'T':	return 60;
						default :	return 62;
		}
		case 'T':	switch (*s) {
						case '-':	return 32;
						case 'A':	return 33;
						case 'C':	return 35;
						case 'G':	return 39;
						case 'T':	return 36;
						default :	return 38;
		}
		case '-':	switch (*s) {
						case 'A':	return 1;
						case 'C':	return 3;
						case 'G':	return 7;
						case 'T':	return 4;
						default :	return 6;
		}
		default:	switch (*s) {
						case '-':	return 48;
						case 'A':	return 49;
						case 'C':	return 51;
						case 'G':	return 55;
						case 'T':	return 52;
						default :	return 54;
		}
	}
}

char get_strain_base(char c)
{
	if (c > 64) return c;
	
	switch (c & 7) {
		case  1:	return 'A';
		case  3:	return 'C';
		case  7:	return 'G';
		case  4:	return 'T';
		case  0:	return '-';
		case  6:	return 'N';
	}
	
	return '\0';
} 


char *decode_seq(char *seq, char* template)
{
	int i;
	for (i=0; i!=strlen(template); ++i) {
		if (template[i] > 64) strncat(seq, template+i, 1);
		else {
			switch (template[i]) {
				case 8:		strcat(seq, "(A-)");break;
				case 9:		strcat(seq, "A");	break;
				case 11:	strcat(seq, "(AC)");break;
				case 15:	strcat(seq, "(AG)");break;
				case 12:	strcat(seq, "(AT)");break;
				case 14:	strcat(seq, "(AN)");break;
				case 24:	strcat(seq, "(C-)");break;
				case 25:	strcat(seq, "(CA)");break;
				case 27:	strcat(seq, "C");	break;
				case 31:	strcat(seq, "(CG)");break;
				case 28:	strcat(seq, "(CT)");break;
				case 30:	strcat(seq, "(CN)");break;
				case 56:	strcat(seq, "(G-)");break;
				case 57:	strcat(seq, "(GA)");break;
				case 59:	strcat(seq, "(GC)");break;
				case 62:	strcat(seq, "(GN)");break;
				case 63:	strcat(seq, "G");	break;
				case 60:	strcat(seq, "(GT)");break;
				case 32:	strcat(seq, "(T-)");break;
				case 33:	strcat(seq, "(TA)");break;
				case 35:	strcat(seq, "(TC)");break;
				case 39:	strcat(seq, "(TG)");break;
				case 38:	strcat(seq, "(TN)");break;
				case 36:	strcat(seq, "T");	break;
				case 1:		strcat(seq, "(-A)");break;
				case 3:		strcat(seq, "(-C)");break;
				case 7:		strcat(seq, "(-G)");break;
				case 4:		strcat(seq, "(-T)");break;
				case 6:		strcat(seq, "(-N)");break;
				case 45:	strcat(seq, "-");	break;
				case 48:	strcat(seq, "(N-)");break;
				case 49:	strcat(seq, "(NA)");break;
				case 51:	strcat(seq, "(NC)");break;
				case 55:	strcat(seq, "(NG)");break;
				case 52:	strcat(seq, "(NT)");break;
				case 54:	strcat(seq, "N");	break;
			}
		}
	}
	strcat(seq,"\0");
	
	return seq;
}	 

void decode_strainseq(char *seq, char* template)
{
	int i;
	for (i=0; i!=strlen(template); ++i) {
		if (template[i] > 64) strncat(seq, template+i, 1);
		else {
			switch (template[i] & 7) {
				case 1:	strcat(seq, "A"); break;
				case 3:	strcat(seq, "C"); break;
				case 7:	strcat(seq, "G"); break;
				case 4:	strcat(seq, "T"); break;
				case 6:	strcat(seq, "N"); break;
			}
		}
	}
}


void print_blocktable(int lim)
{
	char *seq = malloc(BLOCK_SIZE * 4 * sizeof(char));
	// print block table (debugging)
	printf("-----------------------------------------------------------------\n");
	int i;
	printf("block|posR|off|ins|posS|chr|st|prev|next|fbns|lbns| len | seq\n");
	for (i=1; i<=lim; ++i) {
		seq[0] = '\0';
		decode_seq(seq, BLOCK_TABLE[i].seq);
		printf("%5d|%4d|%3d|%3d|%4d|%3d|%2d|%4d|%4d|%4d|%4d|%5d|.%s.\n",
				i, BLOCK_TABLE[i].pos, BLOCK_TABLE[i].indel_offset, BLOCK_TABLE[i].ins_pos, BLOCK_TABLE[i].strainpos, BLOCK_TABLE[i].chr+1, BLOCK_TABLE[i].strain, BLOCK_TABLE[i].prev_block, BLOCK_TABLE[i].next_block, 
				BLOCK_TABLE[i].next_strain_front, BLOCK_TABLE[i].next_strain_end, (int)strlen(BLOCK_TABLE[i].seq), seq);
	}
	printf("-----------------------------------------------------------------\n");
	free(seq);
}
