// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008/09 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#if defined CONF
#else
#define CONF

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define VERSION "0.3g"

// ##############################################################
// ####### GLOBAL VARIABLES #####################################
// ##############################################################

#define MIN_INDEX_DEPTH 5
#define MAX_INDEX_DEPTH 13
#define MAX_NUM_STRAINS 32

char DEBUG;
char BUILD_REVERSE_INDEX;
char VERBOSE;
char HAS_SLOT;
unsigned int *SLOT;
unsigned int *SLOT_REV;

int INDEX_DEPTH;
int POWER[MAX_INDEX_DEPTH];
int BINARY_CODE[5];

unsigned int LONGEST_CHROMOSOME;

int debug;

// ##############################################################
// ####### FILE HANDLING ########################################
// ##############################################################

char GENOME_FILE_NAME[500];
char INDEX_FILE_NAME[500];
char META_INDEX_FILE_NAME[500];
char STRAIN_DIR[500];
char *STRAIN_FILE_NAME[MAX_NUM_STRAINS];
char GENOME_OUT_FILE_NAME[500];
//char OCC_FILE_NAME[500];

FILE *INDEX_FP;
FILE *META_INDEX_FP;
FILE *GENOME_FP;
FILE **STRAIN_FP;
FILE *GENOME_OUT_FP;
//FILE *OCC_FP;
FILE *BLOCKOUT;

// ##############################################################
// ######## SEQUENCE STORAGE ####################################
// ##############################################################

#define CHR_DESC_LENGTH 50

unsigned int CHR_LENGTH;
char *CHR_SEQ;

char CHR_DESC[CHR_DESC_LENGTH];
char CHR_DESC_TMP[CHR_DESC_LENGTH];

unsigned int SLOT_COUNTER; //counts the number of slots used by the forward index (equals the number of reverse slots though the slots themselves are different)
unsigned long int POSITION_COUNTER;

// ##############################################################
// ####### INDEX MANAGEMENT #####################################
// ##############################################################

#define BIN_SIZE 3
#define BIN_SIZE_EXT 20
//#define INDEX_SIZE 16777216 //4^12
#define INDEX_SIZE 67108864 //4^13
// #define INDEX_SIZE 244140625 // 5^12

#define BLOCK_TABLE_SIZE 16777216	// 2^24 (3 Byte)
#define BLOCK_SIZE 256	// 2^8 (1 Byte)

typedef union id_structure {
	unsigned int nr;
	unsigned char id[4];
} ID;

typedef struct block_table_entry {
	unsigned int pos;
	unsigned int strainpos;	
	unsigned int chr;
	unsigned int strain;
	short int indel_offset;	// 1-initialized!!!!!!!!!
	int ins_pos;		// 1-initialized!!!!!!!!!
	char seq[BLOCK_SIZE+1];	//@TODO sequence container!
	int prev_block;
	int next_block;
	int next_strain_front;	// new: order cannot be maintained :-( old: these blocks will always occur in continuous order, so no need to save next strain block 
	int next_strain_end;	// @TODO implement as offset
} BLOCK_TABLE_ENTRY;

BLOCK_TABLE_ENTRY *BLOCK_TABLE;
int BLOCK;

typedef struct block_list_entry {
	unsigned int blocknr;
	struct block_list_entry *next;
} BLOCK_LIST_ENTRY;

BLOCK_LIST_ENTRY *BLOCK_LIST;
BLOCK_LIST_ENTRY *ACTIVE_BLOCKS;
BLOCK_LIST_ENTRY *EMPTY_BLOCK_LIST;

typedef struct bin_extension_structure {
	ID ids[BIN_SIZE_EXT];
	struct bin_extension_structure *bin_ext;
} BIN_EXT;

typedef struct bin_structure {
	unsigned int num_all; // number over all chromosomes
	unsigned int num_pos;
	ID ids[BIN_SIZE];
	BIN_EXT *bin_ext;
	BIN_EXT *last_bin_ext;
} BIN;

BIN *INDEX[INDEX_SIZE];
BIN *INDEX_REV[INDEX_SIZE];

int NUM_USED_SLOTS; //different to SLOT_COUNTER! This counts the number of different used slots, used by reverse and forward Index.
int USED_SLOTS[INDEX_SIZE];


// ##############################################################
// ####### STRAIN MANAGEMENT ####################################
// ##############################################################

#define MAX_BRANCH_LENGTH 1000000

unsigned int NUM_STRAINS;
char STRAIN_DESC[MAX_NUM_STRAINS][100];

typedef struct snindellist_entry {
	char type;
	signed int pos;
	char chr[CHR_DESC_LENGTH];
	unsigned int strain;
	unsigned int seqlen;
	char seq[MAX_BRANCH_LENGTH];
	struct snindellist_entry *next;
	struct snindellist_entry *prev;
} SNINDEL;

SNINDEL *SNINDELS;
SNINDEL *SNINDEL_LIST;

char **BRANCHSEQ;
unsigned int *STRAINLEN;

// ##############################################################
// ####### MEMORY MANAGEMENT ####################################
// ##############################################################

#define BIN_EXT_PER_NUGGET 100000

typedef struct nugget_str {
	BIN_EXT buffer[BIN_EXT_PER_NUGGET];
	struct nugget_str *next;
} NUGGET;

typedef struct stmg_str {
	int curr_num;
	NUGGET *nuggets;
} STORAGE;

STORAGE *MEM_MGR;

// ##############################################################
// ####### ROUTINES #############################################
// ##############################################################

//init.c
int init(int argc, char *argv[]);

//usage.c
int usage();

//load.c
int load_chromosomes();
int desc_parsing(char *c);

//index.c
int index_chromosome(unsigned int chr);
void print_blocktable(int lim);
char *decode_seq(char *seq, char* template);

//alloc.c
int alloc_bin(int slot);
int alloc_bin_rev(int slot);
BIN_EXT *alloc_bin_ext();
void alloc_blocktable();
int dealloc_chr();
//SEQ_CONTAINER *alloc_seq_container();
BLOCK_LIST_ENTRY *alloc_blocklist();
void alloc_branchseqs();

//write.c
int write_index(unsigned int chr);
int write_chr(unsigned int chr);
int write_meta_index(unsigned int num_chr);
char *get_seq(unsigned int n);

//printindex.c
void printindex();

#endif
