// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008/09 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int usage() {
	printf("\nGenomeMapper v%sbeta\n", VERSION);
	printf("Max Planck Institute for Developmental Biology, Tübingen, Germany, 2009\n");
	printf("written by Korbinian Schneeberger and Joerg Hagmann\n\n");
	printf("USAGE: genomemapper [options]\n");
	printf("\n");
	printf("mandatory:\n");
	printf(" -i STRING  input fastafile\n");
	printf(" -x STRING  index filename\n");
	printf(" -t STRING  metaindex filename\n");
	printf(" -q STRING  query filename (fasta, fastq, SHORE flat file)\n");
	printf("\n");
	printf("optional:\n");
	printf(" -f STRING  output format (\"shore\" or \"bed\")\n");
	printf(" -o STRING  output filename (stdout)\n");
	printf(" -u STRING  unmapped reads filename\n");
	printf(" -s STRING  reference sequence ID (\"Ref\")\n\n");

	printf(" -a         report all hits (best hits only)\n");
	printf(" -r         disable reverse alignment\n");
	printf(" -h         always perform alignment on entire read\n");
	printf(" -d         align gaps most right (most left)\n");
	printf(" -w         allow more gaps for best hit\n");
	printf(" -e         report edit operations (alignment scores)\n");
	printf(" -l INT     seed length (index size)\n");
	printf(" -n INT     max number of best alignments (all)\n");
	printf(" -c INT     seed container size (15.000.000)\n\n");

	printf(" -M INT     max number of mismatches (3)\n");
	printf(" -G INT     max number of gaps (1)\n");
	printf(" -E INT     max edit operations(3)\n");
	printf(" -m DOUBLE  mismatch penalty (4)\n");
	printf(" -g DOUBLE  gap penalty (5)\n\n");

	printf(" -v         verbose (silent)\n");
	printf("\n");

	return 0;
}
