// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "gmindex.h"

int write_index_2_file(unsigned int chr);
int write_chr_desc(unsigned int chr);

int write_index(unsigned int chr) 
{
	write_chr_desc(chr);
	write_index_2_file(chr);

	return(0);
}

int write_chr_desc(unsigned int chr) 
{
	if (fwrite(&chr, sizeof(unsigned int), 1, INDEX_FP) == 0) { 
		fprintf(stderr, "ERROR: cant access harddisc for index file\n");
		exit(0); 
	}
	if (fwrite(&CHR_LENGTH, sizeof(unsigned int), 1, INDEX_FP) == 0) { 
		fprintf(stderr, "ERROR: cant access harddisc for index file\n");
		exit(0); 
	}
	if (fwrite(&CHR_DESC[0], sizeof(char), CHR_DESC_LENGTH, INDEX_FP) == 0) { 
		fprintf(stderr, "ERROR: cant access harddisc for index file\n");
		exit(0); 
	}	//@TODO CHR_LENGTH instead of CHR_DESC_LENGTH
	
	/*if (chr==0) ps = 0;
	printf("SLOT_COUNTER: %d\n",SLOT_COUNTER);
	printf("POS_COUNTER: %lu\n",POSITION_COUNTER-ps);
	ps = POSITION_COUNTER;*/
	
	if (fwrite(&SLOT_COUNTER, sizeof(unsigned int), 1, INDEX_FP) == 0) { 
		fprintf(stderr, "ERROR: cant access harddisc for index file\n");
		exit(0); 
	}

	return(0);
}

int write_index_2_file(unsigned int chr) 
{
	unsigned int i, j, k, num;
	int minus_i;
	BIN *bin;
	BIN_EXT **bin_ext;

	for (j=0; j<NUM_USED_SLOTS; j++) {
		i = USED_SLOTS[j];
		
		if (INDEX[i] != NULL && INDEX[i]->num_pos != 0) {

			bin = INDEX[i];
			num = bin->num_pos;

			//HEADER
			if (fwrite(&i, sizeof(int), 1, INDEX_FP) == 0) {	// slot
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
				exit(0);
			}

			if (fwrite(&num, sizeof(int), 1, INDEX_FP) == 0) {	// nr of positions in this slot
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
				exit(0);
			}

			//CONTENT ( = positions)
			if (num <= BIN_SIZE) {

				if (fwrite(&bin->ids[0], sizeof(ID), num, INDEX_FP) == 0) { 
					fprintf(stderr, "ERROR: cant access harddisc for index file\n");
					exit(0); 
				}
if (DEBUG) for (k=0; k!=num; ++k) printf("%s: block %d %d %d, pos %d\n", get_seq(i), bin->ids[k].id[0], bin->ids[k].id[1], bin->ids[k].id[2], (bin->ids[k]).id[3]);
//for (k=0; k!=num; ++k) printf("%s\n",get_seq(i));
			} else { 

				if (fwrite(&(bin->ids[0]), sizeof(ID), BIN_SIZE, INDEX_FP) == 0) { 
					fprintf(stderr, "ERROR: cant access harddisc for index file\n");
					exit(0); 
				}
if (DEBUG) for (k=0; k!=BIN_SIZE; ++k) printf("%s: block %d %d %d, pos %d\n", get_seq(i), bin->ids[k].id[0], bin->ids[k].id[1], bin->ids[k].id[2], (bin->ids[k]).id[3]);
//for (k=0; k!=BIN_SIZE; ++k) printf("%s\n",get_seq(i));
				num -= BIN_SIZE;

				bin_ext = &(bin->bin_ext);

				while (*bin_ext != NULL) {
					if (num > BIN_SIZE_EXT) {  

						if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), BIN_SIZE_EXT, INDEX_FP) == 0) { 
							fprintf(stderr, "ERROR: cant access harddisc for index file\n");
							exit(0); 
						}
if (DEBUG) for (k=0; k!=BIN_SIZE_EXT; ++k) printf("%s: block %d %d %d, pos %d\n", get_seq(i), (*bin_ext)->ids[k].id[0], (*bin_ext)->ids[k].id[1], (*bin_ext)->ids[k].id[2], (*bin_ext)->ids[k].id[3]);						num -= BIN_SIZE_EXT;
//for (k=0; k!=BIN_SIZE_EXT; ++k) printf("%s\n",get_seq(i));
						bin_ext = &((*bin_ext)->bin_ext);

					} else { //write out last entries and finish

						if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), num, INDEX_FP) == 0) {
							fprintf(stderr, "ERROR: cant access harddisc for index file\n");
							exit(0);
						}						
if (DEBUG) for (k=0; k!=num; ++k) printf("%s: block %d %d %d, pos %d\n", get_seq(i), (*bin_ext)->ids[k].id[0], (*bin_ext)->ids[k].id[1], (*bin_ext)->ids[k].id[2], (*bin_ext)->ids[k].id[3]);
//for (k=0; k!=num; ++k) printf("%s\n",get_seq(i));
						*bin_ext = NULL;

					}
				}
			}
		}

		
		// and the same for the reverse index
		if (BUILD_REVERSE_INDEX && INDEX_REV[i] != NULL && INDEX_REV[i]->num_pos != 0) {
					
			bin = INDEX_REV[i];
			num = bin->num_pos;

			//HEADER
			if (i == 0) minus_i = -2147483647;
				else minus_i = -i;
				
			if (fwrite(&minus_i, sizeof(int), 1, INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
				exit(0);
			}

			if (fwrite(&num, sizeof(int), 1, INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
				exit(0);
			}

			//CONTENT
			if (num <= BIN_SIZE) {

				if (fwrite(&bin->ids[0], sizeof(ID), num, INDEX_FP)  == 0) {
					fprintf(stderr, "ERROR: cant access harddisc for index file\n");
					exit(0);
				}

			} else { 

				if (fwrite(&(bin->ids[0]), sizeof(ID), BIN_SIZE, INDEX_FP) == 0) {
					fprintf(stderr, "ERROR: cant access harddisc for index file\n");
					exit(0);
				}
				num -= BIN_SIZE;

				bin_ext = &(bin->bin_ext);

				while (*bin_ext != NULL) {
					if (num > BIN_SIZE_EXT) {  

						if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), BIN_SIZE_EXT, INDEX_FP) == 0) {
							fprintf(stderr, "ERROR: cant access harddisc for index file\n");
							exit(0);
						}
						num -= BIN_SIZE_EXT;
						bin_ext = &((*bin_ext)->bin_ext);

					} else { //write out last entries and finish

						if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), num, INDEX_FP) == 0) {
							fprintf(stderr, "ERROR: cant access harddisc for index file\n");
							exit(0);
						}
						*bin_ext = NULL;					

					}
				}
			}
		}
	}
	
	if (VERBOSE) printf("... done\n");

	return(0);
}

int write_meta_index(unsigned int num_chr) 
{
	unsigned int i;
	int minus_i;

	if (fwrite(&BUILD_REVERSE_INDEX, sizeof(char), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	if (fwrite(&INDEX_DEPTH, sizeof(int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	if (fwrite(&num_chr, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	if (fwrite(&POSITION_COUNTER, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	if (fwrite(&LONGEST_CHROMOSOME, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	
	// write strain information
	if (fwrite(&NUM_STRAINS, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	for (i=0; i!=NUM_STRAINS; ++i) {
		if (fwrite(&STRAIN_DESC[i][0], sizeof(char), 100, META_INDEX_FP) == 0) {
			fprintf(stderr, "ERROR: cant access harddisc for meta index file\n");exit(0);
		} 
	}

	// write block table:
	BLOCK++;
	printf("\n\nblocks to write: %d\n\n",BLOCK);
	if (fwrite(&BLOCK, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	
	if (fwrite(BLOCK_TABLE, sizeof(BLOCK_TABLE_ENTRY), BLOCK, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
	}
	
	
	// write bins: 
	unsigned long int maxnr = 0;

 	for (i=0; i<INDEX_SIZE; i++) {

		if ( INDEX[i] != NULL ) {	
			//Slot
			if (fwrite(&i, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
			}

			//Number
			if (fwrite(&(INDEX[i]->num_all), sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");exit(0);
			}
//printf("slot %d: num %d\n", i, INDEX[i]->num_all);
			maxnr = (INDEX[i]->num_all > maxnr)? INDEX[i]->num_all: maxnr;
		}

		if ( BUILD_REVERSE_INDEX && (INDEX_REV[i] != NULL) ) {
			
			//Slot
			if (i == 0) minus_i = -2147483647;
				else minus_i = -i;
				
			if (fwrite(&minus_i, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); exit(0);
			}

			//Number
			if (fwrite(&(INDEX_REV[i]->num_all), sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");exit(0);
			}

			maxnr = (INDEX_REV[i]->num_all > maxnr)? INDEX_REV[i]->num_all: maxnr;
		}

	}

	if (VERBOSE) printf("... done\n");
	if (DEBUG) printf("\nMax Positions per Slot: %lu\n\n", maxnr);
	
	return(0);
}

int write_chr(unsigned int chr)
{
	if (VERBOSE) printf("writing chromosome %d\n",chr+1);
	if (fwrite(CHR_SEQ, sizeof(char), CHR_LENGTH, GENOME_OUT_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisk for genome output file\n");exit(0);
	}
	
	fclose(GENOME_OUT_FP);
	
	return 0;	
}
