// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "gmindex.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int load_chromosomes();

int main(int argc, char *argv[])
{
	clock_t start, end;
	double elapsed;

	start = clock();
	
	if (VERBOSE) { printf("Start initializing\n"); }

	init(argc, argv);

	if (VERBOSE) { printf("Start loading\n"); }

	load_chromosomes();

	if (VERBOSE) printf("\nTotal number of seed occurrences: %lu\n\n", POSITION_COUNTER);

	// Print seed statistics
	/*if (strlen(OCC_FILE_NAME) != 0) {		
		printf("Print stat to %s ...\n",OCC_FILE_NAME);
		fflush(stdout);
		unsigned int i;
		BIN *bin, *bin_rev;
		for (i=0; i<POWER[INDEX_DEPTH]; i++) {	
			if ((bin = INDEX[i]) != NULL) fprintf(OCC_FP, "%s\t%d\t", get_seq(i), bin->num_all);
				else fprintf(OCC_FP, "%s\t0\t", get_seq(i));
			
			if ((bin_rev = INDEX_REV[i]) != NULL) fprintf(OCC_FP, "%d\n", bin_rev->num_all);
				else fprintf(OCC_FP, "0\n");
		}
		fclose(OCC_FP);
		printf("... done\n");
	}*/
	
	//print_blocktable(28);
	
/*	if (VERBOSE) printf("print blocktable..."); 
	fflush(stdout);
	// print block table (debugging)
	int i;
	char *seq=malloc(6*BLOCK_SIZE*sizeof(char));
	fprintf(BLOCKOUT, "block|posR|ind|off|posS|chr|st|prev|next|fbns|lbns| len | seq      (lbns - last block of next strain)\n");
	for (i=1; i!=BLOCK; ++i) {
		seq[0]='\0';
		decode_seq(seq,BLOCK_TABLE[i].seq);
		fprintf(BLOCKOUT,"%5d|%4d|%3d|%3d|%4d|%3d|%2d|%4d|%4d|%4d|%4d|%5d|.%s.\n",
				i, BLOCK_TABLE[i].pos, BLOCK_TABLE[i].indel_offset, BLOCK_TABLE[i].ins_pos, BLOCK_TABLE[i].strainpos, BLOCK_TABLE[i].chr+1, BLOCK_TABLE[i].strain, BLOCK_TABLE[i].prev_block, BLOCK_TABLE[i].next_block, 
				BLOCK_TABLE[i].next_strain_front, BLOCK_TABLE[i].next_strain_end, (unsigned int)strlen(BLOCK_TABLE[i].seq), seq);
	}
	if (VERBOSE) printf("...done\n");
	free(seq);
*/

	//int i;
	//for (i=0; i!=NUM_STRAINS; ++i) printf("%d: %s\n",i+1,STRAIN_DESC[i]);

	if (VERBOSE) { printf("Finish.\n"); }
	
	end = clock();
	elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
	if (VERBOSE) printf ("Time needed: %g s\n",elapsed);
	
	// print block table (debugging)
	/*printf("-------------------------------------------\n");
	int i;
	for (i=0; i<=BLOCK; ++i) {
		printf("| block %5d | pos %9d | chr %5d |\n", i, BLOCK_TABLE[i].pos, BLOCK_TABLE[i].chr+1);
	}
	printf("-------------------------------------------\n");*/
	
/*
	free(SLOT);
	free(SLOT_REV);
	free(HAS_SLOT);
	free(BLOCK_LIST);
	free(BLOCK_TABLE);
*/
	return EXIT_SUCCESS;
}


// for debugging
char *get_seq(unsigned int n)
{
	char *seq = (char *) malloc ((INDEX_DEPTH+1)*sizeof(char));
	int i, c;
	for (i=INDEX_DEPTH-1; i>=0; --i) {
		c = (int) (n / POWER[i]);
		switch (c)
		{
			case 0: seq[i] = 'A';
					break;
			case 1: seq[i] = 'C';
					break;
			case 2: seq[i] = 'G';
					break;
			case 3: seq[i] = 'T';
					break;
		}
		n -= (int) (c * POWER[i]);
	}
	seq[INDEX_DEPTH] = '\0';
	return seq;
}
