// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int size_hit(HIT *hit, unsigned int *oldlength, char num);
int browse_hits();
int check_duplicate(HIT* hit);
void printgenome();
MAPPING_ENTRY *create_mapping_entry(int *genome_pos, int *genome_chr, unsigned short int *strain, char num);

int map_reads() 
{
	char eof = 0, read_mapped;
	unsigned int count_reads = 0;
	int first_slot = 0;
	int num_edit_ops = NUM_EDIT_OPS;
	if (STATISTICS) MAX_USED_SLOTS = 0;
	unsigned int MAXHITS = 0;
	int c1 = 0;
	int c2 = 0;
	
	//FILE *CHROM_ENTRY_FP;
	//CHROM_ENTRY_FP = fopen("MappingEntriesPerRead", "w");
	
	while (!eof) {
		
		count_reads++;
			
		LONGEST_HIT = 0;

		eof = read_short_read();
		if (eof != 0) continue;
		
		if (READ_LENGTH < HITLEN_LIMIT) {
			fprintf(stderr, "\n!!! WARNING! Read %d (%s) with length %d is shorter than the hitlength limit (=%d) and will not be processed!\n\n", 
				count_reads, READ_ID, READ_LENGTH, HITLEN_LIMIT);
		}
		else {
			//printf("%d ", count_reads); fflush(stdout);
			
			// progress output, just for user convenience 		
			if (VERBOSE && (count_reads % 10000 == 0)) {
				printf(".");
				fflush(stdout);
			}
			

				
			if (STATISTICS) HITS_PER_READ = 0;
			
			HITS_IN_SCORE_LIST = 0;
			
			// map_fast IF 1) best hit strategy 2) only hits up to RL/ID mismatches without gaps should be found
							   // READ_LENGTH / INDEX_DEPTH is the number of seeds fitting in the current read
			int nr_seeds = (int) (READ_LENGTH / INDEX_DEPTH);
 			if (!ALL_HIT_STRATEGY || (NUM_MISMATCHES < nr_seeds && NUM_GAPS == 0)) {
 				first_slot = map_fast();	// if no hits could have been found: ALL_HIT_STRATEGY = -1, necessitating execution of seed&extend in the following
 				c1++;
 			}
		
 			// map_complete IF 1) all hit strategy 2) best hit strategy and no mappings found in map_fast BUT NOT IF MM < RL/ID AND gaps=0 (since map_fast has already found them) 
			if (ALL_HIT_STRATEGY != 0 && !(NUM_MISMATCHES < nr_seeds && NUM_GAPS == 0)) {
				
				c2++;
				map_short_read(count_reads, first_slot);
				
				// for removing duplicates:	
				dealloc_mapping_entries();
				
				// Print Mapping Entry statistics
				//fprintf(CHROM_ENTRY_FP, "%d\t%d\n", CHROMOSOME_ENTRY_OPERATOR->used, NUM_MAPPING_ENTRIES);
				
				CHROMOSOME_ENTRY_OPERATOR->used = 0;
				
				browse_hits();
				
				if (ALL_HIT_STRATEGY < 0) ALL_HIT_STRATEGY = 0;		// resetting ALL_HIT_STRATEGY
				
			}
			
			if (ALL_HIT_STRATEGY < 0) ALL_HIT_STRATEGY = 0;			// resetting ALL_HIT_STRATEGY
			
			if (STATISTICS && HITS_PER_READ > MAXHITS) MAXHITS = HITS_PER_READ;
			
			NUM_EDIT_OPS = num_edit_ops;		// resetting NUM_EDIT_OPS.. has been changed probably in alignments and map_fast
			
			read_mapped = print_hits();	// returns 1 if at least one hit is printed, 0 otherwise
			
			if (read_mapped) READS_MAPPED++;
			else {
				if (strlen(LEFTOVER_FILE_NAME) > 0) print_leftovers();
			}				
			
			
			dealloc_mapping_entries(); //muss eigentlich nur der container zaehler zurückgesetzt werden... optimization?
			dealloc_hits();
			dealloc_hits_by_score();
			CHROMOSOME_ENTRY_OPERATOR->used = 0;
			if (LONGEST_HIT != 0) dealloc_hit_lists_operator();
						

		}

	}
	
	//fclose(CHROM_ENTRY_FP);
	fclose(QUERY_FP);
	
	if (strlen(OUT_FILE_NAME) > 0) fclose(OUT_FP);
	if (strlen(LEFTOVER_FILE_NAME) > 0) fclose(LEFTOVER_FP);
	
	if (STATISTICS) {
		printf("\n\n    MAP_FAST  = %d\n",c1);
		printf("    MAP_COMPL = %d\n\n",c2);
		printf("Maximal number of hits per read: %d\n",MAXHITS);
	}
	
	NUM_READS = count_reads - 1;
	
	if (VERBOSE) printf("\n");
	
	return(0);
}


int seed2genome(unsigned int num, unsigned int index_slot, unsigned int readpos, char reverse)
{
	INDEX_ENTRY index_entry;
	int genome_pos, neighbor_pos, genome_chr;
	unsigned int block;
	unsigned short int strain, neighbor_strain;
	unsigned char pos;
	//char strand;
	//unsigned int direction;
	//unsigned int mmoffset; //Mismatch-Offset
	int read_num = -1;
	int c;

	//char flag = 0;
	char extended = 0;

	//CHROMOSOME_ENTRY *chromosome_director, *chromosome_director_neighbor, *chromosome_director_new;
	CHROMOSOME_ENTRY *chromosome_director_neighbor;
	//MAPPING_ENTRY *mapping_entry, *existing_entry, *neighbor;
	MAPPING_ENTRY *mapping_entry, *neighbor;

	HIT *hit = NULL;

	unsigned int i,k;
	unsigned int oldlength;
	
	// reverse = 1: only index, 2: only index_rev, 4: both
	while (reverse > 0) {
		
		if (reverse != 2) index_entry = *(INDEX+index_slot);
		else 			  index_entry = *(INDEX_REV+index_slot);

		if (read_num == num) {
			printf("###############################################\n");
			printf("Add seed to genomepositions from slot # %d (%s) containing %d genomepositions\n", index_slot, get_seq(index_slot), index_entry.num);
		}
	
		for (i=0; i<index_entry.num; i++) { // foreach seed...		
		
			extended = 0;
		
			if (read_num == num) {
				printf("############################\n");
				printf("Now adding seed # %d/%d of read %i (%s), slot %i, ori %d readpos %d\n", i+1, index_entry.num, num, READ_ID, index_slot, reverse, readpos);
			}
			
			// Every mapping gets an entry
			/*mapping_entry = alloc_mapping_entry();
			mapping_entry->readpos = readpos;
			if (read_num == num) {
				printf("Readpos %d\n", readpos);
			}*/

			// Get current position in the chromosome
			if (reverse != 2) {
				block = 0;
				memcpy(&block, &((index_entry.last_entry-(i+1))->id[0]), 3 * sizeof(char));
				pos = 0;
				memcpy(&pos, &((index_entry.last_entry-(i+1))->id[3]), sizeof(unsigned char));
				strain = BLOCK_TABLE[block].strain;
				genome_pos = (strain == 0)? pos + BLOCK_TABLE[block].pos : pos + BLOCK_TABLE[block].strainpos;
				genome_chr = BLOCK_TABLE[block].chr+1;
				//strand = 1;
			}
			else {
				block = 0;
				memcpy(&block, &((index_entry.last_entry-(index_entry.num-i))->id[0]), 3 * sizeof(char));
				pos = 0;
				memcpy(&pos, &((index_entry.last_entry-(index_entry.num-i))->id[3]), sizeof(unsigned char));
				strain = BLOCK_TABLE[block].strain;
				genome_pos = (strain == 0)? pos + BLOCK_TABLE[block].pos : pos + BLOCK_TABLE[block].strainpos;
				genome_chr = -BLOCK_TABLE[block].chr-1;
				//strand = -1;
			}
			
			if (read_num == num) printf("block %d pos %d [block].pos %d genome_pos %d genome_chr %d strain %d\n", 
				block, pos, BLOCK_TABLE[block].pos, genome_pos, genome_chr, strain);
			
			/*if (read_num == num) {
				printf("Genome Entry: chr %d   block %d   pos %d   genome_pos %d   strain %d\n", genome_chr+1, block, pos, genome_pos, strain);
			}
	

			// Check if there is already a chromosome director and get this or a new one
			if (*(GENOME+genome_pos) == NULL) {
                flag = 1;

                if (read_num == num) {
                        printf("Alloc new chromosome director genome_chr %d\n", genome_chr+1);
                }

                chromosome_director = alloc_chromosome_entry(&genome_pos, &genome_chr, &strand, &strain);
                if (!chromosome_director) return(0);    // chrom_container_size too small -> cancel this read

				*(GENOME + genome_pos) = chromosome_director;

			}
            else {
                if (read_num == num) {
                        printf("Found chromosome director\n");
                }

                chromosome_director = *(GENOME + genome_pos);

                if (read_num == num) {
	                    printf("ChrEntryOp:       %p\n", (CHROMOSOME_ENTRY_OPERATOR->entries));
	                    printf("ChrEntryOp[used]: %p\n", ((CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)));
	                    printf("chrom_director:   %p\n", chromosome_director);
	                    printf("used = %d\n",CHROMOSOME_ENTRY_OPERATOR->used);
	                    printf("chrom_dir->gen_pos: %d\n", chromosome_director->genome_pos);
	                    printf("genome_pos: %d\n", genome_pos);
                }
                
				// is chrom_director from the actual read or from a former one?
                if (chromosome_director >= (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)
                || (chromosome_director < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) && 
                   (chromosome_director->genome_pos != genome_pos))) {

	                    // it's from a former read, thus we need a new chrom_director:
	                    chromosome_director = alloc_chromosome_entry(&genome_pos, &genome_chr, &strand, &strain);
	                    if (!chromosome_director) return(0);    // chrom_container_size too small -> cancel this read
						
						*(GENOME + genome_pos) = chromosome_director;
	
	                    if (read_num == num) {
	                            printf("Overwrite chromosome director %p\n", chromosome_director);
	                    }
				}
			}

			// Parse the list of chromosome directors 
			//printf("chrom_dir %d, genome_chr %d\n", chromosome_director->chromosome, genome_chr);
			int c=0;
			while (chromosome_director->next != NULL && chromosome_director->strain != strain &&
				  (chromosome_director->chromosome != genome_chr ||	(chromosome_director->chromosome == genome_chr && chromosome_director->strand != strand)))
			{
if (STATISTICS && c == 0) listocc++;
if (STATISTICS) listcount++;
				chromosome_director = chromosome_director->next;
			}


			// Chromosome director is set, but still it could be the wrong chromosome, strand or strain, if the right entry is not in there so far.
			if (chromosome_director->chromosome != genome_chr || chromosome_director->strand != strand || chromosome_director->strain != strain) {
				
				if (read_num == num) printf("Expanding list with new chrom.director\n");
				chromosome_director_new = alloc_chromosome_entry(&genome_pos, &genome_chr, &strand, &strain);
				if (!chromosome_director_new) return(0);
				
				chromosome_director_new->next = chromosome_director->next;
				chromosome_director->next = chromosome_director_new;

				chromosome_director = chromosome_director_new;
				
			}
			
			
			// Paste MAPPING_ENTRY in list of chromosome director slot
			if (read_num == num) {
				printf("Mapping entry, genome_chr %d\n", genome_chr+1);
				printf("Mapping entry, chromsome director %p\n", chromosome_director);
			}


			if (chromosome_director->mapping_entries == NULL) {
				if (read_num == num) {
					printf("List of mapping entries in the chromosome director was empty\n");
				}
				chromosome_director->mapping_entries = mapping_entry;
			}
			else {
				if (flag == 1) {
					printf("!!!!!!!!!!!Found entry in chr dir at genome pos %d  --  %p\n", genome_pos, chromosome_director->mapping_entries	);
					exit(1);
				}

				if (read_num == num) {
					printf("Already entries in the chromosome director\n");
				}
				existing_entry = chromosome_director->mapping_entries;
				mapping_entry->pred = existing_entry;
				existing_entry->succ = mapping_entry;
				chromosome_director->mapping_entries = mapping_entry;
			}*/


			// HIT EXTENSION
			
			//Check left (for plus strand) and right (for minus strand) neighbor at the genomeposition of the hit if there is a hit to join.
			//if (genome_pos > 0 && readpos > 1) {
			if (readpos > 1) {	// TODO   VERY IMPORTANT can I erase "genome_pos > 0" ??????????? <<<<<<<<<----------------<<<<<<<<<<---------
				if (read_num == num) {
					printf("Now checking if left neighbor exists and is willing to join %i\n",genome_pos);
				}
				
				//NUM_SEQS = 1;
				//SEQS[0] = strain;
				BRANCHES = 0;
				
				// get correct left or right genome_pos according to graph structure, fill SEQS and set NUM_SEQS
				if (genome_chr > 0) {
					SEQS[strain] = get_genome_pos_left(block, pos, strain, 1, 0);
					/*if (SEQS[strain].overhang == 0) {
						SEQS[strain].next = SEQ_LIST;
						SEQ_LIST = SEQS[strain];
					}*/
				}
				else {
					SEQS[strain] = get_genome_pos_right(block, pos, strain, 1, 0);
				}
				
				//*SEQ_ENTRY seqlist_iterator = SEQ_LIST;
				//while (seqlist_iterator != NULL) {
				
				for (k=0; k<=NUM_STRAINS; ++k) {
				//for (k=0; k!=NUM_SEQS; ++k) {
					
					if (BRANCHES == 0) {
						neighbor_strain = strain;
					}
					else {
						neighbor_strain = k;
					}
					//neighbor_strain = SEQS[k];
					
					
					if (SEQS[k] != 0) continue;
					//if (SEQS[k] < 0) continue;
						
					//neighbor_strain = seqlist_iterator.strain;
					
					if (BLOCK_TABLE[STARTBLOCK[neighbor_strain]].strain == 0)
						neighbor_pos = BLOCK_TABLE[STARTBLOCK[neighbor_strain]].pos + BLOCKOFFSET[neighbor_strain];
					else
						neighbor_pos = BLOCK_TABLE[STARTBLOCK[neighbor_strain]].strainpos + BLOCKOFFSET[neighbor_strain];
				
					
					if (*(GENOME + neighbor_pos) != NULL) { // Is there a chromosome director?
						if (read_num == num) {
							printf("  Found a neighbored chromosome director\n");
						}
						chromosome_director_neighbor = *(GENOME + neighbor_pos);
	
						// Is the chrom director from actual read?
						if (chromosome_director_neighbor < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) &&
						   (chromosome_director_neighbor->genome_pos == neighbor_pos)) {
	
							// Search for chromosome_director_neighbor for the correct chromosome and strand
							//c=0;
							/*while (chromosome_director_neighbor->next != NULL && (chromosome_director_neighbor->chromosome != genome_chr || 
								  (chromosome_director_neighbor->chromosome == genome_chr && chromosome_director_neighbor->strand != strand) ||
								  (chromosome_director_neighbor->strain != neighbor_strain)))
							{
	if (STATISTICS) listcount++;
	if (STATISTICS && c++ == 0) listocc++;
								chromosome_director_neighbor = chromosome_director_neighbor->next;
							}
							
							printf("cd.chr %d cd.strand %d cd.strain %d n.strain %d\n",chromosome_director_neighbor->chromosome,chromosome_director_neighbor->strand,
								chromosome_director_neighbor->strain, neighbor_strain);
								
							if 	(chromosome_director_neighbor->chromosome == genome_chr && 
								 chromosome_director_neighbor->strand == strand &&
								 chromosome_director_neighbor->strain == neighbor_strain)
							{*/
							
							c = 0;
							while (chromosome_director_neighbor != NULL) {


								if (chromosome_director_neighbor->chromosome != genome_chr) { // || chromosome_director_neighbor->strand != strand) {
									chromosome_director_neighbor = chromosome_director_neighbor->next;
if (STATISTICS) listcount++;
if (STATISTICS && c++ == 0) listocc++;
									continue;
								}

								// if we are on Ref and not in a superblock, try to extend all chrom.directors of neighbor slot!
								if (chromosome_director_neighbor->strain != neighbor_strain) {// && !(neighbor_strain + strain == 0 && BLOCK_TABLE[STARTBLOCK[neighbor_strain]].strainpos + BLOCK_TABLE[block].strainpos == 0)) {
									chromosome_director_neighbor = chromosome_director_neighbor->next;
if (STATISTICS) listcount++;
if (STATISTICS && c++ == 0) listocc++;
									continue;
								}


								if (read_num == num) {
									printf("  Found neighboured mapping entry list\n");
								}
			
								neighbor = chromosome_director_neighbor->mapping_entries;
								//while (neighbor != NULL) {
			
									if (read_num == num) {
										printf("  Neighbor readpos: %d  actual readpos %d\n", neighbor->readpos, readpos);
										printf("  neighbor hit: "); 
										if (neighbor->hit!=NULL) printhit(neighbor->hit); else printf("null\n"); 
									}
				
									if (neighbor->readpos == readpos-1) { // is the neighbored mapping entry also neighbored in the read?
										
										hit = neighbor->hit;
										if (read_num==num) { printf("drin!!!  "); printhit(hit); }
										if (hit != NULL) {
											//oldlength = hit->end - hit->start + 1;
											oldlength = hit->length;//(hit->strain != 0)? hit->end-BLOCK_TABLE[hit->startblock].strainpos-hit->startoffset: hit->end-BLOCK_TABLE[hit->startblock].pos-hit->startoffset;
											//mapping_entry->hit = neighbor->hit;
					
											// 1) update neighbor hit
											if (reverse == 2) {
												//get_genome_pos_left(hit->startblock, hit->startoffset, hit->strain, 1, 1);	// sets STARTBLOCK and STRAINOFFSET
												//hit->startblock = STARTBLOCK[hit->strain];
												//hit->startoffset = STRAINOFFSET[hit->strain];
												hit->startblock = block;
												hit->blockoffset = pos;
												hit->strainpos--;
												
												//hit->start--;
											}
											hit->length++;
											if (read_num == num) printhit(hit);
					
											// 2) create own mapping entry
											mapping_entry = create_mapping_entry(&genome_pos, &genome_chr, &(hit->strain), (read_num == num));
											mapping_entry->readpos = readpos;
											mapping_entry->hit = hit;
											
											size_hit(hit, &oldlength, (num==read_num));
					
											if (hit->strain == strain) {
												extended = 1;
												//hit = NULL;
												//break;
											}
										}
										//hit = NULL;
									}

								//	neighbor = neighbor->pred;
								//} // for all mapping entries of chrom.director

								chromosome_director_neighbor = chromosome_director_neighbor->next;
							} // for all chrom.directors
						}
					}
					
					SEQS[neighbor_strain] = -1;
					if (BRANCHES == 0) {
						
						break;
					}
					//seqlist_iterator->visited = 0;
					//seqlist_iterator = seqlist_iterator.next;
				} // foreach neighbor position on all strains
				//SEQ_LIST = NULL;
				
				if (read_num == num) {
					printf("Will the hit be combined with adjacent neighbor? %d\n", extended);
				}
				

				// MISMATCH extension - only on reference (for now?) 
				
				//combine with possible hit at position seedlength+1 to the left(+) or right(-) to span hit over mismatch
				if (strain == 0 && !extended && readpos > INDEX_DEPTH && NUM_MISMATCHES != 0) {	// !!!!!!!!!!!!!!!!!!
					if (read_num == num) printf("Now checking if hit can be extended over mismatch\n");
					
					//NUM_SEQS = 1;
					//SEQS[0] = strain;
					BRANCHES = 0;
					
					//mmoffset = (reverse != 2)? -INDEX_DEPTH - 1: INDEX_DEPTH + 1;
					if (reverse != 2) {
						//SEQS[strain] = get_genome_pos_left(block, pos, strain, INDEX_DEPTH + 1, 0);
						SEQS[strain] = get_genome_pos_left(block, pos, strain, INDEX_DEPTH + 1, 1); //<-----
					}
					else {
						//SEQS[strain] = get_genome_pos_right(block, pos, strain, INDEX_DEPTH + 1, 0);
						SEQS[strain] = get_genome_pos_right(block, pos, strain, INDEX_DEPTH + 1, 1); //<-----
					}
					
					for (k=0; k<=NUM_STRAINS; ++k) {
					//for (k=0; k!=NUM_SEQS; ++k) {
						
						if (BRANCHES == 0) {
							neighbor_strain = strain;
						}
						else {
							neighbor_strain = k;
						}
						
						if (SEQS[neighbor_strain] != 0) continue;
						
						if (BLOCK_TABLE[STARTBLOCK[neighbor_strain]].strain == 0)
							neighbor_pos = BLOCK_TABLE[STARTBLOCK[neighbor_strain]].pos + BLOCKOFFSET[neighbor_strain];
						else
							neighbor_pos = BLOCK_TABLE[STARTBLOCK[neighbor_strain]].strainpos + BLOCKOFFSET[neighbor_strain];
					
					 	
						if (*(GENOME + neighbor_pos) != NULL) {
						
						 	chromosome_director_neighbor = *(GENOME + neighbor_pos);
	
							// Is the chrom director from actual read?
							if  (chromosome_director_neighbor < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) && 
								(chromosome_director_neighbor->genome_pos == neighbor_pos)) {

								c = 0;
								while (chromosome_director_neighbor != NULL) {
	
	
									if (chromosome_director_neighbor->chromosome != genome_chr) {// || chromosome_director_neighbor->strand != strand) {
										chromosome_director_neighbor = chromosome_director_neighbor->next;
if (STATISTICS) listcount++;
if (STATISTICS && c++ == 0) listocc++;
										continue;
									}
	
									// if we are on Ref and not in a superblock, try to extend all chrom.directors of neighbor slot!
									if (chromosome_director_neighbor->strain != neighbor_strain) { // && !(neighbor_strain + strain == 0 && BLOCK_TABLE[STARTBLOCK[neighbor_strain]].strainpos + BLOCK_TABLE[block].strainpos == 0)) {
										chromosome_director_neighbor = chromosome_director_neighbor->next;
if (STATISTICS) listcount++;
if (STATISTICS && c++ == 0) listocc++;
										continue;
									}
	

									neighbor = chromosome_director_neighbor->mapping_entries;
									//while (neighbor != NULL) {
										if (read_num == num) {
											printf("MM neighbor hit: ");
											printhit(neighbor->hit);
											printf("  Found a potential entry, readops(neighbor)=%d, (actual)=%d\n",neighbor->readpos,readpos);
										}
										
										if (neighbor->readpos == readpos - INDEX_DEPTH - 1) {
											if (read_num == num) printf("  Readpos matches\n");
											
											if ((neighbor->hit)->mismatches < NUM_EDIT_OPS && (neighbor->hit)->mismatches-(neighbor->hit)->gaps < NUM_MISMATCHES) {
												if (read_num == num) printf("  Fancy! Mismatches < 4\n");
												
												// 1) update neighbor hit
												hit = neighbor->hit;
												//oldlength = hit->end - hit->start + 1;
												oldlength = hit->length;//(hit->strain != 0)? hit->end-BLOCK_TABLE[hit->startblock].strainpos-hit->startoffset: hit->end-BLOCK_TABLE[hit->startblock].pos-hit->startoffset;
												//mapping_entry->hit = neighbor->hit;
												
												if (reverse != 2) {
													//hit->end = hit->end + INDEX_DEPTH + 1;
													hit->edit_op[hit->mismatches].pos = readpos - 1;
													hit->edit_op[hit->mismatches].mm = 1;
												}
												else {
													//get_genome_pos_left(hit->startblock, hit->startoffset, hit->strain, INDEX_DEPTH + 1, 1);
													//hit->startblock = STARTBLOCK[hit->strain];
													//hit->startoffset = STRAINOFFSET[hit->strain];
													hit->startblock = block;
													hit->blockoffset = pos;
													hit->strainpos = hit->strainpos - INDEX_DEPTH - 1;
													//hit->start = genome_pos+1;	// +1 weg ??
													hit->edit_op[hit->mismatches].pos = READ_LENGTH - readpos + 2;
													hit->edit_op[hit->mismatches].mm = 1;
												}
												hit->length += INDEX_DEPTH + 1;
												hit->mismatches++;
												if (read_num == num) printf("  Mismatch at pos %d, #mm=%d\n",hit->edit_op[hit->mismatches-1].pos, hit->mismatches);
												if (read_num == num) printhit(hit);
												
												// 2) create own mapping entry
												mapping_entry = create_mapping_entry(&genome_pos, &genome_chr, &neighbor_strain, (read_num == num));
												mapping_entry->readpos = readpos;
												mapping_entry->hit = hit;
												
												size_hit(hit, &oldlength, (num==read_num));
												
												if (hit->strain == strain) extended = 1;
											}
										}

									//	neighbor = neighbor->pred;
									//} // for all mapping entries of a chrom.director

									chromosome_director_neighbor = chromosome_director_neighbor->next;
								} // for all chrom.directors
							}
						}
						
						SEQS[neighbor_strain] = -1;
						if (BRANCHES == 0) break;
						//seqlist_iterator->visited = 0;
						//seqlist_iterator = seqlist_iterator.next;
					} // for all strains
					
					//SEQ_LIST = NULL;
				} // MM extension
				
				
			} // readpos > 1
			
	
			// for MM=0: if potential hit doesn't start at readpos 1, it cannot become perfect, thus it is not even allocated:
			if ( !extended && !(NUM_MISMATCHES == 0 && readpos != 1) ) {

				// create new hit:
				
				if (read_num == num) {
					printf("No! Need my own hit structure\n");
				}
				
				hit = alloc_hit();
				
				mapping_entry = create_mapping_entry(&genome_pos, &genome_chr, &strain, (read_num == num));
				mapping_entry->readpos = readpos;
				mapping_entry->hit = hit;
										
				hit->chromosome = genome_chr;
				//hit->end = genome_pos + INDEX_DEPTH;	// -1
				//hit->orientation = (reverse != 2)? '+': '-';
									
				oldlength = INDEX_DEPTH - 1;
				
				hit->readpos = readpos;
				hit->startblock = block;
				hit->blockoffset = pos;
				hit->strain = strain;
				hit->strainpos = (strain != 0)? BLOCK_TABLE[block].strainpos: BLOCK_TABLE[block].pos;
				hit->strainpos += pos + 1;
				hit->length = INDEX_DEPTH;
				
				//hit->end = (hit->strain != 0)? BLOCK_TABLE[hit->startblock].strainpos: BLOCK_TABLE[hit->startblock].pos;
				//hit->end += hit->startoffset + INDEX_DEPTH;		// -1 ??? TODO if not, then check in map_fast !!!!!!!!!! 
				//hit->start = genome_pos+1;	// +1 weg
				
				size_hit(hit, &oldlength, (read_num==num));

			}
			
			/*if (strcmp(READ_ID, "10052014609670874") == 0 && block == 705079 && pos == 51) {
				printf("BRANCHES: %d   ", BRANCHES); printhit(hit); exit(1);
			}*/
	
			// for MM=0: if hit doesn't start at readpos=1, then do not report hit (due to: all perfect hits are extended from a hit starting at readpos 1!!!)
			/*if ( hit != NULL && !(NUM_MISMATCHES == 0 && hit->readpos != 1) ) {
				
				size_hit(hit, &oldlength, (read_num==num));
				
			}*/
			
							
			//flag = 0;
			//hit = NULL;
			
		} //end of for each seed on read

		reverse -= 2; // 1->-1, 2->0, 4->2

	} //end of while (for each strand)
	
	return(1);
}


MAPPING_ENTRY *create_mapping_entry(int *genome_pos, int *genome_chr, unsigned short int *strain, char num)
{
	CHROMOSOME_ENTRY *chromosome_director, *chromosome_director_new;
	//MAPPING_ENTRY *mapping_entry;
	char flag = 0;

	// Check if there is already a chromosome director and get this or a new one
	if (*(GENOME+*genome_pos) == NULL) {
        flag = 1;

        if (num) {
                printf("Alloc new chromosome director at genome_pos %d / genome_chr %d / strain %d\n", 
                	*genome_pos, *genome_chr+1, *strain);
        }

        chromosome_director = alloc_chromosome_entry(genome_pos, genome_chr, strain);
        if (!chromosome_director) return(0);    // chrom_container_size too small -> cancel this read

		*(GENOME + *genome_pos) = chromosome_director;

	}
    else {
        if (num) {
                printf("Found chromosome director\n");
        }

        chromosome_director = *(GENOME + *genome_pos);

        if (num) {
                printf("ChrEntryOp:       %p\n", (CHROMOSOME_ENTRY_OPERATOR->entries));
                printf("ChrEntryOp[used]: %p\n", ((CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)));
                printf("chrom_director:   %p\n", chromosome_director);
                printf("used = %d\n",CHROMOSOME_ENTRY_OPERATOR->used);
                printf("chrom_dir->gen_pos: %d\n", chromosome_director->genome_pos);
                printf("genome_pos: %d\n", *genome_pos);
        }
        
		// is chrom_director from the actual read or from a former one?
        if (chromosome_director >= (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)
        || (chromosome_director < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) && 
           (chromosome_director->genome_pos != *genome_pos))) {

                // it's from a former read, thus we need a new chrom_director:
                chromosome_director = alloc_chromosome_entry(genome_pos, genome_chr, strain);
                if (!chromosome_director) return(0);    // chrom_container_size too small -> cancel this read
				
				*(GENOME + *genome_pos) = chromosome_director;

                if (num) {
                        printf("Overwrite chromosome director %p\n", chromosome_director);
                }
		}	

		// Parse the list of chromosome directors 
		int c=0;
		while (chromosome_director->next != NULL && (chromosome_director->strain != *strain ||
			   chromosome_director->chromosome != *genome_chr)) // || (chromosome_director->chromosome == *genome_chr && chromosome_director->strand != *strand)))
		{
if (STATISTICS && c++ == 0) listocc++;
if (STATISTICS) listcount++;
			chromosome_director = chromosome_director->next;
		}
	
	
		// Chromosome director is set, but still it could be the wrong chromosome, strand or strain, if the right entry is not in there so far.
		if (chromosome_director->chromosome != *genome_chr || chromosome_director->strain != *strain) {// || chromosome_director->strand != *strand || chromosome_director->strain != *strain) {
			
			if (num) printf("Expanding list with new chrom.director\n");
			chromosome_director_new = alloc_chromosome_entry(genome_pos, genome_chr, strain);
			if (!chromosome_director_new) return(0);
			
			chromosome_director_new->next = chromosome_director->next;
			chromosome_director->next = chromosome_director_new;
	
			chromosome_director = chromosome_director_new;
			
		}
	
    }
	
	
	// Paste MAPPING_ENTRY in list of chromosome director slot
	if (num) {
		printf("Mapping entry, genome_chr %d\n", *genome_chr+1);
		printf("Mapping entry, chromsome director %p\n", chromosome_director);
	}


	if (chromosome_director->mapping_entries == NULL) {
		if (num) {
			printf("No mapping entry in the chromosome director yet\n");
		}
		//chromosome_director->mapping_entries = mapping_entry;
		chromosome_director->mapping_entries = alloc_mapping_entry();
	}
	/*else {
		if (flag == 1) {
			printf("!!!!!!!!!!!Found entry in chr dir at genome pos %d  --  %p\n", *genome_pos, chromosome_director->mapping_entries	);
			exit(1);
		}

		if (num) {
			printf("Already mapping entry in the chromosome director\n");
		}

		mapping_entry = alloc_mapping_entry();
		//existing_entry = chromosome_director->mapping_entries;
		//mapping_entry->pred = existing_entry;
		//existing_entry->succ = mapping_entry;
		//chromosome_director->mapping_entries = mapping_entry;

		// insert at the end of mapping entry list, but pointer on list points to the last element
		mapping_entry->pred = chromosome_director->mapping_entries;
		chromosome_director->mapping_entries->succ = mapping_entry;
		chromosome_director->mapping_entries = mapping_entry;
		
		//mapping_entry->readpos = *readpos;
	}*/
	
	return chromosome_director->mapping_entries;	
}


int get_genome_pos_left(unsigned int block, unsigned int blockpos, unsigned int strain, unsigned int len, char stick_to_strain)
{
	unsigned int prevblock, prevprevblock, startpos = blockpos;
	char in_superblock = (strain == 0) && BLOCK_TABLE[block].strainpos;
	
	while (len != 0) {
		
		unsigned int block_seq_len = strlen(BLOCK_TABLE[block].seq);

		if (block_seq_len < abs(BLOCK_TABLE[block].indel_offset)) {
			if (BLOCK_TABLE[block].prev_block == 0) {
				get_genome_pos_right(block, blockpos, strain, 1, 1);
				return len;
			}
			else {
				block = BLOCK_TABLE[block].prev_block;
				block_seq_len = strlen(BLOCK_TABLE[block].seq);
				blockpos = block_seq_len;
				continue;
			}
		}
		
		if (blockpos > block_seq_len + BLOCK_TABLE[block].indel_offset) blockpos = block_seq_len + BLOCK_TABLE[block].indel_offset + 1;
		
		if (blockpos >= len) {
			startpos = blockpos - len;
			len = 0;
		}
		else {
			
			len = len - blockpos;
			
			prevblock = BLOCK_TABLE[block].prev_block;
			if (prevblock == 0) {
				//if (!stick_to_strain) SEQS[strain] = -1;
				BLOCKOFFSET[strain] = 0;//blockpos;
				STARTBLOCK[strain] = block;
				return len;	// block is first block of chromosome -> read could not have been mapped!!
			}
			
			prevprevblock = BLOCK_TABLE[prevblock].next_strain_end;
				
			if (strain == 0) {
				if (!stick_to_strain && !in_superblock) {
					while (prevprevblock != 0) {
						if (SEQS[BLOCK_TABLE[prevprevblock].strain] < 0) {
							SEQS[BLOCK_TABLE[prevprevblock].strain] = get_genome_pos_left(prevprevblock, strlen(BLOCK_TABLE[prevprevblock].seq), BLOCK_TABLE[prevprevblock].strain, len, 1);	// recursion with new strain
							BRANCHES = 1;
							
							STRAINPOS[BLOCK_TABLE[prevprevblock].strain] = BLOCK_TABLE[prevprevblock].strainpos + (strlen(BLOCK_TABLE[prevprevblock].seq) - len) + 1;
							
							//if (SEQS[BLOCK_TABLE[prevprevblock].strain] <= NUM_GAPS) {
															
								//SEQS[BLOCK_TABLE[prevprevblock].strain].next = SEQ_LIST;
								//SEQ_LIST = SEQS[BLOCK_TABLE[prevprevblock].strain];
									//SEQS[NUM_SEQS] = BLOCK_TABLE[prevprevblock].strain;
									//NUM_SEQS++;
							//}
						}
						
						prevprevblock = BLOCK_TABLE[prevprevblock].next_strain_end;
					}
				}
				block = prevblock;
			}
			else {
				if (BLOCK_TABLE[prevblock].strain == 0 && prevprevblock != 0) {
					block = prevblock;
					prevblock = prevprevblock;
					while (BLOCK_TABLE[prevblock].strain != strain && prevblock != 0) {
						prevblock = BLOCK_TABLE[prevblock].next_strain_end;
					}
					if (BLOCK_TABLE[prevblock].strain == strain) block = prevblock;
				}
				else {
					block = prevblock;
				}
			}
				
			
			if (block == 0) { fprintf(stderr, "BLOCK = 0!!\n"); exit(0); }
				
		}
		blockpos = strlen(BLOCK_TABLE[block].seq);
		
	} // while len != 0
	
	
	BLOCKOFFSET[strain] = startpos;
	STARTBLOCK[strain] = block;
	
	return len;
	//if (BLOCK_TABLE[block].strain == 0)	return BLOCK_TABLE[block].pos + startpos;
	//	else 							return BLOCK_TABLE[block].strainpos + startpos;
}

int get_genome_pos_right(unsigned int block, int blockpos, unsigned int strain, unsigned int len, char stick_to_strain)
{
	unsigned int nextblock, nextnextblock, lastlen = len;
	char in_superblock = (strain == 0) && BLOCK_TABLE[block].strainpos;
	int indel_offset;
	
	while (((signed int) strlen(BLOCK_TABLE[block].seq) + BLOCK_TABLE[block].indel_offset) < 0)
		block = BLOCK_TABLE[block].next_block;
		
	blockpos++;
	
	while (len != 0) {
		
		if (BLOCK_TABLE[block].indel_offset < 0) indel_offset = BLOCK_TABLE[block].indel_offset + 1;
		else indel_offset = 0;
		
		unsigned int block_seq_len = strlen(BLOCK_TABLE[block].seq);

		if (block_seq_len + indel_offset == 0) {
			block = BLOCK_TABLE[block].next_block;
			block_seq_len = strlen(BLOCK_TABLE[block].seq);
			continue;
		}
		
		if (block_seq_len + indel_offset - blockpos >= len) {
			
			// here save end pos of hit (pos relative to strain)!!!
			lastlen = len + blockpos - 1;
			
			len = 0;
		}
		else {
			
			len = len - block_seq_len - indel_offset + blockpos;
			
			nextblock = BLOCK_TABLE[block].next_block;
			
			if (nextblock == 0) {
				//if (!stick_to_strain) SEQS[strain] = -1;
				return len;	// block is last block of chromosome -> read could not have been mapped!!
			}
			
			nextnextblock = BLOCK_TABLE[nextblock].next_strain_front;
			
			if (strain == 0) {
				if (!stick_to_strain && !in_superblock) {
					while (nextnextblock != 0) { //len >= INDEX_DEPTH && BLOCK_TABLE[nextnextblock].strain != 0) {
						if (SEQS[BLOCK_TABLE[nextnextblock].strain] < 0) {
							SEQS[BLOCK_TABLE[nextnextblock].strain] = get_genome_pos_right(nextnextblock, 0, BLOCK_TABLE[nextnextblock].strain, len, 1);	// recursion with new strain
							BRANCHES = 1;
							
						}
						
						nextnextblock = BLOCK_TABLE[nextnextblock].next_strain_front;
					}
				}
				block = nextblock;
			}
			else {
				if (BLOCK_TABLE[nextblock].strain == 0 && nextnextblock != 0) { //BLOCK_TABLE[nextnextblock].strain != 0) { // TODO why not nextnextblock != 0 ????????
					block = nextblock;
					nextblock = nextnextblock;
					while (BLOCK_TABLE[nextblock].strain != strain && nextblock != 0) {
						nextblock = BLOCK_TABLE[nextblock].next_strain_front;
					}
					if (BLOCK_TABLE[nextblock].strain == strain) block = nextblock;
				}
				else {
					block = nextblock;
				}
			}
			
			lastlen = 0;	
		}
		blockpos = 0;
		
	} // while len != 0
	
	
	STARTBLOCK[strain] = block;
	BLOCKOFFSET[strain] = lastlen;
	
	return len;
	//if (BLOCK_TABLE[block].strain == 0)	return BLOCK_TABLE[block].pos + lastlen;
	//	else 							return BLOCK_TABLE[block].strainpos + lastlen;
}



#if OLD != 1
void printgenome()
{
	printf("G E N O M E: \n");
	unsigned int i,c;
	HIT *hit;
	CHROMOSOME_ENTRY *ce;
	for (i=0; i!=LONGEST_CHROMOSOME; ++i) {
		c=0;
		ce = *(GENOME+i);
		if (ce != NULL) {
			printf("%d: ",i);
			while (ce != NULL) {
				++c;
				printf("(%d, %d, %d, %d) ", ce->chromosome+1, ce->genome_pos, ce->strain, (ce->next!=NULL));
				hit = ce->mapping_entries->hit;
				printhit(hit);
				ce = ce->next;
			}
			printf("((%d))\n",c);
		}
	}	
}
#endif

//@TODO remove num
int size_hit(HIT *hit, unsigned int *oldlength, char num)
{
	HIT *last, *next;
	
	if (num) { printf("--size_hit-- "); printhit(hit); printf("oldlength: %d\n", *oldlength); }
	
	// close the gap where the hit is taken out
	// shortest possible hits are not under control of the operator so far
	if (*oldlength > INDEX_DEPTH - 1) {
		
		if (hit->last == NULL) { //hit is the first in the list, the operator must be re-linked
 			if (num) printf("Hit is the first in the list\n");
			*(HIT_LISTS_OPERATOR+*oldlength) = hit->next;
			next = hit->next;
			if (next != NULL) {
				next->last = NULL;
			}
		}
		else {
 			if (num) printf("Hit is NOT the first in the list\n");
			//sweet
			last = hit->last;
			next = hit->next;
			last->next = next;
			if (next != NULL) {
				next->last = last; 
			}
		}
	}

	//unsigned int length = hit->end - hit->start + 1;
	//unsigned int length = (hit->strain != 0)? hit->end-BLOCK_TABLE[hit->startblock].strainpos-hit->startoffset: hit->end-BLOCK_TABLE[hit->startblock].pos-hit->startoffset;	// TODO +1 am ende????
	
	if (num) printf("readpos: %d, length: %d\n", hit->readpos, hit->length);
	
	// ##########################################################
	// Mismatch at first pos of read:
	// ##########################################################
	
	// if hit.readpos == 2, then first base of read must be mismatch (spares alignment):
	/*if (hit->readpos == 2) {
		if (hit->mismatches-hit->gaps < NUM_MISMATCHES) {
			//if (hit->orientation == '+' && hit->start != 1) {
					//hit->start--;
			if (hit->orientation == '+' && get_genome_pos_left(hit->startblock, hit->startoffset, hit->strain, 1, 1) >= 0) {
					hit->startblock = STARTBLOCK[hit->strain];
					hit->startoffset = STRAINOFFSET[hit->strain];
					
					hit->edit_op[hit->mismatches].pos = 1;
					hit->edit_op[hit->mismatches].mm = 1;
					hit->mismatches++;
					hit->readpos--;
					// update length:
					length++;
			}
			//else if (hit->orientation == '-' && hit->end != CHR_LENGTH[hit->chromosome]) {
			else if (hit->orientation == '-' && get_genome_pos_right(hit->startblock, hit->startoffset, hit->strain, length+1, 1) >= 0) {	// checks if first base of read can be mapped on strain
					hit->end++;
					hit->edit_op[hit->mismatches].pos = READ_LENGTH;
					hit->edit_op[hit->mismatches].mm = 1; 
					hit->mismatches++;
					hit->readpos--;
					// update length:
					length++;
			}
			else {	// read doesn't fit on chromosome because of the first base
				if (STATISTICS) ENDSTART_MAPPED[0]++;
				return 0;
			}
		}
		else {	// do not add hit to hit list again
			if (num) printf("too many edit ops! %s", READ_ID);
			if (num) printhit(hit);
			return 0;
		}
	}*/
	
	// if hit ends at pos |read|-1, then check last base of read if it's a mismatch:
	/*if (hit->readpos + length == READ_LENGTH) {

		// compare last bases:
		READ[READ_LENGTH - 1] = toupper(READ[READ_LENGTH - 1]);
		//if ( ( 
		//		(hit->orientation == '+') && (hit->end != CHR_LENGTH[hit->chromosome]) && ( (READ[READ_LENGTH - 1] != CHR_SEQ[hit->chromosome][hit->end]) || !unique_base(READ[READ_LENGTH - 1]) ) 
		//	 ) || ( 
		// 	 	(hit->orientation == '-') && (hit->start != 1) && ( (READ[READ_LENGTH - 1] != get_compl_base(CHR_SEQ[hit->chromosome][hit->start-2])) || !unique_base(READ[READ_LENGTH - 1]) )
		// 	 ) )
		if ((hit->orientation == '+' && get_genome_pos_right(hit->startblock, hit->startoffset, hit->strain, length, 1) && 
				(BLOCK_TABLE[STARTBLOCK[hit->strain]].seq[STRAINOFFSET[hit->strain]] != READ[READ_LENGTH-1] || !unique_base(READ[READ_LENGTH-1])))
			||
			(hit->orientation == '-' && get_genome_pos_left(hit->startblock, hit->startoffset, hit->strain, 1, 1) && 
				(get_compl_base(BLOCK_TABLE[STARTBLOCK[hit->strain]].seq[STRAINOFFSET[hit->strain]]) != READ[READ_LENGTH-1] || !unique_base(READ[READ_LENGTH-1]))))	
		{				
			
			// create mismatch:
			if (hit->mismatches < NUM_EDIT_OPS && hit->mismatches-hit->gaps < NUM_MISMATCHES) {
				//if (hit->orientation == '+' && hit->end != CHR_LENGTH[hit->chromosome]) {
				if (hit->orientation == '+') {
						hit->end++;
						hit->edit_op[hit->mismatches].pos = READ_LENGTH;
						hit->edit_op[hit->mismatches].mm = 1; 
						hit->mismatches++;
						// update length:
						length++;
				}
				//else if (hit->orientation == '-' && hit->start != 0) {
				else if (hit->orientation == '-') {
						//hit->start--;
						hit->startblock = STARTBLOCK[hit->strain];
						hit->startoffset = STRAINOFFSET[hit->strain];
						hit->edit_op[hit->mismatches].pos = 1;
						hit->edit_op[hit->mismatches].mm = 1; 
						hit->mismatches++;
						// update length:
						length++;
				}
			}
			else {	// do not add hit to hit list again
				return 0;
			}
			
		}
	}*/

	// ##########################################################

	// add to new list
	if (*(HIT_LISTS_OPERATOR+hit->length) != NULL) {
 		if (num) printf("List already has some entries\n");
		next = *(HIT_LISTS_OPERATOR+hit->length);
		next->last = hit;
		hit->next = next;
		hit->last = NULL;
		*(HIT_LISTS_OPERATOR+hit->length) = hit;
	}
	else {
 		if (num) printf("List already no entries so far\n");
		hit->last = NULL;
		hit->next = NULL;
		*(HIT_LISTS_OPERATOR+hit->length) = hit;
	}

	if (hit->length > LONGEST_HIT) {
		LONGEST_HIT = hit->length;
	}
	
	if (num) printhits();

	return(1);
}



// for each read:
int browse_hits() 
{
	HIT* hit;
	int i;
	char perfect = 0;
	char printed = 0;
	
	// browse hit_list foreach hitlength:
	for (i=READ_LENGTH; i!=INDEX_DEPTH - 1; --i) {

		// if only perfect reads should be reported, break earlier:
		if ((NUM_EDIT_OPS == 0) && (i < READ_LENGTH)) { 
			if (printed) return 1;
				else return 0;
		}
		
		// if hitlength limit is reached, break earlier:
		if (i == HITLEN_LIMIT - 1) {
			if (printed) return 1;
				else return 0;
		}
	
		if ((*(HIT_LISTS_OPERATOR + i)) != NULL) {

			hit = *(HIT_LISTS_OPERATOR + i);
			
			// foreach hit with hitlength i:
			while (hit != NULL) {
				
				
				//hitlength = hit->end - hit->start + 1;	// 2 occs below

				if (STATISTICS) {
					NUM_HITS++;
					HITS_PER_READ++;
				}
								
				// Hit spans the whole read:
				if (i == READ_LENGTH) {		// hitlength

						if (STATISTICS && hit->mismatches == 0) {
						
							// reporting perfect matching reads (only one count per read)
							if (!perfect) {
								PERFECT_READS++;
								perfect = 1;
							}
							
							// reporting perfect hits
							if (hit->chromosome > 0) PERFECT_HITS++;
								else PERFECT_HITS_REV++;
						}
						
						// report match:
						if (hit->mismatches <= NUM_EDIT_OPS) {

							// insert hit into HITS_BY_SCORE
							insert_into_scorelist(hit, 1);
						
							printed = 1;
							if (STATISTICS) NOT_ALIGNED[0]++;
							
							if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
						}
				}
				else {
					
					// if hit ends at pos |read|-1, then last base of read is a mismatch:
					if (hit->readpos + i == READ_LENGTH) {			
							
						// create mismatch:
						if (hit->mismatches < NUM_MISMATCHES) {
							if (hit->chromosome > 0) {
									if (get_genome_pos_right(hit->startblock, hit->blockoffset, hit->strain, i, 1) > 0) {
										if (STATISTICS) ENDSTART_MAPPED[0]++;
										hit = hit->next;
										continue;
									}
									hit->length++;
									
									// only on reference it is sure that last base is mismatch since hit would have been extended
									// on strains hits must not be maximally extended (normally they arent)
									if (hit->strain == 0 || 
										(hit->strain != 0 && (BLOCK_TABLE[STARTBLOCK[hit->strain]].seq[BLOCKOFFSET[hit->strain]] != READ[READ_LENGTH-1] || !unique_base(READ[READ_LENGTH-1]))))
									{	
										hit->edit_op[hit->mismatches].pos = READ_LENGTH;
										hit->edit_op[hit->mismatches].mm = 1; 
										hit->mismatches++;
									}
							}
							else {
									if (get_genome_pos_left(hit->startblock, hit->blockoffset, hit->strain, 1, 1) > 0) {
										if (STATISTICS) ENDSTART_MAPPED[0]++;
										hit = hit->next;
										continue;
									}
									hit->startblock = STARTBLOCK[hit->strain];
									hit->blockoffset = BLOCKOFFSET[hit->strain];
									hit->strainpos--;
									hit->length++;
									
									if (hit->strain == 0 || 
										(hit->strain != 0 && 
										 (get_compl_base(BLOCK_TABLE[STARTBLOCK[hit->strain]].seq[BLOCKOFFSET[hit->strain]]) != READ[READ_LENGTH-1] || !unique_base(READ[READ_LENGTH-1]))))
									{
										hit->edit_op[hit->mismatches].pos = 1;
										hit->edit_op[hit->mismatches].mm = 1; 
										hit->mismatches++;
									}
							}
						}
						else {
							hit = hit->next;
							continue;
						}
					}
					
					// if hit.readpos == 2, then first base of read must be mismatch (spares alignment):
					if (hit->readpos == 2) {
						if (hit->mismatches < NUM_MISMATCHES) {
							if (hit->chromosome > 0) {
									if (get_genome_pos_left(hit->startblock, hit->blockoffset, hit->strain, 1, 1) > 0) {
										if (STATISTICS) ENDSTART_MAPPED[0]++;
										hit = hit->next;
										continue;
									}
									hit->startblock = STARTBLOCK[hit->strain];
									hit->blockoffset = BLOCKOFFSET[hit->strain];
									hit->strainpos--;
									hit->length++;
									hit->readpos--;
									
									if (hit->strain == 0 || 
										(hit->strain != 0 && (BLOCK_TABLE[STARTBLOCK[hit->strain]].seq[BLOCKOFFSET[hit->strain]] != READ[0] || !unique_base(READ[0]))))
									{
										// create mismatch:
										hit->edit_op[hit->mismatches].pos = 1;
										hit->edit_op[hit->mismatches].mm = 1;
										hit->mismatches++;
									}
							}
							else {
									if (get_genome_pos_right(hit->startblock, hit->blockoffset, hit->strain, hit->length, 1) > 0) {
										if (STATISTICS) ENDSTART_MAPPED[0]++;
										hit = hit->next;
										continue;
									}
									hit->length++;
									hit->readpos--;
									
									if (hit->strain == 0 || 
										(hit->strain != 0 && 
										 (get_compl_base(BLOCK_TABLE[STARTBLOCK[hit->strain]].seq[BLOCKOFFSET[hit->strain]]) != READ[0] || !unique_base(READ[0]))))
									{
										// create mismatch:
										hit->edit_op[hit->mismatches].pos = READ_LENGTH;
										hit->edit_op[hit->mismatches].mm = 1; 
										hit->mismatches++;
									}
							}
						}
						else {
							hit = hit->next;
							continue;
						}
					}
					
					if (hit->length == READ_LENGTH) {
						if (insert_into_scorelist(hit, 1)) printed = 1;
						if (STATISTICS) HITS_LEN[hit->length]++;
						
						hit = hit->next;
						continue;
					}


					// Alignment

					// for MM=1: hit must either start at readpos 1 or end at end of read, otherwise more than 1 MM:
					if (hit->mismatches < NUM_MISMATCHES) {
						//(*(*(HITS_READPOS+(hitlength-INDEX_DEPTH))+(hit->readpos-1)))++;
						
						if (NUM_GAPS != 0) {
							// KBOUND:
							if (prepare_kbound_alignment(hit)) printed = 1;
						}
						else {
							// SIMPLE:
							if (align_hit_simple(hit)) printed = 1;
						}
					}

				} // else has mismatches


				if (STATISTICS) HITS_LEN[hit->length]++;

				hit = hit->next;
				
			} // while hitlist not empty
			
		}
		
	} //for each hitlength
	
	return printed;
}


int insert_into_scorelist(HIT* hit, char d)
{		
	if (d && check_duplicate(hit)) return 0;
	
	int interval = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH-hit->mismatches) * M_SCORE;
	if (HITS_BY_SCORE[interval].num == 0) {
		// first entry in list
		HITS_BY_SCORE[interval].hitpointer = hit;
	}
	else {
		// list has already some entries, insert to the front
		HIT *tmp_hit = HITS_BY_SCORE[interval].hitpointer;
		HITS_BY_SCORE[interval].hitpointer = hit;
		hit->same_eo_succ = tmp_hit;
	}
	HITS_BY_SCORE[interval].num++;
	HITS_IN_SCORE_LIST++;
	
	if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
	
	
	return 1;
}



int check_duplicate(HIT* hit)
{
	//if (strcmp("1005805610367",READ_ID) == 0 ||strcmp("1005805620754",READ_ID) == 0) 

	int pos_slot;
	
	//int hitlength = hit->end - hit->start + 1;
	//unsigned int readstart, readend;
	
	//char strand = hit->orientation == '+'? 1: -1;
	
	if (hit->strain == 0) pos_slot = BLOCK_TABLE[hit->startblock].pos + hit->blockoffset;
	else pos_slot = BLOCK_TABLE[hit->startblock].strainpos + hit->blockoffset;
	
	//unsigned char score = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH-hit->mismatches) * M_SCORE;
	
	
	CHROMOSOME_ENTRY *chromosome_director, *chromosome_director_new;
	MAPPING_ENTRY *mapping_entry;//, *existing_entry;
	char flag = 0;
	
	if (*(GENOME+pos_slot) == NULL) {
				flag = 1;
				chromosome_director = alloc_chromosome_entry(&pos_slot, &(hit->chromosome), &(hit->strain));

				if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
				*(GENOME + pos_slot) = chromosome_director;
				
	}
	else {
		
		chromosome_director = *(GENOME + pos_slot);

		// is chrom_director from the actual read or from a former one?
		if (chromosome_director >= (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) 
			|| 	(chromosome_director < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) &&
		   		(chromosome_director->genome_pos != pos_slot))) {
		   			
		   			// it's from a former read, thus we need a new chrom_director:
					chromosome_director = alloc_chromosome_entry(&pos_slot, &(hit->chromosome), &(hit->strain));

					if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
					*(GENOME + pos_slot) = chromosome_director;
					
		}
	}
	
	int c=0;
 	// Search for chromosome_director for the correct chromosome/strand/strain
	while (chromosome_director->next != NULL && (chromosome_director->strain != hit->strain ||
			chromosome_director->chromosome != hit->chromosome)) // || (chromosome_director->chromosome == hit->chromosome && chromosome_director->strand != strand)))
	{
if (STATISTICS && c++ == 0) listocc++;
if (STATISTICS) listcount++;
		chromosome_director = chromosome_director->next;
	}

	if (chromosome_director->chromosome != hit->chromosome) {// || chromosome_director->strand != strand || chromosome_director->strain != hit->strain) {
		
		chromosome_director_new = alloc_chromosome_entry(&pos_slot, &(hit->chromosome), &(hit->strain));
        	if (!chromosome_director_new) return(0);
		
		chromosome_director_new->next = chromosome_director->next;
		chromosome_director->next = chromosome_director_new;
		chromosome_director = chromosome_director_new;
	}

	if (chromosome_director->mapping_entries == NULL) {

		mapping_entry = alloc_mapping_entry();

		chromosome_director->mapping_entries = mapping_entry;
		
		//mapping_entry->readpos = hit->end;
		mapping_entry->hit = hit;
	}
	else {
		
		if (flag == 1) {
			printf("!!!!!!!!!!!Found entry in chr dir at longest_genome pos %d  --  %p\n", pos_slot, chromosome_director->mapping_entries	);
			exit(1);
		}
		
		unsigned char score2, score1 = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE;
		
		mapping_entry = chromosome_director->mapping_entries;
		
		while (mapping_entry != NULL) {
			score2 = (mapping_entry->hit->mismatches-mapping_entry->hit->gaps) * MM_SCORE
					 + mapping_entry->hit->gaps * GAP_SCORE - (READ_LENGTH - mapping_entry->hit->mismatches) * M_SCORE;
		 
			if (mapping_entry->hit->length == hit->length && mapping_entry->hit->strain == hit->strain && score1 == score2) {
				if (STATISTICS) REDUNDANT++;
				return 1;
			}
			
			mapping_entry = mapping_entry->succ;
		}
		
		// no hit with same strain, same end pos of read and same score could have been found -> create another entry:
		//existing_entry = chromosome_director->mapping_entries; 

		mapping_entry = alloc_mapping_entry();
		mapping_entry->succ = chromosome_director->mapping_entries;
		//chromosome_director->mapping_entries->pred = mapping_entry;
		
		//insert to the front of the mapping list
		chromosome_director->mapping_entries = mapping_entry;

		//mapping_entry->readpos = hit->end;
		mapping_entry->hit = hit;

	}
	

	return 0;
}

/*
int duplicate(HIT* hit)
{
	//if (strcmp("1005805610367",READ_ID) == 0 ||strcmp("1005805620754",READ_ID) == 0) 

	int hitlength = hit->end - hit->start + 1;
	unsigned int readstart, readend;

#if OLD == 1
	unsigned int genome_slot;
#else
	char strand;	
#endif

	if (hit->orientation == '+') {
		readstart = hit->start - hit->readpos + hit->start_offset;	// start pos of read in genome	   0-initialized
		readend = hit->end + (READ_LENGTH - hit->readpos - hitlength) + hit->end_offset;			// 0-initialized
#if OLD == 1
		genome_slot = hit->chromosome;
#else
		strand = 1;
#endif
	}
	else {
		readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2) + hit->start_offset; 	// 0-initialized
		readend = hit->end + hit->readpos - 2 + hit->end_offset;									// 0-initialized
#if OLD == 1
		genome_slot = hit->chromosome + NUM_CHROMOSOMES;
#else
		strand = -1;
#endif
	}
	
	double score = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH-hit->mismatches) * M_SCORE;
	
	
#if OLD == 1
	CHROMOSOME_ENTRY *chromosome_director;
#else
	CHROMOSOME_ENTRY *chromosome_director, *chromosome_director_new;
#endif
	MAPPING_ENTRY *mapping_entry, *existing_entry;
	char flag = 0;
	
	if (*(GENOME+readstart) == NULL) {
				flag = 1;
#if OLD == 1
				chromosome_director = alloc_chromosome_entry(&readstart);
#else
				chromosome_director = alloc_chromosome_entry(&readstart, &(hit->chromosome), &strand);
#endif
				if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
				*(GENOME + readstart) = chromosome_director;
				
	}
	else {
		
		chromosome_director = *(GENOME + readstart);

#if OLD == 1
#endif
		// is chrom_director from the actual read or from a former one?
		if (chromosome_director >= (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) 
			|| 	(chromosome_director < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) &&
		   		(chromosome_director->genome_pos != readstart))) {
		   			
		   			// it's from a former read, thus we need a new chrom_director:
#if OLD == 1
		   			chromosome_director = alloc_chromosome_entry(&readstart);
#else
					chromosome_director = alloc_chromosome_entry(&readstart, &(hit->chromosome), &strand);
#endif

					if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
					*(GENOME + readstart) = chromosome_director;
					
		}
	}
	
	
#if OLD == 1	

	if (*((chromosome_director->mapping_entries)+genome_slot) == NULL) {

#else
	int c=0;
 	// Search for chromosome_director for the correct chromosome
 	//printf("%d %d %d %d %d\n",(chromosome_director->next != NULL), chromosome_director->chromosome, hit->chromosome, chromosome_director->strand, strand);
	while (chromosome_director->next != NULL && (chromosome_director->chromosome != hit->chromosome || 
												(chromosome_director->chromosome == hit->chromosome && chromosome_director->strand != strand))) {
if (STATISTICS && c == 0) listocc++;
if (STATISTICS) listcount++;
		chromosome_director = chromosome_director->next;
	}

	if (chromosome_director->chromosome != hit->chromosome || chromosome_director->strand != strand) {
	    chromosome_director_new = alloc_chromosome_entry(&readstart, &(hit->chromosome), &strand);
        if (!chromosome_director_new) return(0);

     	chromosome_director_new->next = chromosome_director->next;
        chromosome_director->next = chromosome_director_new;
        chromosome_director = chromosome_director_new;
	}

	if (chromosome_director->mapping_entries == NULL) {
#endif 
		mapping_entry = alloc_mapping_entry();
#if OLD == 1
		*((chromosome_director->mapping_entries)+genome_slot) = mapping_entry;
#else 
		chromosome_director->mapping_entries = mapping_entry;
#endif
		
		mapping_entry->readpos = readend;
		mapping_entry->hit = hit;
	}
	else {
		
		if (flag == 1) {
			printf("!!!!!!!!!!!Found entry in chr dir at genome pos %d  --  %p\n", readstart, chromosome_director->mapping_entries	);
			exit(1);
		}
		
		double score2, score1 = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE;
		
#if OLD == 1
		existing_entry = *((chromosome_director->mapping_entries)+genome_slot);
#else
		existing_entry = chromosome_director->mapping_entries;
#endif
		
		while (existing_entry != NULL) {
			score2 = (existing_entry->hit->mismatches-existing_entry->hit->gaps) * MM_SCORE
					 + existing_entry->hit->gaps * GAP_SCORE - (READ_LENGTH - existing_entry->hit->mismatches) * M_SCORE;
					 
			if (existing_entry->readpos == readend && score1 == score2) {
				if (STATISTICS) REDUNDANT++;
				return 1;
			}
			
			existing_entry = existing_entry->succ;
		}
		
		// no hit with same end pos of read and same score could have been found -> create another entry:
#if OLD == 1
		existing_entry = *((chromosome_director->mapping_entries)+genome_slot);	// since existing_entry was NULL due to the while loop
#else
		existing_entry = chromosome_director->mapping_entries; 
#endif
		mapping_entry = alloc_mapping_entry();
		mapping_entry->succ = existing_entry;
		existing_entry->pred = mapping_entry;
		//insert to the front of the mapping list
#if OLD == 1
		*((chromosome_director->mapping_entries)+genome_slot) = mapping_entry;
#else
		chromosome_director->mapping_entries = mapping_entry;
#endif
		mapping_entry->readpos = readend;
		mapping_entry->hit = hit;
						
	}
	
	return 0;
}
*/

// for debugging
char *get_seq(unsigned int n)
{
	char *seq = (char *) malloc ((INDEX_DEPTH+1)*sizeof(char));
	int i, c;
	for (i=INDEX_DEPTH-1; i>=0; --i) {
		c = (int) (n / POWER[i]);
		switch (c)
		{
			case 0: seq[i] = 'A';
					break;
			case 1: seq[i] = 'C';
					break;
			case 2: seq[i] = 'G';
					break;
			case 3: seq[i] = 'T';
					break;
		}
		n -= (int) (c * POWER[i]);
	}
	seq[INDEX_DEPTH] = '\0';
	return seq;
}

