// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int kbound_overhang_alignment(HIT* hit, int offset, int readseq_start);
int kbound_global_alignment(HIT* hit);

char unique_base(char c)
{
	return (c == 'A' || c == 'C' || c == 'G' || c == 'T');
}

int align_hit_simple(HIT* hit)
{
	
	/*
	int hitlength = hit->end - hit->start + 1;
	int afterhit_len = READ_LENGTH - hit->readpos - hitlength + 1;
	
	// checking if read fits on the start or end of chromosome:
	//@TODO small overlaps should be mapped
	if (hit->orientation == '+') {
		if (hit->start < hit->readpos) {
			//printf("Read cannot be mapped on plus strand at start of chromosome %d!\n", hit->chromosome+1);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
		if (hit->end + afterhit_len > CHR_LENGTH[hit->chromosome]) {
			//printf("Read cannot be mapped on plus strand at end of chromosome %d!\n", hit->chromosome+1);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
	}
	
	if (hit->orientation == '-') {
		if (afterhit_len >= hit->start) {
			//printf("Read cannot be mapped on minus strand at start of chromosome %d!\n", hit->chromosome+1);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
		if (hit->end + hit->readpos - 1 > CHR_LENGTH[hit->chromosome]) {
			//printf("Read cannot be mapped on minus strand at end of chromosome %d!\n", hit->chromosome+1);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
	}
	
	if (STATISTICS) NUM_ALIGNMENTS++;
	
	int j;
	//int val;
	
	int readstart;
	if (hit->orientation == '+') {
		readstart = hit->start - hit->readpos;	// 0-initialized
	}
	else {
		readstart = hit->start - afterhit_len - 1;	//changed		0-initialized
	}
	
	
	int j;
	char *seq = (char *) malloc(4 + MAX_READ_LENGTH * sizeof(char));
	
	// get sequence to which to align
	if (hit->orientation == '-') {
		if (get_readseq_left(hit->startblock, hit->startoffset, hit->strain, READ_LENGTH - hit->readpos + 1, 1) +
			get_readseq_right(hit->startblock, hit->startoffset, hit->strain, hit->readpos - 1, 1) != 0) {
				
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
			
		}
	}
	else {
		if (get_readseq_left(hit->startblock, hit->startoffset, hit->strain, hit->readpos - 1, 1) +
			get_readseq_right(hit->startblock, hit->startoffset, hit->strain, READ_LENGTH - hit->readpos + 1, 1) != 0) {
			
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
			
		}
	}
	
	// adjusting the start pos of hit to start pos of read (print_alignment demands this)	STARTBLOCK and STRAINOFFSET was set in get_readseq_left
	hit->startblock = STARTBLOCK[hit->strain];
	hit->startoffset = STRAINOFFSET[hit->strain];
	
	decode_strainseq(seq, SEQ[hit->strain]);
	strcpy(SEQ[hit->strain], seq);
		
	printf("seq[%d] .%s.\n", hit->strain, SEQ[hit->strain]);*/
	
	unsigned int strain;
	HIT *orihit = (HIT *) malloc(sizeof(HIT));;
	char *seq = (char *) malloc(4 + MAX_READ_LENGTH * sizeof(char));
	char any_success = 0, success;
	int j,k;
	char in_superblock = (hit->strain == 0) && BLOCK_TABLE[hit->startblock].strainpos;
	
	//unsigned int startblock = hit->startblock;
	//unsigned int startoffset = hit->startoffset;
	
	//////////////////////////////////////
	// get sequence(s) out of block table:
	BRANCHES = 0;
	
	// stores all sequences to which mapping has to occur in SEQ and the corresponding strains in SEQS!
	if (hit->chromosome < 0) {
		SEQS[hit->strain] = get_genome_pos_left(hit->startblock, hit->blockoffset, hit->strain, READ_LENGTH - hit->readpos + 1, in_superblock);
	}
	else {
		SEQS[hit->strain] = get_genome_pos_left(hit->startblock, hit->blockoffset, hit->strain, hit->readpos - 1, in_superblock);
		/*if (get_readseq_left(hit->startblock, hit->startoffset, hit->strain, hit->readpos - 1, 0) == 0) {
			SEQS[NUM_SEQS] = hit->strain;
			NUM_SEQS++;
			SEQ[hit->strain][hit->readpos - 1] = '\0';
		}*/
	}

	/*if (DEBUG)
	for (j=0; j!=NUM_SEQS; ++j) {
		printf("SEQS[%d] = %d", j, SEQS[j]);
		seq[0] = '\0';
		if (SEQ_OVERHANG[SEQS[j]] == 0) printf("\tSEQ: .%s. len %d\n", decode_seq(seq, SEQ[SEQS[j]]), strlen(SEQ[SEQS[j]]));
		else printf("\tno SEQ\n");
		printf("startblock[%d]: %d strainoffset: %d\n", SEQS[j], STARTBLOCK[SEQS[j]], STRAINOFFSET[SEQS[j]]);
	}*/
	
	if (SEQS[hit->strain] == 0) {
		if (hit->chromosome < 0) {
			hit->strainpos = hit->strainpos - (READ_LENGTH - hit->readpos + 1);
		}
		else {
			hit->strainpos = hit->strainpos - (hit->readpos - 1);
		}
		get_readseq_right(STARTBLOCK[hit->strain], BLOCKOFFSET[hit->strain], hit->strain, READ_LENGTH, in_superblock, 0);
		SEQ[hit->strain][READ_LENGTH] = '\0';
	}
	else {
		SEQ[hit->strain][0] = '\0';
		SEQS[hit->strain] = -1;
	}
	
	// adjusting the start pos of hit to start pos of read (print_alignment demands this)	STARTBLOCK and STRAINOFFSET was set in get_readseq_left
	hit->startblock = STARTBLOCK[hit->strain];
	hit->blockoffset = BLOCKOFFSET[hit->strain];

	memcpy(orihit, hit, sizeof(HIT));
		
	//////////////////////////////////////

	
	for (k=0; k<=NUM_STRAINS; ++k) {
		
		
		
		success = 1;
		//strain = k;
		
		if (!BRANCHES) strain = orihit->strain;
		else strain = k;
						
		if (SEQS[strain] != 0) {
			SEQ[strain][0] = '\0';
			SEQS[strain] = -1;
			continue;
		}
		
		// wenn strain == hit->strain, dann braucht man keinen neuen Hit anlegen, ansonsten aber schon !!!!!!!
		// die startpositionen liegen in den glob vars STARTBLOCK..., können also einfach übertragen werden, und pro strain werden die auch nur einmal gefüllt oder? denk schon
		// also das adjusting von oben dorekt vor forloop muss dann runter, da wo die hits ggfs generiert werden

		// ansonsten das mit overlap nochmal genau durchspielen und auch im prepare neue hits ggf erzeugen!!!

		//if (SEQ_OVERHANG[strain] > 0) continue;

		/*if (strlen(SEQ[strain]) != READ_LENGTH) { // if left superblock has strain seq, but not right superblock -> fill up to the right
			if (hit->orientation == '-') get_readseq_right(startblock, startoffset, strain, orihit->readpos - 1, 1);
			else get_readseq_right(startblock, startoffset, strain, READ_LENGTH - orihit->readpos + 1, 1);
			SEQ[strain][READ_LENGTH] = '\0';
		}*/
		
		if (strlen(SEQ[strain]) == 0) { // if left superblock has strain seq, but not right superblock -> fill up to the right
			SEQS[strain] = get_readseq_right(STARTBLOCK[strain], BLOCKOFFSET[strain], strain, READ_LENGTH, 1, 0);
			
			if (SEQS[strain] != 0) {
				SEQ[strain][0] = '\0';
				SEQS[strain] = -1;
				continue;
			}
		}

		decode_strainseq(seq, SEQ[strain]);
		strcpy(SEQ[strain], seq);
		
		
		// create hit if necessary
		if (strain != orihit->strain) {
			hit = alloc_hit();
			
			hit->chromosome = orihit->chromosome;
			//hit->readpos = orihit->readpos;
			if (hit->chromosome > 0) {
				hit->readpos = orihit->readpos;
			}
			else {
				hit->readpos = orihit->readpos + orihit->length - INDEX_DEPTH;
			}
			hit->strain = strain;
			hit->strainpos = STRAINPOS[strain];

			hit->mismatches = orihit->mismatches;
			for (j=0; j!=hit->mismatches; ++j) {
				hit->edit_op[j].mm = orihit->edit_op[j].mm;
				hit->edit_op[j].pos = orihit->edit_op[j].pos;
			}

			hit->startblock = STARTBLOCK[strain];
			hit->blockoffset = BLOCKOFFSET[strain];
			hit->length = INDEX_DEPTH;
			//hit->end = (strain != 0)? BLOCK_TABLE[hit->startblock].strainpos: BLOCK_TABLE[hit->startblock].pos;
			//hit->end += hit->startoffset + hit->readpos - 1 + INDEX_DEPTH;
			
		}
		else memcpy(hit, orihit, sizeof(HIT));

		//hitlength = (hit->strain != 0)? hit->end-BLOCK_TABLE[hit->startblock].strainpos-hit->startoffset: hit->end-BLOCK_TABLE[hit->startblock].pos-hit->startoffset;
	
		// from read[0] to read[hit->readpos]
		for (j=0; j!=hit->readpos-1; ++j) {
					/*if (DEBUG){ if (hit->orientation == '+') {printf("%d,%c ",hit->start - hit->readpos + j,CHR_SEQ[hit->chromosome][hit->start - hit->readpos + j]);}
						else printf("%d,%c ",hit->end + hit->readpos -2 -j,get_compl_base(CHR_SEQ[hit->chromosome][hit->end + hit->readpos - 2 - j]));}*/

			if (	hit->chromosome > 0
					//&& (	(CHR_SEQ[hit->chromosome][hit->start - hit->readpos + j] != READ[j])
					&& (	(SEQ[hit->strain][j] != READ[j])  
						|| !(unique_base(READ[j]))		// [XX] should also be a mismatch!
						// if read[j]=X and chr_seq not, then first or-condition is automatically true -> genome sequence doesn't have to be checked
					) 
			) 
			{
				// create mismatch:
				if (hit->mismatches < NUM_MISMATCHES) {
					(hit->edit_op[hit->mismatches]).pos = j+1;
					(hit->edit_op[hit->mismatches]).mm = 1;
				}
		
				hit->mismatches++;
			}
				
			if (	hit->chromosome < 0 
					//&& (    (get_compl_base(CHR_SEQ[hit->chromosome][hit->end + hit->readpos - 2 - j]) != READ[j])
					&& (    (get_compl_base(SEQ[hit->strain][j]) != READ[j])  
						|| !(unique_base(READ[j]))
					)
			)
			{
				// create mismatch:
				if (hit->mismatches < NUM_MISMATCHES) {
					hit->edit_op[hit->mismatches].pos = READ_LENGTH - j;
					hit->edit_op[hit->mismatches].mm = 1;
				}
		
				hit->mismatches++;
			}
			
			if (hit->mismatches > NUM_MISMATCHES) {
				/*if (hit->orientation == '+') val = readstart;
					else val = readstart * 2;
				if (READSTART[val]) REDUNDANT++;
					else READSTART[val] = 1;*/
				success = 0;
				break;
				//return 0;
			}
		}
		
		if (success == 0) {
			SEQ[hit->strain][0] = '\0';
			SEQS[hit->strain] = -1;
			continue;		// next strain, current one was unsuccessful
		}
		
		// from read[hit->readpos + hitlength] to read[READ_LENGTH - 1]
		//int i = 0;
		//j = hit->readpos + hitlength - 1;
		
		
		for (j = hit->length; j < READ_LENGTH; ++j) {
	
			if (	(hit->chromosome > 0) 
					//&& (    (CHR_SEQ[hit->chromosome][hit->end + i] != READ[j])
					&& (    (SEQ[hit->strain][j] != READ[j])  
						|| !(unique_base(READ[j]))		// [XX] should also be a mismatch!
						// if read[j]=X and chr_seq not, then first or-condition is automatically true -> genome sequence doesn't have to be checked
					) 
			)
			{
				// create mismatch:
				if (hit->mismatches < NUM_MISMATCHES) {		
					(hit->edit_op[hit->mismatches]).pos = j+1;
					(hit->edit_op[hit->mismatches]).mm = 1;
				}
		
				hit->mismatches++;
			}
	
				
			if (	(hit->chromosome < 0) 
					//&& (    (get_compl_base(CHR_SEQ[hit->chromosome][hit->start - 2 - i]) != READ[j])
					&& (    (get_compl_base(SEQ[hit->strain][j]) != READ[j])  
						|| !(unique_base(READ[j]))
					)
			)
			{
				// create mismatch:
				if (hit->mismatches < NUM_MISMATCHES) {
					(hit->edit_op[hit->mismatches]).pos = READ_LENGTH - j;
					(hit->edit_op[hit->mismatches]).mm = 1;
				}
		
				hit->mismatches++;
			}
			
			if (hit->mismatches > NUM_MISMATCHES) {
				/*if (hit->orientation == '+') val = readstart;
					else val = readstart * 2;
				if (READSTART[val]) REDUNDANT++;
					else READSTART[val] = 1;*/
				success = 0;
				break;
				//return 0;
			}
			
			// update hit:
			hit->length++;
			
		}
		
		
		//if (hit->mismatches <= NUM_MISMATCHES) {	// there can't be gaps
		if (success) {
			
			// insert hit into HITS_BY_SCORE
			if (insert_into_scorelist(hit, 1)) any_success = 1; 
			
			if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
		}

		SEQ[hit->strain][0] = '\0';
		SEQS[hit->strain] = -1;
		if (!BRANCHES) break;
	} //for all strains
	
	/*if (hit->orientation == '+') val = readstart;
		else val = readstart * 2;
	if (READSTART[val]) REDUNDANT++;
		else READSTART[val] = 1;*/

	free(seq);
	free(orihit);

	return any_success;
}


// returns if aligned hit fulfills MM and gap-criterias, thus is printed out (alignments are called in this method)
int prepare_kbound_alignment(HIT* hit)
{
	//int hitlength = (hit->strain != 0)? hit->end-BLOCK_TABLE[hit->startblock].strainpos-hit->startoffset: hit->end-BLOCK_TABLE[hit->startblock].pos-hit->startoffset;;
	/*int hitlength = hit->end - hit->start + 1;
	int afterhit_len = READ_LENGTH - hit->readpos - hitlength + 1;
	
	// checking if read fits on the start or end of chromosome:
	//@TODO small overlaps should be mapped
	if (hit->orientation == '+') {
		if (hit->start < hit->readpos) {
			if (DEBUG) printf("Read cannot be mapped on plus strand at start of chromosome %d!\n", hit->chromosome+1);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
		if (hit->end + afterhit_len > CHR_LENGTH[hit->chromosome]) {
			if (DEBUG) printf("Read cannot be mapped on plus strand at end of chromosome %d %d %d!\n", hit->chromosome+1, hit->end, afterhit_len);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
	}
	
	if (hit->orientation == '-') {
		if (afterhit_len >= hit->start) {
			if (DEBUG) printf("Read cannot be mapped on minus strand at start of chromosome %d!\n", hit->chromosome+1);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
		if (hit->end + hit->readpos - 1 > CHR_LENGTH[hit->chromosome]) {
			if (DEBUG) printf("Read cannot be mapped on minus strand at end of chromosome %d!\n", hit->chromosome+1);
			if (STATISTICS) ENDSTART_MAPPED[0]++;
			return 0;
		}
	}*/
	
	int strain, offset;
	unsigned int k,j;
	HIT *orihit = (HIT *) malloc(sizeof(HIT));
	char *seq = malloc(MAX_READ_LENGTH * sizeof(char));
	char any_success = 0;
	char in_superblock = (hit->strain == 0) && BLOCK_TABLE[hit->startblock].strainpos;
	
	//unsigned int startblock = hit->startblock;
	//unsigned int startoffset = hit->startoffset;
	
	//////////////////////////////////////
	// get sequence(s) out of block table:
	//NUM_SEQS = 0;
	//SEQ[hit->strain][0] = '\0';
	BRANCHES = 0;
	
	//if (hit->readpos > 1) {
		// stores all sequences to which mapping has to occur in SEQ and the corresponding strains in SEQS!
		if (hit->chromosome < 0) {
			SEQS[hit->strain] = get_genome_pos_left(hit->startblock, hit->blockoffset, hit->strain, READ_LENGTH - hit->length - hit->readpos + 1 + NUM_GAPS, in_superblock);
			//hit->end = hit->end - (READ_LENGTH - hitlength - hit->readpos + 1);
			
			/*SEQ[hit->strain][READ_LENGTH - hitlength - hit->readpos + 1 + NUM_GAPS] = '\0';
			if (get_readseq_left(hit->startblock, hit->startoffset, hit->strain, READ_LENGTH - hitlength - hit->readpos + 1 + NUM_GAPS, 0) <= NUM_GAPS) {
				SEQS[NUM_SEQS] = hit->strain;
				NUM_SEQS++;
				SEQ[hit->strain][READ_LENGTH - hit->readpos + 1 + NUM_GAPS] = '\0';
				//SEQ[hit->strain] = SEQ[hit->strain] + SEQ_OVERHANG[hit->strain];
				
				hit->end = hit->end - (READ_LENGTH - hitlength - hit->readpos + 1);
			}
			else SEQ[hit->strain][0] = '\0';*/
		}
		else {
			SEQS[hit->strain] = get_genome_pos_left(hit->startblock, hit->blockoffset, hit->strain, hit->readpos - 1 + NUM_GAPS, in_superblock);
			//hit->end = hit->end - hit->readpos + 1;
			
			/*SEQ[hit->strain][hit->readpos - 1 + NUM_GAPS] = '\0';
			if (get_readseq_left(hit->startblock, hit->startoffset, hit->strain, hit->readpos - 1 + NUM_GAPS, 0) <= NUM_GAPS) {
				SEQS[NUM_SEQS] = hit->strain;
				NUM_SEQS++;
				SEQ[hit->strain][hit->readpos - 1 + NUM_GAPS] = '\0';
				//SEQ[hit->strain] = SEQ[hit->strain] + SEQ_OVERHANG[hit->strain];
				
				hit->end = hit->end - hit->readpos + 1; //- (NUM_GAPS - SEQ_OVERHANG[hit->strain]) + 1;
			}
			else SEQ[hit->strain][0] = '\0';*/
		}
		//offset = NUM_GAPS - SEQ_OVERHANG[hit->strain];
		//hit->end -= hit->readpos + 1;
		
	
		/*if (NUM_SEQS == 0) {
			if (DEBUG) printf("No strain matches to the front of a chromosome!\n");
			free(seq);
			return 0;
		}
		
		for (j=0; j!=NUM_SEQS; ++j) {
			printf("SEQS[%d] = %d", j, SEQS[j]);
			seq[0] = '\0';
			printf("\tSEQ: .%s. len %d\n", decode_seq(seq, SEQ[SEQS[j]]), strlen(SEQ[SEQS[j]]));
			printf("startblock[%d]: %d strainoffset: %d\n", SEQS[j], STARTBLOCK[SEQS[j]], STRAINOFFSET[SEQS[j]]);
		}*/
	//}
	
	//#######################
	//'######################
	
	
	if (SEQS[hit->strain] <= NUM_GAPS) {
		if (hit->chromosome < 0) hit->strainpos = hit->strainpos - (READ_LENGTH - hit->length - hit->readpos + 1);
		else					 hit->strainpos = hit->strainpos - (hit->readpos - 1);
		SEQS[hit->strain] = get_readseq_right(STARTBLOCK[hit->strain], BLOCKOFFSET[hit->strain], hit->strain, (NUM_GAPS - SEQS[hit->strain]) + READ_LENGTH + NUM_GAPS, in_superblock, 1);
		
		/*if (hit->orientation == '-')	{
			get_readseq_right(hit->startblock, hit->startoffset, hit->strain, hitlength + hit->readpos - 1 + NUM_GAPS, 0);
		}
		else {
			get_readseq_right(hit->startblock, hit->startoffset, hit->strain, READ_LENGTH - hit->readpos + 1 + NUM_GAPS, 0);
		}*/
	}
	else {
		SEQ[hit->strain][0] = '\0';
		SEQS[hit->strain] = -1;
	}
	//SEQ[hit->strain][READ_LENGTH + offset + NUM_GAPS - SEQ_OVERHANG[hit->strain]] = '\0';
	//SEQ[hit->strain][READ_LENGTH + NUM_GAPS + NUM_GAPS] = '\0';
	
	/*if (DEBUG) printf("seq_overhang: %d\n",SEQ_OVERHANG[hit->strain]);
	if (DEBUG) 
	for (j=0; j!=NUM_SEQS; ++j) {
		printf("SEQS[%d] = %d", j, SEQS[j]);
		seq[0] = '\0';
		printf("\tSEQ: .%s.\n", decode_seq(seq, SEQ[SEQS[j]]));
		//printf("%d: endpos on strain: %d\n", SEQS[j], ENDSTRAINPOS[SEQS[j]]);
	}*/
	//########################
	//########################
		
	// adjusting the start pos of hit to start pos of read (print_alignment demands this)	STARTBLOCK and STRAINOFFSET was set in get_readseq_left
	hit->startblock = STARTBLOCK[hit->strain];
	hit->blockoffset = BLOCKOFFSET[hit->strain];
	
	memcpy(orihit, hit, sizeof(HIT));
	
	//////////////////////////////////////
	
/*
	for (j=0; j!=NUM_SEQS; ++j) {

		strain = SEQS[j];
		if (SEQ_OVERHANG[strain] > 0) {
			SEQ[strain] = SEQ[strain]+SEQ_OVERHANG[strain];
			l = strlen(SEQ[strain]);
			get_readseq_left(STARTBLOCK[strain], STRAINOFFSET[strain], strain, NUM_GAPS - SEQ_OVERHANG[strain] + 1, 1);
			SEQ[strain][l + NUM_GAPS - SEQ_OVERHANG[strain] + 1] = '\0';
		}

	}*/

	for (k=0; k<=NUM_STRAINS; ++k) {
		
		//strain = SEQS[k];
		
		/*if (SEQ_OVERHANG[strain] > NUM_GAPS) {
			SEQ[strain][0] = '\0';
			continue;
		}*/
		
		if (!BRANCHES) strain = orihit->strain;
		else strain = k;
						
		if (SEQS[strain] < 0 || SEQS[strain] > NUM_GAPS) {
			SEQ[strain][0] = '\0';
			SEQS[strain] = -1;
			continue;
		}
		
		if (strlen(SEQ[strain]) == 0) { // if left superblock has strain seq, but not right superblock -> fill up to the right
			STRAINPOS[strain] += NUM_GAPS; // correcting for front overlap
			SEQS[strain] = get_readseq_right(STARTBLOCK[strain], BLOCKOFFSET[strain], strain, (NUM_GAPS - SEQS[strain]) + READ_LENGTH + NUM_GAPS, 1, 1);
			
			
			if (SEQS[strain] > NUM_GAPS) {
				SEQ[strain][0] = '\0';
				SEQS[strain] = -1;
				continue;
			}
		}

		// wenn strain == hit->strain, dann braucht man keinen neuen Hit anlegen, ansonsten aber schon !!!!!!!
		// die startpositionen liegen in den glob vars STARTBLOCK..., können also einfach übertragen werden, und pro strain werden die auch nur einmal gefüllt oder? denk schon
		// also das adjusting von oben dorekt vor forloop muss dann runter, da wo die hits ggfs generiert werden

		// ansonsten das mit overlap nochmal genau durchspielen und auch im prepare neue hits ggf erzeugen!!!

		/*if (strlen(SEQ[strain]) < READ_LENGTH) { // if left superblock has strain seq, but not right superblock -> fill up to the right
			if (hit->orientation == '-') get_readseq_right(startblock, startoffset, strain, hitlength + orihit->readpos - 1 + NUM_GAPS, 1);
			else get_readseq_right(startblock, startoffset, strain, READ_LENGTH - orihit->readpos + 1 + NUM_GAPS, 1);
			//SEQ[strain][READ_LENGTH] = '\0';
		}*/

		decode_strainseq(seq, SEQ[strain]);
		strcpy(SEQ[strain], seq);
		

		// create hit if necessary
		if (strain != orihit->strain) {
			hit = alloc_hit();
			
			// get_readseq_left has delivered the sequence, but the "startpointers" have to set back to hitstart
			get_genome_pos_right(STARTBLOCK[strain], BLOCKOFFSET[strain], strain, strlen(SEQ[strain]) - READ_LENGTH - (NUM_GAPS - SEQS[strain]), 1);
			
			hit->chromosome = orihit->chromosome;
			//hit->readpos = orihit->readpos;
			if (hit->chromosome > 0) {
				hit->readpos = orihit->readpos;
			}
			else {
				hit->readpos = orihit->readpos + orihit->length - INDEX_DEPTH;
			}
			hit->strain = strain;
			hit->strainpos = STRAINPOS[strain];

			hit->mismatches = orihit->mismatches;
			for (j=0; j!=hit->mismatches; ++j) {
				hit->edit_op[j].mm = orihit->edit_op[j].mm;
				hit->edit_op[j].pos = orihit->edit_op[j].pos;
			}

			hit->startblock = STARTBLOCK[strain];
			hit->blockoffset = BLOCKOFFSET[strain];
			hit->length = INDEX_DEPTH;
			//hit->end = (strain != 0)? BLOCK_TABLE[hit->startblock].strainpos: BLOCK_TABLE[hit->startblock].pos;
			//hit->end += hit->startoffset + INDEX_DEPTH;
			
			// what do we do with hit->end???? <<<<<<<---------------- !!!!!!!!!!!!!!!!!!!!!! 
			
		}
		else {
			//hit = orihit;
			memcpy(hit, orihit, sizeof(HIT));
			// get_readseq_left has delivered the sequence, but the "startpointers" have to set back to hitstart
			get_genome_pos_right(STARTBLOCK[strain], BLOCKOFFSET[strain], strain, strlen(SEQ[strain]) - READ_LENGTH - (NUM_GAPS - SEQS[strain]), 1);
			hit->startblock = STARTBLOCK[strain];
			hit->blockoffset = BLOCKOFFSET[strain];
			//hit->end += strlen(SEQ[strain]) - READ_LENGTH - (NUM_GAPS - SEQ_OVERHANG[strain]);
		}
		

		
		
		//hitlength = (hit->strain != 0)? hit->end-BLOCK_TABLE[hit->startblock].strainpos-hit->startoffset: hit->end-BLOCK_TABLE[hit->startblock].pos-hit->startoffset;
		
		// just perform global alignment if gap heuristic/speedup was disabled:
		if (!OVERHANG_ALIGNMENT) {
			// reset possible mismatches within the hit:
			hit->mismatches = 0;
			
			if (kbound_global_alignment(hit)) {
				if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
				//return insert_into_scorelist(hit, 1);
				if (insert_into_scorelist(hit, 1)) any_success = 1;
			}
			//else return 0;
			
			SEQ[strain][0] = '\0';
			SEQS[strain] = -1;
			continue;
		}
		
		// perform whole alignment pipeline:
		
		char k1_aligned;
		
		/*int readstart;	// start pos of read on genome
		if (hit->orientation == '+') {
			readstart = hit->start - hit->readpos;		//	0-initialized
		}
		else {
			readstart = hit->start - afterhit_len - 1;	//changed		0-initialized
		}
		int readend = readstart + READ_LENGTH;	// end pos of read on genome	1-initialized
		
		if (DEBUG) printf("read %s, readstart %d, readend %d:\n",READ_ID, readstart, readend);*/
		
		if (hit->readpos != 1) {
			
			
				if (hit->chromosome > 0) {
					//if (readstart - NUM_GAPS < 0) offset = readstart;
					//	else offset = NUM_GAPS;
					offset = strlen(SEQ[strain]) - READ_LENGTH - (NUM_GAPS - SEQS[strain]);
				} 
				else {
					//if (readend + NUM_GAPS > CHR_LENGTH[hit->chromosome]) offset = CHR_LENGTH[hit->chromosome] - readend;
					//	else offset = NUM_GAPS;
					offset = NUM_GAPS - SEQS[strain];
				}
	
				// perform alignment
				k1_aligned = kbound_overhang_alignment(hit, offset, 0);
				
				//hit->end = hit->end - hit->readpos + 1;
			
				// there are gaps on best path in alignment -> perform whole global alignment
				if (k1_aligned == 0) {
					// reset possible mismatches within the hit:
					hit->mismatches = 0;

					if (kbound_global_alignment(hit)) {
						if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
						//return insert_into_scorelist(hit, 1);
						if (insert_into_scorelist(hit, 1)) any_success = 1;
					}
					//else return 0;
					
					SEQ[strain][0] = '\0';
					SEQS[strain] = -1;
					continue;
				}
				
				// too many mismatches in aligned read already:	
				if (k1_aligned == -1) {
					
					//return 0;
					SEQ[strain][0] = '\0';
					SEQS[strain] = -1;
					continue;
				}
				
		}
		
		//if (hit->readpos + hitlength != READ_LENGTH + 1) {
		//if (hitlength < READ_LENGTH) {
		if (hit->length + hit->readpos < READ_LENGTH) {
			
	
				if (hit->chromosome > 0) {
					//if (readend + NUM_GAPS > CHR_LENGTH[hit->chromosome]) offset = CHR_LENGTH[hit->chromosome] - readend;
					//	else offset = NUM_GAPS;
					offset = NUM_GAPS - SEQS[strain];
				}
				else {
					//if (readstart - NUM_GAPS < 0) offset = readstart;
					//	else offset = NUM_GAPS;
					offset = strlen(SEQ[strain]) - READ_LENGTH - (NUM_GAPS - SEQS[strain]);
				}
	
				// perform alignment if at least one edit op can still be afforded:
				if (hit->mismatches < NUM_EDIT_OPS) k1_aligned = kbound_overhang_alignment(hit, offset, hit->readpos+hit->length-1);	 // -1
					else {
						//return 0;
						SEQ[strain][0] = '\0';
						SEQS[strain] = -1;
						continue;
					}
				
				// there are gaps on best path in alignment -> perform whole global alignment
				if (k1_aligned == 0) {
					// reset possible mismatches within the hit:
					hit->mismatches = 0;

					if (kbound_global_alignment(hit)) {
						if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
						//return insert_into_scorelist(hit, 1);
						if (insert_into_scorelist(hit, 1)) any_success = 1;
					}
					//else return 0;
					
					SEQ[strain][0] = '\0';
					SEQS[strain] = -1;
					continue;
				}
					
				// too many mismatches?
				if (k1_aligned == -1) {
					SEQ[strain][0] = '\0';
					SEQS[strain] = -1;
					continue;
					//return 0;
				}
		}
		
		// gapless alignment was successful -> update hitlength and insert hit into HITS_BY_SCORE:
		hit->length += READ_LENGTH - hit->length;
		//hit->end += READ_LENGTH - hitlength; // - hit->readpos
		if (insert_into_scorelist(hit, 1)) any_success = 1;
		
		if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
	
		SEQ[strain][0] = '\0';
		SEQS[strain] = -1;
		if (!BRANCHES) break;

	} // for all strains
	
	
	free(seq);
	free(orihit);
	
	// successful alignment:
	return any_success;
}




// returns 1 if alignment is gapless, 0 if there are gaps and -1 if nr of allowed MMs is exceeded 
int kbound_overhang_alignment(HIT* hit, int offset, int readstart)
{
	if (STATISTICS) NUM_ALIGNMENTS++;
	
	int K = NUM_GAPS;

	int length;
	int chrstart;
	char offset_comp = 0;
	
	int strain = hit->strain;
	
	if (readstart == 0) {
		length = hit->readpos + offset - 1;
		offset_comp = offset;
//		if (hit->orientation == '+') chrstart = hit->start - length - 1;
//			else chrstart = hit->end + length - 1;
		if (hit->chromosome > 0) chrstart = 0;
			else chrstart = strlen(SEQ[strain]) - 1;
	}
	else {
//		length = READ_LENGTH - (hit->end - hit->start) - hit->readpos + offset;
//		if (hit->orientation == '+') chrstart = hit->end;
//			else chrstart = hit->start - 2;
		length = READ_LENGTH - readstart + offset;
		if (hit->chromosome > 0) chrstart = strlen(SEQ[strain]) - (READ_LENGTH - readstart + offset);
			else chrstart = length - 1; //hit->readpos + offset - 1;
	}

	
	int i,j,h;
	
	// Initialization:
	unsigned char score_before = hit->mismatches * MM_SCORE;
	if (readstart == 0) {
		for (i=0; i!=2*K+1; ++i) {
			M[i][offset] = score_before;
			//T[i][offset] = '0';
		}
		j = (K-offset < 0)? 0: K-offset;
		for (i=0; i!=j; ++i) {
			M[0][i+1+offset] = score_before + (i+1) * GAP_SCORE;
			//T[0][i+1+offset] = UP;
		}
	}
	else {
		for (i = 0; i <= K; ++i) {
			M[i][0] = score_before + i * GAP_SCORE;
			if (i!=0) { 
				M[0][i] = score_before + i * GAP_SCORE;
				
				//T[i][0] = LEFT;
				//T[0][i] = UP;
			}
		}
		//T[0][0] = '0';
	}
	
	// Alignment:
	int c, min_i = -1;
	char best_score_on_diag = 0;
	unsigned char score;
	unsigned char best_score = WORST_SCORE + 1;
	unsigned char column_score = best_score;
	
	for (i = 1; i <= length; ++i) {
		
		for (h = -K; h <= K; ++h) {
			j = i + h;
		
				if (j <= length && j >= 1) {
					if (j>K) c = j - K;
						else c = 0;
					
				if ( !(readstart == 0 && j <= offset) && !(readstart != 0 && j > length-offset) ) {
					
					if (STATISTICS) ++CELLS_OVERHANG;
					
					// Score-Function:
					if (hit->chromosome > 0) {
						if (SEQ[strain][chrstart+i-1] != READ[readstart+j-offset_comp-1] || !unique_base(READ[readstart+j-offset_comp-1]))
							 score = MM_SCORE;
						else score = M_SCORE;
					}
					else {
						if (get_compl_base(SEQ[strain][chrstart-i+1]) != READ[readstart+j-offset_comp-1] || !unique_base(READ[readstart+j-offset_comp-1]))
							 score = MM_SCORE;
						else score = M_SCORE;
					}
					
					M[i-c][j] = M[i-c-(j<=K)][j-1] + score;
					//T[i-c][j] = DIAGONAL;	// traceback diagonally
					
					if ((i-j-1 <= K) && (i-j-1 >= -K)) {
						if (M[i-c-1][j] + GAP_SCORE <= M[i-c][j]) {
							
							if (i == j) {
								if (STATISTICS) GAPS_ENCOUNTERED[0]++;
								return 0;
							}
							
							M[i-c][j] = M[i-c-1][j] + GAP_SCORE;
							//T[i-c][j] = LEFT;	// traceback to the left
							
						}
					}
					if ((i-j+1 <= K) && (i-j+1 >= -K)) {
						if (M[i-c+(j>K)][j-1] + GAP_SCORE <= M[i-c][j]) {
							
							if (i == j) {
								if (STATISTICS) GAPS_ENCOUNTERED[0]++;
								return 0;
							}
							
							M[i-c][j] = M[i-c+(j>K)][j-1] + GAP_SCORE;
							//T[i-c][j] = UP;	// traceback to upper
							
						}
					}
					
					if (readstart != 0 && j == length - offset) {
						if ( (!best_score_on_diag && M[i-c][j] < best_score) || (best_score_on_diag && M[i-c][j] <= best_score) ) {	
							// ensures that if score of most right bottom cell is equal to another cell in the same row, this other cell is reported with the best score
							best_score = M[i-c][j];
							min_i = i;
							if (i == j) best_score_on_diag = 1;
						}
					}
					
					if (M[i-c][j] < column_score) column_score = M[i-c][j];
					
				}
			}
			
		} //for h
		
		if (column_score > WORST_SCORE) {
			
			// readstart==0: score in most right bottom cell cannot become less than worst score
			// best_score > WORST_SCORE: there is no cell in the bottom row which has a valid alignment score 
			if (readstart == 0 || best_score > WORST_SCORE) {
				if (STATISTICS) TOO_MANY_MMS[0]++;
				return -1;
			} 
			// if best_score has been found before most right bottom cell was processed
			/*else if (i < length - offset) {	// readstart here is != 0
						if (DEBUG) print_alignment_matrix(chrstart, readstart, length, 0, offset, hit->chromosome, hit->orientation,K);
				if (DEBUG) printf("Best path in alignment contains gaps!\n");
				GAPS_ENCOUNTERED[1]++;
				return 0;
			}*/
			
			break;
			
		} else {
			column_score = WORST_SCORE + 1;
		}
		
	} //for i
	
	

	if (readstart == 0) {
		j = length;
		i = K - (j<K) * (K - j);
		best_score = M[i][j];
		min_i = j;
	}
	else {
		j = length-offset;
		i = min_i - (j>K) * (j - K);
	}
	

	if (best_score > WORST_SCORE) {
		if (STATISTICS) TOO_MANY_MMS[1]++;
		return -1;
	}
	
	// if best score is worse than max nr of allowed mismatches...
	if (best_score > WORST_MM_SCORE) {
		// ...and best score is in the most right bottom cell, there is no better path with gaps -> so we have too many MMs
		if (min_i == j) {
			if (STATISTICS) TOO_MANY_MMS[1]++;
			return -1;
		}
		// ..and there is another cell with this score other than the most right bottom cell -> there is a path with a valid score, BUT with gaps! 
		else {
			if (STATISTICS) GAPS_ENCOUNTERED[2]++;
			return 0;
		}
	}
	
	// FOR READSTART != 0 ONLY: if best path doesn't start from the most right bottom corner of the matrix -> gaps are in best alignment, return 0
	//if (min_i != j && M[i][j] != M[K-(j<K)*(K-j)][j]) {	@TODO!!!!!!!
	if (min_i != j) {	// even if score in most right bottom cell is equal to best score -> path with gaps needs less edit ops -> perform global algnm.
		if (STATISTICS) GAPS_ENCOUNTERED[2]++;
		return 0;
	}
	// FOR READSTART == 0: traceback has to start in most right bottom corner

	

	// Traceback (if there had been gaps the procedure returned 0, so only mismatches are left -> only diagonal traceback)
	int readpos;
	if (readstart == 0) readpos = j - offset;
		else readpos = readstart + j;
	i = K - (j<K) * (K - j);

	unsigned mms = (unsigned char) (M[i][j] / MM_SCORE) - (unsigned char) (score_before / MM_SCORE);

	
	while (j != (readstart==0)*offset && mms != 0) {
		if (M[i][j] != M[i-(j<=K)][j-1]) {
			// create mismatch:
			
			if (hit->chromosome > 0) hit->edit_op[hit->mismatches].pos = readpos;
				else					 hit->edit_op[hit->mismatches].pos = READ_LENGTH - readpos + 1;
			hit->edit_op[hit->mismatches].mm = 1;
			hit->mismatches++;
					
			--mms;
		}
		--readpos;
		--j;
		if (j<K) --i;
	}

	//print_alignment(hit,0);
	
	// successfully aligned
	return 1;
}






// k-bound global alignment algorithm:
int kbound_global_alignment(HIT* hit)
{
	if (STATISTICS) NUM_WHOLE_ALIGNMENTS++;
	
	int K = NUM_GAPS;
	
	// delete possible mismatches found in k1_alignment or at the beg/end:
	hit->mismatches = 0;
	
	int strain = hit->strain;
	
	int length = strlen(SEQ[strain]);
	int offset_end, offset_front;
	int chrstart;
	if (hit->chromosome < 0) {
		offset_front = NUM_GAPS - SEQS[strain];
		offset_end = length - READ_LENGTH - offset_front;
		chrstart = length - 1;
	} else {
		offset_end = NUM_GAPS - SEQS[strain];
		offset_front = length - READ_LENGTH - offset_end;
		chrstart = 0;
	}
	int start_offset = 0;
	//int hitlength = (hit->strain != 0)? hit->end-BLOCK_TABLE[hit->startblock].strainpos-hit->startoffset: hit->end-BLOCK_TABLE[hit->startblock].pos-hit->startoffset;

	/*int chrstart, chrend, offset_front, offset_end;
	if (hit->orientation == '+') {
		chrstart = hit->start - hit->readpos;		// 0-initialized
		if (chrstart < K) offset_front = chrstart;
			else offset_front = K;
		
		chrend = chrstart + READ_LENGTH;			// 1-initialized
		if (chrend + K > CHR_LENGTH[hit->chromosome]) offset_end = CHR_LENGTH[hit->chromosome] - chrend;
			else offset_end = K;
		
		chrstart -= offset_front;
	}
	else {
		chrstart = hit->end + hit->readpos - 2;		// 0-initialized
		if (chrstart + K >= CHR_LENGTH[hit->chromosome]) offset_front = CHR_LENGTH[hit->chromosome] - chrstart - 1;
			else offset_front = K;
		
		chrend = chrstart - READ_LENGTH + 1;		// 0-initialized
		if (chrend - K < 0) offset_end = chrend;
			else offset_end = K;
			
		chrstart += offset_front;					// 0-initialized
	}

	int length = READ_LENGTH + offset_front + offset_end;*/
	



	int i,j,h;
	
	// Initialization:
	for (i=0; i!=2*K+1-(K-offset_front); ++i) {
		
		M[i][offset_front] = 0;
		T[i][offset_front] = '0';
		
		j = (K-offset_front < 0)? 0: K-offset_front;
		for (h=0; h!=j; ++h) {
			M[0][h+1+offset_front] = (h+1) * GAP_SCORE;
			T[0][h+1+offset_front] = UP;
		}
	}
	
	
	// Alignment:
	int c;
	unsigned char best_score = WORST_SCORE + 1;
	unsigned char column_score = best_score;
	unsigned char score;
	int min_i = 0;	// start of traceback
	char best_score_on_diag = 0;
	
	for (i = 1; i <= length; ++i) {
		
		for (h = -K; h <= K; ++h) {
			j = i + h;
		
				if (j <= length && j >= 1) {
					if (j>K) c = j - K;
						else c = 0;
					
				if ( j > offset_front && j <= length-offset_end ) {
					
					if (STATISTICS) ++CELLS_GLOBAL;
					
					// Score-Function:
					if (hit->chromosome > 0) {
						if (SEQ[strain][chrstart+i-1] != READ[j-offset_front-1] || !unique_base(READ[j-offset_front-1]))	//COMP
							 score = MM_SCORE;
						else score = M_SCORE;
						//if (DEBUG) printf("i%d j%d chr[%d]=%c, read[%d]=%c -> score: %.1f\n", i,j,chrstart+i-1, CHR_SEQ[hit->chromosome][chrstart+i-1],	j-offset_front-1, READ[j-offset_front-1], score);	//COMP
					}
					else {
						if (get_compl_base(SEQ[strain][chrstart-i+1]) != READ[j-offset_front-1] || !unique_base(READ[j-offset_front-1])) //COMP
							 score = MM_SCORE;
						else score = M_SCORE;
						//if (DEBUG) printf("i%d j%d chr[%d]=%c, read[%d]=%c -> score: %.1f\n", i,j,chrstart-i+1, get_compl_base(CHR_SEQ[hit->chromosome][chrstart-i+1]),	j-offset_front-1, READ[j-offset_front-1], score);	//COMP
					}
					
					M[i-c][j] = M[i-c-(j<=K)][j-1] + score;
					T[i-c][j] = DIAGONAL;	// traceback diagonally
					
					if ((i-j+1 <= K) && (i-j+1 >= -K)) {
						// gap in chr
						if (M[i-c+(j>K)][j-1] + GAP_SCORE == M[i-c][j] && 
								((hit->chromosome > 0 && GAPS_MOST_RIGHT) || (hit->chromosome < 0 && !GAPS_MOST_RIGHT))) {
							M[i-c][j] = M[i-c+(j>K)][j-1] + GAP_SCORE;
							T[i-c][j] = UP;	// traceback to upper with gaps most right
						}
						else if (M[i-c+(j>K)][j-1] + GAP_SCORE < M[i-c][j]) {
							M[i-c][j] = M[i-c+(j>K)][j-1] + GAP_SCORE;
							T[i-c][j] = UP;	// traceback to upper
						}
					}
					
					if ((i-j-1 <= K) && (i-j-1 >= -K)) {
						// gap in read
						if (M[i-c-1][j] + GAP_SCORE == M[i-c][j] && 
								((hit->chromosome > 0 && GAPS_MOST_RIGHT) || (hit->chromosome < 0 && !GAPS_MOST_RIGHT))) {
							M[i-c][j] = M[i-c-1][j] + GAP_SCORE;
							T[i-c][j] = LEFT;	// traceback to the left with gaps most right
						}
						else if (M[i-c-1][j] + GAP_SCORE < M[i-c][j]) {
							M[i-c][j] = M[i-c-1][j] + GAP_SCORE;
							T[i-c][j] = LEFT;	// traceback to the left
						}
					}

					// Remember best score, i.e. start of traceback
					if (j == length - offset_end) {
						
						// gaps in reads preferred to gaps in chr:
						if ( (i <= j && M[i-c][j] <= best_score) || (i > j && ((best_score_on_diag && M[i-c][j] <  best_score) 
																		   || (!best_score_on_diag && M[i-c][j] <= best_score))) ) {
						
							best_score = M[i-c][j];
							min_i = i;
							if (i == j) best_score_on_diag = 1;
						}
					}
					// best_score preference:
					//	1. diagonal
					//	2. i > j (gaps in reads)
					//	3. i < j (gaps in chr)
					
					if (M[i-c][j] < column_score) column_score = M[i-c][j];
						
				}
			}
			
		} //for h
		
		if (column_score > WORST_SCORE) {
			if (best_score > WORST_SCORE) {
				if (STATISTICS) BREAK_GLOBAL_ALIGNMENT[0]++;
				return 0;
			}
			else {
				if (STATISTICS) BREAK_GLOBAL_ALIGNMENT[1]++;
				break;
			}
		} else {
			column_score = WORST_SCORE + 1;
		}
		
	} //for i
	
	
	if (best_score > WORST_SCORE) {
                if (STATISTICS) BREAK_GLOBAL_ALIGNMENT[0]++;
        	return 0;
	}


	j = length - offset_end;
	i = min_i - (j>K)*(j-K);
	int chrpos;
	if (hit->chromosome > 0) {
		chrpos = chrstart + min_i - 1;
		//hit->end_offset += min_i - j;	// correcting the read pos on chr for later output
		hit->length += min_i - j;
	}
	else {
		chrpos = chrstart - min_i + 1;
		//hit->start_offset -= min_i - j;	// correcting the read pos on chr for later output
		start_offset -= min_i - j;
	}
	int readpos = READ_LENGTH - 1;
	
	
	
	
	// Traceback:
	
	while (T[i][j] != '0' && M[i][j] != 0) {
			
		switch (T[i][j]) {		
			case DIAGONAL: {
				
				
				//if (CHR_SEQ[hit->chromosome][chrpos] != READ[readpos] || !unique_base(READ[readpos])) {
				//if (M[i-(j<=K)][j-1] == M[i][j] - MM_SCORE) {					// doesn't work for doubles!!
				//if (fabs(M[i-(j<=K)][j-1] - M[i][j] + MM_SCORE) > 1E-9) {		// works, but requires math.h!
				if (M[i-(j<=K)][j-1] != M[i][j]) {
					if ((hit->mismatches-hit->gaps) < NUM_MISMATCHES && hit->mismatches < NUM_EDIT_OPS) {
						if (hit->chromosome > 0) hit->edit_op[hit->mismatches].pos = readpos + 1;
							else					 hit->edit_op[hit->mismatches].pos = READ_LENGTH - readpos;
						hit->edit_op[hit->mismatches].mm = 1;
						hit->mismatches++; 
					}
					else {
						if (STATISTICS) BREAK_TB_IN_GLOBAL_ALIGNMENT++;
						return 0;	// discard hit
					}
				}
				
				i = i-(j<=K);
				j--;
				if (hit->chromosome > 0) chrpos--;
					else chrpos++;
				readpos--;
				break;
			}
			
			case LEFT: {
		
				if (hit->mismatches < NUM_EDIT_OPS && (!STRINGENT_GAPLIMIT || hit->gaps < NUM_GAPS)) {
					if (STATISTICS && hit->gaps >= NUM_GAPS) W++;
					if (hit->chromosome > 0) hit->edit_op[hit->mismatches].pos = readpos + 2;
						else				 hit->edit_op[hit->mismatches].pos = READ_LENGTH - readpos;
					hit->edit_op[hit->mismatches].mm = 0;
					hit->mismatches++;
					hit->gaps++;
				}
				else {
					if (STATISTICS) BREAK_TB_IN_GLOBAL_ALIGNMENT++;
					return 0;	// discard hit
				}
					
				i--;
				if (hit->chromosome > 0) chrpos--;
					else chrpos++;
				break;
			}
			
			case UP: {
				
				if (hit->mismatches < NUM_EDIT_OPS && (!STRINGENT_GAPLIMIT || hit->gaps < NUM_GAPS)) {
					if (STATISTICS && hit->gaps >= NUM_GAPS) W++;
					if (hit->chromosome > 0) hit->edit_op[hit->mismatches].pos = -readpos - 1;
						else				 hit->edit_op[hit->mismatches].pos = -READ_LENGTH + readpos; 
					hit->edit_op[hit->mismatches].mm = 0;
					hit->mismatches++;
					hit->gaps++;
				}
				else {
					if (STATISTICS) BREAK_TB_IN_GLOBAL_ALIGNMENT++;
					return 0;	// discard hit
				}
				
				i = i+(j>K);
				j--;
				readpos--;
				break;
			}
		}
		
	}
	
	if (hit->chromosome > 0) //hit->start_offset += i + (j>K)*(j-K) - j;
		start_offset += i + (j>K)*(j-K) - j;
		else //hit->end_offset -= i + (j>K)*(j-K) - j;
			hit->length -= i + (j>K)*(j-K) - j;
	
	// updating hit start:
	
	if (start_offset > 0) {
		get_genome_pos_right(hit->startblock, hit->blockoffset, hit->strain, start_offset, 1);
	}
	else if (start_offset < 0) {
		get_genome_pos_left(hit->startblock, hit->blockoffset, hit->strain, -start_offset, 1);
	}
	hit->strainpos = hit->strainpos + start_offset;
	hit->startblock = STARTBLOCK[hit->strain];
	hit->blockoffset = BLOCKOFFSET[hit->strain];
	
	// updating hit length:
	hit->length += READ_LENGTH - hit->length;
	
	
	// successfully aligned
	return 1;
}

