// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int usage() {
	printf("\nGenomeMapper v%sbeta\n", VERSION);
	printf("Max Planck Institute for Developmental Biology, Tübingen, Germany, 2009\n");
	printf("written by Korbinian Schneeberger and Joerg Hagmann\n\n");
	printf("USAGE: genomemapper [options]\n");
	printf("\n");
	printf("mandatory:\n");
	printf(" -i STRING  input fastafile\n");
	printf(" -x STRING  index filename\n");
	printf(" -t STRING  metaindex filename\n");
	printf(" -q STRING  query filename (fasta, fastq, SHORE flat file)\n");
	printf("\n");
	printf("optional:\n");
	printf(" -f STRING  output format (\"shore\" or \"bed\")\n");
	printf(" -o STRING  output filename (stdout)\n");
	printf(" -u STRING  unmapped reads filename\n");
	printf(" -s STRING  reference sequence ID (\"Ref\")\n\n");

	printf(" -a         report all hits (best hits only)\n");
	printf(" -r         disable reverse alignment\n");
	printf(" -h         always perform alignment on entire read\n");
	printf(" -d         align gaps most right (most left)\n");
	printf(" -w         allow more gaps for best hit\n");
	printf(" -e         report edit operations (alignment scores)\n");
	printf(" -l INT     seed length (index size)\n");
	printf(" -n INT     max number of best alignments (all)\n");
	printf(" -c INT     seed container size (15.000.000)\n\n");

	printf(" -M INT     max number of mismatches (3)\n");
	printf(" -G INT     max number of gaps (1)\n");
	printf(" -E INT     max edit operations(3)\n");
	printf(" -m DOUBLE  mismatch penalty (4)\n");
	printf(" -g DOUBLE  gap penalty (5)\n\n");

	printf(" -v         verbose (silent)\n");
	printf("\n");

	return 0;
}

// int usage() {
// 	printf("genomemapper v%1.2f\n\n", VERSION);
// 	printf("USAGE: genomemapper [options] -g <genome fasta-file>\n");
// 	printf("                              -i <index-filename>\n");
// 	printf("                              -m <metaindex-filename>\n");
// 	printf("                              -q <query-filename>\n");
// 	printf("\n");
// 	printf("options:\n");
// 	printf(" -o <STRING>\t\toutput file\t[default: stdout]\n");
// 	printf(" -f <STRING>\t\toutput file format (\"shore\" or \"bed\")\t[default: SHORE flat file]\n");
// 	printf(" -u <STRING>\t\tleft_over file: file of unmapped reads\n\t\t\t(works only with -o option)\t[default: none]\n");
// 	printf(" -r \t\t\tdisables mapping against reverse complementary strand\n\t\t\t[default: enabled]\n");
// 	//printf(" -n <INT>\t\tmaximal allowed number of non-base symbols in reads\t[default: 4]\n");
// 	printf(" -A \t\t\tall hits strategy (report all hits)\t[default: best hits strategy]\n");
// 	printf(" -a <INT>\t\tmaximal number of best alignments printed out per read\n\t\t\t(doesn't work in combination with -ar and -A option)\n\t\t\t[default: print all]\n");
// 	printf(" -ar <INT>\t\tmaximal number of best alignments printed out per read, randomly chosen\n\t\t\t(doesn't work in combination with -a and -A option)\n\t\t\t[default: print all]\n");
// 	printf(" -h \t\t\talways perform alignments on the complete read\n\t\t\t(slightly more sensitive)\n\t\t\t[default: only gapped alignments on whole read]\n");
// 	printf(" -l <INT>\t\tseedlength increase: only extended seeds with lengths greater\n\t\t\tthan this value will be aligned (might miss better alignments!)\n\t\t\t[default: seedlength]\n");
// 	printf(" -M <INT>\t\tmaximal number of mismatches\t  [default: 3]\n");
// 	printf(" -G <INT>\t\tmaximal number of gaps\t\t  [default: 1]\n");
// 	printf(" -E <INT>\t\tmaximal number of edit operations [default: 3]\n");	
// 	printf(" -gap_score <DOUBLE>\t\t(must be > 0)\t[default: 5]\n");
// 	printf(" -mismatch_score <DOUBLE>\t(must be > 0)\t[default: 4]\n");
// 	//printf(" -match_score <DOUBLE>\t\t[default: 0]\n");
// 	printf(" -e \t\t\tprints number of edit operations instead of scores in output file\n\t\t\t[default: scores]\n");
// 	printf(" -d \t\t\tgaps will be positioned most right\t[default: most left]\n");
// 	printf(" -w \t\t\tallows more gaps than specified if best alignment necessitates so\n\t\t\t[default: drop that hit]\n");
// 	printf(" -c <INT>\t\tchromosome container size\t[default: 1.000.000]\n");
// 	//printf(" -s \t\t\tcalculate and print statistics\t[default: disabled]\n");
// 	printf(" -v \t\t\tverbose mode\t[default: silent mode]\n");
// 	//printf(" -p \t\t\tdebug mode, long output\t[default: off]\n");
// 	printf("\n");
// 
// 	return 0;
// }
