// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

void printhit(HIT* hit);
int compare (const void *a, const void *b);
int compare_int (const void *a, const void *b);
char *get_align_seq(HIT *hit, int len, char start, char end);

unsigned int startblock;
unsigned char blockoffset;
char *SEQUENCE;
char *seq;


char get_compl_base(char c)
{
	switch (c) {
		case 'A': return 'T';
		case 'C': return 'G';
		case 'G': return 'C';
		case 'T': return 'A';
		default : return c;
	}
	return 0;
}


void print_stats ()
{
			printf("\n########### STATISTICS ###########\n");
			printf("Mapped Reads: %i of all %d reads\n", READS_MAPPED, NUM_READS);
			int i;
			for (i=0; i!=NUM_MISMATCHES+1; ++i) printf(" Reads with %d mismatches: %u\n", i, HITS_MM[i]);
			printf("  Perfect Plus-Hits: %i\n  Perfect Minus-Hits:\t%i\n  Total:\t\t%i\n", PERFECT_HITS, PERFECT_HITS_REV, PERFECT_HITS + PERFECT_HITS_REV);
			printf("   Perfect matching reads (+ or -): %i\n", PERFECT_READS);
			
			for (i=INDEX_DEPTH; i!=37; ++i) printf("    Total Hits of length %d: %u - %.4f%%\n", i, HITS_LEN[i], ((double) (100 * HITS_LEN[i]) / NUM_HITS));
			printf("\n    Total number of hits:                  %lu\n", NUM_HITS);
			printf("      Number of overhang alignments:       %lu\n", NUM_ALIGNMENTS);
			printf("      Successful overhang alignments:      %lu\n", NUM_ALIGNMENTS-GAPS_ENCOUNTERED[0]-GAPS_ENCOUNTERED[1]-GAPS_ENCOUNTERED[2]-TOO_MANY_MMS[0]-TOO_MANY_MMS[1]);
			printf("      Number of global alignments:         %lu\n", NUM_WHOLE_ALIGNMENTS);
			printf("      Successful global alignments:        %lu\n", NUM_WHOLE_ALIGNMENTS-BREAK_GLOBAL_ALIGNMENT[0]-BREAK_TB_IN_GLOBAL_ALIGNMENT);
			printf("      Breaks in global alignments(no hit): %lu\n", BREAK_GLOBAL_ALIGNMENT[0]);
			printf("      Breaks in global alignments(hit):    %lu\n", BREAK_GLOBAL_ALIGNMENT[1]);
			printf("      Breaks after global alignment:       %lu\n\n", BREAK_TB_IN_GLOBAL_ALIGNMENT);
			printf("      Hits of len 36, not aligned:         %d\n", NOT_ALIGNED[0]);
			printf("      Mappings of fast mapping:            %d\n", NOT_ALIGNED[1]);
			//printf("      hits of len 36, not aligned (with 1MM at start/beg of read): %d\n",NOT_ALIGNED[1]);
			//printf("        Number of unmapped hits at beg/end of chrom: %d and in align-step: %d\n", ENDSTART_MAPPED[0], ENDSTART_MAPPED[1]);
			printf("      Overlapping hits at beg/end of chr:  %d\n", ENDSTART_MAPPED[0]);
			
			printf("\nGaps encountered on diagonal during overhang-alignment:   %lu\n",GAPS_ENCOUNTERED[0]);
			printf("Gaps encountered due to score during overhang-alignment:  %lu\n",GAPS_ENCOUNTERED[1]);
			printf("Gaps encountered after overhang-alignment:                %lu\n",GAPS_ENCOUNTERED[2]);
			printf("Too many MMs during overhang-alignment (discarded hits):  %lu\n",TOO_MANY_MMS[0]);
			printf("Too many MMs after overhang-alignment (discarded hits):   %lu\n\n",TOO_MANY_MMS[1]);
			
			printf("cells processed in overhang: %lu\n", CELLS_OVERHANG);
			printf("cells processed in global:   %lu\n", CELLS_GLOBAL);
			printf("total cells:                 %lu\n\n", CELLS_OVERHANG+CELLS_GLOBAL);	
			
			printf("gap limit overcome: %lu\n\n",W);
			
			//printf("reads filtered out due to too much non-base chars: %i\n\n",READS_FILTERED); 
			
			/*printf("Print in stat... ");
			unsigned int sum=0;
			FILE* f;
			f = fopen("stat","w");
			for (i=0; i!= MAX_READ_LENGTH-INDEX_DEPTH+1; ++i) {
				for (j=0; j!=MAX_READ_LENGTH - INDEX_DEPTH - i + 1; ++j) {
					if (*(*(HITS_READPOS+i)+j) != 0) {
						fprintf(f, "\t(%d)%u ", j+1, *(*(HITS_READPOS+i)+j));
						sum += *(*(HITS_READPOS+i)+j);
					}
				}
				fprintf(f, "\nLENGTH %d: %d", i+INDEX_DEPTH, sum); 
				if (i!=MAX_READ_LENGTH-INDEX_DEPTH && sum != 0 && i<36) fprintf(f, "\tfirst: %.4f%%, last: %.4f%%, other: %.4f%%\n", ((double) (100 * *(*(HITS_READPOS+i))) / sum), ((double) (100 * (*(*(HITS_READPOS+i)+(36 - INDEX_DEPTH - i))))/sum), 100 - ((double) (100 * *(*(HITS_READPOS+i))) / sum) - ((double) (100 * (*(*(HITS_READPOS+i)+(36 - INDEX_DEPTH - i))))/sum));
					else fprintf(f, "\n");
				sum = 0;
			}
			printf("done\n");*/
}


// prints out all hits which have been inserted into HITS_BY_EDITOPS
int print_hits()
{
	int i, printed = 0, nr;
	HIT *hit;
	
	for (i = 0; i != NUM_SCORE_INTERVALS; ++i) {
		
		if (printed && !ALL_HIT_STRATEGY) break;	// best hit strategy
		
		if (HITS_BY_SCORE[i].hitpointer != NULL) {
			
			// only REPEATMAP numbers of alignment will be chosen randomly: 
			if (!ALL_HIT_STRATEGY && REPEATMAP < 0 && HITS_BY_SCORE[i].num > -REPEATMAP) {
				srand((unsigned) time(NULL));
				
				int j, k, n;
				int hits[-REPEATMAP];
				for (j=0; j!=-REPEATMAP; ++j) {
					n = 1;
					while (n != 0) {
						n = 0;
						hits[j] = rand() % HITS_BY_SCORE[i].num;
						for (k=0; k!=j; ++k) {
							if (hits[j] == hits[k]) ++n;
						}
					}
				}							
				
				qsort(hits, -REPEATMAP, sizeof(int), compare_int);
				
				hit = HITS_BY_SCORE[i].hitpointer;
				
				nr = 0;
				for (j=0; j!=HITS_BY_SCORE[i].num; ++j) {
					
					if (hits[nr] == j) {
						printed += print_alignment(hit, -REPEATMAP);
						nr++;
					}
					
					if (nr == -REPEATMAP) break;
					
					hit = hit->same_eo_succ;
				}
				
			}
			// no random selection of output alignments:
			else {
			
				hit = HITS_BY_SCORE[i].hitpointer;
				
				while (hit != NULL) {
					
					if (!ALL_HIT_STRATEGY) nr = HITS_BY_SCORE[i].num;
						else nr = HITS_IN_SCORE_LIST;
					
					if (REPEATMAP == 0) {	// no max nr of hits per read was specified, print all
						printed += print_alignment(hit, nr);
					}
					else if (REPEATMAP > 0 && printed < REPEATMAP) {
						printed += print_alignment(hit, (nr < REPEATMAP)? nr: REPEATMAP);
					}
					else if (REPEATMAP == printed) {	// repeatmap many alignments already printed out -> stop printing -> next read
						return 1;
					}
						
					hit = hit->same_eo_succ;
				}
			}
		}	
	}
	
	if (printed != 0) return 1;	// read could have been mapped
		else return 0;			// read couldn't be mapped
}


int print_alignment(HIT* hit, unsigned int num)
{
	
	if (STATISTICS) HITS_MM[hit->mismatches]++;
	
	int j, fstart, flen;	// fstart/fend for flanking regions (WMD3 support)
	char refpos[20];
	seq = (char *) malloc(4 * MAX_READ_LENGTH * sizeof(char));
	SEQUENCE = (char *) malloc(4 * MAX_READ_LENGTH * sizeof(char));
	

	unsigned int readstart = 0;
	
	startblock = hit->startblock;
	blockoffset = hit->blockoffset;
	
	/*int hitlength = hit->end - hit->start + 1;
	if (hit->orientation == '+') {
		readstart = hit->start - hit->readpos + hit->start_offset;	// start pos of read in genome	0-initialized
	}
	else {
		readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2) + hit->start_offset; 	// 0-initialized
	}
	
	
	*/
	
	
	// gets GENOME Sequence ( O N L Y DEBUGGING ):
	
	
	
	// PERFECT HITS:
	if (hit->mismatches == 0) {
		
		
		/*get_align_seq(hit, READ_LENGTH, 1, 1);	// sets SEQUENCE
		if (strlen(SEQUENCE) == 0) {
			free(seq);
			free(SEQUENCE);
			return 0;
		}
		strcpy(ALIGNSEQ, SEQUENCE);*/
		strcpy(ALIGNSEQ, get_align_seq(hit, READ_LENGTH, 1, 1));
		decode_strainseq(STRAINSEQ, ALIGNSEQ);
		
		
		
		if (BLOCK_TABLE[hit->startblock].ins_pos > 0) sprintf(refpos, "%d.%d", BLOCK_TABLE[hit->startblock].pos + 1, hit->blockoffset + BLOCK_TABLE[hit->startblock].ins_pos - 1);
		else if (BLOCK_TABLE[hit->startblock].indel_offset > 0 && hit->blockoffset > BLOCK_TABLE[hit->startblock].indel_offset-2) 
					sprintf(refpos, "%d.%d", BLOCK_TABLE[hit->startblock].pos + BLOCK_TABLE[hit->startblock].indel_offset - 1, hit->blockoffset - BLOCK_TABLE[hit->startblock].indel_offset + 2);
		else sprintf(refpos, "%d", BLOCK_TABLE[hit->startblock].pos + hit->blockoffset + 1);

		// print in file:
		if (OUTPUT_FORMAT == 0) {
			/////// SHORE file ///////	

			fprintf(OUT_FP, "%s\t%s\t%s\t%d\t%s\t%s\t%s\t%c\t%d\t%d\t%d\t%d", 
				(hit->strain == 0)? REFNAME: STRAIN_DESC[hit->strain-1],
				CHR_DESC[abs(hit->chromosome)-1],
				refpos,
				(hit->strain == 0)? atoi(refpos): hit->strainpos,//(hit->strain == 0)? atoi(refpos): BLOCK_TABLE[hit->startblock].strainpos + hit->blockoffset + 1,
				decode_seq(seq, ALIGNSEQ),		// Aligned Seq to Ref 
				STRAINSEQ,				// Strain Seq
				READ_ID,
				hit->chromosome > 0? 'D': 'P',
				SCORES_OUT? -READ_LENGTH * M_SCORE: hit->mismatches,
				num, // Number of hits
				READ_LENGTH,
				0);			
			
			if (READ_FORMAT == 2) fprintf(OUT_FP, "\t%d", READ_PE_FLAG);
			if (strlen(READ_QUALITY[0]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[0]);
			if (strlen(READ_QUALITY[1]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[1]);
			if (strlen(READ_QUALITY[2]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[2]);
			
			// @TODO Parse also flanking parts of hit out of graph
			
			if (FLANKING != 0) {
				fstart = (readstart < FLANKING)? 0: readstart - FLANKING;
				flen   = (readstart + READ_LENGTH + FLANKING > CHR_LENGTH[hit->chromosome])? CHR_LENGTH[hit->chromosome] - fstart: readstart - fstart + READ_LENGTH + FLANKING;
				strncpy(FLANK_SEQ, CHR_SEQ[hit->chromosome] + fstart, flen);
				FLANK_SEQ[flen] = '\0';
				fprintf(OUT_FP, "\t%d\t%s", CHR_LENGTH[hit->chromosome], FLANK_SEQ);
			}
			else if (PRINT_SEQ > 0) fprintf(OUT_FP, "\t%d", CHR_LENGTH[hit->chromosome]);
			if (PRINT_SEQ == 2) fprintf(OUT_FP, "\t%s", CHR_SEQ[hit->chromosome]);

			fprintf(OUT_FP, "\n");
		}
		else {
			/////// BED file ///////
			fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
				CHR_DESC[abs(hit->chromosome)-1],
				readstart,
				readstart + 1 + READ_LENGTH,
				READ_ID,
				SCORES_OUT? -READ_LENGTH * M_SCORE: hit->mismatches,
				hit->chromosome > 0? '+': '-');
		}
		
	}	
	// HITS WITH MISMATCHES:
	else {

		//int count_char = 0;
		unsigned int alignlen, strainlen;
		char gap_offset = 0;
		char gap_in_read = 0;
		char gap_in_chr = 0;
		
		// sort mismatches in ascending order according to their abs positions and 'gap before mm'-strategy if equal
		qsort(hit->edit_op, hit->mismatches, sizeof(EDIT_OPS), compare); 
		
		// determine startblock and startpos or already stored in alignment procedures??? TODO
		startblock = hit->startblock;
		blockoffset = hit->blockoffset;
		
		
		// calculate reference start position and store it as a string in refpos
		if (BLOCK_TABLE[hit->startblock].ins_pos > 0) sprintf(refpos, "%d.%d", BLOCK_TABLE[hit->startblock].pos + 1, hit->blockoffset + BLOCK_TABLE[hit->startblock].ins_pos - 1);	// old pos + indel_offset - 1
		else if (BLOCK_TABLE[hit->startblock].indel_offset > 0 && hit->blockoffset > BLOCK_TABLE[hit->startblock].indel_offset-2) 
					sprintf(refpos, "%d.%d", BLOCK_TABLE[hit->startblock].pos + BLOCK_TABLE[hit->startblock].indel_offset - 1, hit->blockoffset - BLOCK_TABLE[hit->startblock].indel_offset + 2);
		else sprintf(refpos, "%d", BLOCK_TABLE[hit->startblock].pos + hit->blockoffset + 1);
		

		
		for (j=0; j!=hit->mismatches; ++j) {
			
				if (hit->edit_op[j].pos < 0) {
					hit->edit_op[j].pos = -hit->edit_op[j].pos;
					gap_in_chr = 1;
				}
			
				if (j == 0) {  fflush(stdout);

					/*get_align_seq(hit, hit->edit_op[0].pos-1, 1, gap_in_chr);
					if (strlen(SEQUENCE) == 0) {
						free(seq);
						free(SEQUENCE);
						return 0;
					}
					strcpy(ALIGNSEQ, SEQUENCE);*/
					strcpy(ALIGNSEQ, get_align_seq(hit, hit->edit_op[0].pos-1, 1, gap_in_chr)); 
					decode_strainseq(STRAINSEQ, SEQUENCE); 
				}
				else if (hit->edit_op[j].pos - hit->edit_op[j-1].pos != 0) {
					
					/*get_align_seq(hit, hit->edit_op[j].pos - hit->edit_op[j-1].pos - 1 + gap_in_read, 0, gap_in_chr);
					if (strlen(SEQUENCE) == 0) {
						free(seq);
						free(SEQUENCE);
						return 0;
					}
					strcpy(ALIGNSEQ+strlen(ALIGNSEQ), SEQUENCE);*/
					strcpy(ALIGNSEQ+strlen(ALIGNSEQ), get_align_seq(hit, hit->edit_op[j].pos - hit->edit_op[j-1].pos - 1 + gap_in_read, 0, gap_in_chr));
					strcpy(STRAINSEQ+strlen(STRAINSEQ), decode_strainseq(seq, SEQUENCE));
				}	// else: edit_op[j-1] must have been a gap!
				else if (hit->edit_op[j-1].pos > 0) {	// last edit op was a deletion -> "pointer" has to be moved one to the right
					get_genome_pos_right(startblock, blockoffset, hit->strain, 1, 1);
					startblock = STARTBLOCK[hit->strain];
					blockoffset = BLOCKOFFSET[hit->strain];
				}
				
				gap_in_read = 0;
				
				
				alignlen = strlen(ALIGNSEQ);
				strainlen = strlen(STRAINSEQ);
				if (hit->edit_op[j].mm) {
					if (hit->chromosome > 0) {
						if (hit->strain != 0 && get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]) == READ[hit->edit_op[j].pos - 1]) {
							// Mismatch is rescued by Reference sequence
							sprintf(ALIGNSEQ+strlen(ALIGNSEQ), "%c", get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]));
						}
						else {
							sprintf(ALIGNSEQ+strlen(ALIGNSEQ), "[%c%c]", get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]), READ[hit->edit_op[j].pos - 1]);
						}
						sprintf(STRAINSEQ+strlen(STRAINSEQ), "[%c%c]", get_strain_base(BLOCK_TABLE[startblock].seq[blockoffset]), READ[hit->edit_op[j].pos - 1]);
					}
					else {
						if (hit->strain != 0 && get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]) == get_compl_base(READ[READ_LENGTH - hit->edit_op[j].pos])) {
							// Mismatch is rescued by Reference sequence
							sprintf(ALIGNSEQ+strlen(ALIGNSEQ), "%c", get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]));
						}
						else {
							sprintf(ALIGNSEQ+strlen(ALIGNSEQ), "[%c%c]", get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]), get_compl_base(READ[READ_LENGTH - hit->edit_op[j].pos]));
						}
						sprintf(STRAINSEQ+strlen(STRAINSEQ), "[%c%c]", get_strain_base(BLOCK_TABLE[startblock].seq[blockoffset]), get_compl_base(READ[READ_LENGTH - hit->edit_op[j].pos]));
					}
				}
				else if (gap_in_chr) {
					if (hit->chromosome > 0) {
						sprintf(ALIGNSEQ+strlen(ALIGNSEQ), "[-%c]", READ[hit->edit_op[j].pos - 1]);
						sprintf(STRAINSEQ+strlen(STRAINSEQ), "[-%c]", READ[hit->edit_op[j].pos - 1]);
					}
					else {
						sprintf(ALIGNSEQ+strlen(ALIGNSEQ), "[-%c]", get_compl_base(READ[READ_LENGTH - hit->edit_op[j].pos]));
						sprintf(STRAINSEQ+strlen(STRAINSEQ), "[-%c]", get_compl_base(READ[READ_LENGTH - hit->edit_op[j].pos]));
					}
					
					gap_offset--;
					gap_in_chr = 0;
				}
				else {
					//sprintf(ALIGNSEQ+count_char, "[%c-]", CHR_SEQ[hit->chromosome][readstart + hit->edit_op[j].pos - 1 + gap_offset]);
					if (get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]) != '-')
						sprintf(ALIGNSEQ+strlen(ALIGNSEQ), "[%c-]", get_ref_base(BLOCK_TABLE[startblock].seq[blockoffset]));
					// else: do not print [--]
					sprintf(STRAINSEQ+strlen(STRAINSEQ), "[%c-]", get_strain_base(BLOCK_TABLE[startblock].seq[blockoffset]));
					
					gap_offset++;
					gap_in_read = 1;
				}
				ALIGNSEQ[alignlen+4] = '\0';
				STRAINSEQ[strainlen+4] = '\0';		
				
					
		}
			
		// from last mismatch to end of read:
		/*get_align_seq(hit, READ_LENGTH - hit->edit_op[j-1].pos + gap_in_read, 0, 1);
		if (strlen(SEQUENCE) == 0) {
			free(SEQUENCE);
			free(seq);
			return 0;
		}
		strcpy(ALIGNSEQ+strlen(ALIGNSEQ), SEQUENCE);*/
		strcpy(ALIGNSEQ+strlen(ALIGNSEQ), get_align_seq(hit, READ_LENGTH - hit->edit_op[j-1].pos + gap_in_read, 0, 1));
		strcpy(STRAINSEQ+strlen(STRAINSEQ), decode_strainseq(seq, SEQUENCE));
		

		// strain-to-reference-alignment-transformation corrections
		if (hit->strain != 0) {
			int l = 0;
			int c = 0;
			int j,jj;
			int len;
			char mm = 0;
			char* postseq; postseq = (char*) malloc(4*MAX_READ_LENGTH*sizeof(char));
			char* ins; ins = (char*) malloc(4*MAX_READ_LENGTH*sizeof(char));
			seq = decode_seq(seq,ALIGNSEQ);

if (DEBUG) printf("%s\n",seq);
if (DEBUG) printf("012345678901234567890123456789012345678901234567890123456789012345678901234567890\n");
			TMP_ALIGNSEQ[l] = '\0';
			int i;
			for (i = 0; i < strlen(seq); ++i) {
if (DEBUG) printf("%d",i);
				// correct ALIGNSEQ for sequences which can be shifted in preceding insertions
				if ((seq[i] == '[' || seq[i] == '(') && i < strlen(seq) - 1 && seq[i+1] == '-') {
					
					// first detect insertion length
					c = i+1;
					len = 1;
if (DEBUG) printf("first gap at pos %d\n",c);
					while (c+4 < strlen(seq) && seq[c+4] == '-') {
						ins[len-1] = seq[c+1];
						ins[len] = '\0';
						c += 4;
						len++;
					}
					ins[len-1] = seq[c+1];
					ins[len] = '\0';

if (DEBUG) printf("len: %d, ins: .%s. c=%d len bases fit? %d < %d?\n",len, ins, c, c+3+len, (int) strlen(seq));
					// get subsequent len chars and check whether there is a MM or not
					if (c+3+len < strlen(seq) && mm >= 0) {
						j = c+3;
						jj = 0;
						mm = 0;
						while (jj < len) {
							if (seq[j] == '[') {
								if (seq[j+1] == '-' || seq[j+2] == '-') {
									mm = -1;
									break;
								}
								else {
									postseq[jj++] = seq[j+1];
									j += 4;
									mm = 1;
								}
							}
							else {
								postseq[jj++] = seq[j];
								j++;
							}
						}
						postseq[jj] = '\0';

if (DEBUG) printf("j %d - mm %d - postseq: .%s.\n",j,mm,postseq);

						// was among those chars a MM and are the seqs equal?
						if (mm == 1 && memcmp(postseq,ins,(size_t) len) == 0) {
							// YES! MM and equal sequences:
							memcpy(TMP_ALIGNSEQ+l, postseq, len * sizeof(char));
							i = c+2;
							l += len;
							while (jj > 0) {	// due to jj == len
								++i;
								TMP_ALIGNSEQ[l++] = '[';
								TMP_ALIGNSEQ[l++] = '-';
								if (seq[i] == '[') {
									TMP_ALIGNSEQ[l++] = seq[i+2];
									i += 3;
								}
								else {
									TMP_ALIGNSEQ[l++] = seq[i];
								}
								TMP_ALIGNSEQ[l++] = ']';
								jj--;
							}
if (DEBUG) printf("MM and equal seqs, TMP_ALIGNSEQ: .%s. i = %d, l = %d\n",TMP_ALIGNSEQ, i, l);
							postseq[0] = '\0';
							ins[0] = '\0';
							continue;
						}
					}

					postseq[0] = '\0';
					ins[0] = '\0';

				}

				// correct ALIGNSEQ for [.=](=-) and [=.](-=)
				if (seq[i] == '[' && i < strlen(seq) - 6 && seq[i+4] == '(') {
if (DEBUG) printf("other correction!\n");
					if (seq[i+6] == '-') {
						
						if (seq[i+5] == seq[i+2]) {
							// [-=](=-)
							if (seq[i+1] == '-') {
								TMP_ALIGNSEQ[l++] = seq[i+2];
							}
							// [.=](=-)
							else {
								TMP_ALIGNSEQ[l++] = '[';
								TMP_ALIGNSEQ[l++] = seq[i+1];
								TMP_ALIGNSEQ[l++] = '-';
								TMP_ALIGNSEQ[l++] = ']';
								TMP_ALIGNSEQ[l++] = seq[i+2];
							}

							i += 7;
						}
						// [-.](.-)
						else if (seq[i+1] == '-') {
							TMP_ALIGNSEQ[l++] = '[';
							TMP_ALIGNSEQ[l++] = seq[i+5];
							TMP_ALIGNSEQ[l++] = seq[i+1];
							TMP_ALIGNSEQ[l++] = ']';
							i += 7;
						}
						else TMP_ALIGNSEQ[l++] = seq[i];
						
					}
					else if (seq[i+5] == '-') {
						if (seq[i+1] == seq[i+6]) {
							// [=-](-=)
							if (seq[i+2] == '-') {
								TMP_ALIGNSEQ[l++] = seq[i+1];
							}
							// [=.](-=)
							else {
								TMP_ALIGNSEQ[l++] = '[';
								TMP_ALIGNSEQ[l++] = '-';
								TMP_ALIGNSEQ[l++] = seq[i+2];
								TMP_ALIGNSEQ[l++] = ']';
								TMP_ALIGNSEQ[l++] = seq[i+1];
							}

							i += 7;
						}
						// [.-](-.)
						else if (seq[i+2] == '-') {
							TMP_ALIGNSEQ[l++] = '[';
							TMP_ALIGNSEQ[l++] = seq[i+1];
							TMP_ALIGNSEQ[l++] = seq[i+6];
							TMP_ALIGNSEQ[l++] = ']';
							i += 7;
						}
						else TMP_ALIGNSEQ[l++] = seq[i];

					}
					else TMP_ALIGNSEQ[l++] = seq[i];
				
				}
				else TMP_ALIGNSEQ[l++] = seq[i];
if (DEBUG) printf("TMP_ALIGNSEQ .%s.\n",TMP_ALIGNSEQ);
				TMP_ALIGNSEQ[l] = '\0';
			}

			free(ins);
			free(postseq);
		}


		
		
		// print in file:
		if (OUTPUT_FORMAT == 0) {
			
			/////// SHORE file ///////
			
			fprintf(OUT_FP, "%s\t%s\t%s\t%d\t%s\t%s\t%s\t%c\t%d\t%d\t%d\t%d",
				(hit->strain == 0)? REFNAME: STRAIN_DESC[hit->strain-1], 
				CHR_DESC[abs(hit->chromosome)-1],
				//readstart+1,	// 1-initialized
				refpos,
				(hit->strain == 0)? atoi(refpos): hit->strainpos,
				(hit->strain == 0)? decode_seq(seq, ALIGNSEQ): TMP_ALIGNSEQ,	//Strain aligned to Ref-Seq
				STRAINSEQ,							//Strain Seq
				READ_ID,
				hit->chromosome > 0? 'D': 'P',
				SCORES_OUT? hit->gaps * GAP_SCORE + (hit->mismatches - hit->gaps) * MM_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE: hit->mismatches,
				num, // Number of hits
				READ_LENGTH,	// length of hit on genome
				0);			
			
			if (READ_FORMAT == 2) fprintf(OUT_FP, "\t%d", READ_PE_FLAG);
			if (strlen(READ_QUALITY[0]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[0]);
			if (strlen(READ_QUALITY[1]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[1]);
			if (strlen(READ_QUALITY[2]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[2]);

			if (FLANKING != 0) {
				fstart = (readstart < FLANKING)? 0: readstart - FLANKING;
				flen   = (readstart + READ_LENGTH + FLANKING > CHR_LENGTH[hit->chromosome])? CHR_LENGTH[hit->chromosome] - fstart: readstart - fstart + READ_LENGTH + FLANKING;
				strncpy(FLANK_SEQ, CHR_SEQ[hit->chromosome] + fstart, flen);
				FLANK_SEQ[flen] = '\0';
				fprintf(OUT_FP, "\t%d\t%s", CHR_LENGTH[hit->chromosome], FLANK_SEQ);
			}
			else if (PRINT_SEQ > 0) fprintf(OUT_FP, "\t%d", CHR_LENGTH[hit->chromosome]);
			if (PRINT_SEQ == 2) fprintf(OUT_FP, "\t%s", CHR_SEQ[hit->chromosome]);
			
			fprintf(OUT_FP, "\n");
		}
		else {
			
			/////// BED file ///////
			fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
				CHR_DESC[abs(hit->chromosome)-1],
				readstart,
				readstart + 1 + READ_LENGTH + gap_offset,
				READ_ID,
				SCORES_OUT? hit->gaps * GAP_SCORE + (hit->mismatches - hit->gaps) * MM_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE: hit->mismatches,
				hit->chromosome > 0? '+': '-');
			
		}


	}
	
	free(seq);
	free(SEQUENCE);
	
	ALIGNSEQ[0] = '\0';
	STRAINSEQ[0] = '\0';
	

	return 1;
	
}


char *get_align_seq(HIT *hit, int len, char start, char end)		// extends the seq to the right with 'len' many read bases starting from global startcoordinates (startblock/offset)
{
	
	SEQUENCE[0] = '\0';
	
	start = !start;		// accounting for deletions directly following a mismatch
	if (!end) len++;	// accounting for deletions just before the mismatch base

	unsigned int nextblock = 0; unsigned int nextnextblock, l = blockoffset;
	int indel_offset;
	
	
	while (len != 0) {
		
		if (BLOCK_TABLE[startblock].indel_offset < 0) indel_offset = BLOCK_TABLE[startblock].indel_offset + 1;
		else indel_offset = 0;
		
		/*if (strlen(BLOCK_TABLE[block].seq) + indel_offset == 0) {
			block = BLOCK_TABLE[block].next_block;
			continue;
		}*/
		
		if (strlen(BLOCK_TABLE[startblock].seq) + indel_offset - blockoffset - start >= len) {

			l = strlen(SEQUENCE);
			strncpy(SEQUENCE+l, BLOCK_TABLE[startblock].seq + blockoffset + start, len);
			if (end) SEQUENCE[l+len] = '\0';
				else SEQUENCE[l+len-1] = '\0';
			
			
			l = len + blockoffset - !start;	// stores startoffset before end of loop	// -1 ????
				
			len = 0;
		}
		else {
			
			len = len - strlen(BLOCK_TABLE[startblock].seq) - indel_offset + blockoffset + start;
			l = strlen(SEQUENCE);
			strcpy(SEQUENCE+l, BLOCK_TABLE[startblock].seq + blockoffset + start);
			//strncpy(SEQUENCE[strain]+l, BLOCK_TABLE[block].seq + blockpos, strlen(BLOCK_TABLE[block].seq) + indel_offset - blockpos);
			//strncpy(SEQUENCE[strain]+l+strlen(BLOCK_TABLE[block].seq)+indel_offset-blockpos, BLOCK_TABLE[block].seq+strlen(BLOCK_TABLE[block].seq)+indel_offset, -indel_offset); //deletions inbetween
			//SEQUENCE[strain][l+strlen(BLOCK_TABLE[block].seq)-blockpos] = '\0';
			start = 0; 
			
			nextblock = BLOCK_TABLE[startblock].next_block; 
			if (nextblock == 0) { 
if (DEBUG) printf("OOOOOOO  SEQUENCE: .%s.  OOOOOOOOO\n",SEQUENCE);
				return SEQUENCE; //return '\0';	// block is last block of chromosome -> read could not have been mapped!!
			}
			
			nextnextblock = BLOCK_TABLE[nextblock].next_strain_front; 
			/*if (BLOCK_TABLE[nextnextblock].chr != BLOCK_TABLE[nextblock].chr || nextnextblock >= NUM_BLOCKS) {
				block = nextblock;			// nextblock is last block of chromosome
			}
			else {*/
			
				if (hit->strain == 0) {
					startblock = nextblock;
				}
				else {
					if (BLOCK_TABLE[nextblock].strain == 0 && BLOCK_TABLE[nextnextblock].strain != 0) {
						startblock = nextblock;
						nextblock = nextnextblock;
						while (BLOCK_TABLE[nextblock].strain != hit->strain && nextblock != 0) {
							nextblock = BLOCK_TABLE[nextblock].next_strain_front;
						}
						if (BLOCK_TABLE[nextblock].strain == hit->strain) startblock = nextblock;
					}
					else {
						
						startblock = nextblock;
					}
				} 
				
			//}
			blockoffset = 0; 
		}
		
	} // while len != 0
	
	blockoffset = l;
	// startblock is already set correctly
	
	return SEQUENCE;
}

// sorts by position, and if it's identical, then gaps have to be before mismatches 
int compare (const void *a, const void *b)
{
	EDIT_OPS *ia = (EDIT_OPS *)a;
	EDIT_OPS *ib = (EDIT_OPS *)b;
	if (ia->pos == ib->pos) return (int) (ib->mm - ia->mm);
	
	return (int) (abs(ia->pos) - abs(ib->pos));
}

int compare_int (const void *a, const void *b)
{
	int *ia = (int *)a;
	int *ib = (int *)b;
	
	return (int) (*ia-*ib);
}


void print_leftovers()
{
	if (READ_FORMAT == 0) fprintf(LEFTOVER_FP, "@%s\n%s\n+\n%s\n", READ_ID, READ, READ_QUALITY[0]);
	else if (READ_FORMAT == 1) fprintf(LEFTOVER_FP, ">%s\n%s\n", READ_ID, READ);
	else fprintf(LEFTOVER_FP, "%s\t%s\t%d\t%s\t%s\t%s\n", READ_ID, READ, READ_PE_FLAG, READ_QUALITY[0], READ_QUALITY[1], READ_QUALITY[2]);
}
					
void print_alignment_matrix(int chrstart, int readstart, int length, int offset_front, int offset_end, int strain, int chr, int K)
{
	int i,j;
	
	printf(" k=%d |\t-\t",K);
	if (chr > 0)	for (i=0; i!=length; i++) printf("%c\t",SEQ[strain][chrstart + i]);
	else for (i=0; i!=length; i++) printf("%c\t",get_compl_base(SEQ[strain][chrstart - i]));
	printf("\n----------------------------------------------------------------------------------------------");
	printf("----------------------------------------------------------------------------------------------\n");
	
	for (j=0; j!=length + 1; ++j) {
		if (j==0) printf("  -  |\t");
			else {
				if ((readstart == 0 && (j <= offset_front || (j > length-offset_end && K != 1))) || (readstart != 0 && j > length-offset_end)) printf("  X  |\t");
				else printf("  %c  |\t", READ[readstart + j - (readstart == 0) * offset_front - 1]);
			}
			
		if (j>K) for (i=0; i!=j-K; ++i) printf("\t");
		
		for (i=0; i!=2*K+1; ++i) {
			if (i-j>K) break;
			if (i+j>length+K) break;
			if (i>length || j>length) break;
			if ((readstart!=0 && j>length-offset_end) || (readstart==0 && j<offset_front)) break;
			//printf("{i%d,j%d}",i,j);
			printf("%d(%c)\t", M[i][j], T[i][j]);
			if(i==6 && j==1) printf("---");
		}
		
		printf("\n----------------------------------------------------------------------------------------------");
		printf("----------------------------------------------------------------------------------------------\n");
	}	
	
} 


void printhits()
{
	//printf("list:\n");
	//printf("print hitlist with readlength %i, read %s, last[rl-2]=%c\n",READ_LENGTH, READ, READ[READ_LENGTH-2]);
	int i;
	int c=0;
	HIT* hit;
	for (i = INDEX_DEPTH; i != READ_LENGTH+1; ++i) {

		if (*(HIT_LISTS_OPERATOR + i) != NULL) {
			printf("%i: ",i);
			hit = *(HIT_LISTS_OPERATOR + i);
			do {
				//if (hit->orientation == '-') {
				printf("[%i: %i.%i/str%i/chr%i/rp%i/%imm",
					hit->length,hit->startblock, hit->blockoffset, hit->strain, hit->chromosome, hit->readpos,hit->mismatches);
				if (hit->mismatches != 0) {
					printf(":");
					int j;
					for (j=0; j!=hit->mismatches; ++j)
						printf(" %i%c", hit->edit_op[j].pos, (hit->edit_op[j].mm)? 'M': 'G');
				}
				printf("/%s]",READ_ID); 
++c;
//}
				hit = hit->next;
if (c>4) hit = NULL;
			} while (hit != NULL);
			printf("\n");
		}
c=0;
	}
	//printf("done\n");
}

void printhit(HIT* hit)
{
	printf("[%i: %i.%i/str%i/chr%i/rp%i/%imm",
					hit->length, hit->startblock, hit->blockoffset, hit->strain, hit->chromosome, hit->readpos,hit->mismatches);
	if (hit->mismatches != 0) {
		printf(":");
		int i;
		for (i=0; i!=hit->mismatches; ++i)
			printf(" %i%c", hit->edit_op[i].pos, (hit->edit_op[i].mm)? 'M': 'G');
	}
	printf("/ID: %s]\n",READ_ID); 
}
