// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "gmindex.h"

int usage() {
	printf("\ngmindex v%ss\n", VERSION);
	printf("developed by Korbinian Schneeberger, Stephan Ossowski and Joerg Hagmann\n");
	printf("Max Planck Institute for Developmental Biology, Tübingen, Germany, 2008\n\n");
	printf("USAGE: gmindex [options]\n");
#ifdef METHYLOME
	printf("\nThis version is for indexing genomes for bisulfite treated DNA only!\n");
#endif
	printf("\n");
	printf("mandatory:\n");
	printf(" -i STRING          Input fastafile\n");
	printf("\n");
	printf("optional:\n");
#ifndef METHYLOME
	printf(" -s INT             Seed length, range 5 to 13\n");
#else
	printf(" -s INT             Seed length, range 5 to 12\n");
#endif
	printf(" -r                 Do not build reverse index\n");
	printf(" -v                 Verbose (silent)\n");

	printf("statistics:\n");
	printf(" -seedstat STRING   prints occurrences per seed\n");
	printf("\n");

	return 0;
}
