// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int get_slot(int pos);


/// Get a read from the query file.
int read_short_read()
{
	debug_printf("read_short_read()\n");

	char *tmp;
	int linelen;

	if (fgets(QUERY_LINEBUF, MAX_LINEWIDTH, QUERY_FP) == NULL) {
		if (READ_LENGTH == 0) fprintf(stderr, "\n!!! WARNING: Input read file '%s' is empty!\n\n", QUERY_FILE_NAME);
		return 1;
	}
	++linenr;

	if (strcspn(QUERY_LINEBUF, " \n\t") == 0) {
		do {
			if (fgets(QUERY_LINEBUF, MAX_LINEWIDTH, QUERY_FP) == NULL) {
				if (READ_LENGTH == 0) fprintf(stderr, "\n!!! WARNING: Input read file '%s' is empty!\n\n", QUERY_FILE_NAME);  
				return 1;
			}
			++linenr;
		} while (strcspn(QUERY_LINEBUF, " \n\t") == 0);
	}
	
	linelen = strlen(QUERY_LINEBUF);
	if (linelen < 3) {
		fprintf(stderr, "ERROR: Unknown read input format! Do all the reads have an identifier?\n");
		exit(2);
	}
	
	if (QUERY_LINEBUF[0] == '@') {
		
		/////// FastQ input ///////
		
		// R E A D _ I D
		if(astr_asscn(READ_ID, QUERY_LINEBUF+1, strcspn(QUERY_LINEBUF, " \t\n")-1)) {
			perror("ERROR: allocate memory for read ID");
			exit(1);
		}

		
		do {
			if (fgets(QUERY_LINEBUF, MAX_LINEWIDTH, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing read sequence and quality!\n", astr_beg(READ_ID), linenr, QUERY_FILE_NAME);
				exit(2);
			}
			++linenr;
		} while (strcspn(QUERY_LINEBUF, " \t\n") == 0);

		// R E A D
		if(astr_asscn(READ, QUERY_LINEBUF, strcspn(QUERY_LINEBUF, " \t\n"))) {
			perror("ERROR: allocate memory for read sequence");
			exit(1);
		}
#ifdef THREADS 
		if (astr_len(READ) > MAX_READ_LENGTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", astr_beg(READ_ID), linenr, MAX_READ_LENGTH);
			return -1;
		}
		else
#endif
                if (astr_len(READ) == 0) {
			fprintf(stderr, "ERROR: Cannot find read sequence of read '%s' in line %lu in input query file '%s'!\n", astr_beg(READ_ID), linenr, QUERY_FILE_NAME);
			exit(2);
		}
		if (strcspn(astr_beg(READ), "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}
		
		if (astr_len(READ) < INDEX_DEPTH) { 
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}
		
		do {
			if (fgets(QUERY_LINEBUF, MAX_LINEWIDTH, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing quality!\n", astr_beg(READ_ID), linenr, QUERY_FILE_NAME);
				exit(2);
			}
			++linenr;
		} while (strcspn(QUERY_LINEBUF, " \t\n") == 0);

		// +
		if (strlen(QUERY_LINEBUF) < 1 || QUERY_LINEBUF[0] != '+') {
			fprintf(stderr, "ERROR: Read '%s' in line %lu is not in fastq format!\n", astr_beg(READ_ID), linenr);
			exit(2);
		}
		
		do {
			if (fgets(QUERY_LINEBUF, MAX_LINEWIDTH, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing quality!\n", astr_beg(READ_ID), linenr, QUERY_FILE_NAME);
				exit(0);
			}
			++linenr;
		} while (strcspn(QUERY_LINEBUF, " \t\n") == 0);
		
		// Q U A L I T Y
		if (strlen(QUERY_LINEBUF) > 0) {
			if(astr_asscn(READ_QUALITY[0], QUERY_LINEBUF, strcspn(QUERY_LINEBUF, " \t\n"))) {
				perror("ERROR: allocate memory for read quality");
				exit(1);
			}
		} else {
			fprintf(stderr, "ERROR: Cannot find read quality of read '%s' in line %lu in input query file '%s'!\n", astr_beg(READ_ID), linenr, QUERY_FILE_NAME);
			exit(2);
		}
		
		READ_LENGTH = astr_len(READ);
		
		if (USR_READ_LENGTH < READ_LENGTH) {

			if(astr_resize(READ,USR_READ_LENGTH)) {
				perror("ERROR: allocate memory for read sequence");
				exit(1);
			}
			if(astr_len(READ_QUALITY[0])>USR_READ_LENGTH) {
				if(astr_resize(READ_QUALITY[0],USR_READ_LENGTH)) {
					perror("ERROR: allocate memory for read quality");
					exit(1);
				}
			}

			READ_LENGTH = USR_READ_LENGTH;
		}
		
		// O T H E R
                if(astr_resize(READ_QUALITY[1],0)) {
			perror("ERROR: allocate memory for read quality");
			exit(1);
		}
		if(astr_resize(READ_QUALITY[2],0)) {
			perror("ERROR: allocate memory for read quality");
			exit(1);
		}

		if(astr_assc(READ_PE_FLAG,"0")) {
			perror("ERROR: allocate memory for read flag");
			exit(1);
		}
		READ_FORMAT = 0;
	}
	else if (QUERY_LINEBUF[0] == '>') {
		
		/////// Fasta input ///////

		if(astr_asscn(READ_ID, QUERY_LINEBUF+1, strcspn(QUERY_LINEBUF, " \t\n")-1)) {
			perror("ERROR: allocate memory for read ID");
			exit(1);
		}

		do {
			if (fgets(QUERY_LINEBUF, 512, QUERY_FP) == NULL || QUERY_LINEBUF[0] == '>') {
				fprintf(stderr, "ERROR: cannot find read \"%s\"!\n",astr_beg(READ_ID));
				exit(1);
			}
			++linenr;
		} while (strcspn(QUERY_LINEBUF, " \t\n") == 0);

		READ_LENGTH = 0;
		unsigned int fp = ftell(QUERY_FP);
		while (QUERY_LINEBUF[0] != '>') {

			if (strcspn(QUERY_LINEBUF, "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
				fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
				return -1;
			}

                        if(astr_appcn(READ,QUERY_LINEBUF,(strlen(QUERY_LINEBUF)-1) * sizeof(char))) {
				perror("ERROR: allocate memory for read sequence");
				exit(1);
			}
			READ_LENGTH += strlen(QUERY_LINEBUF)-1;
#ifdef THREADS 
			if (READ_LENGTH > MAX_READ_LENGTH) {
				fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", astr_beg(READ_ID), linenr, MAX_READ_LENGTH);
				return -1;
			}
#endif

			do {
				fp = ftell(QUERY_FP);
				if (fgets(QUERY_LINEBUF, 512, QUERY_FP) == NULL) {
					QUERY_LINEBUF[0] = '>';
					break;
				}
				++linenr;
			} while (strcspn(QUERY_LINEBUF, " \n\t") == 0);

		}

		if (READ_LENGTH < INDEX_DEPTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}

		if (strcspn(astr_beg(READ), "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}

		if (USR_READ_LENGTH < READ_LENGTH) {
			if(astr_resize(READ,USR_READ_LENGTH)) {
				perror("ERROR: allocate memory for read sequence");
				exit(1);
			}
			READ_LENGTH = USR_READ_LENGTH;
		}


/*		strncpy(READ_ID, QUERY_LINEBUF+1, strcspn(QUERY_LINEBUF, " \t\n")-1);
		
		do {
			if (fgets(QUERY_LINEBUF, MAX_LINEWIDTH, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing read sequence!\n", astr_beg(READ_ID), linenr, QUERY_FILE_NAME);
				exit(2);
			}
			++linenr;
		} while (strcspn(QUERY_LINEBUF, " \t\n") == 0);
		
		// R E A D
		strncpy(READ, QUERY_LINEBUF, strcspn(QUERY_LINEBUF, " \t\n"));
		if (strlen(READ) > MAX_READ_LENGTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", astr_beg(READ_ID), linenr, MAX_READ_LENGTH);
			return -1;
		}
		else if (strlen(READ) == 0) {
			fprintf(stderr, "ERROR: Cannot find read sequence of read '%s' in line %lu in input query file '%s'!\n", astr_beg(READ_ID), linenr, QUERY_FILE_NAME);
			exit(2);
		}		
		if (strcspn(READ, "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}
		
		if (strlen(READ) < INDEX_DEPTH) { 
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}
		
		READ_LENGTH = strlen(READ);
*/

		if(astr_assc(READ_PE_FLAG,"0")) {
			perror("ERROR: allocate memory for read flag");
			exit(1);
		}
		if(astr_resize(READ_QUALITY[0],0)) {
			perror("ERROR: allocate memory for read quality");
			exit(1);
		}
		if(astr_resize(READ_QUALITY[1],0)) {
			perror("ERROR: allocate memory for read quality");
			exit(1);
		}
		if(astr_resize(READ_QUALITY[2],0)) {
			perror("ERROR: allocate memory for read quality");
			exit(1);
		}
		
		READ_FORMAT = 1;

		fseek(QUERY_FP, fp, SEEK_SET);

	}
	else {
		char delims[] = "\t\n";

		/////// Flatfile input ///////
		tmp = strtok(&(QUERY_LINEBUF[0]), delims);
		if(astr_assc(READ_ID,tmp)) {
			perror("ERROR: allocate memory for read ID");
			exit(1);
		}

		if (astr_len(READ_ID) == linelen) {
			fprintf(stderr, "ERROR: wrong read input data format, line %lu!\n", linenr);
			exit(2);
		}
		if (astr_len(READ_ID) == 0) {
			fprintf(stderr, "ERROR: Read ID is empty, line %lu!\n", linenr);
			exit(2);
		}
		
		tmp = strtok('\0', delims);
		if(astr_assc(READ,tmp)) {
			perror("ERROR: allocate memory for read sequence");
			exit(1);
		}

#ifdef THREADS
		if (astr_len(READ) > MAX_READ_LENGTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", astr_beg(READ_ID), linenr, MAX_READ_LENGTH);
			return -1;
		}
#endif
		if (astr_len(READ) == 0) {
			fprintf(stderr, "ERROR: Read sequence is empty, line %lu!\n", linenr);
			exit(2);
		}
		if (strcspn(astr_beg(READ), "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}
			
		READ_LENGTH = astr_len(READ);
		if (READ_LENGTH < INDEX_DEPTH) { 
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", astr_beg(READ_ID), linenr);
			return -1;
		}

		tmp = strtok('\0', delims);
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Paired-end flag is empty, line %lu!\n", linenr);
			exit(2);
		}
		if(astr_assc(READ_PE_FLAG,tmp)) {
			perror("ERROR: allocate memory for read flag");
			exit(1);
		}

		// optional Qualities:
		tmp = strtok('\0', delims);
		if (tmp != NULL) {
			if(astr_assc(READ_QUALITY[0],tmp)) {
				perror("ERROR: allocate memory for read quality");
				exit(1);
			}

			tmp = strtok('\0', delims);
			if (tmp != NULL) {
				if(astr_assc(READ_QUALITY[1],tmp)) {
					perror("ERROR: allocate memory for read quality");
					exit(1);
				}

				tmp = strtok('\0', delims);
				if (tmp != NULL) {
					if(astr_assc(READ_QUALITY[2],tmp)) {
						perror("ERROR: allocate memory for read quality");
						exit(1);
					}
				}
				else {
					if(astr_resize(READ_QUALITY[2],0)) {
						perror("ERROR: allocate memory for read quality");
						exit(1);
					}
				}
			}
			else {
				if(astr_resize(READ_QUALITY[1],0)) {
					perror("ERROR: allocate memory for read quality");
					exit(1);
				}
				if(astr_resize(READ_QUALITY[2],0)) {
					perror("ERROR: allocate memory for read quality");
					exit(1);
				}
			}
		}
		else {
			if(astr_resize(READ_QUALITY[0],0)) {
				perror("ERROR: allocate memory for read quality");
				exit(1);
			}
			if(astr_resize(READ_QUALITY[1],0)) {
				perror("ERROR: allocate memory for read quality");
				exit(1);
			}
			if(astr_resize(READ_QUALITY[2],0))
			{
				perror("ERROR: allocate memory for read quality");
				exit(1);
			}
		}

//printf(".%s.%s.%s.\n",READ_QUALITY[0], READ_QUALITY[1], READ_QUALITY[2]);

/*
		tmp = strtok('\0', "\t");
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Read Quality 1 is empty, line %lu!\n", linenr);
			exit(2);
		}
		//if (strlen(READ_QUALITY[0]) != READ_LENGTH) {
		//	fprintf(stderr, "ERROR: Read quality 1 hasn't length of read, line %lu!\n", linenr);
		//	exit(2);
		//}

		tmp = strtok('\0', "\t");
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Read Quality 2 is empty, line %lu!\n", linenr);
			exit(2);
		}
		//if (strlen(READ_QUALITY[1]) != READ_LENGTH) {
		//	fprintf(stderr, "ERROR: Read quality 2 hasn't length of read, line %lu!\n", linenr);
		//	exit(2);
		//}
		strcpy(READ_QUALITY[1],tmp);
	
		tmp = strtok('\0', "\n");
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Read Quality 3 is empty, line %lu!\n", linenr);
			exit(2);
		}	
		//if (strlen(READ_QUALITY[2]) != READ_LENGTH) {
		//	fprintf(stderr, "ERROR: Read quality 3 hasn't length of read, line %lu!\n", linenr);
		//	exit(2);
		//}
		strcpy(READ_QUALITY[2], tmp);
*/

		if (USR_READ_LENGTH < READ_LENGTH) {
			if(astr_resize(READ,USR_READ_LENGTH)) {
				perror("ERROR: allocate memory for read quality");
				exit(1);
			}
                        if(astr_len(READ_QUALITY[0])>USR_READ_LENGTH) {
				if(astr_resize(READ_QUALITY[0],USR_READ_LENGTH)) {
					perror("ERROR: allocate memory for read quality");
					exit(1);
				}
			}
                        if(astr_len(READ_QUALITY[1])>USR_READ_LENGTH) {
				if(astr_resize(READ_QUALITY[1],USR_READ_LENGTH)) {
					perror("ERROR: allocate memory for read quality");
					exit(1);
				}
			}
                        if(astr_len(READ_QUALITY[2])>USR_READ_LENGTH) {
				if(astr_resize(READ_QUALITY[2],USR_READ_LENGTH)) {
					perror("ERROR: allocate memory for read quality");
					exit(1);
				}
			}
			READ_LENGTH = USR_READ_LENGTH;
		}

		READ_FORMAT = 2;
	}

	READNR++;

	while (READNR < FROM_READ) {
		read_short_read();
	}

        if(astr_len(READ)>MAX_READ_LENGTH)
        {
            int old_len=MAX_READ_LENGTH;
            MAX_READ_LENGTH=astr_len(READ);
            if(realloc_alignment_structures()!=0)
            {
                perror("ERROR: re-allocating alignment structures");
                exit(1);
            }
            if(realloc_hit_lists_operator(old_len)!=0)
            {
                perror("ERROR: re-allocating hit list");
                exit(1);
            }
        }

	return 0;
}

unsigned int map_fast() {

	debug_printf("map_fast()\n");

	char *read = astr_beg(READ);

	unsigned int hits_reported = 0;
	int firstslot = 0;
	int num_edit_ops = NUM_EDIT_OPS;

#ifdef METHYLOME
	//char switch_complete_mapping_on = 0;

	int conversion;
	for (conversion = 1; conversion <= 2; conversion++) {
	POS *BLOCK_TABLE;
	if (conversion == 1) {
		BLOCK_TABLE = BLOCK_TABLE_CT;
	}
	else {
		BLOCK_TABLE = BLOCK_TABLE_GA;
	}

	//int seeds_not_inspected_fwd = 0;
	//int seeds_not_inspected_rev = 0;
#endif

	STORAGE_ENTRY *index_mmap;
	INDEX_ENTRY index_entry;
	index_entry.num = 0;
	index_entry.offset = 0;
	unsigned int pos, i, j, p, chars, chr, block;
	int slot, nr_mms, readpos, chrpos, readstart, chrstart;
	unsigned char position;
	int run;
	char nr_runs, rev, nr_seeds = READ_LENGTH / INDEX_DEPTH, mm, cancel, mms_better_than_gap = GAP_SCORE / MM_SCORE;

	if (NUM_GAPS != 0)
		nr_runs = (nr_seeds > mms_better_than_gap)? mms_better_than_gap: nr_seeds;
	else
		nr_runs = (nr_seeds > NUM_MISMATCHES)? NUM_MISMATCHES + 1: nr_seeds;

	//char seed_already_inspected_fwd[nr_runs+1];
	//char seed_already_inspected_rev[nr_runs+1];

	char max_mms = nr_runs - 1;
	char best_mms = max_mms;
	int mmpos[max_mms];
	
	for (run=1; run<=nr_runs; ++run) {
		
		if (nr_runs == 1) nr_runs = 0;	// a bit fishy, but nr_runs and run only have to be different, thats why this assignment is due
		if (run == nr_runs) readstart = READ_LENGTH - INDEX_DEPTH;
			else	    readstart = (run-1) * INDEX_DEPTH;

		slot = get_slot(readstart);
		if (run == 1) firstslot = slot;
		
		if (slot >= 0) {	// tests if slot has an unallowed char!

			for (rev=0; rev <= MAP_REVERSE; ++rev) {

				if (!rev) {
#ifndef METHYLOME
					index_entry.num = INDEX[slot].num;
					index_entry.offset = INDEX[slot].offset;
					index_mmap = INDEX_FWD_MMAP;
#else
					if (conversion == 1) {
						index_entry.num = INDEX_CT[slot].num;
	                                        index_entry.offset = INDEX_CT[slot].offset;
        	                                index_mmap = INDEX_FWD_CT_MMAP;
					}
					else {
						index_entry.num = INDEX_GA[slot].num;
                                                index_entry.offset = INDEX_GA[slot].offset;
	                                        index_mmap = INDEX_FWD_GA_MMAP;
					}
#endif
				}
				else  {
#ifndef METHYLOME
					index_entry.num = INDEX_REV[slot].num;
					index_entry.offset = INDEX_REV[slot].offset;
					index_mmap = INDEX_REV_MMAP;
#else
					if (conversion == 1) {
						index_entry.num = INDEX_REV_CT[slot].num;
	                                        index_entry.offset = INDEX_REV_CT[slot].offset;
	                                        index_mmap = INDEX_REV_CT_MMAP;
					}
					else {
						index_entry.num = INDEX_REV_GA[slot].num;
                                                index_entry.offset = INDEX_REV_GA[slot].offset;
                                	        index_mmap = INDEX_REV_GA_MMAP;
					}
#endif
				}


/*
				if (index_entry.num > MAX_OCC_PER_SEED) {
#ifdef METHYLOME
					if (rev) ++seeds_not_inspected_rev;
					else ++seeds_not_inspected_fwd;
//printf("cv %d run %d(%d) rev %d sni_fwd: %d sni_rev %d NUM %d\n",conversion, run, nr_runs, rev, seeds_not_inspected_fwd, seeds_not_inspected_rev, index_entry.num);
#endif
					if (rev) seed_already_inspected_rev[run] = 0;
					else seed_already_inspected_fwd[run] = 0;
					continue;
				}
				else {
					if (rev) seed_already_inspected_rev[run] = 1;
					else seed_already_inspected_fwd[run] = 1;
				}*/

					
				// for each mapping position
				for (i=0; i!=index_entry.num; ++i) {

					if (!rev) {
						block = 0; position = 0;
						memcpy(&block, &((index_mmap+(index_entry.offset-(i+1)))->id[0]), 3 * sizeof(char));
						memcpy(&position, &((index_mmap+(index_entry.offset-(i+1)))->id[3]), sizeof(unsigned char));

						pos = (unsigned int) position + BLOCK_TABLE[block].pos;
						chr = BLOCK_TABLE[block].chr;
					}
					else {
						block = 0; position = 0;
						memcpy(&block, &((index_mmap+(index_entry.offset-(index_entry.num-i)))->id[0]), 3 * sizeof(char));
						memcpy(&position, &((index_mmap+(index_entry.offset-(index_entry.num-i)))->id[3]), sizeof(unsigned char));

						pos = (unsigned int) position + BLOCK_TABLE[block].pos;
						chr = BLOCK_TABLE[block].chr;
					}

					if (!rev) {
						chrstart = pos - (run!=nr_runs) * (run-1) * INDEX_DEPTH - (run==nr_runs) * (READ_LENGTH - INDEX_DEPTH);
					}
					else {
						chrstart = pos + (run!=nr_runs) *   run   * INDEX_DEPTH + (run==nr_runs) * READ_LENGTH - 1;
					}
					
					// check if read can map on position in genome:
					if ( (!rev && chrstart < 0) || (rev && chrstart < READ_LENGTH - 1) ) {

					}
					else if ( (!rev && chrstart + READ_LENGTH > CHR_LENGTH[chr]) || ( rev && chrstart > CHR_LENGTH[chr] - 1) ) {

					}
					else {

						nr_mms = 0;
						chars = 0;
						cancel = 0;
						
						readpos = 0;
						chrpos = chrstart;
						
						// Check if there is at least one mismatch in each seed processed before,
                                                // if not, another seed must find this potential hit,
                                                // if so, not too many mismatches may be there.
                                                // For Met-Seq:
                                                // GA and TC relaxed alignments have to be allowed.
                                                // If seed did not decide on metstate, both need to be
                                                // validated.
						for (j=1; j!=run; ++j) {

							mm = 0;

							for (p=0; p!=INDEX_DEPTH; ++p) {
								read[readpos+p] = toupper(read[readpos+p]);
#ifndef METHYLOME
								if (    (rev && get_compl_base(CHR_SEQ[chr][chrpos-p]) != read[readpos+p]) 
									|| 
									(!rev && CHR_SEQ[chr][chrpos+p] != read[readpos+p]) 
									|| 
									!(unique_base(read[readpos+p])) ) {
#else
								if (    (rev && conversion == 1 && CHR_SEQ[chr][chrpos-p] != get_compl_base(read[readpos+p]) && !(CHR_SEQ[chr][chrpos-p] == 'C' && read[readpos+p] == 'A'))
									||
								        (rev && conversion == 2 && CHR_SEQ[chr][chrpos-p] != get_compl_base(read[readpos+p]) && !(CHR_SEQ[chr][chrpos-p] == 'G' && read[readpos+p] == 'T'))
									||
									(!rev && conversion == 1 && CHR_SEQ[chr][chrpos+p] != read[readpos+p] && !(CHR_SEQ[chr][chrpos+p] == 'C' && read[readpos+p] == 'T')) 
									||
									(!rev && conversion == 2 && CHR_SEQ[chr][chrpos+p] != read[readpos+p] && !(CHR_SEQ[chr][chrpos+p] == 'G' && read[readpos+p] == 'A')) 
									||
									 !(unique_base(read[readpos+p]))
								) {
#endif
									if (nr_mms < max_mms) {
										mmpos[nr_mms] = readpos + p + 1;
										nr_mms++;
									}
									else {
										cancel = 1;
										break;
									}
									mm++;
								}
								
								chars++;
								
							}

							// Magic: break because it matches!
                                                        // It has to be found by another seed hit (if this other seed hit has been inspected (be aware of seed thresholds!))

							if (!mm)// && ((rev && seed_already_inspected_rev[j]) || (!rev && seed_already_inspected_fwd[j])))
							{
								cancel = 1;
								break;
							}
						
							if (cancel) break;
							
							chrpos += INDEX_DEPTH * (rev? -1: 1);
							readpos += INDEX_DEPTH;
							
						}
		
						// 
                                                // Describe...
						chrpos  = chrpos  + (run!=nr_runs) * INDEX_DEPTH * (rev? -1: 1);
						readpos = readpos + (run!=nr_runs) * INDEX_DEPTH;

						while (!cancel && chars != READ_LENGTH - INDEX_DEPTH) {
							read[readpos] = toupper(read[readpos]);
#ifndef METHYLOME
							if ( ( rev && get_compl_base(CHR_SEQ[chr][chrpos]) != read[readpos]) || (!rev && CHR_SEQ[chr][chrpos]  != read[readpos]) || !(unique_base(read[readpos])) ) {
#else
							if ( 	(rev && conversion == 1 && CHR_SEQ[chr][chrpos] != get_compl_base(read[readpos]) && !(CHR_SEQ[chr][chrpos] == 'C' && read[readpos] == 'A'))
								||
								(rev && conversion == 2 && CHR_SEQ[chr][chrpos] != get_compl_base(read[readpos]) && !(CHR_SEQ[chr][chrpos] == 'G' && read[readpos] == 'T'))
								|| 
								(!rev && conversion == 1 && CHR_SEQ[chr][chrpos] != read[readpos] && !(CHR_SEQ[chr][chrpos] == 'C' && read[readpos] == 'T')) 
								||
								(!rev && conversion == 2 && CHR_SEQ[chr][chrpos] != read[readpos] && !(CHR_SEQ[chr][chrpos] == 'G' && read[readpos] == 'A')) 
								|| 
								!(unique_base(read[readpos])) 
							) {
#endif
								if (nr_mms == max_mms) {
									cancel = 1;
									break;
								}
								mmpos[nr_mms] = readpos + 1;
								++nr_mms;
							}
							
							readpos++;
							chrpos += rev? -1: 1;
							chars++;
							
						}

						// A valid alignment was found
                                                // report it

						if ( !cancel && nr_mms <= max_mms ) {
							// create hit
							HIT* hit = alloc_hit();
							hit->chromosome = chr;
							hit->readpos = 1;
#ifdef METHYLOME
							hit->conversion = conversion;
#endif
							
							if (!rev) {
								hit->orientation = '+';
								hit->start = chrstart + 1;
								hit->end = chrstart + READ_LENGTH;
							}
							else {
								hit->orientation = '-';
								hit->start = chrstart - READ_LENGTH + 2;
								hit->end = chrstart + 1;
							}

							mm = 0;
							// create possible mismatches
							for (j=0; j!=nr_mms; ++j) {
								hit->edit_ops[j] = EDIT_OPS_MASK_MM;
								if (hit->orientation == '+') hit->edit_ops[j] |= mmpos[j];
									else hit->edit_ops[j] |= READ_LENGTH - mmpos[j] + 1;
								hit->mismatches++;
								mm = 1;
							}

							//if (!ALL_HIT_STRATEGY && nr_mms < max_mms) max_mms = nr_mms;
							if (!ALL_HIT_STRATEGY) {
								if (nr_mms < max_mms) {
									if (!SECOND_BEST_HIT_STRATEGY) max_mms = nr_mms;
									else if (nr_mms != max_mms) {
										if (nr_mms < best_mms) {
											max_mms = best_mms;
											best_mms = nr_mms;
										}
										else if (nr_mms != best_mms) {
											max_mms = nr_mms;
										}
									}
									NUM_EDIT_OPS = nr_mms;
								}
							}

							// perfect matching read
#ifndef METHYLOME
							insert_into_scorelist(hit, 0);
#else
							insert_into_scorelist(hit, 1);
#endif
							
							hits_reported++;
							
						} // end of create hit
						
					} // end of no hit-overlap with chrom border

				} // end of for each mapping pos
				
			} // end of forward/reverse	rev
			
		} // end of slot != -1
			
	} // end of runs = different slots
	
#ifdef METHYLOME
//printf("fwd: %d rev %d conv %d \n",seeds_not_inspected_fwd,seeds_not_inspected_rev,conversion);
	/*if (seeds_not_inspected_fwd == nr_runs || seeds_not_inspected_rev == nr_runs) {
		switch_complete_mapping_on = 1;
	}*/

	} // end of different conversions

#endif

	if (!ALL_HIT_STRATEGY && !hits_reported) {	//if best hit strategy, but no mappings found -> prepare for complete mapping!
		ALL_HIT_STRATEGY = -1;
	}

//#ifndef METHYLOME
	if (SECOND_BEST_HIT_STRATEGY && SCORE_LIMIT == WORST_SCORE + 1) {	// if only best hits have been found, there can be other second best ones
//#else
//	if (switch_complete_mapping_on || (SECOND_BEST_HIT_STRATEGY && SCORE_LIMIT == WORST_SCORE + 1)) {
//#endif
		ALL_HIT_STRATEGY = -1;
		NUM_EDIT_OPS = num_edit_ops;
		dealloc_hits_by_score();
		BEST_SCORE = WORST_SCORE + 1;
	}

//printf("firstslot: %d, ALL %d, hits_reported %d\n",firstslot, ALL_HIT_STRATEGY, hits_reported);

	return firstslot;
}

#ifndef METHYLOME
int map_short_read(unsigned int num, int first_slot) {
#else
int map_short_read(unsigned int num, int first_slot, int conversion) {
#endif

	debug_printf("map_short_read(num=%d, first_slot=%d)\n", num, first_slot);

	char *read = astr_beg(READ);

	char reverse;
        unsigned int readpos = 0;
        unsigned int spacer;
        unsigned int slot;

#ifdef METHYLOME
	INDEX_ENTRY *INDEX;
	INDEX_ENTRY *INDEX_REV;
	if (conversion == 1) {
		INDEX = INDEX_CT;
		INDEX_REV = INDEX_REV_CT;
	}
	else {
		INDEX = INDEX_GA;
		INDEX_REV = INDEX_REV_GA;
	}

	spacer = 0; // Do not trust the first slot
	slot = 0;
	HAS_SLOT = 0;
#endif


#ifndef METHYLOME
	if (first_slot < 0) {	// first slot has an unallowed char!
		spacer = -first_slot; //+1
		readpos = -first_slot; //+1
		HAS_SLOT = 0;
	}
	else if (ALL_HIT_STRATEGY) {// first slot hasn't been computed yet
		spacer = 0;
		slot = 0;
		HAS_SLOT = 0;
	}
	else {	// first slot has already been computed in map_fast and doesn't contain unallowed chars 
		slot = first_slot;
		
		reverse = 0;
		if (INDEX[slot].num != 0) {
			reverse = 1;
		}

		if (MAP_REVERSE && INDEX_REV[slot].num != 0) {
			reverse = (reverse + reverse) + 2;
		}

		if (reverse > 0) {
			if (!seed2genome(num, slot, readpos + 1, reverse)) return 0;
		}
		
		readpos++;
		spacer = INDEX_DEPTH;
		SLOT = first_slot;
		HAS_SLOT = 1;
	}
#endif

        while (spacer < READ_LENGTH) {
       		read[spacer] = toupper(read[spacer]);
                if (spacer < readpos + INDEX_DEPTH - 1) {
                        if (read[spacer]=='A' || read[spacer]=='T' || read[spacer]=='C' || read[spacer]=='G') {
                                spacer++;
                        }
                        else {
                                spacer++;
                                readpos = spacer;
                                HAS_SLOT = 0;
                        }
                }
                else {
                        if (read[spacer]=='A' || read[spacer]=='T' || read[spacer]=='C' || read[spacer]=='G') {

                                slot = get_slot(readpos);

				// reverse: 0: slot doesnt match in either index or index_rev, 1: only index, 2: only index_rev, 4: both
				reverse = 0;
				if (INDEX[slot].num != 0) {
					reverse = 1;
				}
				if (MAP_REVERSE && INDEX_REV[slot].num != 0) {
					reverse = (reverse + reverse) + 2;
				}

				if (reverse > 0) {
#ifndef METHYLOME
					if (!seed2genome(num, slot, readpos + 1, reverse)) {
						return 0; 
					}
#else
					if (!seed2genome(num, slot, readpos + 1, reverse, conversion)) return 0; 
#endif
				}
								
                                spacer++;
                                readpos++;
                                HAS_SLOT = 1;

                        }
                        else {
                                spacer++;
                                readpos=spacer;
                                HAS_SLOT = 0;
                        }
                }
        }


	HAS_SLOT = 0;
		
        return 1;
}



int get_slot(int pos)
{
	char *read = astr_beg(READ);

        unsigned int slot = 0;
        unsigned int i;
        int c = 0;

        if (HAS_SLOT == 0) {

                for (i=0; i<INDEX_DEPTH; i++) {
			read[pos+i] = toupper(read[pos+i]);
                        if (read[pos+i] == 'A') {
                                c = 0;
                        }
                        else {
                                if (read[pos+i] == 'C') {
                                        c = 1;
                                }
                                else {
                                        if (read[pos+i] == 'G') {
                                                c = 2;
                                        }
                                        else {
                                                if (read[pos+i] == 'T') {
                                                        c = 3;
                                                }
                                                else {
                                                        return -pos-i-1;
                                                }
                                        }
                                }
                        }
                        slot = slot + POWER[i] * c;
                }

        }
        else {

                slot = SLOT;
                slot >>= 2;

				read[pos+INDEX_DEPTH-1] = toupper(read[pos+INDEX_DEPTH-1]);
                if (read[pos+INDEX_DEPTH-1] == 'A') {
                        slot = slot | BINARY_CODE[0];
                }
				else {
                	if (read[pos+INDEX_DEPTH-1] == 'C') {
	                        slot = slot | BINARY_CODE[1];
        	        }
					else {
						if (read[pos+INDEX_DEPTH-1] == 'G') {
							slot = slot | BINARY_CODE[2];
						}
						else {
							if (read[pos+INDEX_DEPTH-1] == 'T') {
								slot = slot | BINARY_CODE[3];
							}
							else {
								return -1;
							}
						}
					}
				}
				
        }

        SLOT = slot;

        return(slot);
}
