// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

void printhit(HIT* hit);
int compare_int (const void *a, const void *b);


char get_compl_base(char c)
{
	switch (c) {
		case 'A': return 'T';
		case 'C': return 'G';
		case 'G': return 'C';
		case 'T': return 'A';
		default : return c;
	}
	return 0;
}


/**
void print_stats ()
{
			printf("\n########### STATISTICS ###########\n");
			printf("Mapped Reads: %i of all %d reads\n", READS_MAPPED, NUM_READS);
			int i;
			for (i=0; i!=NUM_MISMATCHES+1; ++i) printf(" Reads with %d mismatches: %u\n", i, HITS_MM[i]);
			printf("  Perfect Plus-Hits: %i\n  Perfect Minus-Hits:\t%i\n  Total:\t\t%i\n", PERFECT_HITS, PERFECT_HITS_REV, PERFECT_HITS + PERFECT_HITS_REV);
			printf("   Perfect matching reads (+ or -): %i\n", PERFECT_READS);
		 
#ifdef THREADS	
			for (i=INDEX_DEPTH; i!=37; ++i) printf("    Total Hits of length %d: %u - %.4f%%\n", i, HITS_LEN[i], ((double) (100 * HITS_LEN[i]) / NUM_HITS));
			printf("\n    Total number of hits:                  %lu\n", NUM_HITS);
#endif
			printf("      Number of overhang alignments:       %lu\n", NUM_ALIGNMENTS);
			printf("      Successful overhang alignments:      %lu\n", NUM_ALIGNMENTS-GAPS_ENCOUNTERED[0]-GAPS_ENCOUNTERED[1]-GAPS_ENCOUNTERED[2]-TOO_MANY_MMS[0]-TOO_MANY_MMS[1]);
			printf("      Number of global alignments:         %lu\n", NUM_WHOLE_ALIGNMENTS);
			printf("      Successful global alignments:        %lu\n", NUM_WHOLE_ALIGNMENTS-BREAK_GLOBAL_ALIGNMENT[0]-BREAK_TB_IN_GLOBAL_ALIGNMENT);
			printf("      Breaks in global alignments(no hit): %lu\n", BREAK_GLOBAL_ALIGNMENT[0]);
			printf("      Breaks in global alignments(hit):    %lu\n", BREAK_GLOBAL_ALIGNMENT[1]);
			printf("      Breaks after global alignment:       %lu\n\n", BREAK_TB_IN_GLOBAL_ALIGNMENT);
			printf("      Hits of len 36, not aligned:         %d\n", NOT_ALIGNED[0]);
			printf("      Mappings of fast mapping:            %d\n", NOT_ALIGNED[1]);
			//printf("      hits of len 36, not aligned (with 1MM at start/beg of read): %d\n",NOT_ALIGNED[1]);
			//printf("        Number of unmapped hits at beg/end of chrom: %d and in align-step: %d\n", ENDSTART_MAPPED[0], ENDSTART_MAPPED[1]);
			printf("      Overlapping hits at beg/end of chr:  %d\n", ENDSTART_MAPPED[0]);
			
			printf("\nGaps encountered on diagonal during overhang-alignment:   %lu\n",GAPS_ENCOUNTERED[0]);
			printf("Gaps encountered due to score during overhang-alignment:  %lu\n",GAPS_ENCOUNTERED[1]);
			printf("Gaps encountered after overhang-alignment:                %lu\n",GAPS_ENCOUNTERED[2]);
			printf("Too many MMs during overhang-alignment (discarded hits):  %lu\n",TOO_MANY_MMS[0]);
			printf("Too many MMs after overhang-alignment (discarded hits):   %lu\n\n",TOO_MANY_MMS[1]);
			
			printf("cells processed in overhang: %lu\n", CELLS_OVERHANG);
			printf("cells processed in global:   %lu\n", CELLS_GLOBAL);
			printf("total cells:                 %lu\n\n", CELLS_OVERHANG+CELLS_GLOBAL);	
			
			printf("gap limit overcome: %lu\n\n",W);
			
			//printf("reads filtered out due to too much non-base chars: %i\n\n",READS_FILTERED); 
			
			unsigned int sum=0;
			FILE* f;
			f = fopen("stat","w");
			for (i=0; i!= MAX_READ_LENGTH-INDEX_DEPTH+1; ++i) {
				for (j=0; j!=MAX_READ_LENGTH - INDEX_DEPTH - i + 1; ++j) {
					if (*(*(HITS_READPOS+i)+j) != 0) {
						fprintf(f, "\t(%d)%u ", j+1, *(*(HITS_READPOS+i)+j));
						sum += *(*(HITS_READPOS+i)+j);
					}
				}
				fprintf(f, "\nLENGTH %d: %d", i+INDEX_DEPTH, sum); 
				if (i!=MAX_READ_LENGTH-INDEX_DEPTH && sum != 0 && i<36) fprintf(f, "\tfirst: %.4f%%, last: %.4f%%, other: %.4f%%\n", ((double) (100 * *(*(HITS_READPOS+i))) / sum), ((double) (100 * (*(*(HITS_READPOS+i)+(36 - INDEX_DEPTH - i))))/sum), 100 - ((double) (100 * *(*(HITS_READPOS+i))) / sum) - ((double) (100 * (*(*(HITS_READPOS+i)+(36 - INDEX_DEPTH - i))))/sum));
					else fprintf(f, "\n");
				sum = 0;
			}
			printf("done\n");
}*/


// prints out all hits which have been inserted into HITS_BY_SCORE
int print_hits()
{
	debug_printf("print_hits()\n");

	int i, printed = 0, nr, repeatmap;
	HIT *hit;

	debug_printf("print_hits(): BEST_SCORE=%u SCORE_LIMIT=%u\n", BEST_SCORE, SCORE_LIMIT);

	if (!ALL_HIT_STRATEGY) {
		if ((SCORE_LIMIT > WORST_SCORE) && (BEST_SCORE > WORST_SCORE)) return 0;
		if (!SECOND_BEST_HIT_STRATEGY) {
			BEST_SCORE = SCORE_LIMIT;
		}
	}
	else {
		BEST_SCORE = 0;
		SCORE_LIMIT = WORST_SCORE;
	}

	debug_printf("print_hits(): BEST_SCORE=%u SCORE_LIMIT=%u\n", BEST_SCORE, SCORE_LIMIT);

	//for (i = 0; i != NUM_SCORE_INTERVALS; ++SCORE_INTERVAL) {
	for (i = BEST_SCORE; i <= SCORE_LIMIT; i += SCORE_INTERVAL) {

		if (printed && !ALL_HIT_STRATEGY && !SECOND_BEST_HIT_STRATEGY) break;	// best hit strategy
		
		if (HITS_BY_SCORE[i].hitpointer != NULL) {
//if (DEBUG) printf("num %d\n",HITS_BY_SCORE[i].num);

			// only REPEATMAP numbers of alignment will be chosen randomly:
			if (REPEATMAP < 0 && HITS_BY_SCORE[i].num > -REPEATMAP) {
				srand((unsigned) time(NULL));
				
				int j, k, n;
				int hits[-REPEATMAP];
				for (j=0; j!=-REPEATMAP; ++j) {
					n = 1;
					while (n != 0) {
						n = 0;
						hits[j] = rand() % HITS_BY_SCORE[i].num;
						for (k=0; k!=j; ++k) {
							if (hits[j] == hits[k]) ++n;
						}
					}
				}
				
				qsort(hits, -REPEATMAP, sizeof(int), compare_int);
				
				hit = HITS_BY_SCORE[i].hitpointer;
				
				nr = 0;
				for (j=0; j!=HITS_BY_SCORE[i].num; ++j) {
					
					if (hits[nr] == j) {
						printed += print_alignment(hit, -REPEATMAP);
						nr++;
					}
					
					if (nr == -REPEATMAP) break;
					
					hit = hit->same_eo_succ;
				}
				
			}
			// no random selection of output alignments:
			else {
		
				repeatmap = abs(REPEATMAP);
				hit = HITS_BY_SCORE[i].hitpointer;
				
				while (hit != NULL) {
//if (DEBUG) { printf("print "); printhit(hit); }
					if (!SECOND_BEST_HIT_STRATEGY) {
						if (!ALL_HIT_STRATEGY) nr = HITS_BY_SCORE[i].num;
						else nr = HITS_IN_SCORE_LIST;
					}
					else nr = HITS_BY_SCORE[BEST_SCORE].num + (BEST_SCORE != SCORE_LIMIT) * HITS_BY_SCORE[SCORE_LIMIT].num;

					if (repeatmap == 0) {	// no max nr of hits per read was specified, print all
						printed += print_alignment(hit, nr);
					}
					else if (printed < repeatmap) {
						printed += print_alignment(hit, (nr < repeatmap)? nr: repeatmap);
					}
					else if (repeatmap == printed) {	// repeatmap many alignments already printed out -> stop printing -> next read
						return 1;
					}

					hit = hit->same_eo_succ;
				}
			}
		}	
	}
	
	if (printed != 0) return 1;	// read could have been mapped
		else return 0;		// read couldn't have been mapped
}


int print_alignment(HIT* hit, unsigned int num)
{
	debug_printf("print_alignment(hit, num=%d)\n", num);

	char *read = astr_beg(READ);

	int j, fstart, flen;
#ifdef METHYLOME
	int i;
#endif

	int hitlength = hit->end - hit->start + 1;
	unsigned int readstart;
	if (hit->orientation == '+') {
		readstart = hit->start - hit->readpos + hit->start_offset;	// start pos of read in genome	0-initialized
	}
	else {
		readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2) + hit->start_offset; 	// 0-initialized
	}
	
	// PERFECT HITS:
	if (hit->mismatches == 0) {
#ifndef METHYLOME
		// Why not always taking the chrseq?
		//if (hit->orientation == '+') strcpy(ALIGNSEQ,read);
		//else strncpy(ALIGNSEQ, CHR_SEQ[hit->chromosome]+readstart, READ_LENGTH);
		strncpy(ALIGNSEQ, CHR_SEQ[hit->chromosome]+readstart, READ_LENGTH);
		ALIGNSEQ[READ_LENGTH] = '\0';
#else
		int count_c = 0;
		if (hit->orientation == '+') {
                	for (i = 0; i < READ_LENGTH; i++) {
	                       	if (*(CHR_SEQ[hit->chromosome]+readstart+i) == read[i]) {
        	                	sprintf(ALIGNSEQ+count_c, "%c", read[i]);
                	        	count_c++;
                        	}
   	                	else {
        	                	sprintf(ALIGNSEQ+count_c, "{%c%c}", *(CHR_SEQ[hit->chromosome]+readstart+i), read[i]);
                	                count_c += 4;
                        	}
                        }
                }
                else {
                	for (i = 0; i < READ_LENGTH; i++) {
                        	if (get_compl_base(*(CHR_SEQ[hit->chromosome]+readstart+i)) == read[READ_LENGTH - i - 1]) {
                                        sprintf(ALIGNSEQ+count_c, "%c", *(CHR_SEQ[hit->chromosome]+readstart+i));
                                        count_c++;
                                }
                        	else {
                                        sprintf(ALIGNSEQ+count_c, "{%c%c}", *(CHR_SEQ[hit->chromosome]+readstart+i), get_compl_base(read[READ_LENGTH - i - 1]));
                                        count_c += 4;
                                }
                        }
                }

		ALIGNSEQ[count_c] = '\0';
#endif
 

		// print in file:
		if (OUTPUT_FORMAT == 0) {

			/////// SHORE file ///////	
			
			fprintf(OUT_FP, "%s\t%d\t%s\t%s\t%c", 
				CHR_DESC[hit->chromosome],
				readstart+1,	// 1-initialized
				ALIGNSEQ,//Alignment String
				astr_beg(READ_ID),
				((hit->orientation == '+')? 'D': 'P'));

			if (SCORES_OUT)
				fprintf(OUT_FP, "\t%d", -READ_LENGTH * M_SCORE);
			else
				fprintf(OUT_FP, "\t%d", hit->mismatches);

			fprintf(OUT_FP, "\t%d\t%d\t%d",
			//fprintf(OUT_FP, "\t%d\t%d",
				num, // Number of hits
				READ_LENGTH,
				0);
			
			if (READ_FORMAT != 1) fprintf(OUT_FP, "\t%s", astr_beg(READ_PE_FLAG));
			if (astr_len(READ_QUALITY[0]) != 0) fprintf(OUT_FP, "\t%s", astr_beg(READ_QUALITY[0]));
			if (astr_len(READ_QUALITY[1]) != 0) fprintf(OUT_FP, "\t%s", astr_beg(READ_QUALITY[1]));
			if (astr_len(READ_QUALITY[2]) != 0) fprintf(OUT_FP, "\t%s", astr_beg(READ_QUALITY[2]));
			
			if (FLANKING != 0) {
				fstart = (readstart < FLANKING)? 0: readstart - FLANKING;
				flen   = (readstart + READ_LENGTH + FLANKING > CHR_LENGTH[hit->chromosome])? CHR_LENGTH[hit->chromosome] - fstart: readstart - fstart + READ_LENGTH + FLANKING;
				//strncpy(FLANK_SEQ, CHR_SEQ[hit->chromosome] + fstart, flen);
				//FLANK_SEQ[flen] = '\0';
				if(astr_asscn(FLANK_SEQ,CHR_SEQ[hit->chromosome] + fstart, flen)) {
					perror("ERROR: allocate memory for FLANK_SEQ (2)");
                                        exit(1);
                                }
				fprintf(OUT_FP, "\t%d\t%s", CHR_LENGTH[hit->chromosome], astr_beg(FLANK_SEQ));
			}
			else if (PRINT_SEQ > 0) fprintf(OUT_FP, "\t%d", CHR_LENGTH[hit->chromosome]);
			if (PRINT_SEQ == 2) fprintf(OUT_FP, "\t%s", CHR_SEQ[hit->chromosome]);
			
			fprintf(OUT_FP, "\n");

		}
		else {
			/////// BED file ///////
			
			if (SCORES_OUT) {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH,
					astr_beg(READ_ID),
					-READ_LENGTH * M_SCORE,
					hit->orientation);
			}
			else {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH,
					astr_beg(READ_ID),
					hit->mismatches,
					hit->orientation);
			}
			
		}
		
	}	
	// HITS WITH MISMATCHES:
	else {
//if (hit->start == 10890369) { printf("print: "); printhit(hit); }
		
		int count_char = 0;
#ifdef METHYLOME
		int count_c = 0;
#endif
		char gap_offset = 0;
		char gap_in_read = 0;
		char gap_in_chr = 0;
		
		// sort mismatches in ascending order according to their abs positions and 'gap before mm'-strategy if equal
		qsort(hit->edit_ops, hit->mismatches, sizeof(edit_op_t), compare); 
		
		ALIGNSEQ[0] = '\0';
		
		for (j=0; j!=hit->mismatches; ++j) {

				if (hit->edit_ops[j] & EDIT_OPS_MASK_INS) {
					hit->edit_ops[j] &= EDIT_OPS_MASK_POS;
					gap_in_chr = 1;
				}

				if (j == 0) {
#ifndef METHYLOME
					strncpy(ALIGNSEQ, CHR_SEQ[hit->chromosome]+(readstart), (hit->edit_ops[0] & EDIT_OPS_MASK_POS) - 1);
					count_char += (hit->edit_ops[0] & EDIT_OPS_MASK_POS) - 1;
#else
					if (hit->orientation == '+') {
                        			for (i = 0; i < (hit->edit_ops[0] & EDIT_OPS_MASK_POS) - 1; i++) {
                                			if (*(CHR_SEQ[hit->chromosome]+readstart+i) == read[i]) {
                                        			sprintf(ALIGNSEQ+count_char, "%c", read[i]);
                                        			count_char++;
                                			}
                                			else {
                                       				sprintf(ALIGNSEQ+count_char, "{%c%c}", *(CHR_SEQ[hit->chromosome]+readstart+i), read[i]);
                                        			count_char += 4;
                                			}
                        			}
                			}
                			else {
                        			for (i = 0; i < (hit->edit_ops[0] & EDIT_OPS_MASK_POS)-1; i++) {
                                			if (get_compl_base(*(CHR_SEQ[hit->chromosome]+readstart+i)) == read[READ_LENGTH - i - 1]) {
                                        			sprintf(ALIGNSEQ+count_char, "%c", *(CHR_SEQ[hit->chromosome]+readstart+i));
                                        			count_char++;
                                			}
                                			else {
                                        			sprintf(ALIGNSEQ+count_char, "{%c%c}", *(CHR_SEQ[hit->chromosome]+readstart+i), get_compl_base(read[READ_LENGTH-i-1]));
                                       				count_char += 4;
                                			}
                        			}
                			}

#endif
				}
				else if ((hit->edit_ops[j] & EDIT_OPS_MASK_POS) != (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS)) {
#ifndef METHYLOME
					strncpy(ALIGNSEQ+count_char, CHR_SEQ[hit->chromosome]+(readstart + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read), (hit->edit_ops[j] & EDIT_OPS_MASK_POS) - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - 1 + gap_in_read);	// -1??? 
					count_char += (hit->edit_ops[j] & EDIT_OPS_MASK_POS) - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - 1 + gap_in_read;
#else
					count_c = 0;
					if (hit->orientation == '+') {
                                                for (i = 0; i < ((hit->edit_ops[j] & EDIT_OPS_MASK_POS) - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - 1 + gap_in_read); i++) {
							int locreadpos = i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - gap_in_read;
                                                        if (*(CHR_SEQ[hit->chromosome] + readstart + i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read) == read[locreadpos]) {
                                                                sprintf(ALIGNSEQ+count_char, "%c", read[locreadpos]);
                                                                count_char++;
                                                        }
                                                        else {
                                                                sprintf(ALIGNSEQ+count_char, "{%c%c}", *(CHR_SEQ[hit->chromosome] + readstart + i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read), read[locreadpos]);
                                                                count_char += 4;
                                                        }
                                                }
                                        }
                                        else {
                                                for (i = 0; i < ((hit->edit_ops[j] & EDIT_OPS_MASK_POS) - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - 1 + gap_in_read); i++) {
							int locreadpos = READ_LENGTH - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - i - 1 + gap_in_read;
                                                        if (*(CHR_SEQ[hit->chromosome] + readstart + i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read) == get_compl_base(read[locreadpos])) {
                                                                sprintf(ALIGNSEQ+count_char, "%c", get_compl_base(read[locreadpos]));
                                                                count_char++;
                                                        }
                                                        else {
                                                                sprintf(ALIGNSEQ+count_char, "{%c%c}", *(CHR_SEQ[hit->chromosome] + readstart + i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read), get_compl_base(read[locreadpos]));
                                                                count_char += 4;
                                                        }
                                                }
                                        }
#endif
				}	// else: edit_op[j-1] must have been a gap!
				
				gap_in_read = 0;
				
				if (hit->edit_ops[j] & EDIT_OPS_MASK_MM) {
					if (hit->orientation == '+') {
						sprintf(ALIGNSEQ+count_char, "[%c%c]", CHR_SEQ[hit->chromosome][readstart + (hit->edit_ops[j] & EDIT_OPS_MASK_POS) - 1 + gap_offset], read[(hit->edit_ops[j] & EDIT_OPS_MASK_POS) - 1]);
					}
					else {
						sprintf(ALIGNSEQ+count_char, "[%c%c]", CHR_SEQ[hit->chromosome][readstart + (hit->edit_ops[j] & EDIT_OPS_MASK_POS) - 1 + gap_offset], get_compl_base(read[READ_LENGTH - (hit->edit_ops[j] & EDIT_OPS_MASK_POS)]));
					}
				}
				else if (gap_in_chr) {
					if (hit->orientation == '+') 
						sprintf(ALIGNSEQ+count_char, "[-%c]", read[(hit->edit_ops[j] & EDIT_OPS_MASK_POS) - 1]);
					else
						sprintf(ALIGNSEQ+count_char, "[-%c]", get_compl_base(read[READ_LENGTH - (hit->edit_ops[j] & EDIT_OPS_MASK_POS)]));
						
					gap_offset--;
					gap_in_chr = 0;
				}
				else {

					sprintf(ALIGNSEQ+count_char, "[%c-]", CHR_SEQ[hit->chromosome][readstart + (hit->edit_ops[j]& EDIT_OPS_MASK_POS) - 1 + gap_offset]);
					
					gap_offset++;
					gap_in_read = 1;
				}
					
				count_char += 4;
					
		}
			
		// from last mismatch to end of read:
			
#ifndef METHYLOME
		strncpy(ALIGNSEQ+count_char, CHR_SEQ[hit->chromosome]+(readstart + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read), READ_LENGTH - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_in_read);
		count_char += READ_LENGTH - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_in_read;
                //fprintf(stderr,"DEBUG   count_char %d\n",count_char);
                ALIGNSEQ[count_char] = '\0';
#else
		count_c = 0;
		if (hit->orientation == '+') {

			for (i = 0; i < READ_LENGTH - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_in_read; i++) {
				if (*(CHR_SEQ[hit->chromosome] + readstart + i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read) == read[i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - gap_in_read]) {
					sprintf(ALIGNSEQ+count_char+count_c, "%c", read[i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - gap_in_read]);
					count_c++;
				}
				else {
					sprintf(ALIGNSEQ+count_char+count_c, "{%c%c}", *(CHR_SEQ[hit->chromosome] + readstart + i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read), read[i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - gap_in_read]);
					count_c += 4;
				}
			}
		}
		else {
			for (i = 0; i < READ_LENGTH - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_in_read; i++) {
				int locreadpos = READ_LENGTH - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) - i - 1 + gap_in_read;
				int locchrpos = readstart + i + (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_offset - gap_in_read;
				if (get_compl_base(*(CHR_SEQ[hit->chromosome] + locchrpos)) == read[locreadpos]) {
					sprintf(ALIGNSEQ+count_char+count_c, "%c", get_compl_base(read[locreadpos]));
					count_c++;
				}
				else {
					sprintf(ALIGNSEQ+count_char+count_c, "{%c%c}", *(CHR_SEQ[hit->chromosome] + locchrpos), get_compl_base(read[locreadpos]));
					count_c += 4;
				}
//printf("%d %s\n", i, ALIGNSEQ);
			}
		}

//printf("OUTPUTTING ADD STRING END\n");
		count_char += READ_LENGTH - (hit->edit_ops[j-1] & EDIT_OPS_MASK_POS) + gap_in_read + count_c;
//printf("%s\n", ALIGNSEQ);
		ALIGNSEQ[count_char] = '\0';
#endif
		
		// print in file:
		if (OUTPUT_FORMAT == 0) {
			
			/////// SHORE file ///////
			
			fprintf(OUT_FP, "%s\t%d\t%s\t%s\t%c", 
				CHR_DESC[hit->chromosome],
				readstart+1,	// 1-initialized
				ALIGNSEQ,//Alignment String
				astr_beg(READ_ID),
				((hit->orientation == '+')? 'D': 'P'));
			
			if (SCORES_OUT)
				fprintf(OUT_FP, "\t%d", 
					(hit->gaps * GAP_SCORE + (hit->mismatches - hit->gaps) * MM_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE));
			else
				fprintf(OUT_FP, "\t%d", hit->mismatches);
				
			fprintf(OUT_FP, "\t%d\t%d\t%d",
			//fprintf(OUT_FP, "\t%d\t%d",
				num, // Number of hits
				READ_LENGTH,	// length of hit on genome
				0);			
			
			if (READ_FORMAT != 1) fprintf(OUT_FP, "\t%s", astr_beg(READ_PE_FLAG));
			if (astr_len(READ_QUALITY[0]) != 0) fprintf(OUT_FP, "\t%s", astr_beg(READ_QUALITY[0]));
			if (astr_len(READ_QUALITY[1]) != 0) fprintf(OUT_FP, "\t%s", astr_beg(READ_QUALITY[1]));
			if (astr_len(READ_QUALITY[2]) != 0) fprintf(OUT_FP, "\t%s", astr_beg(READ_QUALITY[2]));
			
			if (FLANKING != 0) {
				fstart = (readstart < FLANKING)? 0: readstart - FLANKING;
				flen   = (readstart + READ_LENGTH + FLANKING > CHR_LENGTH[hit->chromosome])? CHR_LENGTH[hit->chromosome] - fstart: readstart - fstart + READ_LENGTH + FLANKING;
				//strncpy(FLANK_SEQ, CHR_SEQ[hit->chromosome] + fstart, flen);
				//FLANK_SEQ[flen] = '\0';
				if(astr_asscn(FLANK_SEQ, CHR_SEQ[hit->chromosome] + fstart, flen)) {
					perror("ERROR: allocate memory for FLANK_SEQ (1)");
					exit(1);
				}
				fprintf(OUT_FP, "\t%d\t%s", CHR_LENGTH[hit->chromosome], astr_beg(FLANK_SEQ));
			}
			else if (PRINT_SEQ > 0) fprintf(OUT_FP, "\t%d", CHR_LENGTH[hit->chromosome]);
			if (PRINT_SEQ == 2) fprintf(OUT_FP, "\t%s", CHR_SEQ[hit->chromosome]);
			
			fprintf(OUT_FP, "\n");

		}
		else {
			
			/////// BED file ///////
			
			if (SCORES_OUT) {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH + gap_offset,
					astr_beg(READ_ID),
					(hit->gaps * GAP_SCORE + (hit->mismatches - hit->gaps) * MM_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE),
					hit->orientation);
			}
			else {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH + gap_offset,
					astr_beg(READ_ID),
					hit->mismatches,
					hit->orientation);
			}
			
		}


	}

	return 1;
}


// sorts by position, if it's identical, then gaps have to be before mismatches 
// hmmm... somehow this is switched now?
int compare (const void *a, const void *b)
{
	//EDIT_OPS *ia = (EDIT_OPS *)a;
	//EDIT_OPS *ib = (EDIT_OPS *)b;
	//if (ia->pos == ib->pos) return (int) (ib->mm - ia->mm);
	//return (int) (abs(ia->pos) - abs(ib->pos));

	edit_op_t ea = (*((edit_op_t *)a));
	edit_op_t eb = (*((edit_op_t *)b));

	if(ea == eb) return 0;

	edit_op_t pa = ea & EDIT_OPS_MASK_POS;
	edit_op_t pb = eb & EDIT_OPS_MASK_POS;

	// mismatch indicator is the most significant bit
	if (pa == pb) return (ea > eb)?1:-1;

	return (int) (pa > pb)?1:-1;
}

int compare_int (const void *a, const void *b)
{
	int *ia = (int *)a;
	int *ib = (int *)b;
	
	return (int) (*ia-*ib);
}


void print_leftovers()
{
	debug_printf("print_leftovers()\n");

	char *read = astr_beg(READ);
	if (READ_FORMAT == 0) fprintf(LEFTOVER_FP, "@%s\n%s\n+\n%s\n", astr_beg(READ_ID), read, astr_beg(READ_QUALITY[0]));
	else if (READ_FORMAT == 1) fprintf(LEFTOVER_FP, ">%s\n%s\n", astr_beg(READ_ID), read);
	else {
		fprintf(LEFTOVER_FP, "%s\t%s\t%s\t%s", astr_beg(READ_ID), read, astr_beg(READ_PE_FLAG), astr_beg(READ_QUALITY[0]));
		if (strlen(astr_beg(READ_QUALITY[1])) > 0) fprintf(LEFTOVER_FP, "\t%s", astr_beg(READ_QUALITY[1]));
		if (strlen(astr_beg(READ_QUALITY[2])) > 0) fprintf(LEFTOVER_FP, "\t%s", astr_beg(READ_QUALITY[2]));
		fprintf(LEFTOVER_FP, "\n");
	}		
}
					
void print_alignment_matrix(int chrstart, int readstart, int length, int offset_front, int offset_end, int chr, char ori, int K)
{
	char *read = astr_beg(READ);
	int i,j;
	
	printf(" k=%d |\t-\t",K);
	if (ori == '+')	for (i=0; i!=length; i++) printf("%c\t",CHR_SEQ[chr][chrstart + i]);
	else for (i=0; i!=length; i++) printf("%c\t",get_compl_base(CHR_SEQ[chr][chrstart - i]));
	printf("\n----------------------------------------------------------------------------------------------");
	printf("----------------------------------------------------------------------------------------------\n");
	
	for (j=0; j!=length + 1; ++j) {
		if (j==0) printf("  -  |\t");
			else {
				if ((readstart == 0 && (j <= offset_front || (j > length-offset_end && K != 1))) || (readstart != 0 && j > length-offset_end)) printf("  X  |\t");
				else printf("  %c  |\t", read[readstart + j - (readstart == 0) * offset_front - 1]);
			}
			
		if (j>K) for (i=0; i!=j-K; ++i) printf("\t");
		
		for (i=0; i!=2*K+1; ++i) {
			if (i-j>K) break;
			if (i+j>length+K) break;
			if (i>length || j>length) break;
			if ((readstart!=0 && j>length-offset_end) || (readstart==0 && j<offset_front)) break;
			//printf("{i%d,j%d}",i,j);
			//printf("%d(%c)\t", M[i][j], T[i][j]);
			if(i==6 && j==1) printf("---");
		}
		
		printf("\n----------------------------------------------------------------------------------------------");
		printf("----------------------------------------------------------------------------------------------\n");
	}	
	
} 


void printhits()
{
	debug_printf("print_hits()\n");

	//printf("list:\n");
	//printf("print hitlist with readlength %i, read %s, last[rl-2]=%c\n",READ_LENGTH, read, read[READ_LENGTH-2]);
	int i;
	int c=0;
	HIT* hit;
	for (i = INDEX_DEPTH; i != READ_LENGTH+1; ++i) {

		if (*(HIT_LISTS_OPERATOR + i) != NULL) {
			printf("%i: ",i);
			hit = *(HIT_LISTS_OPERATOR + i);
			do {
				//if (hit->orientation == '-') {
				printf("[%i: %i-%i/%c/chr%i/rp%i/%imm",
					hit->end-hit->start+1,hit->start, hit->end, hit->orientation,hit->chromosome+1, hit->readpos,hit->mismatches);
				if (hit->mismatches != 0) {
					printf(":");
					int j;
					for (j=0; j!=hit->mismatches; ++j)
						printf(" %i%c", (hit->edit_ops[j] & EDIT_OPS_MASK_POS), (hit->edit_ops[j] & EDIT_OPS_MASK_MM)? 'M': 'G');
				}
				printf("/%s]",astr_beg(READ_ID)); 
++c;
//}
				hit = hit->next;
if (c>4) hit = NULL;
			} while (hit != NULL);
			printf("\n");
		}
c=0;
	}
	//printf("done\n");
}


void print_hits_by_score()
{
	debug_printf("print_hits_by_score()\n");

	HIT* hit;
	int i;
	for (i=0; i!=SCORE_LIMIT; i += SCORE_INTERVAL) {
		if (HITS_BY_SCORE[i].hitpointer != NULL) {
			hit = HITS_BY_SCORE[i].hitpointer;
			printf("###%d:\n",i);
			while (hit != NULL) {
				printhit(hit);
				hit = hit->same_eo_succ;
			}
		}
	}
}


void printhit(HIT* hit)
{
	debug_printf("printhit(hit)\n");

#ifndef METHYLOME
	printf("[%i: %i-%i/%c/chr%i/rp%i/%imm",
					hit->end-hit->start+1,hit->start, hit->end, hit->orientation,hit->chromosome+1, hit->readpos,hit->mismatches);
#else
	printf("[%i: %i-%i/%c/conv%i/chr%i/rp%i/%imm",
					hit->end-hit->start+1,hit->start, hit->end, hit->orientation,hit->conversion,hit->chromosome+1, hit->readpos,hit->mismatches);
#endif
	if (hit->mismatches != 0) {
		printf(":");
		int i;
		for (i=0; i!=hit->mismatches; ++i)
			printf(" %i%c", (hit->edit_ops[i] & EDIT_OPS_MASK_POS), (hit->edit_ops[i] & EDIT_OPS_MASK_MM)? 'M': 'G');
	}
	printf("/ID: %s]\n",astr_beg(READ_ID)); 
}

void printhit_err(HIT* hit)
{
	debug_printf("printhit_err(hit)\n");

#ifndef METHYLOME
	fprintf(stderr,"[%i: %i-%i/%c/chr%i/rp%i/%imm",
					hit->end-hit->start+1,hit->start, hit->end, hit->orientation,hit->chromosome+1, hit->readpos,hit->mismatches);
#else
	fprintf(stderr,"[%i: %i-%i/%c/conv%i/chr%i/rp%i/%imm",
					hit->end-hit->start+1,hit->start, hit->end, hit->orientation,hit->conversion,hit->chromosome+1, hit->readpos,hit->mismatches);
#endif
	if (hit->mismatches != 0) {
		printf(":");
		int i;
		for (i=0; i!=hit->mismatches; ++i)
			fprintf(stderr," %i%c", (hit->edit_ops[i] & EDIT_OPS_MASK_POS), (hit->edit_ops[i] & EDIT_OPS_MASK_MM)? 'M': 'G');
	}
	fprintf(stderr,"/ID: %s]\n",astr_beg(READ_ID)); 
}

int print_spliced_hits()
{
	debug_printf("print_spliced_hits()\n");

	int i, j;
	int readend, partnerreadend;
	HIT *hit;
	HIT *partner; // Howdy.

	int num_spliced_hits = 0;

        for (i = READ_LENGTH; i >= SPLICED_HIT_MIN_LENGTH_LONG; i--) {

		hit = *(HIT_LISTS_OPERATOR + i);

		while (hit != NULL) {

			readend = hit->readpos + (hit->end - hit->start + 1) - 1;

			if (hit->readpos <= 3 || readend > READ_LENGTH - 3) {

				// Search all other hits of the same length
				partner = hit->next;
				while (partner != NULL) {
					partnerreadend = partner->readpos + (partner->end - partner->start + 1) - 1;
					if (partner->readpos <= 3 || partnerreadend > READ_LENGTH - 3) {
						num_spliced_hits += comp_hits_4_splicing(hit, partner);
					}
					partner = partner->next;
				}
					// Search all hits smaller
				int min_hit = SPLICED_HIT_MIN_LENGTH_COMB - i;
				for (j = i - 1; j >= min_hit && j >= SPLICED_HIT_MIN_LENGTH_SHORT; j--) {
					partner = *(HIT_LISTS_OPERATOR + j);

					while (partner != NULL) {
						partnerreadend = partner->readpos + (partner->end - partner->start + 1) - 1;
						if (partner->readpos <= 3 || partnerreadend > READ_LENGTH - 3) {
							num_spliced_hits += comp_hits_4_splicing(hit, partner);
						}
						partner = partner->next;
					}
				}
			}
	

        	        hit = hit->next;
		}
	}

	return num_spliced_hits;	
}

int print_largest_hit() {

	debug_printf("print_largest_hit()\n");

	char *read = astr_beg(READ);
	int i;
	int readend;
	int count = 0;
	HIT *hit;

	for (i = READ_LENGTH; i >= SPLICED_LONGEST_HIT_MIN_LENGTH; i--) {

		hit = *(HIT_LISTS_OPERATOR + i);
		
		if (hit != NULL) {
	                while (hit != NULL) {

				readend = hit->readpos + (hit->end - hit->start + 1) - 1;

				fprintf(SP_OUT_FP, "%s\t%d\t", astr_beg(READ_ID), hit->chromosome+1);
				fprintf(SP_OUT_FP, "%d\t%d\tna\tna\t", hit->start, hit->end);
				fprintf(SP_OUT_FP, "%d\t%d\tna\tna\t", hit->readpos, readend);
                                fprintf(SP_OUT_FP, "%c\t", hit->orientation);
                                fprintf(SP_OUT_FP, "%.*s\tna\t", hit->end - hit->start + 1, &read[hit->readpos-1]);
                                fprintf(SP_OUT_FP, "%s\t", read);
                                fprintf(SP_OUT_FP, "%s\n", astr_beg(READ_QUALITY[0]));

				hit = hit->next;	
			}

			// break the for loop;
			i = SPLICED_LONGEST_HIT_MIN_LENGTH - 1;
		}

	}
	
	return count;
}

int comp_hits_4_splicing(HIT *hit1, HIT *hit2) {
	
	char *read = astr_beg(READ);
	int count = 0;
	int readend1, readend2;

	if (hit1->chromosome != hit2->chromosome || hit1->orientation != hit2->orientation) {
		return count;
	}
	else {
		if (hit1->readpos <= 3 && hit2->readpos <= 3) {
			return count;
		}
		else {

			readend1 = hit1->readpos + (hit1->end - hit1->start + 1) - 1;
			readend2 = hit2->readpos + (hit2->end - hit2->start + 1) - 1;
				
			if (readend1 > READ_LENGTH - 3 && readend2 > READ_LENGTH - 3) {
				return count;
			}
			else {
				// One hit is subhit of the other
				if ((hit1->readpos <= hit2->readpos && readend1 >= readend2) || (hit2->readpos <= hit1->readpos && readend2 >= readend1)) {
					return count;
				}
				else {
					int dist = SPLICED_HIT_MAX_DIST + 1;
					if (hit1->start < hit2->start) {
						dist =  (hit2->start - hit1->end + 1);
					}
					else {
						dist = (hit1->start - hit2->end + 1);
					}
					if (dist > SPLICED_HIT_MAX_DIST) {
						return count;
					}
					else {
						fprintf(SP_OUT_FP, "%s\t%d\t", astr_beg(READ_ID), hit1->chromosome+1);
						if (hit1->start < hit2->start) {
							fprintf(SP_OUT_FP, "%d\t%d\t%d\t%d\t", hit1->start, hit1->end, hit2->start, hit2->end);
							fprintf(SP_OUT_FP, "%d\t%d\t%d\t%d\t", hit1->readpos, readend1, hit2->readpos, readend2);
							fprintf(SP_OUT_FP, "%c\t", hit1->orientation);
							fprintf(SP_OUT_FP, "%.*s\t", hit1->end - hit1->start + 1, &read[hit1->readpos-1]);
							fprintf(SP_OUT_FP, "%.*s\t", hit2->end - hit2->start + 1, &read[hit2->readpos-1]);
							fprintf(SP_OUT_FP, "%s\t", read);
							fprintf(SP_OUT_FP, "%s\n", astr_beg(READ_QUALITY[0]));
						}
						else {
							fprintf(SP_OUT_FP, "%d\t%d\t%d\t%d\t", hit2->start, hit2->end, hit1->start, hit1->end);
                                                        fprintf(SP_OUT_FP, "%d\t%d\t%d\t%d\t", hit2->readpos, readend2, hit1->readpos, readend1);
                                                        fprintf(SP_OUT_FP, "%c\t", hit2->orientation);
							fprintf(SP_OUT_FP, "%.*s\t", hit2->end - hit2->start + 1, &read[hit2->readpos-1]);
							fprintf(SP_OUT_FP, "%.*s\t", hit1->end - hit1->start + 1, &read[hit1->readpos-1]);
							fprintf(SP_OUT_FP, "%s\t", read);
							fprintf(SP_OUT_FP, "%s\n", astr_beg(READ_QUALITY[0]));
						}
						count++;
					}
				}
			}
		}
	}
	
	return count;
}


