// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

#ifndef METHYLOME
int alloc_index_memory() {
	INDEX_ENTRY **index;
	INDEX_ENTRY **index_rev;
	index = &INDEX;
	index_rev = &INDEX_REV;
#else
int alloc_index_memory(int conversion) {
	INDEX_ENTRY **index;
	INDEX_ENTRY **index_rev;
	if (conversion == 1) {
		index = &INDEX_CT;
		index_rev = &INDEX_REV_CT;
	}
	else {
		index = &INDEX_GA;
		index_rev = &INDEX_REV_GA;
	}
#endif

	if ( ((*index) = (INDEX_ENTRY *) malloc (INDEX_SIZE * sizeof(INDEX_ENTRY)) ) == NULL) {
		perror("ERROR : not enough memory for mem_master (2)\n");
		exit(1);
	}

	if ( MAP_REVERSE && (((*index_rev) = (INDEX_ENTRY *) malloc (INDEX_SIZE * sizeof(INDEX_ENTRY))) == NULL) ) {
		perror("ERROR : not enough memory for mem_master (3)\n");
		exit(1);
	}

	int i;
	for (i=0; i < INDEX_SIZE; i++)
	{
		(*index)[i].num = 0;
		(*index)[i].offset = 0;
		if (MAP_REVERSE) {
			(*index_rev)[i].num = 0;
			(*index_rev)[i].offset = 0;
		}
	}

	return(0);
}

int alloc_genome_memory()
{
	if ((GENOME = (CHROMOSOME_ENTRY **) malloc (LONGEST_CHROMOSOME * sizeof(CHROMOSOME_ENTRY**))) == NULL) {
		perror("ERROR : not enough memory for genome memory\n");
		exit(1);
	}
		
	//@TODO is this really necessary? why isn't it already NULL
	int i;
	for (i=0; i!=LONGEST_CHROMOSOME; ++i) {
		*(GENOME+i) = NULL;
	}

	return(0);
}

MAPPING_ENTRY* alloc_mapping_entry()
{
	MAPPING_ENTRY_CONTAINER *container;
	MAPPING_ENTRY *entry;

	if (MAPPING_ENTRY_OPERATOR->used >= CONTAINER_SIZE - 1) {
		container = alloc_mapping_entry_container();
		MAPPING_ENTRY_OPERATOR->next = container;
		MAPPING_ENTRY_OPERATOR = container;
	}
	
	entry = &(MAPPING_ENTRY_OPERATOR->entries[MAPPING_ENTRY_OPERATOR->used]);
	MAPPING_ENTRY_OPERATOR->used++;

	entry->hit = NULL;
	entry->pred = NULL;
	entry->succ = NULL;
	entry->readpos = -1;
	
	NUM_MAPPING_ENTRIES++;
	
	return(entry);
}

MAPPING_ENTRY_CONTAINER* alloc_mapping_entry_container()
{
	MAPPING_ENTRY_CONTAINER *container;

	if ((container =  (MAPPING_ENTRY_CONTAINER *) malloc (sizeof(MAPPING_ENTRY_CONTAINER))) == NULL) {
		perror("ERROR : not enough memory for mapping entry container memory\n");
		exit(1);
	}

	container->used = 0;
	container->next = NULL;

	return(container);
}


CHROMOSOME_ENTRY* alloc_chromosome_entry(unsigned int *pos, unsigned int *chr, char *strand)
{
	if (CHROMOSOME_ENTRY_OPERATOR->used > CHROM_CONTAINER_SIZE - 1) {
		fprintf(stderr, "\n!!! WARNING: Chromosome container size of %d is too small! Hits for read %s cannot be reported any more!\n\n", CHROM_CONTAINER_SIZE, astr_beg(READ_ID));
		return(NULL);
	}
	
	CHROMOSOME_ENTRY *entry;

	entry = &(CHROMOSOME_ENTRY_OPERATOR->entries[CHROMOSOME_ENTRY_OPERATOR->used]);
	entry->chromosome = *chr;
	entry->genome_pos = *pos;
	entry->strand = *strand;
	entry->next = NULL;
	entry->mapping_entries = NULL;

	CHROMOSOME_ENTRY_OPERATOR->used++;


	return(entry);
}

CHROMOSOME_ENTRY_CONTAINER* alloc_chromosome_entry_container()
{

    if ((CHROMOSOME_ENTRY_OPERATOR = (CHROMOSOME_ENTRY_CONTAINER *) malloc (sizeof(CHROMOSOME_ENTRY_CONTAINER))) == NULL) {
    	perror("ERROR : not enough memory for chromosome entry container memory\n");
		exit(1);
	}

	if ((CHROMOSOME_ENTRY_OPERATOR->entries = (CHROMOSOME_ENTRY *) malloc (CHROM_CONTAINER_SIZE * sizeof(CHROMOSOME_ENTRY))) == NULL) {
		perror("ERROR : not enough memory for chromosome entry container memory\n");
		exit(1);
	}
	
	CHROMOSOME_ENTRY_OPERATOR->used = 0;

	return(CHROMOSOME_ENTRY_OPERATOR);
}

HIT* alloc_hit()
{
	HIT_CONTAINER *container;
	HIT *hit;

	if (HIT_OPERATOR->used >= CONTAINER_SIZE) {
                if(HIT_OPERATOR->next == NULL) {
			container = alloc_hit_container();
			HIT_OPERATOR->next = container;
			HIT_OPERATOR = container;
		}
                else HIT_OPERATOR=HIT_OPERATOR->next;
	}
	
	hit = &(HIT_OPERATOR->entries[HIT_OPERATOR->used]);
	HIT_OPERATOR->used++;

	hit->readpos = 0;
	hit->start = 0;
	hit->end = 0;
	hit->chromosome = 0;
	hit->mismatches = 0;
	hit->gaps = 0;
	hit->start_offset = 0;
	hit->end_offset = 0;
	hit->aligned = 0;

	if(hit->edit_ops == NULL) {
		if((hit->edit_ops = malloc(MAX_EDIT_OPS * sizeof(edit_op_t))) == NULL) {
			perror("ERROR: Could not allocate edit ops memory");
			exit(1);
		}
		// indicate that the next hit is unallocated
		if(HIT_OPERATOR->used < CONTAINER_SIZE) {
		    HIT_OPERATOR->entries[HIT_OPERATOR->used].edit_ops = NULL;
		}
	}

	/*int i;
	//for (i=0; i!=MAX_MISMATCHES; ++i) hit->mismatch[i] = READ_LENGTH + 1;
	for (i=0; i!=MAX_MISMATCHES; ++i) {
		hit->edit_op[i].mm = 0;
	}*/
	hit->orientation = ' ';
	hit->same_eo_succ = NULL;
	hit->next = NULL;
	hit->last = NULL;

	return(hit);
}

HIT_CONTAINER* alloc_hit_container()
{
	HIT_CONTAINER *container;

	if ((container =  (HIT_CONTAINER *) malloc (sizeof(HIT_CONTAINER))) == NULL) {
		perror("ERROR : not enough memory for mapping entry container memory\n");
		exit(1);
	}

	container->used = 0;
	container->next = NULL;
	container->entries[0].edit_ops = NULL;

	return(container);
}

int alloc_hit_lists_operator()
{
	if ((HIT_LISTS_OPERATOR = (HIT **) malloc (sizeof(HIT*) * (MAX_READ_LENGTH+1))) == NULL) {
		perror("ERROR : not enough memory for hitlist\n");
		exit(1);
	}
	int i;
	for (i = 0; i <= MAX_READ_LENGTH; i++)
		*(HIT_LISTS_OPERATOR+i) = NULL;
#ifdef THREADS
	HITS_NUM_PER_LENGTH = (unsigned long int *) malloc (MAX_READ_LENGTH * sizeof(unsigned long int));	
	for (i = 0; i < MAX_READ_LENGTH; i++)
		HITS_NUM_PER_LENGTH[i] = 0;
#endif
	return(0);
}

/// Re-initialize hit structures for a new MAX_READ_LENGTH.
int realloc_hit_lists_operator(unsigned int old_size)
{
#ifdef THREADS
        return -1;
#endif
	if ((HIT_LISTS_OPERATOR = (HIT **) realloc (HIT_LISTS_OPERATOR,sizeof(HIT*) * (MAX_READ_LENGTH+1))) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for hitlist\n");
		exit(1);
	}
	int i;
	for (i = old_size; i <= MAX_READ_LENGTH; i++)
		*(HIT_LISTS_OPERATOR+i) = NULL;
	return(0);
}

int alloc_hits_by_score()
{
	/*unsigned int max_score = NUM_GAPS * GAP_SCORE + (NUM_EDIT_OPS - NUM_GAPS) * MM_SCORE;
	NUM_SCORE_INTERVALS = (int) max_score / SCORE_INTERVAL;
	if (NUM_SCORE_INTERVALS * SCORE_INTERVAL != (int) max_score) ++NUM_SCORE_INTERVALS;
	NUM_SCORE_INTERVALS++;*/
	
	if ((HITS_BY_SCORE = (HITS_BY_SCORE_STRUCT *) malloc (sizeof(HITS_BY_SCORE_STRUCT) * (WORST_SCORE+1))) == NULL) {
		perror("ERROR : not enough memory for hitlist by score\n");
		exit(1);
	}

	int i;
	for (i=0; i<=WORST_SCORE; i += SCORE_INTERVAL) {
		HITS_BY_SCORE[i].hitpointer = NULL;
		HITS_BY_SCORE[i].num = 0;
	}

	return(0);
}

int alloc_readstart_bins()
{
	if ((READSTART_BINS = (HIT **) malloc (sizeof(HIT*) * (LONGEST_CHROMOSOME / ((NUM_GAPS==0)? 1: NUM_GAPS)))) == NULL) {
		perror("ERROR : not enough memory for readstart bin structure\n");
		exit(1);
	}

	return(0);
} 

int dealloc_mapping_entries()
{
	MAPPING_ENTRY_CONTAINER *container, *next;
	container = MAPPING_ENTRY_OPERATOR_FIRST->next;

	while (container != NULL) {
		next = container->next;
		free(container);
		container = next;
	}
	
	MAPPING_ENTRY_OPERATOR = MAPPING_ENTRY_OPERATOR_FIRST;
	MAPPING_ENTRY_OPERATOR->used = 0;
	MAPPING_ENTRY_OPERATOR->next = NULL;

	return(0);
}

/// Release memory for the HIT_CONTAINER list.
int dealloc_hits()
{
	HIT_CONTAINER *container, *next;
	size_t i;

	container = HIT_OPERATOR_FIRST->next;

	while (container != NULL) {
		next = container->next;

		// free allocated edit_ops
		i=0;
		while((i < CONTAINER_SIZE) && (container->entries[i].edit_ops != NULL)) {
			free(container->entries[i].edit_ops);
			++i;
		}

		free(container);
		container = next;
	}

	HIT_OPERATOR = HIT_OPERATOR_FIRST;
	HIT_OPERATOR->used = 0;
	HIT_OPERATOR->next = NULL;

	// free allocated edit_ops
	i=0;
	while((i < CONTAINER_SIZE) && (HIT_OPERATOR->entries[i].edit_ops != NULL)) {
		free(HIT_OPERATOR->entries[i].edit_ops);
		++i;
	}
	HIT_OPERATOR->entries[0].edit_ops = NULL;

	return(0);
}

/// Clear the HIT_CONTAINER list, but do not release memory.
void reset_hits()
{
	HIT_CONTAINER *container;

	container = HIT_OPERATOR_FIRST;

	while (container != NULL) {
		container->used=0;
		container = container->next;
	}

	HIT_OPERATOR = HIT_OPERATOR_FIRST;
}

int dealloc_chromosome_entries()
{
	unsigned int i;
	
	for (i=0; i < CHROM_CONTAINER_SIZE; i++) {
		free(CHROMOSOME_ENTRY_OPERATOR->entries[i].mapping_entries);
		free(CHROMOSOME_ENTRY_OPERATOR->entries+i);
	}
	//free(CHROMOSOME_ENTRY_OPERATOR);

	return(0);
}

int dealloc_hit_lists_operator()
{
	unsigned int i;

	for (i = INDEX_DEPTH; i <= LONGEST_HIT; i++) {
		*(HIT_LISTS_OPERATOR+i) = NULL;
	}

	return(0);
}

int dealloc_hits_by_score()
{
	debug_printf("dealloc_hits_by_score()\n");

	unsigned int i;

//	if (SCORE_LIMIT == WORST_SCORE + 1) SCORE_LIMIT--;
//if (DEBUG) printf("dealloc: from BESTSCORE %d to SCORELIMIT %d\n",BEST_SCORE,SCORE_LIMIT);

	if (!SECOND_BEST_HIT_STRATEGY && !ALL_HIT_STRATEGY) BEST_SCORE = SCORE_LIMIT;

	for (i = BEST_SCORE; i <= WORST_SCORE; i += SCORE_INTERVAL) {
		HITS_BY_SCORE[i].hitpointer = NULL;
		HITS_BY_SCORE[i].num = 0;
	}

	return(0);
}

