// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

#ifndef THREADS 
// ORIGINAL:
int browse_hits() 
{

	HIT* hit;
	int hitlength;
	int i;
	char printed = 0;

	// browse hit_list foreach hitlength:
	for (i=READ_LENGTH; i!=INDEX_DEPTH - 1; --i) {

		// if only perfect reads should be reported, break earlier:
		if (!NOT_MAXIMAL_HITS && NUM_EDIT_OPS == 0 && i < READ_LENGTH) {
			if (printed) return 1;
				else return 0;
		}
		
		// if hitlength limit is reached, break earlier:
		if (i == HITLEN_LIMIT - 1) {
			if (printed) return 1;
				else return 0;
		}
	
		if ((*(HIT_LISTS_OPERATOR + i)) != NULL) {

			hit = *(HIT_LISTS_OPERATOR + i);

			// foreach hit with hitlength i:
			while (hit != NULL) {

				hitlength = hit->end - hit->start + 1;

				// ##########################################################
				// Mismatch at first or last pos of read:
				// ##########################################################
				
				// if hit.readpos == 2, then spare alignment since if first base is mm, it's cheaper than a gap
				if (hit->readpos == 2) {
					if (NOT_MAXIMAL_HITS || hit->mismatches < NUM_MISMATCHES) {
						if (hit->orientation == '+' && hit->start != 1) {
#ifndef METHYLOME
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->start-2, 0, 1)) {
#else
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->start-2, 0, 1, hit->conversion)) {
#endif
								hit->edit_op[hit->mismatches].pos = 1;
								hit->edit_op[hit->mismatches].mm = 1;
								hit->mismatches++;
							}
							hit->start--;
							hit->readpos--;
						}
						else if (hit->orientation == '-' && hit->end != CHR_LENGTH[hit->chromosome]) {
#ifndef METHYLOME
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->end, 0, -1)) {
#else
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->end, 0, -1, hit->conversion)) {
#endif
								hit->edit_op[hit->mismatches].pos = READ_LENGTH;
								hit->edit_op[hit->mismatches].mm = 1;
								hit->mismatches++;
							}
							hit->end++;
							hit->readpos--;
						}
					}
					else {
						hit = hit->next;
						continue;
					}

					// update length:
					hitlength = hit->end - hit->start + 1;
				}
			
				// if hit ends at pos |read|-1, then spare alignment since if last base is mm, it's cheaper than a gap
				if (hit->readpos + hitlength == READ_LENGTH) {
					if (NOT_MAXIMAL_HITS || hit->mismatches < NUM_MISMATCHES) {
						if (hit->orientation == '+' && hit->end != CHR_LENGTH[hit->chromosome]) {
#ifndef METHYLOME
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->end, READ_LENGTH-1, 1)) {
#else
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->end, READ_LENGTH-1, 1, hit->conversion)) {
#endif
								hit->edit_op[hit->mismatches].pos = READ_LENGTH;
								hit->edit_op[hit->mismatches].mm = 1;
								hit->mismatches++;
							}
							hit->end++;
						}
						else if (hit->orientation == '-' && hit->start != 1) {
#ifndef METHYLOME
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->start-2, READ_LENGTH-1, -1)) {
#else
							if (!NOT_MAXIMAL_HITS || check_mm(hit->chromosome, hit->start-2, READ_LENGTH-1, -1, hit->conversion)) {
#endif
								hit->edit_op[hit->mismatches].pos = 1;
								hit->edit_op[hit->mismatches].mm = 1;
								hit->mismatches++;
							}
							hit->start--;
						}
					}
					else {
						hit = hit->next;
						continue;
					}

					// update length:
					hitlength = hit->end - hit->start + 1;
				}
				// ##########################################################

				// Hit spans the whole read:
				if (hitlength == READ_LENGTH) {

						// report match:
						if (hit->mismatches <= NUM_EDIT_OPS) {

							// insert hit into HITS_BY_SCORE
							insert_into_scorelist(hit, 1);
						
							printed = 1;
							
							//if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
						}
				}
				else {

					unsigned int readstart;
					if (hit->orientation == '+') {
						readstart = hit->start - hit->readpos;	// start pos of read in genome	
					}
					else {
						readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2);
					}

					// Alignment
					if (hit->mismatches < NUM_EDIT_OPS || NOT_MAXIMAL_HITS) {

						if (NUM_GAPS != 0) {
							// KBOUND:
							printed = prepare_kbound_alignment(hit);
						}
						else {
							// SIMPLE:
							printed = align_hit_simple(hit);
						}
					}

				} // else has mismatches

				hit = hit->next;

			} // while hitlist not empty
			
		}
	} //for each hitlength

	return printed;
}
#endif
