// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

#ifdef CUDA


// ORIGINAL:
int browse_hits() 
{
	HIT* hit;
	int hitlength;
	int i;
	char perfect = 0;
	char printed = 0;

	init_cuda();
	
	// browse hit_list foreach hitlength:
	for (i=READ_LENGTH; i!=INDEX_DEPTH - 1; --i) {

		// if only perfect reads should be reported, break earlier:
		if ((NUM_EDIT_OPS == 0) && (i < READ_LENGTH)) { 
			if (printed) return 1;
				else return 0;
		}
		
		// if hitlength limit is reached, break earlier:
		if (i == HITLEN_LIMIT - 1) {
			if (printed) return 1;
				else return 0;
		}
	
		if ((*(HIT_LISTS_OPERATOR + i)) != NULL) {

			hit = *(HIT_LISTS_OPERATOR + i);
			
			// foreach hit with hitlength i:
			while (hit != NULL) {
				
				hitlength = hit->end - hit->start + 1;

				// Hit spans the whole read:
				if (hitlength == READ_LENGTH) {

						if (STATISTICS && hit->mismatches == 0) {
						
							// reporting perfect matching reads (only one count per read)
							if (!perfect) {
								PERFECT_READS++;
								perfect = 1;
							}
							
							// reporting perfect hits
							if (hit->orientation == '+') PERFECT_HITS++;
								else PERFECT_HITS_REV++;
						}
						
						// report match:
						if (hit->mismatches <= NUM_EDIT_OPS) {

							// insert hit into HITS_BY_SCORE
							insert_into_scorelist(hit, 1);
						
							printed = 1;
							if (STATISTICS) NOT_ALIGNED[0]++;
							
							if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
						}
				}
				else {
				
				
					unsigned int readstart;
					if (hit->orientation == '+') {
						readstart = hit->start - hit->readpos;	// start pos of read in genome	0-initialized
					}
					else {
						readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2); 	// 0-initialized
					}

					// Alignment

					// for MM=1: hit must either start at readpos 1 or end at end of read, otherwise more than 1 MM:
					if (hit->mismatches < NUM_EDIT_OPS) {
						//(*(*(HITS_READPOS+(hitlength-INDEX_DEPTH))+(hit->readpos-1)))++;
						
						if (NUM_GAPS != 0) {
							// KBOUND:
							NUM_ALIGNMENTS++;
							printed = prepare_kbound_alignment(hit);
						}
						else {
							// SIMPLE:
							printed = align_hit_simple(hit);
						}
					}

				} // else has mismatches


				if (STATISTICS) HITS_LEN[hitlength]++;

				hit = hit->next;
				
			} // while hitlist not empty
			
		}
		
	} //for each hitlength
	
	return printed;
}
#endif
