// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "gmindex.h"

int write_chr_desc(unsigned int chr) 
{
	if (fwrite(&chr, sizeof(unsigned int), 1, CHR_INDEX_FP) == 0) {
                fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                exit(0);
        }
        if (fwrite(&CHR_LENGTH, sizeof(unsigned int), 1, CHR_INDEX_FP) == 0) {
                fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                exit(0);
        }
        if (fwrite(&CHR_DESC[0], sizeof(char), CHR_DESC_LENGTH, CHR_INDEX_FP) == 0) {
                fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                exit(0);
        }	

	return 0;
}

#ifndef METHYLOME
int write_meta_index(unsigned int num_chr) {
#else
int write_meta_index(unsigned int num_chr, int conversion) {
	
	FILE *META_INDEX_FP;
	FILE *MAPFWD_INDEX_FP;
	FILE *MAPREV_INDEX_FP;
		
	if (conversion == 1) {
		META_INDEX_FP = META_INDEX_CT_FP;
		MAPFWD_INDEX_FP = MAPFWD_INDEX_CT_FP;
		MAPREV_INDEX_FP = MAPREV_INDEX_CT_FP;
	}
	else {
		META_INDEX_FP = META_INDEX_GA_FP;
		MAPFWD_INDEX_FP = MAPFWD_INDEX_GA_FP;
		MAPREV_INDEX_FP = MAPREV_INDEX_GA_FP;
	}	
#endif

	BIN *bin = 0;
        BIN_EXT **bin_ext;

	unsigned int dummy = 0;
	unsigned int i, num;
	int minus_i;

	// write meta information
	if (fwrite(&BUILD_REVERSE_INDEX, sizeof(char), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n");
	}
	if (fwrite(&INDEX_DEPTH, sizeof(int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	if (fwrite(&num_chr, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	if (fwrite(&dummy, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	if (fwrite(&LONGEST_CHROMOSOME, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}

	// write block table
	if (fwrite(&BLOCK, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}	
	if (fwrite(BLOCK_TABLE, sizeof(POS), BLOCK, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}

	// write bins: 
	unsigned long int maxnr = 0;

 	for (i=0; i<INDEX_SIZE; i++) {

#ifndef METHYLOME
		if ( INDEX[i] != NULL ) {	
			bin = INDEX[i];
                        num = bin->num_pos;

#else
		if ( (conversion == 1 && INDEX_CT[i] != NULL) || (conversion == 2 && INDEX_GA[i] != NULL)) {

			if (conversion == 1) {
				bin = INDEX_CT[i];
	                        num = bin->num_pos;
			}
			else {
				bin = INDEX_GA[i];
                                num = bin->num_pos;
			}
#endif

			//Slot
			if (fwrite(&i, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
			}

			//Number
			if (fwrite(&num, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
			}
			maxnr = (num > maxnr)? num : maxnr;

			//CONTENT
                        if (num <= BIN_SIZE) {

                                if (fwrite(&bin->ids[0], sizeof(ID), num, MAPFWD_INDEX_FP) == 0) {
                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                        exit(0);
                                }

                        } else {

                                if (fwrite(&(bin->ids[0]), sizeof(ID), BIN_SIZE, MAPFWD_INDEX_FP) == 0) {
                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                        exit(0);
                                }
                                num -= BIN_SIZE;

                                bin_ext = &(bin->bin_ext);

                                while (*bin_ext != NULL) {
                                        if (num > BIN_SIZE_EXT) {

                                                if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), BIN_SIZE_EXT, MAPFWD_INDEX_FP) == 0) {
                                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                                        exit(0);
                                                }
                                                num -= BIN_SIZE_EXT;
                                                bin_ext = &((*bin_ext)->bin_ext);

                                        } else { //write out last entries and finish

                                                if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), num, MAPFWD_INDEX_FP) == 0) {
                                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                                        exit(0);
                                                }
                                                *bin_ext = NULL;

                                        }
                                }
                        }


		}


#ifndef METHYLOME
		if ( BUILD_REVERSE_INDEX && (INDEX_REV[i] != NULL) ) {
			bin = INDEX_REV[i];
                        num = bin->num_pos;
#else
		if (  BUILD_REVERSE_INDEX && ((conversion == 1 && INDEX_REV_CT[i] != NULL) || (conversion == 2 && INDEX_REV_GA[i] != NULL )) ) {

			if (conversion == 1) {
				bin = INDEX_REV_CT[i];
        	                num = bin->num_pos;
			}
			else {
				bin = INDEX_REV_GA[i];
                                num = bin->num_pos;
			}
#endif


			//Slot
			if (i == 0) minus_i = -2147483647;
			else minus_i = -i;
				

			if (fwrite(&minus_i, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
			}

			//Number
			if (fwrite(&num, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
			}
			maxnr = (num > maxnr)? num : maxnr;

			//CONTENT
                        if (num <= BIN_SIZE) {

                                if (fwrite(&bin->ids[0], sizeof(ID), num, MAPREV_INDEX_FP)  == 0) {
                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                        exit(0);
                                }


                        } else {

                                if (fwrite(&(bin->ids[0]), sizeof(ID), BIN_SIZE, MAPREV_INDEX_FP) == 0) {
                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                        exit(0);
                                }
                                num -= BIN_SIZE;

                                bin_ext = &(bin->bin_ext);

                                while (*bin_ext != NULL) {
                                        if (num > BIN_SIZE_EXT) {
                                                if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), BIN_SIZE_EXT, MAPREV_INDEX_FP) == 0) {
                                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                                        exit(0);
                                                }
                                                num -= BIN_SIZE_EXT;
                                                bin_ext = &((*bin_ext)->bin_ext);

                                        } else { //write out last entries and finish
                                                if (fwrite(&((*bin_ext)->ids[0]), sizeof(ID), num, MAPREV_INDEX_FP) == 0) {
                                                        fprintf(stderr, "ERROR: cant access harddisc for index file\n");
                                                        exit(0);
                                                }
                                                *bin_ext = NULL;

                                        }
                                }
                        }
		}

	}

	if (VERBOSE) printf("... done\n");
	
	return(0);
}

