// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"
#include <sys/time.h>

#ifdef THREADS

int init_thread_const(THREAD_CONST* thread_const);
int browse_hits_seriell();
 
int browse_hits() 
{
	int hitlength;
	int j;
	int hits_num; 
	int num_hits;

	int hits_per_thread, lastlength, lastdepth;
	THREAD_CONST* thread_const = (THREAD_CONST*) malloc (sizeof(THREAD_CONST));

	if (NUM_HITS < 600) {
		browse_hits_seriell();
	}
	else {
	hits_num = NUM_HITS;
	if (INDEX_DEPTH > HITLEN_LIMIT) {	
		hitlength = INDEX_DEPTH;
	}
	else {
		hitlength = HITLEN_LIMIT;
		
		for (j = HITLEN_LIMIT-1; j>=INDEX_DEPTH; j--) {
			hits_num -= HITS_NUM_PER_LENGTH[j];
                }
	}

//printf("hitlength: %d\n", hitlength);
	hits_per_thread = hits_num / NUM_THREADS + 1;
	lastlength = READ_LENGTH;
  	lastdepth = 0;	
	THREADS_FINISHED = 0;
	
	//distribute hits on threads
	for (j=0; j < NUM_THREADS; j++) 
	{
		thread_data[j]->num_thread = j;
		init_thread_const(thread_const);
		thread_data[j]->thread_const = thread_const;
	
		thread_data[j]->hitlength_start = lastlength;
		num_hits = HITS_NUM_PER_LENGTH[lastlength] - lastdepth;

		if (num_hits >= hits_per_thread) {
			thread_data[j]->hitlength_end = lastlength;
			thread_data[j]->hitdepth_start[lastlength] = lastdepth + 1;
			if (num_hits == hits_per_thread) {
				thread_data[j]->hitdepth_end[lastlength] = HITS_NUM_PER_LENGTH[lastlength];
				lastdepth = 0;
				lastlength--;	
			}
			else {
				thread_data[j]->hitdepth_end[lastlength] = lastdepth + hits_per_thread;
				lastdepth =  thread_data[j]->hitdepth_end[lastlength];
			}
		}
		else {
			while ((num_hits < hits_per_thread) && (lastlength > hitlength))
			{
				thread_data[j]->hitlength_end = lastlength;
				thread_data[j]->hitdepth_start[lastlength] = lastdepth + 1;
				thread_data[j]->hitdepth_end[lastlength] = HITS_NUM_PER_LENGTH[lastlength];
				lastdepth = 0;
				lastlength--;	
 				num_hits += HITS_NUM_PER_LENGTH[lastlength];
			} //while

			thread_data[j]->hitlength_end = lastlength;
			thread_data[j]->hitdepth_start[lastlength] = lastdepth + 1;
			if (num_hits > hits_per_thread) {
				thread_data[j]->hitdepth_end[lastlength] = hits_per_thread + HITS_NUM_PER_LENGTH[lastlength] - num_hits - lastdepth;
				lastdepth = thread_data[j]->hitdepth_end[lastlength];	
			}
			else {
				thread_data[j]->hitdepth_end[lastlength] = HITS_NUM_PER_LENGTH[lastlength];
				if (lastlength > hitlength)
					lastlength--;
				lastdepth = 0;
			}
		}

		THREAD_STARTED[j] = 0;
		while (pthread_mutex_trylock(&start_align_mutex[j])) usleep(1);
		pthread_cond_signal(&start_align_cond[j]);
		pthread_mutex_unlock(&start_align_mutex[j]);


	} // per thread

        for (j = 0; j < NUM_THREADS; j++) {
	        while (!THREAD_STARTED[j]) {
			usleep(50);
			if (!THREAD_STARTED[j]) {
             			while (pthread_mutex_trylock(&start_align_mutex[j])) usleep(10);
                        	pthread_cond_signal(&start_align_cond[j]);
                        	pthread_mutex_unlock(&start_align_mutex[j]);
			}
               }
        }

        while (pthread_mutex_trylock(&aligned_mutex)) usleep(100);
        if (THREADS_FINISHED < NUM_THREADS)
        	pthread_cond_wait(&aligned_cond, &aligned_mutex);
        pthread_mutex_unlock(&aligned_mutex);
	} //if NUM_HITS
	free(thread_const);
	return 1;
}

int init_thread_const(THREAD_CONST* thread_const)
{

  	thread_const->num_gaps = NUM_GAPS;
        thread_const->num_mismatches = NUM_MISMATCHES;
        thread_const->read_length = READ_LENGTH;
        thread_const->all_hit_strategy = ALL_HIT_STRATEGY;
        thread_const->overhang_alignment = OVERHANG_ALIGNMENT;
        thread_const->gaps_most_right = GAPS_MOST_RIGHT;
        thread_const->stringent_gaplimit = STRINGENT_GAPLIMIT;
        thread_const->mm_score = MM_SCORE;
        thread_const->m_score = M_SCORE;
        thread_const->gap_score = GAP_SCORE;
        thread_const->worst_score = WORST_SCORE;
        thread_const->worst_mm_score = WORST_MM_SCORE;

        return 1;
}

int browse_hits_seriell() 
{
	HIT* hit;
	int hitlength;
	int i;
	THREAD_CONST* thread_const = (THREAD_CONST*) malloc (sizeof(THREAD_CONST));

        init_thread_const(thread_const);
	
	// browse hit_list foreach hitlength:
	for (i=READ_LENGTH; i!=INDEX_DEPTH - 1; --i) {

		// if only perfect reads should be reported, break earlier:
		if ((NUM_EDIT_OPS == 0) && (i < READ_LENGTH)) { 
			return 1;
		}
		
		// if hitlength limit is reached, break earlier:
		if (i == HITLEN_LIMIT - 1) {
			return 1;
		}
	
		if ((*(HIT_LISTS_OPERATOR + i)) != NULL) {

			hit = *(HIT_LISTS_OPERATOR + i);
			
			// foreach hit with hitlength i:
			while (hit != NULL) {
				hitlength = hit->end - hit->start + 1;

				// Hit spans the whole read:
				if (hitlength == READ_LENGTH) {

						// report match:
						if (hit->mismatches <= NUM_EDIT_OPS) {

							// insert hit into HITS_BY_SCORE
							insert_into_scorelist(hit, 1);
						
							if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) {
                                                                while (pthread_mutex_trylock(&num_edit_ops_mutex))
                                                                        usleep(1);
								NUM_EDIT_OPS = hit->mismatches;
                                                                pthread_mutex_unlock(&num_edit_ops_mutex);
							}
						}
				}
				else {
				
				
					unsigned int readstart;
					if (hit->orientation == '+') {
						readstart = hit->start - hit->readpos;	// start pos of read in genome	0-initialized
					}
					else {
						readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2); 	// 0-initialized
					}

					// Alignment

					// for MM=1: hit must either start at readpos 1 or end at end of read, otherwise more than 1 MM:
					if (hit->mismatches < NUM_EDIT_OPS) {
						
						if (NUM_GAPS != 0) {
							// KBOUND:
                                                                prepare_kbound_alignment(hit, thread_const, 0);
                                                                if (hit->aligned)
                                                                        insert_into_scorelist(hit, 1);

                                                        }
                                                        else {
                                                        // SIMPLE:
                                                                align_hit_simple(hit, thread_const, 0);
                                                                if (hit->aligned)
                                                                        insert_into_scorelist(hit, 1);
                                                        }
                                                }


				} // else has mismatches


				hit = hit->next;
				
			} // while hitlist not empty
			
		}
	} //for each hitlength
	free(thread_const);
	return 0;
}
#endif
