// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int get_slot(int pos);


int read_short_read()
{
	char line[10000];
	char *tmp;
	int linelen;

	if (fgets(line, 10000, QUERY_FP) == NULL) {
		if (READ_LENGTH == 0) fprintf(stderr, "\n!!! WARNING: Input read file '%s' is empty!\n\n", QUERY_FILE_NAME);
		return 1;
	}
	++linenr;

	if (strcspn(line, " \n\t") == 0) {
		do {
			if (fgets(line, 10000, QUERY_FP) == NULL) {
				if (READ_LENGTH == 0) fprintf(stderr, "\n!!! WARNING: Input read file '%s' is empty!\n\n", QUERY_FILE_NAME);  
				return 1;
			}
			++linenr;
		} while (strcspn(line, " \n\t") == 0);
	}
	
	linelen = strlen(line);
	if (linelen < 3) {
		fprintf(stderr, "ERROR: Unknown read input format! Do all the reads have an identifier?\n");
		exit(0);
	}
	
	if (line[0] == '@') {
		
		/////// FastQ input ///////
		
		// R E A D _ I D
		strncpy(READ_ID, line+1, strcspn(line, " \t\n")-1);
		READ_ID[strcspn(line, " \t\n")-1] = '\0';
		
		do {
			if (fgets(line, 10000, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing read sequence and quality!\n", READ_ID, linenr, QUERY_FILE_NAME);
				exit(0);
			}
			++linenr;
		} while (strcspn(line, " \t\n") == 0);

		// R E A D
		strncpy(READ, line, strcspn(line, " \t\n"));
		if (strlen(READ) > MAX_READ_LENGTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", READ_ID, linenr, MAX_READ_LENGTH);
			return -1;
		}
		else if (strlen(READ) == 0) {
			fprintf(stderr, "ERROR: Cannot find read sequence of read '%s' in line %lu in input query file '%s'!\n", READ_ID, linenr, QUERY_FILE_NAME);
			exit(0);
		}
		if (strcspn(READ, "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}
		
		if (strlen(READ) < INDEX_DEPTH) { 
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}
		
		do {
			if (fgets(line, 10000, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing quality!\n", READ_ID, linenr, QUERY_FILE_NAME);
				exit(0);
			}
			++linenr;
		} while (strcspn(line, " \t\n") == 0);

		// +
		if (strlen(line) < 1 || line[0] != '+') {
			fprintf(stderr, "ERROR: Read '%s' in line %lu is not in fastq format!\n", READ_ID, linenr);
			exit(0);
		}
		
		do {
			if (fgets(line, 10000, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing quality!\n", READ_ID, linenr, QUERY_FILE_NAME);
				exit(0);
			}
			++linenr;
		} while (strcspn(line, " \t\n") == 0);
		
		// Q U A L I T Y
		if (strlen(line) > 0) strncpy(READ_QUALITY[0], line, strcspn(line, " \t\n"));
		else {
			fprintf(stderr, "ERROR: Cannot find read quality of read '%s' in line %lu in input query file '%s'!\n", READ_ID, linenr, QUERY_FILE_NAME);
			exit(0);
		}
		
		/*if (strlen(READ_QUALITY[0]) != READ_LENGTH) {
			fprintf(stderr, "ERROR: Read quality 1 of read '%s' in line %lu hasn't length of read!\n", READ_ID, linenr);
			exit(0);
		}*/

		READ_LENGTH = strlen(READ);
		
		if (USR_READ_LENGTH < READ_LENGTH) {
			READ[USR_READ_LENGTH] = '\0';
			READ_QUALITY[0][USR_READ_LENGTH] = '\0';
			READ_LENGTH = USR_READ_LENGTH;
		}
		
		// O T H E R
		int i;
		for (i=0; i!=READ_LENGTH; ++i) {
			READ_QUALITY[1][i] = READ_QUALITY[0][i]-31;
			READ_QUALITY[2][i] = 'Z';
		}
		READ_QUALITY[1][READ_LENGTH] = '\0';
		READ_QUALITY[2][READ_LENGTH] = '\0';

		READ_PE_FLAG = 0;
		READ_FORMAT = 0;
	}
	else if (line[0] == '>') {
		
		/////// Fasta input ///////

		strncpy(READ_ID, line+1, strcspn(line, " \t\n")-1);
		READ_ID[strcspn(line, " \t\n")-1] = '\0';

		do {
			if (fgets(line, 512, QUERY_FP) == NULL || line[0] == '>') {
				fprintf(stderr, "ERROR: cannot find read \"%s\"!\n",READ_ID);
				exit(1);
			}
			++linenr;
		} while (strcspn(line, " \t\n") == 0);

		READ_LENGTH = 0;
		unsigned int fp = ftell(QUERY_FP);
		while (line[0] != '>') {

			if (strcspn(line, "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
				fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", READ_ID, linenr);
				return -1;
			}

			memcpy(READ+READ_LENGTH, line, (strlen(line)-1) * sizeof(char));
			READ_LENGTH += strlen(line)-1;
			if (READ_LENGTH > MAX_READ_LENGTH) {
				fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", READ_ID, linenr, MAX_READ_LENGTH);
				return -1;
			}

			do {
				fp = ftell(QUERY_FP);
				if (fgets(line, 512, QUERY_FP) == NULL) {
					line[0] = '>';
					break;
				}
				++linenr;
			} while (strcspn(line, " \n\t") == 0);

		}

		if (READ_LENGTH < INDEX_DEPTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}

		READ[READ_LENGTH] = '\0';

		if (strcspn(READ, "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}

		if (USR_READ_LENGTH < READ_LENGTH) {
			READ[USR_READ_LENGTH] = '\0';
			READ_LENGTH = USR_READ_LENGTH;
		}


/*		strncpy(READ_ID, line+1, strcspn(line, " \t\n")-1);
		
		do {
			if (fgets(line, 10000, QUERY_FP) == NULL) {
				fprintf(stderr, "ERROR: Read '%s' in line %lu is not complete in input query file '%s'! Missing read sequence!\n", READ_ID, linenr, QUERY_FILE_NAME);
				exit(0);
			}
			++linenr;
		} while (strcspn(line, " \t\n") == 0);
		
		// R E A D
		strncpy(READ, line, strcspn(line, " \t\n"));
		if (strlen(READ) > MAX_READ_LENGTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", READ_ID, linenr, MAX_READ_LENGTH);
			return -1;
		}
		else if (strlen(READ) == 0) {
			fprintf(stderr, "ERROR: Cannot find read sequence of read '%s' in line %lu in input query file '%s'!\n", READ_ID, linenr, QUERY_FILE_NAME);
			exit(0);
		}		
		if (strcspn(READ, "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}
		
		if (strlen(READ) < INDEX_DEPTH) { 
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}
		
		READ_LENGTH = strlen(READ);
*/

		READ_PE_FLAG = 0;
		READ_QUALITY[0] = "";
		READ_QUALITY[1] = "";
		READ_QUALITY[2] = "";
		
		READ_FORMAT = 1;

		fseek(QUERY_FP, fp, SEEK_SET);

	}
	else {
		
		/////// Flatfile input ///////
		tmp = strtok(&(line[0]), "\t");
		strcpy(READ_ID, tmp);

		if (strlen(READ_ID) == linelen) {
			fprintf(stderr, "ERROR: wrong read input data format, line %lu!\n", linenr);
			exit(0);
		}
		if (READ_ID == NULL) {
			fprintf(stderr, "ERROR: Read ID is empty, line %lu!\n", linenr);
			exit(0);
		}
		
		//@TODO read is cut to MAX_READ_LENGTH (=1000) without notice! how to determine???
		tmp = strtok('\0', "\t");
		strcpy(READ, tmp);

		if (strlen(READ) > MAX_READ_LENGTH) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is longer than the max read length (=%d)! It will be omitted!\n\n", READ_ID, linenr, MAX_READ_LENGTH);
			return -1;
		}
		if (READ == NULL) {
			fprintf(stderr, "ERROR: Read sequence is empty, line %lu!\n", linenr);
			exit(0);
		}   
		//printf("%s sp: %d\n",READ,(int) strcspn(READ, "A"));
		if (strcspn(READ, "aAcCgGtTnNrRyYmMkKwWsSbBdDhHvV") != 0) {
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu contains non-IUPAC characters! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}
			
		READ_LENGTH = strlen(READ);
		if (READ_LENGTH < INDEX_DEPTH) { 
			fprintf(stderr, "\n!!! WARNING: Read '%s' in line %lu is shorter than the specified seedlength! It will be omitted!\n\n", READ_ID, linenr);
			return -1;
		}

		tmp = strtok('\0', "\t");
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Paired-end flag is empty, line %lu!\n", linenr);
			exit(0);
		}	
		READ_PE_FLAG = atoi(tmp);
		
		tmp = strtok('\0', "\t");
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Read Quality 1 is empty, line %lu!\n", linenr);
			exit(0);
		}
		/*if (strlen(READ_QUALITY[0]) != READ_LENGTH) {
			fprintf(stderr, "ERROR: Read quality 1 hasn't length of read, line %lu!\n", linenr);
			exit(0);
		}*/
		strcpy(READ_QUALITY[0], tmp);
		
		tmp = strtok('\0', "\t");
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Read Quality 2 is empty, line %lu!\n", linenr);
			exit(0);
		}
		/*if (strlen(READ_QUALITY[1]) != READ_LENGTH) {
			fprintf(stderr, "ERROR: Read quality 2 hasn't length of read, line %lu!\n", linenr);
			exit(0);
		}*/
		strcpy(READ_QUALITY[1],tmp);
	
		tmp = strtok('\0', "\n");
		if (tmp == NULL) {
			fprintf(stderr, "ERROR: Read Quality 3 is empty, line %lu!\n", linenr);
			exit(0);
		}	
		/*if (strlen(READ_QUALITY[2]) != READ_LENGTH) {
			fprintf(stderr, "ERROR: Read quality 3 hasn't length of read, line %lu!\n", linenr);
			exit(0);
		}*/
		strcpy(READ_QUALITY[2], tmp);

		if (USR_READ_LENGTH < READ_LENGTH) {
			READ[USR_READ_LENGTH] = '\0';
			READ_QUALITY[0][USR_READ_LENGTH] = '\0';
			READ_QUALITY[1][USR_READ_LENGTH] = '\0';
			READ_QUALITY[2][USR_READ_LENGTH] = '\0';
			READ_LENGTH = USR_READ_LENGTH;
		}

		READ_FORMAT = 2;
	}

	return 0;
}

unsigned int map_fast() {


	unsigned int hits_reported = 0;
	int firstslot = 0;
	int num_edit_ops = NUM_EDIT_OPS;

#ifdef METHYLOME
	int conversion;
	for (conversion = 1; conversion <= 2; conversion++) {

	POS *BLOCK_TABLE;
	if (conversion == 1) {
		BLOCK_TABLE = BLOCK_TABLE_CT;	
	}
	else {
		BLOCK_TABLE = BLOCK_TABLE_GA;
	}
#endif

	STORAGE_ENTRY *index_mmap;
	INDEX_ENTRY index_entry;
		index_entry.num = 0;
		index_entry.offset = 0;
	unsigned int pos, i, j, p, chars, chr, block;
	int slot, nr_mms, readpos, chrpos, readstart, chrstart;
	unsigned char position;
	char run, nr_runs, rev, nr_seeds = READ_LENGTH / INDEX_DEPTH, mm, cancel, mms_better_than_gap = GAP_SCORE / MM_SCORE;

	if (NUM_GAPS != 0)
		nr_runs = (nr_seeds > mms_better_than_gap)? mms_better_than_gap: nr_seeds;
	else
		nr_runs = (nr_seeds > NUM_MISMATCHES)? NUM_MISMATCHES + 1: nr_seeds;
	
	char max_mms = nr_runs - 1;
	char best_mms = max_mms;
	int mmpos[max_mms];
	
	for (run=1; run<=nr_runs; ++run) {
		
		if (nr_runs == 1) nr_runs = 0;	// a bit fishy, but nr_runs and run only have to be different, thats why this assignment is due
		if (run == nr_runs) readstart = READ_LENGTH - INDEX_DEPTH;
			else	    readstart = (run-1) * INDEX_DEPTH;

		slot = get_slot(readstart);
		if (run == 1) firstslot = slot;
		
		if (slot >= 0) {	// tests if slot has an unallowed char!

			for (rev=0; rev <= MAP_REVERSE; ++rev) {
				if (!rev) {
#ifndef METHYLOME
					index_entry.num = INDEX[slot].num;
					index_entry.offset = INDEX[slot].offset;
					index_mmap = INDEX_FWD_MMAP;
#else
					if (conversion == 1) {
						index_entry.num = INDEX_CT[slot].num;
	                                        index_entry.offset = INDEX_CT[slot].offset;
        	                                index_mmap = INDEX_FWD_CT_MMAP;
					}
					else {
						index_entry.num = INDEX_GA[slot].num;
                                                index_entry.offset = INDEX_GA[slot].offset;
	                                        index_mmap = INDEX_FWD_GA_MMAP;
					}
#endif
				}
				else  {
#ifndef METHYLOME
					index_entry.num = INDEX_REV[slot].num;
					index_entry.offset = INDEX_REV[slot].offset;
					index_mmap = INDEX_REV_MMAP;
#else
					if (conversion == 1) {
						index_entry.num = INDEX_REV_CT[slot].num;
	                                        index_entry.offset = INDEX_REV_CT[slot].offset;
	                                        index_mmap = INDEX_REV_CT_MMAP;
					}
					else {
						index_entry.num = INDEX_REV_GA[slot].num;
                                                index_entry.offset = INDEX_REV_GA[slot].offset;
                                	        index_mmap = INDEX_REV_GA_MMAP;
					}
#endif
				}
					
				// for each mapping position
				for (i=0; i!=index_entry.num; ++i) {
					
					if (!rev) {
						block = 0; position = 0;
						memcpy(&block, &((index_mmap+(index_entry.offset-(i+1)))->id[0]), 3 * sizeof(char));
						memcpy(&position, &((index_mmap+(index_entry.offset-(i+1)))->id[3]), sizeof(unsigned char));

						pos = (unsigned int) position + BLOCK_TABLE[block].pos;	
						chr = BLOCK_TABLE[block].chr;
					}
					else {
						block = 0; position = 0;
						memcpy(&block, &((index_mmap+(index_entry.offset-(index_entry.num-i)))->id[0]), 3 * sizeof(char));
						memcpy(&position, &((index_mmap+(index_entry.offset-(index_entry.num-i)))->id[3]), sizeof(unsigned char));

						pos = (unsigned int) position + BLOCK_TABLE[block].pos;	
						chr = BLOCK_TABLE[block].chr;
					}
											
					if (!rev) {
						chrstart = pos - (run!=nr_runs) * (run-1) * INDEX_DEPTH - (run==nr_runs) * (READ_LENGTH - INDEX_DEPTH);
					}
					else {
						chrstart = pos + (run!=nr_runs) *   run   * INDEX_DEPTH + (run==nr_runs) * READ_LENGTH - 1; 
					}
					
					
					// check if read can map on position in genome:
					if ( (!rev && chrstart < 0) || (rev && chrstart < READ_LENGTH - 1) ) {

					}
					else if ( (!rev && chrstart + READ_LENGTH > CHR_LENGTH[chr]) || ( rev && chrstart > CHR_LENGTH[chr] - 1) ) {

					}
					else {
						
						nr_mms = 0;
						chars = 0;
						cancel = 0;
						
						readpos = 0;
						chrpos = chrstart;
						
						// Check if there is mismatch before the seed,
                                                // if not another seed must find this potential hit,
                                                // if so not too many mismatches may be there.
                                                // For Met-Seq:
                                                // GA and TC relaxed alignments have to be allowed.
                                                // If seed did not decide on metstate, both need to be
                                                // validated.
						for (j=1; j!=run; ++j) {
							
							mm = 0;
							
							for (p=0; p!=INDEX_DEPTH; ++p) {
								READ[readpos+p] = toupper(READ[readpos+p]);
#ifndef MEYTHLOME
								if (    (rev && get_compl_base(CHR_SEQ[chr][chrpos-p]) != READ[readpos+p]) 
									|| 
									(!rev && CHR_SEQ[chr][chrpos+p] != READ[readpos+p]) 
									|| 
									!(unique_base(READ[readpos+p])) ) {
#else
								if (    (rev && conversion == 1 && CHR_SEQ[chr][chrpos-p] != get_compl_base(READ[readpos+p]) && !(CHR_SEQ[chr][chrpos-p] == 'C' && get_compl_base(READ[readpos+p]) == 'T'))
									||
								        (rev && conversion == 2 && CHR_SEQ[chr][chrpos-p] != get_compl_base(READ[readpos+p]) && !(CHR_SEQ[chr][chrpos-p] == 'G' && get_compl_base(READ[readpos+p]) == 'A'))
									||
									(!rev && conversion == 1 && CHR_SEQ[chr][chrpos+p] != READ[readpos+p] && !(CHR_SEQ[chr][chrpos+p] == 'C' && READ[readpos+p] == 'T')) 
									||
									(!rev && conversion == 2 && CHR_SEQ[chr][chrpos+p] != READ[readpos+p] && !(CHR_SEQ[chr][chrpos+p] == 'G' && READ[readpos+p] == 'A')) 
									||
									 !(unique_base(READ[readpos+p])) 
								) {
#endif
									if (nr_mms < max_mms) {
										mmpos[nr_mms] = readpos + p + 1;
										nr_mms++;
									}
									else {
										cancel = 1;
										break;
									}
									mm++;
									
								}
								
								chars++;
								
							}
								
							// Magic: break because it matches!
                                                        // It has to be found by another seed hit.
							if (!mm) {
								cancel = 1;
								break;
							}
						
							if (cancel) break;
							
							chrpos += INDEX_DEPTH * (rev? -1: 1);
							readpos += INDEX_DEPTH;
							
						}
		
						// 
                                                // Describe...
						chrpos  = chrpos  + (run!=nr_runs) * INDEX_DEPTH * (rev? -1: 1);
						readpos = readpos + (run!=nr_runs) * INDEX_DEPTH;
						while (!cancel && chars != READ_LENGTH - INDEX_DEPTH) {
							READ[readpos] = toupper(READ[readpos]);
#ifndef METHYLOME
							if ( ( rev && get_compl_base(CHR_SEQ[chr][chrpos]) != READ[readpos]) || (!rev && CHR_SEQ[chr][chrpos]  != READ[readpos]) || !(unique_base(READ[readpos])) ) {
#else
							if ( 	(rev && conversion == 1 && CHR_SEQ[chr][chrpos] != get_compl_base(READ[readpos]) && !(CHR_SEQ[chr][chrpos] == 'C' && get_compl_base(READ[readpos]) == 'T'))
								||
								(rev && conversion == 2 && CHR_SEQ[chr][chrpos] != get_compl_base(READ[readpos]) && !(CHR_SEQ[chr][chrpos] == 'G' && get_compl_base(READ[readpos]) == 'A'))
								|| 
								(!rev && conversion == 1 && CHR_SEQ[chr][chrpos] != READ[readpos] && !(CHR_SEQ[chr][chrpos] == 'C' && READ[readpos] == 'T')) 
								||
								(!rev && conversion == 2 && CHR_SEQ[chr][chrpos] != READ[readpos] && !(CHR_SEQ[chr][chrpos] == 'G' && READ[readpos] == 'A')) 
								|| 
								!(unique_base(READ[readpos])) 
							) {
#endif
								if (nr_mms == max_mms) {
									cancel = 1;
									break;
								}
								mmpos[nr_mms] = readpos + 1;
								++nr_mms;
								
							}
							
							readpos++;
							chrpos += rev? -1: 1;
							chars++;
							
						}
							
						// A valid alignment was found
                                                // report it

						if ( !cancel && nr_mms <= max_mms ) {
							// create hit
							HIT* hit = alloc_hit();
							hit->chromosome = chr;
							hit->readpos = 1;
#ifdef METHYLOME
							hit->conversion = conversion;
#endif
							
							if (!rev) {
								hit->orientation = '+';
								hit->start = chrstart + 1;
								hit->end = chrstart + READ_LENGTH;
							}
							else {
								hit->orientation = '-';
								hit->start = chrstart - READ_LENGTH + 2;
								hit->end = chrstart + 1;
							}
							
							mm = 0;
							// create possible mismatches
							for (j=0; j!=nr_mms; ++j) {
								hit->edit_op[j].mm = 1;
								if (hit->orientation == '+') hit->edit_op[j].pos = mmpos[j];
									else hit->edit_op[j].pos = READ_LENGTH - mmpos[j] + 1;
								hit->mismatches++;
								mm = 1;
							}
							
							//if (!ALL_HIT_STRATEGY && nr_mms < max_mms) max_mms = nr_mms;

							if (!ALL_HIT_STRATEGY) {
								if (nr_mms < max_mms) {
									if (!SECOND_BEST_HIT_STRATEGY) max_mms = nr_mms;
									else if (nr_mms != max_mms) {
										if (nr_mms < best_mms) {
											max_mms = best_mms;
											best_mms = nr_mms;
										}
										else if (nr_mms != best_mms) {
											max_mms = nr_mms;
										}
									}
									NUM_EDIT_OPS = nr_mms;
								}
							}
							
							// perfect matching read
#ifndef METHYLOME
							insert_into_scorelist(hit, 0);
#else
							insert_into_scorelist(hit, 1);
#endif
							
							hits_reported++;
							
						} // end of create hit
						
					} // end of no hit-overlap with chrom border

				} // end of for each mapping pos
				
			} // end of forward/reverse	rev
			
		} // end of slot != -1
			
	} // end of runs = different slots
	
#ifdef METHYLOME
	}	
#endif 

	if (!ALL_HIT_STRATEGY && !hits_reported) {	//if best hit strategy, but no mappings found -> prepare for complete mapping!
		ALL_HIT_STRATEGY = -1;
	}

	if (SECOND_BEST_HIT_STRATEGY && SCORE_LIMIT == WORST_SCORE + 1) {	// if only best hits have been found, there can be other second best ones
		ALL_HIT_STRATEGY = -1;
		NUM_EDIT_OPS = num_edit_ops;
		dealloc_hits_by_score();
		BEST_SCORE = WORST_SCORE + 1;
	}

	return firstslot;
}

#ifndef METHYLOME
int map_short_read(unsigned int num, int first_slot) {
#else
int map_short_read(unsigned int num, int first_slot, int conversion) {
#endif

	char reverse;
        unsigned int readpos = 0;
        unsigned int spacer;
        unsigned int slot;

#ifdef METHYLOME
	INDEX_ENTRY *INDEX;
	INDEX_ENTRY *INDEX_REV;
	if (conversion == 1) {
		INDEX = INDEX_CT;
		INDEX_REV = INDEX_REV_CT;
	}
	else {
		INDEX = INDEX_GA;
		INDEX_REV = INDEX_REV_GA;
	}

	spacer = 0; // Do not trust the first slot
	slot = 0;
	HAS_SLOT = 0;
#endif


#ifndef METHYLOME
	if (first_slot < 0) {	// first slot has an unallowed char!
		spacer = -first_slot; //+1
		readpos = -first_slot; //+1
		HAS_SLOT = 0;
	}
	else if (ALL_HIT_STRATEGY) {// first slot hasn't been computed yet
		spacer = 0;
		slot = 0;
		HAS_SLOT = 0;
	}
	else {	// first slot has already been computed in map_fast and doesn't contain unallowed chars 
		slot = first_slot;
		
		reverse = 0;
		if (INDEX[slot].num != 0) {
			reverse = 1;
		}

		if (MAP_REVERSE && INDEX_REV[slot].num != 0) {
			reverse = (reverse + reverse) + 2;
		}

		if (reverse > 0) {
			if (!seed2genome(num, slot, readpos + 1, reverse)) return 0;
		}
		
		readpos++;
		spacer = INDEX_DEPTH;
		SLOT = first_slot;
		HAS_SLOT = 1;
	}
#endif

        while (spacer < READ_LENGTH) {
       		READ[spacer] = toupper(READ[spacer]);
                if (spacer < readpos + INDEX_DEPTH - 1) {
                        if (READ[spacer]=='A' || READ[spacer]=='T' || READ[spacer]=='C' || READ[spacer]=='G') {
                                spacer++;
                        }
                        else {
                                spacer++;
                                readpos = spacer;
                                HAS_SLOT = 0;
                        }
                }
                else {
                        if (READ[spacer]=='A' || READ[spacer]=='T' || READ[spacer]=='C' || READ[spacer]=='G') {

                                slot = get_slot(readpos);

				// reverse: 0: slot doesnt match in either index or index_rev, 1: only index, 2: only index_rev, 4: both
				reverse = 0;
				if (INDEX[slot].num != 0) {
					reverse = 1;
				}
				if (MAP_REVERSE && INDEX_REV[slot].num != 0) {
					reverse = (reverse + reverse) + 2;
				}

				if (reverse > 0) {
#ifndef METHYLOME
					if (!seed2genome(num, slot, readpos + 1, reverse)) {
						return 0; 
					}
#else
					if (!seed2genome(num, slot, readpos + 1, reverse, conversion)) return 0; 
#endif
				}
								
                                spacer++;
                                readpos++;
                                HAS_SLOT = 1;

                        }
                        else {
                                spacer++;
                                readpos=spacer;
                                HAS_SLOT = 0;
                        }
                }
        }


	HAS_SLOT = 0;
		
        return 1;
}



int get_slot(int pos)
{
        unsigned int slot = 0;
        unsigned int i;
        int c = 0;

        if (HAS_SLOT == 0) {

                for (i=0; i<INDEX_DEPTH; i++) {
			READ[pos+i] = toupper(READ[pos+i]);
                        if (READ[pos+i] == 'A') {
                                c = 0;
                        }
                        else {
                                if (READ[pos+i] == 'C') {
                                        c = 1;
                                }
                                else {
                                        if (READ[pos+i] == 'G') {
                                                c = 2;
                                        }
                                        else {
                                                if (READ[pos+i] == 'T') {
                                                        c = 3;
                                                }
                                                else {
                                                        return -pos-i-1;
                                                }
                                        }
                                }
                        }
                        slot = slot + POWER[i] * c;
                }

        }
        else {

                slot = SLOT;
                slot >>= 2;

				READ[pos+INDEX_DEPTH-1] = toupper(READ[pos+INDEX_DEPTH-1]);
                if (READ[pos+INDEX_DEPTH-1] == 'A') {
                        slot = slot | BINARY_CODE[0];
                }
				else {
                	if (READ[pos+INDEX_DEPTH-1] == 'C') {
	                        slot = slot | BINARY_CODE[1];
        	        }
					else {
						if (READ[pos+INDEX_DEPTH-1] == 'G') {
							slot = slot | BINARY_CODE[2];
						}
						else {
							if (READ[pos+INDEX_DEPTH-1] == 'T') {
								slot = slot | BINARY_CODE[3];
							}
							else {
								return -1;
							}
						}
					}
				}
				
        }

        SLOT = slot;

        return(slot);
}
