// Authors: Korbinian Schneeberger, Joerg Hagmann, Sandra Gesing
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int main(int argc, char *argv[]) {

#ifdef METHYLOME
fprintf(stderr, "METHYLOME VERSION\n");
#endif

	// timing //////////////
	//time_t timer, timer_mid, timer2;
  	//timer=time(NULL);
	////////////////////////

        //SG
        if (!check_compile_options())
          return 255;
 
	init(argc, argv);

 	if (VERBOSE) { printf("Reading in indices\n"); }
	build_index();

	if (VERBOSE) printf("Reading in genome\n");
	load_genome();
	
	// timing //////////////
	//timer_mid=time(NULL);
  	////////////////////////
	
 	if (VERBOSE) { printf("Mapping reads\n"); }
	map_reads();

	if (VERBOSE) printf("Mapped Reads: %i of all %d reads\n", READS_MAPPED, NUM_READS);
		
	// timing //////////////
  	/**
	timer2=time(NULL);
  	int seconds = difftime(timer2, timer_mid);
  	int hours = seconds / 3600;
  	seconds %= 3600;
  	int minutes = seconds / 60;
  	seconds %= 60;
  	printf("Time needed to pre-process: %gs\n",difftime(timer_mid, timer));
  	printf("Time needed to map: %dh %dm %ds\n", hours, minutes, seconds);
  	seconds = difftime(timer2, timer);
  	hours = seconds / 3600;
  	seconds %= 3600;
  	minutes = seconds / 60;
  	seconds %= 60;
  	printf("Total time needed: %dh %dm %ds\n", hours, minutes, seconds);
  	*////////////////////////


	return 0;
}

//SG
char check_compile_options()
{
#ifdef CUDA
        cudaGetDeviceCount(&DEVICE_COUNT);
        if (DEVICE_COUNT == 0)
        {
          fprintf(stderr, "No CUDA devices found. Please use CPU version of program.\n");
          return 0;
        }
#endif

	return 1;
}
 
