// Authors: Korbinian Schneeberger and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

#ifndef METHYLOME
int alloc_index_memory() {
	INDEX_ENTRY **index;
	INDEX_ENTRY **index_rev;
	index = &INDEX;
	index_rev = &INDEX_REV;
#else
int alloc_index_memory(int conversion) {
	INDEX_ENTRY **index;
	INDEX_ENTRY **index_rev;
	if (conversion == 1) {
		index = &INDEX_CT;
		index_rev = &INDEX_REV_CT;
	}
	else {
		index = &INDEX_GA;
		index_rev = &INDEX_REV_GA;
	}
#endif

	if ( ((*index) = (INDEX_ENTRY *) malloc (INDEX_SIZE * sizeof(INDEX_ENTRY)) ) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for mem_master (2)\n");
		exit(1);
	}
	int i;
	for (i=0; i < INDEX_SIZE; i++)
	{
		(*index)[i].num = 0;
		(*index)[i].offset = 0;
	}

	if ( MAP_REVERSE && (((*index_rev) = (INDEX_ENTRY *) malloc (INDEX_SIZE * sizeof(INDEX_ENTRY))) == NULL) ) {
		fprintf(stderr, "ERROR : not enough memory for mem_master (3)\n");
		exit(1);
	}
	for (i=0; i < INDEX_SIZE; i++)
	{
		(*index)[i].num = 0;
		(*index)[i].offset = 0;
	}

	return(0);
}

int alloc_genome_memory()
{
	if ((GENOME = (CHROMOSOME_ENTRY **) malloc (LONGEST_CHROMOSOME * sizeof(CHROMOSOME_ENTRY**))) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for genome memory\n");
		exit(1);
	}
		
	//@TODO is this really necessary? why isn't it already NULL
	int i;
	for (i=0; i!=LONGEST_CHROMOSOME; ++i) {
		*(GENOME+i) = NULL;
	}

	return(0);
}

MAPPING_ENTRY* alloc_mapping_entry()
{
	MAPPING_ENTRY_CONTAINER *container;
	MAPPING_ENTRY *entry;

	if (MAPPING_ENTRY_OPERATOR->used >= CONTAINER_SIZE - 1) {
		container = alloc_mapping_entry_container();
		MAPPING_ENTRY_OPERATOR->next = container;
		MAPPING_ENTRY_OPERATOR = container;
	}
	
	entry = &(MAPPING_ENTRY_OPERATOR->entries[MAPPING_ENTRY_OPERATOR->used]);
	MAPPING_ENTRY_OPERATOR->used++;

	entry->hit = NULL;
	entry->pred = NULL;
	entry->succ = NULL;
	entry->readpos = -1;
	
	return(entry);
}

MAPPING_ENTRY_CONTAINER* alloc_mapping_entry_container()
{
	MAPPING_ENTRY_CONTAINER *container;

	if ((container =  (MAPPING_ENTRY_CONTAINER *) malloc (sizeof(MAPPING_ENTRY_CONTAINER))) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for mapping entry container memory\n");
		exit(1);
	}

	container->used = 0;
	container->next = NULL;

	return(container);
}


CHROMOSOME_ENTRY* alloc_chromosome_entry(unsigned int *pos, unsigned int *chr, char *strand)
{
	if (CHROMOSOME_ENTRY_OPERATOR->used > CHROM_CONTAINER_SIZE - 1) {
		fprintf(stderr, "\n!!! WARNING: Chromosome container size of %d is too small! Hits for read %s cannot be reported any more!\n\n", CHROM_CONTAINER_SIZE, READ_ID);
		return(NULL);
	}
	
	CHROMOSOME_ENTRY *entry;

	entry = &(CHROMOSOME_ENTRY_OPERATOR->entries[CHROMOSOME_ENTRY_OPERATOR->used]);
	entry->chromosome = *chr;
	entry->genome_pos = *pos;
	entry->strand = *strand;
	entry->next = NULL;
    entry->mapping_entries = NULL;
    
    CHROMOSOME_ENTRY_OPERATOR->used++;


	return(entry);
}

CHROMOSOME_ENTRY_CONTAINER* alloc_chromosome_entry_container()
{

    if ((CHROMOSOME_ENTRY_OPERATOR = (CHROMOSOME_ENTRY_CONTAINER *) malloc (sizeof(CHROMOSOME_ENTRY_CONTAINER))) == NULL) {
    	fprintf(stderr, "ERROR : not enough memory for chromosome entry container memory\n");
		exit(1);
	}

	if ((CHROMOSOME_ENTRY_OPERATOR->entries = (CHROMOSOME_ENTRY *) malloc (CHROM_CONTAINER_SIZE * sizeof(CHROMOSOME_ENTRY))) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for chromosome entry container memory\n");
		exit(1);
	}
	
	CHROMOSOME_ENTRY_OPERATOR->used = 0;

	return(CHROMOSOME_ENTRY_OPERATOR);
}

HIT* alloc_hit()
{
	HIT_CONTAINER *container;
	HIT *hit;

	if (HIT_OPERATOR->used >= CONTAINER_SIZE - 1) {
		container = alloc_hit_container();
		HIT_OPERATOR->next = container;
		HIT_OPERATOR = container;
	}
	
	hit = &(HIT_OPERATOR->entries[HIT_OPERATOR->used]);
	HIT_OPERATOR->used++;

	hit->readpos = 0;
	hit->start = 0;
	hit->end = 0;
	hit->chromosome = 0;
	hit->mismatches = 0;
	hit->gaps = 0;
	hit->start_offset = 0;
	hit->end_offset = 0;
	hit->aligned = 0;

	/*int i;
	//for (i=0; i!=MAX_MISMATCHES; ++i) hit->mismatch[i] = READ_LENGTH + 1;
	for (i=0; i!=MAX_MISMATCHES; ++i) {
		hit->edit_op[i].mm = 0;
	}*/
	hit->orientation = ' ';
	hit->same_eo_succ = NULL;
	hit->next = NULL;
	hit->last = NULL;

	return(hit);
}

HIT_CONTAINER* alloc_hit_container()
{
	HIT_CONTAINER *container;

	if ((container =  (HIT_CONTAINER *) malloc (sizeof(HIT_CONTAINER))) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for mapping entry container memory\n");
		exit(1);
	}

	container->used = 0;
	container->next = NULL;

	return(container);
}

int alloc_hit_lists_operator()
{
	if ((HIT_LISTS_OPERATOR = (HIT **) malloc (sizeof(HIT*) * MAX_READ_LENGTH)) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for hitlist\n");
		exit(1);
	}
	int i;
	for (i = 0; i < MAX_READ_LENGTH; i++)
		*(HIT_LISTS_OPERATOR+i) = NULL;
#ifdef THREADS
	HITS_NUM_PER_LENGTH = (unsigned long int *) malloc (MAX_READ_LENGTH * sizeof(unsigned long int));	
	for (i = 0; i < MAX_READ_LENGTH; i++)
		HITS_NUM_PER_LENGTH[i] = 0;
#endif
	return(0);
}

int alloc_hits_by_score()
{
	unsigned char max_score = NUM_GAPS * GAP_SCORE + (NUM_EDIT_OPS - NUM_GAPS) * MM_SCORE;
	NUM_SCORE_INTERVALS = (int) max_score / SCORE_INTERVAL;
	if (NUM_SCORE_INTERVALS * SCORE_INTERVAL != (int) max_score) ++NUM_SCORE_INTERVALS;
	NUM_SCORE_INTERVALS++;
	
	if ((HITS_BY_SCORE = (HITS_BY_SCORE_STRUCT *) malloc (sizeof(HITS_BY_SCORE_STRUCT) * NUM_SCORE_INTERVALS)) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for hitlist by score\n");
		exit(1);
	}

	int i;
	for (i=0; i!=NUM_SCORE_INTERVALS; ++i) {
		HITS_BY_SCORE[i].hitpointer = NULL;
		HITS_BY_SCORE[i].num = 0;
	}

	return(0);
}

int alloc_readstart_bins()
{
	if ((READSTART_BINS = (HIT **) malloc (sizeof(HIT*) * (LONGEST_CHROMOSOME / ((NUM_GAPS==0)? 1: NUM_GAPS)))) == NULL) {
		fprintf(stderr, "ERROR : not enough memory for readstart bin structure\n");
		exit(1);
	}

	return(0);
} 

int dealloc_mapping_entries()
{
	NUM_MAPPING_ENTRIES = 0;
	
	MAPPING_ENTRY_CONTAINER *container, *next;
	container = MAPPING_ENTRY_OPERATOR_FIRST->next;

	while (container != NULL) {
		next = container->next;
		NUM_MAPPING_ENTRIES += container->used;
		free(container);
		container = next;
	}

	NUM_MAPPING_ENTRIES += MAPPING_ENTRY_OPERATOR_FIRST->used;
	
	MAPPING_ENTRY_OPERATOR = MAPPING_ENTRY_OPERATOR_FIRST;
	MAPPING_ENTRY_OPERATOR->used = 0;
	MAPPING_ENTRY_OPERATOR->next = NULL;

	return(0);
}

int dealloc_hits()
{
	HIT_CONTAINER *container, *next;
	container = HIT_OPERATOR_FIRST->next;

	while (container != NULL) {
		next = container->next;
		free(container);
		container = next;
	}


	HIT_OPERATOR = HIT_OPERATOR_FIRST;
	HIT_OPERATOR->used = 0;
	HIT_OPERATOR->next = NULL;

	return(0);
}

int dealloc_chromosome_entries()
{
	unsigned int i;
	
	for (i=0; i < CHROM_CONTAINER_SIZE; i++) {
		free(CHROMOSOME_ENTRY_OPERATOR->entries[i].mapping_entries);
		free(CHROMOSOME_ENTRY_OPERATOR->entries+i);
	}
	//free(CHROMOSOME_ENTRY_OPERATOR);

	return(0);
}

int dealloc_hit_lists_operator()
{
	unsigned int i;

	for (i = INDEX_DEPTH; i <= LONGEST_HIT; i++) {
		*(HIT_LISTS_OPERATOR+i) = NULL;
	}

	return(0);
}

int dealloc_hits_by_score()
{
	unsigned int i;

	for (i = 0; i != NUM_SCORE_INTERVALS; i++) {
		HITS_BY_SCORE[i].hitpointer = NULL;
		HITS_BY_SCORE[i].num = 0;
	}

	return(0);
}

