// Authors: Korbinian Schneeberger, Stephan Ossowski and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "mkindex.h"

int write_index_2_file(unsigned int chr);
int write_chr_desc(unsigned int chr);

int write_index(unsigned int chr) 
{
	write_chr_desc(chr);
	write_index_2_file(chr);

	return(0);
}

int write_chr_desc(unsigned int chr) 
{
	fwrite(&chr, sizeof(unsigned int), 1, INDEX_FP);
	fwrite(&CHR_LENGTH, sizeof(unsigned int), 1, INDEX_FP);
	fwrite(&CHR_DESC[0], sizeof(char), CHR_DESC_LENGTH, INDEX_FP);	//@TODO CHR_LENGTH instead of CHR_DESC_LENGTH
	fwrite(&SLOT_COUNTER, sizeof(unsigned int), 1, INDEX_FP);

	return(0);
}

int write_index_2_file(unsigned int chr) 
{
	unsigned int j, i, num;
	int minus_i;
	BIN *bin;
	BIN_EXT **bin_ext;

	for (j=0; j<NUM_USED_SLOTS; j++) {
		i = USED_SLOTS[j];
		
		if (INDEX[i] != NULL && INDEX[i]->num_pos != 0) {

			bin = INDEX[i];
			num = bin->num_pos;

			//HEADER
			if (fwrite(&i, sizeof(int), 1, INDEX_FP) == 0) {	// slot
				fprintf(stderr, "ERROR: cant access harddisc for index file\n"); 
			}

			if (fwrite(&num, sizeof(int), 1, INDEX_FP) == 0) {	// nr of positions in this slot
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
			}

			//CONTENT ( = positions)
			if (num <= BIN_SIZE) {

				fwrite(&bin->ids[0], sizeof(ID), num, INDEX_FP);
			
			} else { 

				fwrite(&(bin->ids[0]), sizeof(ID), BIN_SIZE, INDEX_FP);
				num -= BIN_SIZE;

				bin_ext = &(bin->bin_ext);

				while (*bin_ext != NULL) {
					if (num > BIN_SIZE_EXT) {  

						fwrite(&((*bin_ext)->ids[0]), sizeof(ID), BIN_SIZE_EXT, INDEX_FP);
						num -= BIN_SIZE_EXT;
						bin_ext = &((*bin_ext)->bin_ext);

					} else { //write out last entries and finish

						fwrite(&((*bin_ext)->ids[0]), sizeof(ID), num, INDEX_FP);
						*bin_ext = NULL;

					}
				}
			}
		}

		
		// and the same for the reverse index
		if (BUILD_REVERSE_INDEX && INDEX_REV[i] != NULL && INDEX_REV[i]->num_pos != 0) {
					
			bin = INDEX_REV[i];
			num = bin->num_pos;

			//HEADER
			if (i == 0) minus_i = -2147483647;
				else minus_i = -i;
				
			if (fwrite(&minus_i, sizeof(int), 1, INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n"); 
			}

			if (fwrite(&num, sizeof(int), 1, INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
			}

			//CONTENT
			if (num <= BIN_SIZE) {

				fwrite(&bin->ids[0], sizeof(ID), num, INDEX_FP);

			} else { 

				fwrite(&(bin->ids[0]), sizeof(ID), BIN_SIZE, INDEX_FP);
				num -= BIN_SIZE;

				bin_ext = &(bin->bin_ext);

				while (*bin_ext != NULL) {
					if (num > BIN_SIZE_EXT) {  

						fwrite(&((*bin_ext)->ids[0]), sizeof(ID), BIN_SIZE_EXT, INDEX_FP);
						num -= BIN_SIZE_EXT;
						bin_ext = &((*bin_ext)->bin_ext);

					} else { //write out last entries and finish

						fwrite(&((*bin_ext)->ids[0]), sizeof(ID), num, INDEX_FP);
						*bin_ext = NULL;					

					}
				}
			}
		}
	}
	
	if (VERBOSE) printf("... done\n");

	return(0);
}

int write_meta_index(unsigned int num_chr) 
{
	unsigned int i;
	int minus_i;

	if (fwrite(&BUILD_REVERSE_INDEX, sizeof(char), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	if (fwrite(&INDEX_DEPTH, sizeof(int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	if (fwrite(&num_chr, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	if (fwrite(&POSITION_COUNTER, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	if (fwrite(&LONGEST_CHROMOSOME, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}


	// write block table:
	/*unsigned int tmp = BLOCK_SIZE;
	if (fwrite(&tmp, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}*/
	
	if (fwrite(&BLOCK, sizeof(unsigned int), 1, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	
	if (fwrite(BLOCK_TABLE, sizeof(POS), BLOCK, META_INDEX_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
	}
	
	
	// write bins: 
	unsigned long int maxnr = 0;

 	for (i=0; i<INDEX_SIZE; i++) {

		if ( INDEX[i] != NULL ) {	
			//Slot
			if (fwrite(&i, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
			}

			//Number
			if (fwrite(&(INDEX[i]->num_all), sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
			}
//printf("slot %d: num %d\n", i, INDEX[i]->num_all);
			maxnr = (INDEX[i]->num_all > maxnr)? INDEX[i]->num_all: maxnr;
		}

		if ( BUILD_REVERSE_INDEX && (INDEX_REV[i] != NULL) ) {
			
			//Slot
			if (i == 0) minus_i = -2147483647;
				else minus_i = -i;
				
			if (fwrite(&minus_i, sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for meta index file\n"); 
			}

			//Number
			if (fwrite(&(INDEX_REV[i]->num_all), sizeof(int), 1, META_INDEX_FP) == 0) {
				fprintf(stderr, "ERROR: cant access harddisc for index file\n");
			}

			maxnr = (INDEX_REV[i]->num_all > maxnr)? INDEX_REV[i]->num_all: maxnr;
		}

	}

	if (VERBOSE) printf("... done\n");
	if (DEBUG) printf("\nMax Positions per Slot: %lu\n\n", maxnr);
	
	return(0);
}

int write_chr(unsigned int chr)
{
	if (VERBOSE) printf("writing chromosome %d\n",chr+1);
	if (fwrite(CHR_SEQ, sizeof(char), CHR_LENGTH, GENOME_OUT_FP) == 0) {
		fprintf(stderr, "ERROR: cant access harddisk for genome output file\n");
	}
	
	fclose(GENOME_OUT_FP);
	
	return 0;	
}
