// Authors: Korbinian Schneeberger, Stephan Ossowski and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

void printhit(HIT* hit);
int compare (const void *a, const void *b);
int compare_int (const void *a, const void *b);


char get_compl_base(char c)
{
	switch (c) {
		case 'A': return 'T';
		case 'C': return 'G';
		case 'G': return 'C';
		case 'T': return 'A';
		default : return c;
	}
	return 0;
}


void print_stats ()
{
			printf("\n########### STATISTICS ###########\n");
			printf("Mapped Reads: %i of all %d reads\n", READS_MAPPED, NUM_READS);
			int i;
			for (i=0; i!=NUM_MISMATCHES+1; ++i) printf(" Reads with %d mismatches: %u\n", i, HITS_MM[i]);
			printf("  Perfect Plus-Hits: %i\n  Perfect Minus-Hits:\t%i\n  Total:\t\t%i\n", PERFECT_HITS, PERFECT_HITS_REV, PERFECT_HITS + PERFECT_HITS_REV);
			printf("   Perfect matching reads (+ or -): %i\n", PERFECT_READS);
			
			for (i=INDEX_DEPTH; i!=37; ++i) printf("    Total Hits of length %d: %u - %.4f%%\n", i, HITS_LEN[i], ((double) (100 * HITS_LEN[i]) / NUM_HITS));
			printf("\n    Total number of hits:                  %lu\n", NUM_HITS);
			printf("      Number of overhang alignments:       %lu\n", NUM_ALIGNMENTS);
			printf("      Successful overhang alignments:      %lu\n", NUM_ALIGNMENTS-GAPS_ENCOUNTERED[0]-GAPS_ENCOUNTERED[1]-GAPS_ENCOUNTERED[2]-TOO_MANY_MMS[0]-TOO_MANY_MMS[1]);
			printf("      Number of global alignments:         %lu\n", NUM_WHOLE_ALIGNMENTS);
			printf("      Successful global alignments:        %lu\n", NUM_WHOLE_ALIGNMENTS-BREAK_GLOBAL_ALIGNMENT[0]-BREAK_TB_IN_GLOBAL_ALIGNMENT);
			printf("      Breaks in global alignments(no hit): %lu\n", BREAK_GLOBAL_ALIGNMENT[0]);
			printf("      Breaks in global alignments(hit):    %lu\n", BREAK_GLOBAL_ALIGNMENT[1]);
			printf("      Breaks after global alignment:       %lu\n\n", BREAK_TB_IN_GLOBAL_ALIGNMENT);
			printf("      Hits of len 36, not aligned:         %d\n", NOT_ALIGNED[0]);
			printf("      Mappings of fast mapping:            %d\n", NOT_ALIGNED[1]);
			//printf("      hits of len 36, not aligned (with 1MM at start/beg of read): %d\n",NOT_ALIGNED[1]);
			//printf("        Number of unmapped hits at beg/end of chrom: %d and in align-step: %d\n", ENDSTART_MAPPED[0], ENDSTART_MAPPED[1]);
			printf("      Overlapping hits at beg/end of chr:  %d\n", ENDSTART_MAPPED[0]);
			
			printf("\nGaps encountered on diagonal during overhang-alignment:   %lu\n",GAPS_ENCOUNTERED[0]);
			printf("Gaps encountered due to score during overhang-alignment:  %lu\n",GAPS_ENCOUNTERED[1]);
			printf("Gaps encountered after overhang-alignment:                %lu\n",GAPS_ENCOUNTERED[2]);
			printf("Too many MMs during overhang-alignment (discarded hits):  %lu\n",TOO_MANY_MMS[0]);
			printf("Too many MMs after overhang-alignment (discarded hits):   %lu\n\n",TOO_MANY_MMS[1]);
			
			printf("cells processed in overhang: %lu\n", CELLS_OVERHANG);
			printf("cells processed in global:   %lu\n", CELLS_GLOBAL);
			printf("total cells:                 %lu\n\n", CELLS_OVERHANG+CELLS_GLOBAL);	
			
			printf("gap limit overcome: %lu\n\n",W);
			
			//printf("reads filtered out due to too much non-base chars: %i\n\n",READS_FILTERED); 
			
			/*printf("Print in stat... ");
			unsigned int sum=0;
			FILE* f;
			f = fopen("stat","w");
			for (i=0; i!= MAX_READ_LENGTH-INDEX_DEPTH+1; ++i) {
				for (j=0; j!=MAX_READ_LENGTH - INDEX_DEPTH - i + 1; ++j) {
					if (*(*(HITS_READPOS+i)+j) != 0) {
						fprintf(f, "\t(%d)%u ", j+1, *(*(HITS_READPOS+i)+j));
						sum += *(*(HITS_READPOS+i)+j);
					}
				}
				fprintf(f, "\nLENGTH %d: %d", i+INDEX_DEPTH, sum); 
				if (i!=MAX_READ_LENGTH-INDEX_DEPTH && sum != 0 && i<36) fprintf(f, "\tfirst: %.4f%%, last: %.4f%%, other: %.4f%%\n", ((double) (100 * *(*(HITS_READPOS+i))) / sum), ((double) (100 * (*(*(HITS_READPOS+i)+(36 - INDEX_DEPTH - i))))/sum), 100 - ((double) (100 * *(*(HITS_READPOS+i))) / sum) - ((double) (100 * (*(*(HITS_READPOS+i)+(36 - INDEX_DEPTH - i))))/sum));
					else fprintf(f, "\n");
				sum = 0;
			}
			printf("done\n");*/
}


// prints out all hits which have been inserted into HITS_BY_EDITOPS
int print_hits()
{
	int i, printed = 0, nr;
	HIT *hit;
	
	for (i = 0; i != NUM_SCORE_INTERVALS; ++i) {
		
		if (printed && !ALL_HIT_STRATEGY) break;	// best hit strategy
		
		if (HITS_BY_SCORE[i].hitpointer != NULL) {
			
			// only REPEATMAP numbers of alignment will be chosen randomly: 
			if (!ALL_HIT_STRATEGY && REPEATMAP < 0 && HITS_BY_SCORE[i].num > -REPEATMAP) {
				srand((unsigned) time(NULL));
				
				int j, k, n;
				int hits[-REPEATMAP];
				for (j=0; j!=-REPEATMAP; ++j) {
					n = 1;
					while (n != 0) {
						n = 0;
						hits[j] = rand() % HITS_BY_SCORE[i].num;
						for (k=0; k!=j; ++k) {
							if (hits[j] == hits[k]) ++n;
						}
					}
				}							
				
				qsort(hits, -REPEATMAP, sizeof(int), compare_int);
				
				hit = HITS_BY_SCORE[i].hitpointer;
				
				nr = 0;
				for (j=0; j!=HITS_BY_SCORE[i].num; ++j) {
					
					if (hits[nr] == j) {
						printed += print_alignment(hit, -REPEATMAP);
						nr++;
					}
					
					if (nr == -REPEATMAP) break;
					
					hit = hit->same_eo_succ;
				}
				
			}
			// no random selection of output alignments:
			else {
			
				hit = HITS_BY_SCORE[i].hitpointer;
				
				while (hit != NULL) {
					
					if (!ALL_HIT_STRATEGY) nr = HITS_BY_SCORE[i].num;
						else nr = HITS_IN_SCORE_LIST;
					
					if (REPEATMAP == 0) {	// no max nr of hits per read was specified, print all
						printed += print_alignment(hit, nr);
					}
					else if (REPEATMAP > 0 && printed < REPEATMAP) {
						printed += print_alignment(hit, (nr < REPEATMAP)? nr: REPEATMAP);
					}
					else if (REPEATMAP == printed) {	// repeatmap many alignments already printed out -> stop printing -> next read
						return 1;
					}
						
					hit = hit->same_eo_succ;
				}
			}
		}	
	}
	
	if (printed != 0) return 1;	// read could have been mapped
		else return 0;			// read couldn't be mapped
}


int print_alignment(HIT* hit, unsigned int num)
{
	//if (hit->chromosome == 1 && strcmp(READ_ID,"1000109840310")==0) DEBUG = 1;
	//DEBUG = 1;
	
	if (STATISTICS) HITS_MM[hit->mismatches]++;
	
	int j, fstart, flen;
	
	if (DEBUG) printf("PRINT_HIT: \n");
	
	int hitlength = hit->end - hit->start + 1;
	unsigned int readstart;
	if (hit->orientation == '+') {
		readstart = hit->start - hit->readpos + hit->start_offset;	// start pos of read in genome	0-initialized
	}
	else {
		readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2) + hit->start_offset; 	// 0-initialized
	}
	
	
	if (DEBUG) printf("hit->start %d startoffset %d hit->end %d read_len %d hit->readpos %d hitlength %d readstart %d\n",hit->start,hit->start_offset,hit->end,READ_LENGTH,hit->readpos,hitlength,readstart);
	if (DEBUG) printf("hit->chr %d\n",hit->chromosome+1);
	
	// gets GENOME Sequence ( O N L Y DEBUGGING ):
	/*if (DEBUG) {
		chrseq[0] = '\0';
		if (hit->orientation == '+') {
			strncpy(chrseq, CHR_SEQ[hit->chromosome]+(hit->start-hit->readpos), READ_LENGTH);
		}
		else {
			for (j = hit->end + hit->readpos - 2; j != hit->start - READ_LENGTH + hitlength + hit->readpos - 3; --j) { 
				chrseq[hit->end + hit->readpos - 2 - j] = (char) get_compl_base(CHR_SEQ[hit->chromosome][j]);
				//if (DEBUG) printf("j = %i: %c - pos: %i, compl_base: %c\n", j, CHR_SEQ[hit->chromosome][j], hit->end + hit->readpos - 2 - j, get_compl_base(CHR_SEQ[hit->chromosome][j]));
			}
		}
		chrseq[READ_LENGTH] = '\0';
		printf("     %c%c\n",CHR_SEQ[hit->chromosome][readstart], CHR_SEQ[hit->chromosome][readstart+1]);
		printf("chr  %s\n",chrseq);
		printf("read %s\n",READ);
	}*/
	
	
	
	// PERFECT HITS:
	if (hit->mismatches == 0) {

		if (hit->orientation == '+') strcpy(ALIGNSEQ,READ);
		else strncpy(ALIGNSEQ, CHR_SEQ[hit->chromosome]+readstart, READ_LENGTH);
		ALIGNSEQ[READ_LENGTH] = '\0'; 

		// print in file:
		if (OUTPUT_FORMAT == 0) {
			/////// SHORE file ///////	
			
			fprintf(OUT_FP, "%s\t%d\t%s\t%s\t%c", 
				CHR_DESC[hit->chromosome],
				readstart+1,	// 1-initialized
				ALIGNSEQ,//Alignment String
				READ_ID,
				((hit->orientation == '+')? 'D': 'P'));

			if (SCORES_OUT)
				fprintf(OUT_FP, "\t%.1f", 
					(double) (-READ_LENGTH * M_SCORE));
			else
				fprintf(OUT_FP, "\t%d", hit->mismatches);

			fprintf(OUT_FP, "\t%d\t%d\t%d",
				num, // Number of hits
				READ_LENGTH,
				0);			
			
			if (READ_FORMAT == 2) fprintf(OUT_FP, "\t%d", READ_PE_FLAG);
			if (strlen(READ_QUALITY[0]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[0]);
			if (strlen(READ_QUALITY[1]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[1]);
			if (strlen(READ_QUALITY[2]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[2]);
			
			if (FLANKING != 0) {
				fstart = (readstart < FLANKING)? 0: readstart - FLANKING;
				flen   = (readstart + READ_LENGTH + FLANKING > CHR_LENGTH[hit->chromosome])? CHR_LENGTH[hit->chromosome] - fstart: readstart - fstart + READ_LENGTH + FLANKING;
				strncpy(FLANK_SEQ, CHR_SEQ[hit->chromosome] + fstart, flen);
				FLANK_SEQ[flen] = '\0';
				fprintf(OUT_FP, "\t%d\t%s", CHR_LENGTH[hit->chromosome], FLANK_SEQ);
			}
			else if (PRINT_SEQ > 0) fprintf(OUT_FP, "\t%d", CHR_LENGTH[hit->chromosome]);
			if (PRINT_SEQ == 2) fprintf(OUT_FP, "\t%s", CHR_SEQ[hit->chromosome]);
			
			fprintf(OUT_FP, "\n");
		}
		else {
			/////// BED file ///////
			
			if (SCORES_OUT) {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%.1f\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH,
					READ_ID,
					(double) (-READ_LENGTH * M_SCORE),
					hit->orientation);
			}
			else {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH,
					READ_ID,
					hit->mismatches,
					hit->orientation);
			}
			
		}
		
	}	
	// HITS WITH MISMATCHES:
	else {
		
		int count_char = 0;
		char gap_offset = 0;
		char gap_in_read = 0;
		char gap_in_chr = 0;
		
		// sort mismatches in ascending order according to their abs positions and 'gap before mm'-strategy if equal
		if (DEBUG) printhit(hit);
		qsort(hit->edit_op, hit->mismatches, sizeof(EDIT_OPS), compare); 
		if (DEBUG) { printf("after sorting: "); printhit(hit); }
		
		
		ALIGNSEQ[0] = '\0';
		if (DEBUG) printf("0 %d - .%s.\n", (int)strlen(ALIGNSEQ), ALIGNSEQ);

		
		for (j=0; j!=hit->mismatches; ++j) {
			
				if (hit->edit_op[j].pos < 0) {
					hit->edit_op[j].pos = -hit->edit_op[j].pos;
					gap_in_chr = 1;
				}
			
				if (j == 0) {
					strncpy(ALIGNSEQ, CHR_SEQ[hit->chromosome]+(readstart), hit->edit_op[0].pos-1);
					count_char += hit->edit_op[0].pos - 1;
				}
				else if (hit->edit_op[j].pos - hit->edit_op[j-1].pos != 0) {
					strncpy(ALIGNSEQ+count_char, 
								CHR_SEQ[hit->chromosome]+(readstart + hit->edit_op[j-1].pos + gap_offset - gap_in_read), 
									hit->edit_op[j].pos - hit->edit_op[j-1].pos - 1 + gap_in_read);	// -1???
					count_char += hit->edit_op[j].pos - hit->edit_op[j-1].pos - 1 + gap_in_read;
				}	// else: edit_op[j-1] must have been a gap!
				
				gap_in_read = 0;
				
				if (hit->edit_op[j].mm) {
					if (hit->orientation == '+')
						sprintf(ALIGNSEQ+count_char, "[%c%c]", 
									CHR_SEQ[hit->chromosome][readstart + hit->edit_op[j].pos - 1 + gap_offset], 
										READ[hit->edit_op[j].pos - 1]);
					else 
						sprintf(ALIGNSEQ+count_char, "[%c%c]", 
									CHR_SEQ[hit->chromosome][readstart + hit->edit_op[j].pos - 1 + gap_offset], 
										get_compl_base(READ[READ_LENGTH - hit->edit_op[j].pos]));
				}
				else if (gap_in_chr) {
					if (hit->orientation == '+') 
						sprintf(ALIGNSEQ+count_char, "[-%c]", READ[hit->edit_op[j].pos - 1]);
					else
						sprintf(ALIGNSEQ+count_char, "[-%c]", get_compl_base(READ[READ_LENGTH - hit->edit_op[j].pos]));
						
					gap_offset--;
					gap_in_chr = 0;
				}
				else {
					sprintf(ALIGNSEQ+count_char, "[%c-]", CHR_SEQ[hit->chromosome][readstart + hit->edit_op[j].pos - 1 + gap_offset]);
					
					gap_offset++;
					gap_in_read = 1;
				}
					
				count_char += 4;
				
				if (DEBUG) printf("%d %d - .%s.\n", j+1, (int)strlen(ALIGNSEQ), ALIGNSEQ);
					
		}
			
		// from last mismatch to end of read:
			
		strncpy(ALIGNSEQ+count_char, 
					CHR_SEQ[hit->chromosome]+(readstart + hit->edit_op[j-1].pos + gap_offset - gap_in_read),
						READ_LENGTH - hit->edit_op[j-1].pos + gap_in_read);
		count_char += READ_LENGTH - hit->edit_op[j-1].pos + gap_in_read;

		ALIGNSEQ[count_char] = '\0';
		if (DEBUG) printf("t %d - .%s.\n", (int)strlen(ALIGNSEQ), ALIGNSEQ);
		if (DEBUG) printhit(hit);
		
		
		// print in file:
		if (OUTPUT_FORMAT == 0) {
			
			/////// SHORE file ///////
			
			fprintf(OUT_FP, "%s\t%d\t%s\t%s\t%c", 
				CHR_DESC[hit->chromosome],
				readstart+1,	// 1-initialized
				ALIGNSEQ,//Alignment String
				READ_ID,
				((hit->orientation == '+')? 'D': 'P'));
			
			if (SCORES_OUT)
				fprintf(OUT_FP, "\t%.1f", 
					(double) (hit->gaps * GAP_SCORE + (hit->mismatches - hit->gaps) * MM_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE));
			else
				fprintf(OUT_FP, "\t%d", hit->mismatches);
				
			fprintf(OUT_FP, "\t%d\t%d\t%d",
				num, // Number of hits
				READ_LENGTH,	// length of hit on genome
				0);			
			
			if (READ_FORMAT == 2) fprintf(OUT_FP, "\t%d", READ_PE_FLAG);
			if (strlen(READ_QUALITY[0]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[0]);
			if (strlen(READ_QUALITY[1]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[1]);
			if (strlen(READ_QUALITY[2]) != 0) fprintf(OUT_FP, "\t%s", READ_QUALITY[2]);
			
			if (FLANKING != 0) {
				fstart = (readstart < FLANKING)? 0: readstart - FLANKING;
				flen   = (readstart + READ_LENGTH + FLANKING > CHR_LENGTH[hit->chromosome])? CHR_LENGTH[hit->chromosome] - fstart: readstart - fstart + READ_LENGTH + FLANKING;
				strncpy(FLANK_SEQ, CHR_SEQ[hit->chromosome] + fstart, flen);
				FLANK_SEQ[flen] = '\0';
				fprintf(OUT_FP, "\t%d\t%s", CHR_LENGTH[hit->chromosome], FLANK_SEQ);
			}
			else if (PRINT_SEQ > 0) fprintf(OUT_FP, "\t%d", CHR_LENGTH[hit->chromosome]);
			if (PRINT_SEQ == 2) fprintf(OUT_FP, "\t%s", CHR_SEQ[hit->chromosome]);
			
			/*if (PRINT_SEQ == 1) 	 fprintf(OUT_FP, "\t%d", CHR_LENGTH[hit->chromosome]);
			else if (PRINT_SEQ == 2) fprintf(OUT_FP, "\t%d\t%s", CHR_LENGTH[hit->chromosome], CHR_SEQ[hit->chromosome]);*/
			
			fprintf(OUT_FP, "\n");
		}
		else {
			
			/////// BED file ///////
			
			if (SCORES_OUT) {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%.1f\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH + gap_offset,
					READ_ID,
					(double) (hit->gaps * GAP_SCORE + (hit->mismatches - hit->gaps) * MM_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE),
					hit->orientation);
			}
			else {
				fprintf(OUT_FP, "%s\t%d\t%d\t%s\t%d\t%c\n", 
					CHR_DESC[hit->chromosome],
					readstart,
					readstart + 1 + READ_LENGTH + gap_offset,
					READ_ID,
					hit->mismatches,
					hit->orientation);
			}
			
		}

		if (DEBUG) printf("%s\n",ALIGNSEQ);

	}
	
	if (DEBUG) printf("done printing\n");
	//DEBUG = 0;

	return 1;
	
}


// sorts by position, if it's identical, then gaps have to be before mismatches 
int compare (const void *a, const void *b)
{
	EDIT_OPS *ia = (EDIT_OPS *)a;
	EDIT_OPS *ib = (EDIT_OPS *)b;
	if (ia->pos == ib->pos) return (int) (ib->mm - ia->mm);
	
	return (int) (abs(ia->pos) - abs(ib->pos));
}

int compare_int (const void *a, const void *b)
{
	int *ia = (int *)a;
	int *ib = (int *)b;
	
	return (int) (*ia-*ib);
}


void print_leftovers()
{
	if (READ_FORMAT == 0) fprintf(LEFTOVER_FP, "@%s\n%s\n+\n%s\n", READ_ID, READ, READ_QUALITY[0]);
	else if (READ_FORMAT == 1) fprintf(LEFTOVER_FP, ">%s\n%s\n", READ_ID, READ);
	else fprintf(LEFTOVER_FP, "%s\t%s\t%d\t%s\t%s\t%s\n", READ_ID, READ, READ_PE_FLAG, READ_QUALITY[0], READ_QUALITY[1], READ_QUALITY[2]);
}
					
void print_alignment_matrix(int chrstart, int readstart, int length, int offset_front, int offset_end, int chr, char ori, int K)
{
	int i,j;
	
	printf(" k=%d |\t-\t",K);
	if (ori == '+')	for (i=0; i!=length; i++) printf("%c\t",CHR_SEQ[chr][chrstart + i]);
	else for (i=0; i!=length; i++) printf("%c\t",get_compl_base(CHR_SEQ[chr][chrstart - i]));
	printf("\n----------------------------------------------------------------------------------------------");
	printf("----------------------------------------------------------------------------------------------\n");
	
	for (j=0; j!=length + 1; ++j) {
		if (j==0) printf("  -  |\t");
			else {
				if ((readstart == 0 && (j <= offset_front || (j > length-offset_end && K != 1))) || (readstart != 0 && j > length-offset_end)) printf("  X  |\t");
				else printf("  %c  |\t", READ[readstart + j - (readstart == 0) * offset_front - 1]);
			}
			
		if (j>K) for (i=0; i!=j-K; ++i) printf("\t");
		
		for (i=0; i!=2*K+1; ++i) {
			if (i-j>K) break;
			if (i+j>length+K) break;
			if (i>length || j>length) break;
			if ((readstart!=0 && j>length-offset_end) || (readstart==0 && j<offset_front)) break;
			//printf("{i%d,j%d}",i,j);
			printf("%.1f(%c)\t", M[i][j], T[i][j]);
			if(i==6 && j==1) printf("---");
		}
		
		printf("\n----------------------------------------------------------------------------------------------");
		printf("----------------------------------------------------------------------------------------------\n");
	}	
	
} 


void printhits()
{
	//printf("list:\n");
	//printf("print hitlist with readlength %i, read %s, last[rl-2]=%c\n",READ_LENGTH, READ, READ[READ_LENGTH-2]);
	int i;
	int c=0;
	HIT* hit;
	for (i = INDEX_DEPTH; i != READ_LENGTH+1; ++i) {

		if (*(HIT_LISTS_OPERATOR + i) != NULL) {
			printf("%i: ",i);
			hit = *(HIT_LISTS_OPERATOR + i);
			do {
				//if (hit->orientation == '-') {
				printf("[%i: %i-%i/%c/chr%i/rp%i/%imm",
					hit->end-hit->start+1,hit->start, hit->end, hit->orientation,hit->chromosome+1, hit->readpos,hit->mismatches);
				if (hit->mismatches != 0) {
					printf(":");
					int j;
					for (j=0; j!=hit->mismatches; ++j)
						printf(" %i%c", hit->edit_op[j].pos, (hit->edit_op[j].mm)? 'M': 'G');
				}
				printf("/%s]",READ_ID); 
++c;
//}
				hit = hit->next;
if (c>4) hit = NULL;
			} while (hit != NULL);
			printf("\n");
		}
c=0;
	}
	//printf("done\n");
}


void printhit(HIT* hit)
{
	printf("[%i: %i-%i/%c/chr%i/rp%i/%imm",
					hit->end-hit->start+1,hit->start, hit->end, hit->orientation,hit->chromosome+1, hit->readpos,hit->mismatches);
	if (hit->mismatches != 0) {
		printf(":");
		int i;
		for (i=0; i!=hit->mismatches; ++i)
			printf(" %i%c", hit->edit_op[i].pos, (hit->edit_op[i].mm)? 'M': 'G');
	}
	printf("/ID: %s]",READ_ID); 
}
