// Authors: Korbinian Schneeberger, Stephan Ossowski and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"


int main(int argc, char *argv[]) {

#if OLD == 1
	if (DEBUG) printf("OLD position handling is active\n");
#else
	if (DEBUG) printf("NEW position handling is active\n");
#endif

	// timing //////////////
	time_t timer, timer_mid, timer2;
  	timer=time(NULL);
  	//printf("The current time is %s",asctime(localtime(&timer)));
	////////////////////////

	init(argc, argv);

 	if (VERBOSE) { printf("Reading in indices\n"); }
	build_index();

	if (VERBOSE) printf("Reading in genome\n");
	load_genome();
	
	// timing //////////////
	timer_mid=time(NULL);
	//printf("The current time is %s",asctime(localtime(&timer_mid)));
  	////////////////////////
	
 	if (VERBOSE) { printf("Mapping reads\n"); }
	map_reads();

	if (STATISTICS)	{
		print_stats();
		printf("R E D U N D A N T : %d\n",REDUNDANT);
		printf("Max used slots: %d\n", MAX_USED_SLOTS);
		printf("\nList iterations: %d\n", listcount);
		printf("List iterations occurrences: %d\n",listocc);
	}
	else if (VERBOSE) printf("Mapped Reads: %i of all %d reads\n", READS_MAPPED, NUM_READS);
		
	// timing //////////////
  	timer2=time(NULL);
  	//printf("The current time is %s",asctime(localtime(&timer2)));
  	int seconds = difftime(timer2, timer_mid);
  	int hours = seconds / 3600;
  	seconds %= 3600;
  	int minutes = seconds / 60;
  	seconds %= 60;
  	if (STATISTICS) {
  		printf("Time needed to pre-process: %gs\n",difftime(timer_mid, timer));
  		printf("Time needed to map: %dh %dm %ds\n", hours, minutes, seconds);
  	}
  	seconds = difftime(timer2, timer);
  	hours = seconds / 3600;
  	seconds %= 3600;
  	minutes = seconds / 60;
  	seconds %= 60;
  	if (STATISTICS) printf("Total time needed: %dh %dm %ds\n", hours, minutes, seconds);
  	////////////////////////

	//if (VERBOSE) { printf("La Fin.\n"); }

	return 0;
}




