// Authors: Korbinian Schneeberger, Stephan Ossowski and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "mkindex.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int load_chromosomes();
char* get_seq(unsigned int n);

int main(int argc, char *argv[])
{
	clock_t start, end;
	double elapsed;

	start = clock();
	
	if (VERBOSE) { printf("Start initializing\n"); }

	init(argc, argv);

	if (VERBOSE) { printf("Start loading\n"); }

	load_chromosomes();

	if (VERBOSE) printf("\nTotal number of seed occurrences: %lu\n\n", POSITION_COUNTER);

	// Print seed statistics
	/*if (strlen(OCC_FILE_NAME) != 0) {		
		printf("Print stat to %s ...\n",OCC_FILE_NAME);
		fflush(stdout);
		unsigned int i;
		BIN *bin, *bin_rev;
		for (i=0; i<POWER[INDEX_DEPTH]; i++) {	
			if ((bin = INDEX[i]) != NULL) fprintf(OCC_FP, "%s\t%d\t", get_seq(i), bin->num_all);
				else fprintf(OCC_FP, "%s\t0\t", get_seq(i));
			
			if ((bin_rev = INDEX_REV[i]) != NULL) fprintf(OCC_FP, "%d\n", bin_rev->num_all);
				else fprintf(OCC_FP, "0\n");
		}
		fclose(OCC_FP);
		printf("... done\n");
	}*/

	if (VERBOSE) { printf("Finish.\n"); }
	
	end = clock();
	elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
	if (VERBOSE) printf ("Time needed: %g s\n",elapsed);
	
	// print block table (debugging)
	/*printf("-------------------------------------------\n");
	int i;
	for (i=0; i<=BLOCK; ++i) {
		printf("| block %5d | pos %9d | chr %5d |\n", i, BLOCK_TABLE[i].pos, BLOCK_TABLE[i].chr+1);
	}
	printf("-------------------------------------------\n");*/

	return EXIT_SUCCESS;
}


char *get_seq(unsigned int n)
{
	char *seq = (char *) malloc (INDEX_DEPTH*sizeof(char));
	int i, c;
	for (i=INDEX_DEPTH-1; i>=0; --i) {
		c = (int) (n / POWER[i]);
		switch (c)
		{
			case 0: seq[i] = 'A';
					break;
			case 1: seq[i] = 'C';
					break;
			case 2: seq[i] = 'G';
					break;
			case 3: seq[i] = 'T';
					break;
		}
		n -= (int) (c * POWER[i]);
	}
	return seq;
}
