// Authors: Korbinian Schneeberger, Stephan Ossowski and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#if defined CONF
#else
#define CONF

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define VERSION "0.1.1"

// ##############################################################
// ####### GLOBAL VARIABLES #####################################
// ##############################################################

#define MIN_INDEX_DEPTH 5
#define MAX_INDEX_DEPTH 13

char DEBUG;
char BUILD_REVERSE_INDEX;
char VERBOSE;
char HAS_SLOT;
unsigned int SLOT;
unsigned int SLOT_REV;

int INDEX_DEPTH;
int POWER[MAX_INDEX_DEPTH];
int BINARY_CODE[5];

unsigned int LONGEST_CHROMOSOME;

int debug;

// ##############################################################
// ####### FILE HANDLING ########################################
// ##############################################################

char GENOME_FILE_NAME[500];
char INDEX_FILE_NAME[500];
char INDEX_REV_FILE_NAME[500];
char META_INDEX_FILE_NAME[500];
char GENOME_OUT_FILE_NAME[500];
//char OCC_FILE_NAME[500];

FILE *INDEX_FP;
FILE *META_INDEX_FP;
FILE *GENOME_FP;
FILE *GENOME_OUT_FP;
//FILE *OCC_FP;

// ##############################################################
// ######## SEQUENCE STORAGE ####################################
// ##############################################################

#define CHR_DESC_LENGTH 50

unsigned int CHR_LENGTH;
char *CHR_SEQ;

char CHR_DESC[2000];
char CHR_DESC_TMP[2000];

unsigned int SLOT_COUNTER; //counts the number of slots used by the forward index (equals the number of reverse slots though the slots themselves are different)
unsigned long int POSITION_COUNTER;

// ##############################################################
// ####### INDEX MANAGEMENT #####################################
// ##############################################################

#define BIN_SIZE 3
#define BIN_SIZE_EXT 20
//#define INDEX_SIZE 16777216 //4^12
#define INDEX_SIZE 67108864 //4^13
// #define INDEX_SIZE 244140625 // 5^12

#define BLOCK_TABLE_SIZE 16777216	// 2^24 (3 Byte)
#define BLOCK_SIZE 256	// 2^8 (1 Byte)

typedef struct id_structure {
	unsigned char id[4];
} ID;

typedef struct position_structure {
	unsigned int pos;
	unsigned int chr;
} POS;

POS *BLOCK_TABLE;
unsigned int BLOCK;
unsigned short int POSITION;

typedef struct bin_extension_structure {
	ID ids[BIN_SIZE_EXT];
	struct bin_extension_structure *bin_ext;
} BIN_EXT;

typedef struct bin_structure {
	unsigned int num_all; // number over all chromosomes
	unsigned int num_pos;
	ID ids[BIN_SIZE];
	BIN_EXT *bin_ext;
	BIN_EXT *last_bin_ext;
} BIN;

//BIN *INDEX;
//BIN *INDEX_REV;

BIN *INDEX[INDEX_SIZE];
BIN *INDEX_REV[INDEX_SIZE];

int NUM_USED_SLOTS; //different to SLOT_COUNTER! This counts the number of different used slots, used by reverse and forward Index.
int USED_SLOTS[INDEX_SIZE];


// ##############################################################
// ####### MEMORY MANAGEMENT ####################################
// ##############################################################

#define BIN_EXT_PER_NUGGET 100000

typedef struct nugget_str {
	BIN_EXT buffer[BIN_EXT_PER_NUGGET];
	struct nugget_str *next;
} NUGGET;

typedef struct stmg_str {
	int curr_num;
	NUGGET *nuggets;
} STORAGE;

STORAGE *MEM_MGR;

// ##############################################################
// ####### ROUTINES #############################################
// ##############################################################

//init.c
int init(int argc, char *argv[]);

//usage.c
int usage();

//load.c
int load_chromosomes();
int desc_parsing(char *c);

//indec.c
int index_chromosome(unsigned int chr);

//alloc.c
int alloc_bin(int slot);
int alloc_bin_rev(int slot);
BIN_EXT *alloc_bin_ext();
void alloc_blocktable();
int dealloc_chr();

//write.c
int write_index(unsigned int chr);
int write_chr(unsigned int chr);
int write_meta_index(unsigned int num_chr);

//printindex.c
void printindex();

#endif
