// Authors: Korbinian Schneeberger, Stephan Ossowski and Joerg Hagmann
// Copyright (C) 2008 by Max-Planck Institute for Developmental Biology, Tuebingen, Germany

#include "genomemapper.h"

int size_hit(HIT *hit, unsigned int *oldlength, char num);
int browse_hits();
int duplicate(HIT* hit);
void printgenome();

int map_reads() 
{
	char eof = 0, read_mapped;
	unsigned int count_reads = 0;
	int first_slot = 0;
	int num_edit_ops = NUM_EDIT_OPS;
	if (STATISTICS) MAX_USED_SLOTS = 0;
	unsigned int MAXHITS = 0;
	int c1 = 0;
	int c2 = 0;
	
	//FILE *CHROM_ENTRY_FP;
	//CHROM_ENTRY_FP = fopen("MappingEntriesPerRead", "w");
	
	while (!eof) {
		
		count_reads++;
			
		LONGEST_HIT = 0;

		if (DEBUG) printf("read short read\n");
		eof = read_short_read();
		if (eof != 0) continue;
		
		if (READ_LENGTH < HITLEN_LIMIT) {
			fprintf(stderr, "\n!!! WARNING! Read %d (%s) with length %d is shorter than the hitlength limit (=%d) and will not be processed!\n\n", 
				count_reads, READ_ID, READ_LENGTH, HITLEN_LIMIT);
		}
		else {
			//printf("%d ", count_reads); fflush(stdout);
			
			// progress output, just for user convenience 		
			if (VERBOSE && (count_reads % 10000 == 0)) {
				printf(".");
				fflush(stdout);
			}
			
			if (count_reads == DEBUGREAD) DEBUG = 1; 

			//if (strcmp(READ_ID, "1019109050592") == 0) DEBUG = 1; else DEBUG = 0;
				
			if (DEBUG) {
				printhits();
				printf("chrom_entry_op->used: %d\n",CHROMOSOME_ENTRY_OPERATOR->used);
			}

			if (STATISTICS) HITS_PER_READ = 0;
			
			HITS_IN_SCORE_LIST = 0;
			
			// map_fast IF 1) best hit strategy 2) only hits up to RL/ID mismatches without gaps should be found
							   // READ_LENGTH / INDEX_DEPTH is the number of seeds fitting in the current read
			int nr_seeds = (int) (READ_LENGTH / INDEX_DEPTH);
			if (DEBUG) printf("strategy: %d, nr_seeds %d, NUM_MM: %d\n",ALL_HIT_STRATEGY, nr_seeds, NUM_MISMATCHES);
 			if (!ALL_HIT_STRATEGY || (NUM_MISMATCHES < nr_seeds && NUM_GAPS == 0)) {
 				if (DEBUG) printf("map short reads FAST\n");
 				first_slot = map_fast();	// if no hits could have been found: ALL_HIT_STRATEGY = -1, necessitating execution of normal mapping in the following
 				c1++;
 			}
		
			if (DEBUG) printf("strategy: %d, nr_seeds %d, NUM_MM: %d, gaps %d\n",ALL_HIT_STRATEGY, nr_seeds, NUM_MISMATCHES, NUM_GAPS);
 			// map_complete IF 1) all hit strategy 2) best hit strategy and no mappings found in map_fast BUT NOT IF MM < RL/ID AND gaps=0 (since map_fast has already found them) 
			if (ALL_HIT_STRATEGY != 0 && !(NUM_MISMATCHES < nr_seeds && NUM_GAPS == 0)) {
				
				if (DEBUG) printf("map short reads NORMAL\n");
				c2++;
				map_short_read(count_reads, first_slot);
				
				// removing duplicates:	
				dealloc_mapping_entries();
				
				// Print Mapping Entry statistics
				//fprintf(CHROM_ENTRY_FP, "%d\t%d\n", CHROMOSOME_ENTRY_OPERATOR->used, NUM_MAPPING_ENTRIES);
				
				CHROMOSOME_ENTRY_OPERATOR->used = 0;
				
				if (DEBUG) printf("browse hits\n");
				browse_hits();
				
				if (ALL_HIT_STRATEGY < 0) ALL_HIT_STRATEGY = 0;		// resetting ALL_HIT_STRATEGY
				
			}
			
			if (STATISTICS && HITS_PER_READ > MAXHITS) MAXHITS = HITS_PER_READ;
			
			NUM_EDIT_OPS = num_edit_ops;		// resetting NUM_EDIT_OPS.. has been changed probably in alignments and map_fast
			
			if (DEBUG) printf("print out mapped reads\n");
			read_mapped = print_hits();	// returns 1 if at least one hit is printed, 0 otherwise
			
			if (read_mapped) READS_MAPPED++;
			else {
				if (strlen(LEFTOVER_FILE_NAME) > 0) print_leftovers();
			}				
			
			
			if (DEBUG) printf("Dealloc memory for mapping entries\n");
			dealloc_mapping_entries(); //muss eigentlich nur der container zaehler zurückgesetzt werden... optimization?
			if (DEBUG) printf("Dealloc memory for hits\n");
			dealloc_hits();
			if (DEBUG) printf("Resetting hits_by_score_lists\n");
			dealloc_hits_by_score();
			if (DEBUG) printf("Resetting chr entries\n");
			CHROMOSOME_ENTRY_OPERATOR->used = 0;
			if (DEBUG) printf("Dealloc memory for hit lists operator, longest hit: %d\n", LONGEST_HIT);
			if (LONGEST_HIT != 0) dealloc_hit_lists_operator();
						
			if (DEBUG) printf("done deallocating...\n");
			
			if (count_reads == DEBUGREAD) DEBUG = 0;		
		}

	}
	
	//fclose(CHROM_ENTRY_FP);
	fclose(QUERY_FP);
	
	if (strlen(OUT_FILE_NAME) > 0) fclose(OUT_FP);
	if (strlen(LEFTOVER_FILE_NAME) > 0) fclose(LEFTOVER_FP);
	
	if (STATISTICS) {
		printf("\n\n    MAP_FAST  = %d\n",c1);
		printf("    MAP_COMPL = %d\n\n",c2);
		printf("Maximal number of hits per read: %d\n",MAXHITS);
	}
	
	NUM_READS = count_reads - 1;
	
	if (VERBOSE) printf("\n");
	
	return(0);
}


int seed2genome(unsigned int num, unsigned int index_slot, unsigned int readpos, char reverse)
{
	INDEX_ENTRY index_entry;
	unsigned int genome_pos, genome_chr, block;
	unsigned char pos;
#if OLD == 1
	unsigned int genome_slot;
#else
	char strand;
#endif
	unsigned int direction;
	unsigned int mmoffset; //Mismatch-Offset
	int read_num = -1;
	if (DEBUG) read_num = num;

	char flag = 0;

#if OLD == 1
	CHROMOSOME_ENTRY *chromosome_director, *chromosome_director_neighbor;
#else
	CHROMOSOME_ENTRY *chromosome_director, *chromosome_director_neighbor, *chromosome_director_new;
#endif
	MAPPING_ENTRY *mapping_entry, *existing_entry, *neighbor;

	HIT *hit = NULL;

	unsigned int i;
	unsigned int oldlength;
	
	// reverse = 1: only index, 2: only index_rev, 4: both
	while (reverse > 0) {
		if (read_num == num) DEBUG = 1;
		
		if (reverse != 2) {
			index_entry = *(INDEX+index_slot);
			direction = -1;
		}
		else {
			index_entry = *(INDEX_REV+index_slot);
			direction = 1;
		}

		if (read_num == num) {
			printf("###############################################\n");
			printf("Add seed to genomepositions from slot # %d (%s) containing %d genomepositions\n", index_slot, get_seq(index_slot), index_entry.num);
		}
	
		for (i=0; i<index_entry.num; i++) { // foreach seed...		
		
			if (read_num == num) {
				printf("############################\n");
				printf("Now adding seed # %d/%d of read %i (%s), slot %i, ori %d\n", i+1, index_entry.num, num, READ_ID, index_slot, reverse);
			}
			
			// Every mapping gets an entry
			mapping_entry = alloc_mapping_entry();
			mapping_entry->readpos = readpos;
			if (read_num == num) {
				printf("Readpos %d\n", readpos);
			}

			// Get current position in the chromosome
			if (reverse != 2) {
				block = 0;
				memcpy(&block, &((index_entry.last_entry-(i+1))->id[0]), 3 * sizeof(char));
				pos = 0;
				memcpy(&pos, &((index_entry.last_entry-(i+1))->id[3]), sizeof(unsigned char));
				genome_pos = pos + BLOCK_TABLE[block].pos;
				genome_chr = BLOCK_TABLE[block].chr;
#if OLD == 1
				genome_slot = genome_chr;
#else 
				strand = 1;
#endif
			}
			else {
				block = 0;
				memcpy(&block, &((index_entry.last_entry-(index_entry.num-i))->id[0]), 3 * sizeof(char));
				pos = 0;
				memcpy(&pos, &((index_entry.last_entry-(index_entry.num-i))->id[3]), sizeof(unsigned char));
				genome_pos = pos + BLOCK_TABLE[block].pos;
				genome_chr = BLOCK_TABLE[block].chr;
#if OLD == 1
				genome_slot = genome_chr + NUM_CHROMOSOMES;
#else
				strand = -1;
#endif
			}
			
//printf("block %d pos %d [block].pos %d genome_pos %d genome_chr %d\n", block, pos, BLOCK_TABLE[block].pos, genome_pos, genome_chr);
			
			if (read_num == num) {
#if OLD == 1
				printf("Genome Entry: chr %d   pos %d	gen_slot %d\n", genome_chr+1, genome_pos, genome_slot);
#else
				printf("Genome Entry: chr %d   pos %d   \n", genome_chr+1, genome_pos);
#endif
			}
	
#if OLD == 1
			// Check if there is already a chromosome director and get this or a new one
			if (*(GENOME+genome_pos) == NULL) {
				flag = 1;

				if (read_num == num) {
					printf("Alloc new chromosome director genome_chr %d\n", genome_chr+1);
				}
				
				chromosome_director = alloc_chromosome_entry(&genome_pos);
				if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
				*(GENOME + genome_pos) = chromosome_director;
			}
			else {
				if (read_num == num) {
					printf("Found chromosome director\n");
				}

				chromosome_director = *(GENOME + genome_pos);
				
				// is chrom_director from the actual read or from a former one?
				if (read_num == num) {
						printf("ChrEntryOp:       %p\n", (CHROMOSOME_ENTRY_OPERATOR->entries));
						printf("ChrEntryOp[used]: %p\n", ((CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)));
						printf("chrom_director:   %p\n", chromosome_director);
						printf("used = %d\n",CHROMOSOME_ENTRY_OPERATOR->used);
						printf("chrom_dir->gen_pos: %d\n", chromosome_director->genome_pos);
						printf("genome_pos: %d\n", genome_pos);
				}
				if (chromosome_director >= (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) 
					|| 	(chromosome_director < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) &&
				   		(chromosome_director->genome_pos != genome_pos))) {
				   	
					// it's from a former read, thus we need a new chrom_director:
					chromosome_director = alloc_chromosome_entry(&genome_pos);
					if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
					*(GENOME + genome_pos) = chromosome_director;
					
					if (read_num == num) {
						printf("Overwrite chromosome director %p\n", chromosome_director);
					}
					
				}
			}
#else
			// Check if there is already a chromosome director and get this or a new one
			if (*(GENOME+genome_pos) == NULL) {
                flag = 1;

                if (read_num == num) {
                        printf("Alloc new chromosome director genome_chr %d\n", genome_chr+1);
                }

                chromosome_director = alloc_chromosome_entry(&genome_pos, &genome_chr, &strand);
                if (!chromosome_director) return(0);    // chrom_container_size too small -> cancel this read

				*(GENOME + genome_pos) = chromosome_director;

			}
            else {
                if (read_num == num) {
                        printf("Found chromosome director\n");
                }

                chromosome_director = *(GENOME + genome_pos);

                if (read_num == num) {
	                    printf("ChrEntryOp:       %p\n", (CHROMOSOME_ENTRY_OPERATOR->entries));
	                    printf("ChrEntryOp[used]: %p\n", ((CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)));
	                    printf("chrom_director:   %p\n", chromosome_director);
	                    printf("used = %d\n",CHROMOSOME_ENTRY_OPERATOR->used);
	                    printf("chrom_dir->gen_pos: %d\n", chromosome_director->genome_pos);
	                    printf("genome_pos: %d\n", genome_pos);
                }
                
				// is chrom_director from the actual read or from a former one?
                if (chromosome_director >= (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)
                || (chromosome_director < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) && 
                   (chromosome_director->genome_pos != genome_pos))) {

	                    // it's from a former read, thus we need a new chrom_director:
	                    chromosome_director = alloc_chromosome_entry(&genome_pos, &genome_chr, &strand);
	                    if (!chromosome_director) return(0);    // chrom_container_size too small -> cancel this read
						
						*(GENOME + genome_pos) = chromosome_director;
	
	                    if (read_num == num) {
	                            printf("Overwrite chromosome director %p\n", chromosome_director);
	                    }
				}
			}

			// Parse the list of chromosome directors 
			//printf("chrom_dir %d, genome_chr %d\n", chromosome_director->chromosome, genome_chr);
			while (chromosome_director->next != NULL && (chromosome_director->chromosome != genome_chr || 
														(chromosome_director->chromosome == genome_chr && chromosome_director->strand != strand)))
			{
if (STATISTICS) listcount++;
				chromosome_director = chromosome_director->next;
			}

			// Chromosome director is set, but still it could be the wrong chromosome, if the right chromosome is not in there so far.
			if (chromosome_director->chromosome != genome_chr || chromosome_director->strand != strand) {
				if (read_num == num) printf("Expanding list with new chrom.director\n");
				chromosome_director_new = alloc_chromosome_entry(&genome_pos, &genome_chr, &strand);
				if (!chromosome_director_new) return(0);
				
				chromosome_director_new->next = chromosome_director->next;
				chromosome_director->next = chromosome_director_new;

				chromosome_director = chromosome_director_new;
			}
#endif
			
			// Paste MAPPING_ENTRY in list of chromosome director slot
			if (read_num == num) {
				printf("Mapping entry, genome_chr %d\n", genome_chr+1);
				printf("Mapping entry, chromsome director %p\n", chromosome_director);
			}
#if OLD == 1
			if (*((chromosome_director->mapping_entries)+genome_slot) == NULL) { 
#else
			if (chromosome_director->mapping_entries == NULL) {
#endif

				if (read_num == num) {
					printf("List of mapping entries in the chromosome director was empty\n");
				}
#if OLD == 1
				*((chromosome_director->mapping_entries)+genome_slot) = mapping_entry;
#else
				chromosome_director->mapping_entries = mapping_entry;
#endif
			}
			else {
				if (flag == 1) {
					printf("!!!!!!!!!!!Found entry in chr dir at genome pos %d  --  %p\n", genome_pos, chromosome_director->mapping_entries	);
					exit(1);
				}

				if (read_num == num) {
					printf("Already entries in the chromosome director\n");
				}
#if OLD == 1
				existing_entry = *((chromosome_director->mapping_entries)+genome_slot);
				mapping_entry->pred = existing_entry;
				existing_entry->succ = mapping_entry;
				*((chromosome_director->mapping_entries)+genome_slot) = mapping_entry;
#else 
				existing_entry = chromosome_director->mapping_entries;
				mapping_entry->pred = existing_entry;
				existing_entry->succ = mapping_entry;
				chromosome_director->mapping_entries = mapping_entry;
#endif
			}


			// HIT EXTENSION
			
			//Check left (for plus strand) and right (for minus strand) neighbor at the genomeposition of the hit if there is a hit to join.
			if (genome_pos > 0 && readpos > 1) {
				if (read_num == num) {
					printf("Now checking if left neighbor exists and is willing to join %i\t%i\t%i\n",genome_pos, genome_pos+direction,reverse);
				}
				
				if (*(GENOME + (genome_pos + direction)) != NULL) { // Is there a chromosome director?
					if (read_num == num) {
						printf("  Found a neigboured chromosome director\n");
					}
					chromosome_director_neighbor = *(GENOME + (genome_pos + direction));
					
#if OLD == 1
					if (read_num == num)
						printf("chrom_director: %p, neighbor: %p, used: %p, back: %d, genome: %d\n", chromosome_director, 
								chromosome_director_neighbor, (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used),
								chromosome_director_neighbor->genome_pos, genome_pos+direction);
#endif

					// Is the chrom director from actual read?
					if (chromosome_director_neighbor < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) &&
					   (chromosome_director_neighbor->genome_pos == genome_pos + direction)) {
					
						// is there a mapping entry in the right chromosome solt, mr. director?
#if OLD == 1
						if (*((chromosome_director_neighbor->mapping_entries)+(genome_slot)) != NULL) { 
							if (read_num == num) {
								printf("  Found neighboured mapping entry list\n");
							}
							neighbor = *((chromosome_director_neighbor->mapping_entries)+genome_slot);
							if (read_num == num) {
								printf("  Neighbour info: readpos %d \n", neighbor->readpos);
							}
							if (read_num == num) printf("neighbor hit: ");
							if (read_num == num) { if (neighbor->hit!=NULL) printhit(neighbor->hit); else printf("null\n"); }
							if (neighbor->readpos == mapping_entry->readpos-1) { // is the neighbored mapping entry also neighbored in the read?
								hit = neighbor->hit;
								if (hit != NULL) {
									oldlength = hit->end - hit->start + 1;
									mapping_entry->hit = neighbor->hit;
									if (reverse != 2) hit->end++;
										else hit->start--;
									if (read_num == num) printhit(hit);
								}
							}
						}
#else 
						// Search for chromosome_director_neighbor for the correct chromosome and strand
						while (chromosome_director_neighbor->next != NULL && (chromosome_director_neighbor->chromosome != genome_chr || 
							  (chromosome_director_neighbor->chromosome == genome_chr && chromosome_director_neighbor->strand != strand)))
						{
if (STATISTICS) listcount++;
							chromosome_director_neighbor = chromosome_director_neighbor->next;
						}

						if 	(chromosome_director_neighbor->chromosome == genome_chr && chromosome_director_neighbor->strand == strand)
						{
								
                            if (read_num == num) {
                                    printf("  Found neighboured mapping entry list\n");
                            }
                            neighbor = chromosome_director_neighbor->mapping_entries;
                            if (read_num == num) {
                                    printf("  Neighbour info: readpos %d \n", neighbor->readpos);
                            }
                            if (read_num == num) { printf("neighbor hit: "); if (neighbor->hit!=NULL) printhit(neighbor->hit); else printf("null\n"); }
                            if (neighbor->readpos == mapping_entry->readpos-1) { // is the neighbored mapping entry also neighbored in the read?
								hit = neighbor->hit;
                                if (hit != NULL) {
                                    oldlength = hit->end - hit->start + 1;
                                    mapping_entry->hit = neighbor->hit;
                                    if (reverse != 2) hit->end++;
										else hit->start--;
                                    if (read_num == num) printhit(hit);
                                }
                    		}
                    		
                		}
#endif
					}
				}
				
				if (read_num == num) {
					printf("Will the hit be combined with adjacent neighbor? %d\n", (hit!=NULL));
				}
				

				// MISMATCH extension 
				
				//combine with possible hit at position seedlength+1 to the left(+) or right(-) to span hit over mismatch
				if (hit == NULL && NUM_MISMATCHES != 0) {
					if (read_num == num) printf("Now checking if hit can be extended over mismatch\n");
					mmoffset = (reverse != 2)? -INDEX_DEPTH - 1: INDEX_DEPTH + 1; 
					 
					if ( (genome_pos + mmoffset > 0) && (genome_pos + mmoffset < CHR_LENGTH[genome_chr]) && (*(GENOME + (genome_pos + mmoffset)) != NULL) ) {
					 	chromosome_director_neighbor = *(GENOME + (genome_pos + mmoffset));
					 	

#if OLD == 1			 		
						if (read_num == num) {
							printf("chrom_director: %p, neighbor: %p, used: %p, start: %p, back: %d, genome_back: %d\n", chromosome_director, 
								chromosome_director_neighbor, (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used),
								CHROMOSOME_ENTRY_OPERATOR->entries,	chromosome_director_neighbor->genome_pos, genome_pos+mmoffset);
						}
#endif

						// Is the chrom director from actual read?
						if  (chromosome_director_neighbor < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) && (chromosome_director_neighbor->genome_pos == genome_pos + mmoffset)) {
							
							// is there a mapping entry in the right chromosome solt, mr. director?
#if OLD == 1
							if (*((chromosome_director_neighbor->mapping_entries)+(genome_slot)) != NULL) { 
								neighbor = *((chromosome_director_neighbor->mapping_entries)+genome_slot);

#else
							// Search for chromosome_director for the correct chromosome
							while (chromosome_director_neighbor->next != NULL && (chromosome_director_neighbor->chromosome != genome_chr || 
								  (chromosome_director_neighbor->chromosome == genome_chr && chromosome_director_neighbor->strand != strand)))
							{
if (STATISTICS) listcount++;
								chromosome_director_neighbor = chromosome_director_neighbor->next;
							}

							if (chromosome_director_neighbor->chromosome == genome_chr && chromosome_director_neighbor->strand == strand) {
								neighbor = chromosome_director_neighbor->mapping_entries;
#endif
								if (read_num == num) printf("MM neighbor hit: ");
								if (read_num == num) printhit(neighbor->hit);
								if (read_num == num) printf("  Found a potential entry, readops(neighbor)=%d, (actual)=%d\n",neighbor->readpos,readpos);
								if (neighbor->readpos == mapping_entry->readpos - INDEX_DEPTH - 1) {
									if (read_num == num) printf("  Readpos matches\n");
									
									if ((neighbor->hit)->mismatches < NUM_EDIT_OPS && (neighbor->hit)->mismatches-(neighbor->hit)->gaps < NUM_MISMATCHES) {
										hit = neighbor->hit;
										oldlength = hit->end - hit->start + 1;
										mapping_entry->hit = neighbor->hit;
										if (read_num == num) printf("  Fancy! Mismatches < 4\n");
										
										if (reverse != 2) {
											hit->end = hit->end + INDEX_DEPTH + 1;
											hit->edit_op[hit->mismatches].pos = readpos - 1;
											hit->edit_op[hit->mismatches].mm = 1;
										}
										else {
											hit->start = genome_pos+1;	// +1 weg
											hit->edit_op[hit->mismatches].pos = READ_LENGTH - readpos + 2;
											hit->edit_op[hit->mismatches].mm = 1;
										}
										hit->mismatches++;
										if (read_num == num) printf("  Mismatch at pos %d, #mm=%d\n",hit->edit_op[hit->mismatches-1].pos, hit->mismatches);
										if (read_num == num) printhit(hit);
									}
								}
							}
						}
					}
				}
			}
	
			// for MM=0: if potential hit doesn't start at readpos 1, it cannot become perfect, thus it is not even allocated:
			if ( !(NUM_MISMATCHES == 0 && readpos != 1) ) {

				// create new hit:
				if (hit == NULL) {
					
					if (read_num == num) {
						printf("No! Need my own hit structure\n");
					}
					
					hit = alloc_hit();
					mapping_entry->hit = hit;
		
					hit->chromosome = genome_chr;
					hit->end = genome_pos + INDEX_DEPTH;	// -1
					hit->orientation = (reverse != 2)? '+': '-';
										
					oldlength = INDEX_DEPTH - 1;
					
					hit->readpos = readpos;
					hit->start = genome_pos+1;	// +1 weg

				}
			
			}		
	
			// for MM=0: if hit doesn't start at readpos=1, then do not report hit (due to: all perfect hits are extended from a hit starting at readpos 1!!!)
			if ( hit != NULL && !(NUM_MISMATCHES == 0 && hit->readpos != 1) ) {
				
				if (read_num == num) {
					printf("Paste hit in the hit lists with oldlength %d: ", oldlength);
					printhit(hit);
				}
				
				size_hit(hit, &oldlength, (read_num==num));
				
			}
			
			//printgenome();	
							
			flag = 0;
			hit = NULL;
			
		} //end of for each seed on read

		reverse -= 2; // 1->-1, 2->0, 4->2

	} //end of while (for each strand)
	
	return(1);
}

#if OLD != 1
void printgenome()
{
	printf("G E N O M E: \n");
	unsigned int i,c;
	HIT *hit;
	CHROMOSOME_ENTRY *ce;
	for (i=0; i!=LONGEST_CHROMOSOME; ++i) {
		c=0;
		ce = *(GENOME+i);
		if (ce != NULL) {
			printf("%d: ",i);
			while (ce != NULL) {
				++c;
				printf("(%d, %d, %d, %d) ", ce->chromosome+1, ce->strand, ce->genome_pos, (ce->next!=NULL));
				hit = ce->mapping_entries->hit;
				printhit(hit);
				ce = ce->next;
			}
			printf("((%d))\n",c);
		}
	}	
}
#endif

//@TODO remove num
int size_hit(HIT *hit, unsigned int *oldlength, char num)
{
	HIT *last, *next;

	// close the gap where the hit is taken out
	// shortest possible hits are not under control of the operator so far
	if (*oldlength > INDEX_DEPTH - 1) {
		
		if (hit->last == NULL) { //hit is the first in the list, the operator must be re-linked
 			if (num) printf("Hit is the first in the list\n");
			*(HIT_LISTS_OPERATOR+*oldlength) = hit->next;
			next = hit->next;
			if (next != NULL) {
				next->last = NULL;
			}
		}
		else {
 			if (num) printf("Hit is NOT the first in the list\n");
			//sweet
			last = hit->last;
			next = hit->next;
			last->next = next;
			if (next != NULL) {
				next->last = last; 
			}
		}
	}

	unsigned int length = hit->end - hit->start + 1;
	
	if (num) printf("readpos: %d, length: %d\n", hit->readpos, length);
	
	// ##########################################################
	// Mismatch at first or last pos of read:
	// ##########################################################
	
	// if hit.readpos == 2, then first base of read must be mismatch (spares alignment):
	if (hit->readpos == 2) {
		if (hit->mismatches < NUM_EDIT_OPS && hit->mismatches-hit->gaps < NUM_MISMATCHES) {
			if (hit->orientation == '+' && hit->start != 1) {
					hit->start--;
					hit->edit_op[hit->mismatches].pos = 1;
					hit->edit_op[hit->mismatches].mm = 1;
					hit->mismatches++;
					hit->readpos--;
					// update length:
					length++;
			}
			else if (hit->orientation == '-' && hit->end != CHR_LENGTH[hit->chromosome]) {
					hit->end++;
					hit->edit_op[hit->mismatches].pos = READ_LENGTH;
					hit->edit_op[hit->mismatches].mm = 1; 
					hit->mismatches++;
					hit->readpos--;
					// update length:
					length++;
			}
		}
		else {	// do not add hit to hit list
			if (DEBUG) printf("too many edit ops! %s", READ_ID);
			if (DEBUG) printhit(hit);
			return 0;
		}
	}
	
	// if hit ends at pos |read|-1, then check last base of read if it's a mismatch:
	if (hit->readpos + length == READ_LENGTH) {

		// compare last bases:
		READ[READ_LENGTH - 1] = toupper(READ[READ_LENGTH - 1]);
		if ( ( 
				(hit->orientation == '+') && (hit->end != CHR_LENGTH[hit->chromosome]) && ( (READ[READ_LENGTH - 1] != CHR_SEQ[hit->chromosome][hit->end]) || !unique_base(READ[READ_LENGTH - 1]) ) 
			 ) || ( 
		   	 	(hit->orientation == '-') && (hit->start != 1) && ( (READ[READ_LENGTH - 1] != get_compl_base(CHR_SEQ[hit->chromosome][hit->start-2])) || !unique_base(READ[READ_LENGTH - 1]) )
		   	 ) ) 
		{				
			
			// create mismatch:
			if (hit->mismatches < NUM_EDIT_OPS && hit->mismatches-hit->gaps < NUM_MISMATCHES) {
				//if (hit->orientation == '+' && hit->end != CHR_LENGTH[hit->chromosome]) {
				if (hit->orientation == '+') {
						hit->end++;
						hit->edit_op[hit->mismatches].pos = READ_LENGTH;
						hit->edit_op[hit->mismatches].mm = 1; 
						hit->mismatches++;
						// update length:
						length++;
				}
				//else if (hit->orientation == '-' && hit->start != 0) {
				else if (hit->orientation == '-') {
						hit->start--;
						hit->edit_op[hit->mismatches].pos = 1;
						hit->edit_op[hit->mismatches].mm = 1; 
						hit->mismatches++;
						// update length:
						length++;
				}
			}
			else {	// do not add hit to hit list
				if (DEBUG) printf("too many edit ops 2! %s", READ_ID);
				if (DEBUG) printhit(hit);
				return 0;
			}
			
		}
	}

	// ##########################################################

	// add to new list
	if (*(HIT_LISTS_OPERATOR+length) != NULL) {
 		if (num) printf("List already has some entries\n");
		next = *(HIT_LISTS_OPERATOR+length);
		next->last = hit;
		hit->next = next;
		hit->last = NULL;
		*(HIT_LISTS_OPERATOR+length) = hit;
	}
	else {
 		if (num) printf("List already no entries so far\n");
		hit->last = NULL;
		hit->next = NULL;
		*(HIT_LISTS_OPERATOR+length) = hit;
	}

	if (length > LONGEST_HIT) {
		LONGEST_HIT = length;
	}
	
	if (num) printhits();

	return(1);
}



// for each read:
int browse_hits() 
{
	HIT* hit;
	int hitlength;
	int i;
	char perfect = 0;
	char printed = 0;
	
	// browse hit_list foreach hitlength:
	for (i=READ_LENGTH; i!=INDEX_DEPTH - 1; --i) {

		// if only perfect reads should be reported, break earlier:
		if ((NUM_EDIT_OPS == 0) && (i < READ_LENGTH)) { 
			if (printed) return 1;
				else return 0;
		}
		
		// if hitlength limit is reached, break earlier:
		if (i == HITLEN_LIMIT - 1) {
			if (printed) return 1;
				else return 0;
		}
	
		if ((*(HIT_LISTS_OPERATOR + i)) != NULL) {

			hit = *(HIT_LISTS_OPERATOR + i);
			
			// foreach hit with hitlength i:
			while (hit != NULL) {
				
				if (DEBUG) {
					printf("@@@@@@@@@@@@@@@@@@\nnext hit: ");
					printhit(hit);
					printf("@@@@@@@@@@@@@@@@@@\n");
				}
				
				hitlength = hit->end - hit->start + 1;

				if (STATISTICS) {
					NUM_HITS++;
					HITS_PER_READ++;
				}
								
				// Hit spans the whole read:
				if (hitlength == READ_LENGTH) {

						if (STATISTICS && hit->mismatches == 0) {
						
							// reporting perfect matching reads (only one count per read)
							if (!perfect) {
								PERFECT_READS++;
								perfect = 1;
							}
							
							// reporting perfect hits
							if (hit->orientation == '+') PERFECT_HITS++;
								else PERFECT_HITS_REV++;
						}
						
						// report match:
						if (hit->mismatches <= NUM_EDIT_OPS) {

							// insert hit into HITS_BY_SCORE
							insert_into_scorelist(hit, 1);
						
							printed = 1;
							if (STATISTICS) NOT_ALIGNED[0]++;
							
							if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
						}
				}
				else {
				
				
					unsigned int readstart;
					if (hit->orientation == '+') {
						readstart = hit->start - hit->readpos;	// start pos of read in genome	0-initialized
					}
					else {
						readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2); 	// 0-initialized
					}

					// Alignment

					// for MM=1: hit must either start at readpos 1 or end at end of read, otherwise more than 1 MM:
					if (hit->mismatches < NUM_EDIT_OPS) {
						//(*(*(HITS_READPOS+(hitlength-INDEX_DEPTH))+(hit->readpos-1)))++;
						
						if (NUM_GAPS != 0) {
							// KBOUND:
							if (DEBUG) printf("Hit has to be aligned - kbound is used\n");
							printed = prepare_kbound_alignment(hit);
						}
						else {
							// SIMPLE:
							if (DEBUG) printf("align hit simple:\n");
							printed = align_hit_simple(hit);
						}
					}
					else {
						if (DEBUG) printf("before K1-alignment: already too many mismatches\n");
					}

				} // else has mismatches


				if (STATISTICS) HITS_LEN[hitlength]++;

				hit = hit->next;
				
			} // while hitlist not empty
			
		}
		
	} //for each hitlength
	
	return printed;
}


int insert_into_scorelist(HIT* hit, char d)
{		
	if (d && duplicate(hit)) return 0;
	
	int interval = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH-hit->mismatches) * M_SCORE;
	if (HITS_BY_SCORE[interval].num == 0) {
		// first entry in list
		if (DEBUG) printf("  SCORELIST: first entry in list, interval: %d\n",interval);
		HITS_BY_SCORE[interval].hitpointer = hit;
	}
	else {
		// list has already some entries, insert to the front
		if (DEBUG) printf("  SCORELIST: list already some entries, interval: %d\n",interval);
		HIT *tmp_hit = HITS_BY_SCORE[interval].hitpointer;
		HITS_BY_SCORE[interval].hitpointer = hit;
		hit->same_eo_succ = tmp_hit;
	}
	HITS_BY_SCORE[interval].num++;
	HITS_IN_SCORE_LIST++;
	
	char c = hit->mismatches < NUM_EDIT_OPS;
	if (!ALL_HIT_STRATEGY && hit->mismatches < NUM_EDIT_OPS) NUM_EDIT_OPS = hit->mismatches;
	
	if (DEBUG) printf("\nHIT REPORTED!   (new num_edit_op? %d -> %d)\n", c, NUM_EDIT_OPS);
	
	return 1;
}


int duplicate(HIT* hit)
{
	//if (strcmp("1005805610367",READ_ID) == 0 ||strcmp("1005805620754",READ_ID) == 0) 
	//DEBUG = 1;

	int hitlength = hit->end - hit->start + 1;
	unsigned int readstart, readend;

#if OLD == 1
	unsigned int genome_slot;
#else
	char strand;	
#endif

	if (hit->orientation == '+') {
		readstart = hit->start - hit->readpos + hit->start_offset;	// start pos of read in genome	   0-initialized
		readend = hit->end + (READ_LENGTH - hit->readpos - hitlength) + hit->end_offset;			// 0-initialized
#if OLD == 1
		genome_slot = hit->chromosome;
#else
		strand = 1;
#endif
	}
	else {
		readstart = hit->start - (READ_LENGTH - hit->readpos - hitlength + 2) + hit->start_offset; 	// 0-initialized
		readend = hit->end + hit->readpos - 2 + hit->end_offset;									// 0-initialized
#if OLD == 1
		genome_slot = hit->chromosome + NUM_CHROMOSOMES;
#else
		strand = -1;
#endif
	}
	
	double score = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH-hit->mismatches) * M_SCORE;
	
	if (DEBUG) {
		printf("\n@@duplicate@@@@@@@@@@ ");
		printhit(hit);
		printf("readstart: %d, readend: %d -> len on chr: %d\treadlen: %d\thitlen: %d\tscore: %.1f\n",readstart,readend,readend-readstart+1,READ_LENGTH,hitlength,score);
	}	
	
#if OLD == 1
	CHROMOSOME_ENTRY *chromosome_director;
#else
	CHROMOSOME_ENTRY *chromosome_director, *chromosome_director_new;
#endif
	MAPPING_ENTRY *mapping_entry, *existing_entry;
	char flag = 0;
	
	if (*(GENOME+readstart) == NULL) {
				flag = 1;
#if OLD == 1
				chromosome_director = alloc_chromosome_entry(&readstart);
#else
				chromosome_director = alloc_chromosome_entry(&readstart, &(hit->chromosome), &strand);
#endif
				if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
				*(GENOME + readstart) = chromosome_director;
				
				if (DEBUG) printf("Alloc new chromosome director genome_chr %d - %p - used: %d\n", hit->chromosome+1, chromosome_director, CHROMOSOME_ENTRY_OPERATOR->used);
	}
	else {
		if (DEBUG) printf("Found chromosome director\n");
		
		chromosome_director = *(GENOME + readstart);

#if OLD == 1
		if (DEBUG) {
				printf("ChrEntryOp:       %p\n", (CHROMOSOME_ENTRY_OPERATOR->entries));
				printf("ChrEntryOp[used]: %p\n", ((CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used)));
				printf("chrom_director:   %p\n", chromosome_director);
				printf("used = %d\n",CHROMOSOME_ENTRY_OPERATOR->used);
				printf("chrom_dir->gen_pos: %d\n", chromosome_director->genome_pos);
				printf("readstart: %d\n", readstart);
		}
#endif
		// is chrom_director from the actual read or from a former one?
		if (chromosome_director >= (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) 
			|| 	(chromosome_director < (CHROMOSOME_ENTRY_OPERATOR->entries+CHROMOSOME_ENTRY_OPERATOR->used) &&
		   		(chromosome_director->genome_pos != readstart))) {
		   			
		   			// it's from a former read, thus we need a new chrom_director:
#if OLD == 1
		   			chromosome_director = alloc_chromosome_entry(&readstart);
#else
					chromosome_director = alloc_chromosome_entry(&readstart, &(hit->chromosome), &strand);
#endif

					if (!chromosome_director) return(0);	// chrom_container_size too small -> cancel this read
					*(GENOME + readstart) = chromosome_director;
					
					if (DEBUG) printf("Overwrite with chromosome director %p\n", chromosome_director);
		}
	}
	
	
#if OLD == 1	

	if (*((chromosome_director->mapping_entries)+genome_slot) == NULL) {

#else
 	// Search for chromosome_director for the correct chromosome
 	//printf("%d %d %d %d %d\n",(chromosome_director->next != NULL), chromosome_director->chromosome, hit->chromosome, chromosome_director->strand, strand);
	while (chromosome_director->next != NULL && (chromosome_director->chromosome != hit->chromosome || 
												(chromosome_director->chromosome == hit->chromosome && chromosome_director->strand != strand))) {
if (STATISTICS) listcount++;
		chromosome_director = chromosome_director->next;
	}

	if (chromosome_director->chromosome != hit->chromosome || chromosome_director->strand != strand) {
		if (DEBUG) printf("Chrom.director of different chrom has to be allocated!\n");
	    chromosome_director_new = alloc_chromosome_entry(&readstart, &(hit->chromosome), &strand);
        if (!chromosome_director_new) return(0);

     	chromosome_director_new->next = chromosome_director->next;
        chromosome_director->next = chromosome_director_new;
        chromosome_director = chromosome_director_new;
	}

	if (chromosome_director->mapping_entries == NULL) {
#endif 
		if (DEBUG) printf("List of mapping entries in the chromosome director was empty\n");
		mapping_entry = alloc_mapping_entry();
#if OLD == 1
		*((chromosome_director->mapping_entries)+genome_slot) = mapping_entry;
#else 
		chromosome_director->mapping_entries = mapping_entry;
#endif
		
		mapping_entry->readpos = readend;
		mapping_entry->hit = hit;
	}
	else {
		if (DEBUG) printf("Already entries in the chromosome director %p\n", chromosome_director);
		
		if (flag == 1) {
			printf("!!!!!!!!!!!Found entry in chr dir at genome pos %d  --  %p\n", readstart, chromosome_director->mapping_entries	);
			exit(1);
		}
		
		double score2, score1 = (hit->mismatches-hit->gaps) * MM_SCORE + hit->gaps * GAP_SCORE - (READ_LENGTH - hit->mismatches) * M_SCORE;
		
#if OLD == 1
		existing_entry = *((chromosome_director->mapping_entries)+genome_slot);
#else
		existing_entry = chromosome_director->mapping_entries;
#endif
		
		while (existing_entry != NULL) {
			score2 = (existing_entry->hit->mismatches-existing_entry->hit->gaps) * MM_SCORE
					 + existing_entry->hit->gaps * GAP_SCORE - (READ_LENGTH - existing_entry->hit->mismatches) * M_SCORE;
			if (DEBUG) printf("  existing_entry->readend = %d, actual readend = %d\tscore(ex.entry)=%.1f, score(hit)=%.1f\n",
								 existing_entry->readpos, readend, score2, score1);
					 
			if (existing_entry->readpos == readend && score1 == score2) {
				if (DEBUG) printf("return 1\n");
				if (STATISTICS) REDUNDANT++;
				//DEBUG = 0;
				return 1;
			}
			
			existing_entry = existing_entry->succ;
		}
		
		// no hit with same end pos of read and same score could have been found -> create another entry:
#if OLD == 1
		existing_entry = *((chromosome_director->mapping_entries)+genome_slot);	// since existing_entry was NULL due to the while loop
#else
		existing_entry = chromosome_director->mapping_entries; 
#endif
		if (DEBUG) printf("there was no hit with same readend and same score! now creating new entry!\n");
		mapping_entry = alloc_mapping_entry();
		mapping_entry->succ = existing_entry;
		existing_entry->pred = mapping_entry;
		//insert to the front of the mapping list
#if OLD == 1
		*((chromosome_director->mapping_entries)+genome_slot) = mapping_entry;
#else
		chromosome_director->mapping_entries = mapping_entry;
#endif
		mapping_entry->readpos = readend;
		mapping_entry->hit = hit;
						
	}
	
	if (DEBUG) printf("return 0\n");
	//DEBUG = 0;
	return 0;
}

// for debugging
char *get_seq(unsigned int n)
{
	char *seq = (char *) malloc ((INDEX_DEPTH+1)*sizeof(char));
	int i, c;
	for (i=INDEX_DEPTH-1; i>=0; --i) {
		c = (int) (n / POWER[i]);
		switch (c)
		{
			case 0: seq[i] = 'A';
					break;
			case 1: seq[i] = 'C';
					break;
			case 2: seq[i] = 'G';
					break;
			case 3: seq[i] = 'T';
					break;
		}
		n -= (int) (c * POWER[i]);
	}
	seq[INDEX_DEPTH] = '\0';
	return seq;
}

